/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.yixixun.more_potion_effects.MorePotionEffectsMod;

@Mod.EventBusSubscriber(modid="more_potion_effects", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PotionBrewingSystem {
    private static final Path CONFIG_DIR = Paths.get("config", "more_potion_effects");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(EffectConfig.class, (Object)new EffectConfig.Deserializer()).create();
    private static final List<ItemStack> GENERATED_POTION_STACKS = new ArrayList<ItemStack>();
    private static final List<IngredientBrewingRecipe> REGISTERED_INGREDIENT_RECIPES = new CopyOnWriteArrayList<IngredientBrewingRecipe>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ItemStack> getCustomsPotionStacks() {
        List<ItemStack> list = GENERATED_POTION_STACKS;
        synchronized (list) {
            ArrayList ALL_CUSTOM_POTION = new ArrayList();
            GENERATED_POTION_STACKS.forEach(stack -> {
                ALL_CUSTOM_POTION.add(stack);
                ALL_CUSTOM_POTION.add(PotionBrewingSystem.gunpowderConversion(stack));
                ALL_CUSTOM_POTION.add(PotionBrewingSystem.dragonBreathConversion(stack));
                ALL_CUSTOM_POTION.add(PotionBrewingSystem.getPotionArrow(stack));
            });
            return new ArrayList<ItemStack>(ALL_CUSTOM_POTION);
        }
    }

    public static List<IngredientBrewingRecipe> getRegisteredIngredientRecipes() {
        return new ArrayList<IngredientBrewingRecipe>(REGISTERED_INGREDIENT_RECIPES);
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(PotionBrewingSystem::loadAndRegisterRecipes);
    }

    public static void loadAndRegisterRecipes() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            PotionBrewingSystem.createExampleConfigs();
            try (Stream<Path> paths = Files.list(CONFIG_DIR);){
                paths.filter(path -> path.toString().endsWith(".json")).forEach(PotionBrewingSystem::loadRecipeFile);
            }
            PotionBrewingSystem.registerGlobalConversionRecipes();
        }
        catch (IOException e) {
            MorePotionEffectsMod.LOGGER.error("Failed to load brewing recipes", (Throwable)e);
        }
    }

    private static void createExampleConfigs() throws IOException {
        Path exampleFile = CONFIG_DIR.resolve("example_recipes.json");
        if (!Files.exists(exampleFile, new LinkOption[0])) {
            JsonObject root = new JsonObject();
            JsonArray recipes = new JsonArray();
            JsonObject multiEffect = new JsonObject();
            multiEffect.addProperty("base_potion", "minecraft:awkward");
            multiEffect.addProperty("ingredient", "minecraft:totem_of_undying");
            JsonArray effects = new JsonArray();
            JsonObject effect = new JsonObject();
            effect.addProperty("effect_id", "more_potion_effects:immortal");
            effect.addProperty("duration", (Number)12000);
            effect.addProperty("amplifier", (Number)0);
            effects.add((JsonElement)effect);
            multiEffect.add("effects", (JsonElement)effects);
            multiEffect.addProperty("custom_name", "\u00a7e\u4e0d\u6b7b\u836f\u6c34");
            multiEffect.addProperty("custom_color", "FFD700");
            multiEffect.addProperty("custom_base", "custom_immortal");
            recipes.add((JsonElement)multiEffect);
            JsonObject Potion2 = new JsonObject();
            Potion2.addProperty("base_potion", "custom_immortal");
            Potion2.addProperty("ingredient", "minecraft:totem_of_undying");
            JsonArray effects2 = new JsonArray();
            JsonObject effect1 = new JsonObject();
            effect1.addProperty("effect_id", "more_potion_effects:immortal");
            effect1.addProperty("duration", (Number)12000);
            effect1.addProperty("amplifier", (Number)1);
            effects2.add((JsonElement)effect1);
            JsonObject effect2 = new JsonObject();
            effect2.addProperty("effect_id", "minecraft:regeneration");
            effect2.addProperty("duration", (Number)200);
            effect2.addProperty("amplifier", (Number)2);
            effects2.add((JsonElement)effect2);
            Potion2.add("effects", (JsonElement)effects2);
            Potion2.addProperty("custom_name", "\u00a7e\u4e0d\u6b7b\u836f\u6c34II");
            Potion2.addProperty("custom_color", "FFD700");
            Potion2.addProperty("custom_base", "custom_immortal2");
            recipes.add((JsonElement)Potion2);
            root.add("recipes", (JsonElement)recipes);
            Files.writeString(exampleFile, (CharSequence)GSON.toJson((JsonElement)root), new OpenOption[0]);
        }
    }

    private static void loadRecipeFile(Path file) {
        try {
            String content = Files.readString(file);
            JsonElement rootElement = JsonParser.parseString((String)content);
            if (!rootElement.isJsonObject()) {
                MorePotionEffectsMod.LOGGER.error("Invalid JSON structure in file: {}", (Object)file);
                return;
            }
            JsonObject root = rootElement.getAsJsonObject();
            if (!root.has("recipes") || !root.get("recipes").isJsonArray()) {
                MorePotionEffectsMod.LOGGER.error("Missing 'recipes' array in file: {}", (Object)file);
                return;
            }
            JsonArray recipes = root.getAsJsonArray("recipes");
            for (JsonElement element : recipes) {
                if (!element.isJsonObject()) {
                    MorePotionEffectsMod.LOGGER.warn("Skipping invalid recipe element in {}", (Object)file);
                    continue;
                }
                try {
                    BrewingRecipe recipe = (BrewingRecipe)GSON.fromJson(element, BrewingRecipe.class);
                    if (recipe.isValid()) {
                        PotionBrewingSystem.registerRecipe(recipe);
                        MorePotionEffectsMod.LOGGER.info("Successfully registered recipe: {}", (Object)recipe);
                        continue;
                    }
                    MorePotionEffectsMod.LOGGER.warn("Skipping invalid recipe in {}: {}", (Object)file, (Object)element);
                }
                catch (JsonParseException e) {
                    MorePotionEffectsMod.LOGGER.error("Error parsing recipe in {}: {}", (Object)file, (Object)element, (Object)e);
                }
            }
        }
        catch (Exception e) {
            MorePotionEffectsMod.LOGGER.error("Error reading recipe file: {}", (Object)file, (Object)e);
        }
    }

    private static void registerRecipe(BrewingRecipe recipe) {
        ArrayList<MobEffectInstance> effectInstances = new ArrayList<MobEffectInstance>();
        for (EffectConfig effectConfig : recipe.effects) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectConfig.getEffectId());
            if (effect == null) {
                MorePotionEffectsMod.LOGGER.warn("Skipping unknown effect: {}", (Object)effectConfig.getEffectId());
                continue;
            }
            effectInstances.add(new MobEffectInstance(effect, effectConfig.duration, effectConfig.amplifier, effectConfig.ambient, effectConfig.visible, effectConfig.showIcon));
        }
        if (effectInstances.isEmpty()) {
            MorePotionEffectsMod.LOGGER.warn("Skipping recipe with no valid effects");
            return;
        }
        ItemStack outputStack = new ItemStack((ItemLike)Items.f_42589_);
        PotionUtils.m_43549_((ItemStack)outputStack, (Potion)Potions.f_43598_);
        PotionUtils.m_43552_((ItemStack)outputStack, effectInstances);
        recipe.getCustomBase().ifPresent(base -> outputStack.m_41784_().m_128359_("BasePotion", base));
        recipe.getCustomName().ifPresent(name -> outputStack.m_41714_((Component)Component.m_237113_((String)name)));
        recipe.getCustomColor().ifPresent(color -> {
            try {
                long colorLong = Long.parseLong(color, 16);
                int colorValue = (int)(colorLong & 0xFFFFFFFFL);
                CompoundTag tag = outputStack.m_41784_();
                tag.m_128405_("CustomPotionColor", colorValue);
            }
            catch (NumberFormatException e) {
                MorePotionEffectsMod.LOGGER.warn("Invalid color format in recipe: {}, using default", color);
            }
        });
        GENERATED_POTION_STACKS.add(outputStack.m_41777_());
        Potion basePotion = recipe.getBasePotion();
        if (basePotion == null) {
            MorePotionEffectsMod.LOGGER.error("Failed to register recipe: base potion is null");
            return;
        }
        Item ingredientItem = recipe.getIngredientItem();
        if (ingredientItem == null) {
            MorePotionEffectsMod.LOGGER.error("Failed to register recipe: ingredient item is null");
            return;
        }
        IngredientBrewingRecipe brewingRecipe = new IngredientBrewingRecipe(basePotion, recipe.getBasePotionId(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredientItem}), outputStack);
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)brewingRecipe);
        REGISTERED_INGREDIENT_RECIPES.add(brewingRecipe);
    }

    private static void registerGlobalConversionRecipes() {
        GunpowderConversionRecipe gunpowderRecipe = new GunpowderConversionRecipe();
        DragonBreathConversionRecipe dragonBreathRecipe = new DragonBreathConversionRecipe();
        try {
            Field recipesField = BrewingRecipeRegistry.class.getDeclaredField("recipes");
            recipesField.setAccessible(true);
            List recipes = (List)recipesField.get(null);
            recipes.add(0, dragonBreathRecipe);
            recipes.add(0, gunpowderRecipe);
            MorePotionEffectsMod.LOGGER.info("Registered global potion conversion recipes at the beginning of the list via reflection");
        }
        catch (Exception e) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)gunpowderRecipe);
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)dragonBreathRecipe);
            MorePotionEffectsMod.LOGGER.info("Registered global potion conversion recipes normally (at the end)");
            MorePotionEffectsMod.LOGGER.error("\u53cd\u5c04\u5931\u8d25 for BrewingRecipeRegistry.recipes: ", (Throwable)e);
        }
    }

    public static ItemStack gunpowderConversion(ItemStack potion) {
        ItemStack result = new ItemStack((ItemLike)Items.f_42736_);
        if (potion.m_41782_()) {
            result.m_41751_(potion.m_41783_());
        }
        return result;
    }

    public static ItemStack dragonBreathConversion(ItemStack potion) {
        ItemStack result = new ItemStack((ItemLike)Items.f_42739_);
        if (potion.m_41782_()) {
            result.m_41751_(potion.m_41783_());
        }
        return result;
    }

    public static ItemStack getPotionArrow(ItemStack potion) {
        ItemStack result = new ItemStack((ItemLike)Items.f_42738_);
        if (potion.m_41782_()) {
            ItemStack copy = potion.m_41777_();
            result.m_41751_(copy.m_41783_());
            result.m_41714_((Component)Component.m_237113_((String)copy.m_41786_().getString().replace("\u836f\u6c34", "\u4e4b\u7bad")).m_6270_(copy.m_41786_().m_7383_()));
        }
        return result;
    }

    public static class BrewingRecipe {
        @SerializedName(value="base_potion")
        public String base_potion;
        @SerializedName(value="ingredient")
        public String ingredient;
        @SerializedName(value="effects")
        public List<EffectConfig> effects;
        @SerializedName(value="custom_name")
        public String custom_name;
        @SerializedName(value="custom_color")
        public String custom_color;
        @SerializedName(value="custom_base")
        public String custom_base;

        public Optional<String> getCustomBase() {
            return Optional.ofNullable(this.custom_base);
        }

        public Optional<String> getCustomName() {
            return Optional.ofNullable(this.custom_name);
        }

        public Optional<String> getCustomColor() {
            return Optional.ofNullable(this.custom_color);
        }

        public Potion getBasePotion() {
            return this.base_potion != null ? (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(this.base_potion)) : null;
        }

        public String getBasePotionId() {
            return this.base_potion;
        }

        public Item getIngredientItem() {
            return this.ingredient != null ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.ingredient)) : null;
        }

        public boolean isValid() {
            return this.base_potion != null && this.ingredient != null && this.effects != null && !this.effects.isEmpty() && this.getBasePotion() != null && this.getIngredientItem() != null;
        }

        public String toString() {
            return "BrewingRecipe{base_potion='" + this.base_potion + "', ingredient='" + this.ingredient + "', effects=" + this.effects + "}";
        }
    }

    public static class EffectConfig {
        private ResourceLocation effect_id;
        public int duration;
        public int amplifier;
        public boolean ambient = false;
        public boolean visible = true;
        public boolean showIcon = true;

        public ResourceLocation getEffectId() {
            return this.effect_id;
        }

        public static class Deserializer
        implements JsonDeserializer<EffectConfig> {
            public EffectConfig deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
                JsonObject obj = json.getAsJsonObject();
                EffectConfig config = new EffectConfig();
                config.effect_id = new ResourceLocation(obj.get("effect_id").getAsString());
                config.duration = obj.get("duration").getAsInt();
                config.amplifier = obj.get("amplifier").getAsInt();
                if (obj.has("ambient")) {
                    config.ambient = obj.get("ambient").getAsBoolean();
                }
                if (obj.has("visible")) {
                    config.visible = obj.get("visible").getAsBoolean();
                }
                if (obj.has("show_icon")) {
                    config.showIcon = obj.get("show_icon").getAsBoolean();
                }
                return config;
            }
        }
    }

    public record IngredientBrewingRecipe(Potion basePotion, String basePotionId, Ingredient ingredient, ItemStack outputTemplate) implements IBrewingRecipe
    {
        public IngredientBrewingRecipe(Potion basePotion, String basePotionId, Ingredient ingredient, ItemStack outputTemplate) {
            this.basePotion = basePotion;
            this.basePotionId = basePotionId;
            this.ingredient = ingredient;
            this.outputTemplate = outputTemplate.m_41777_();
        }

        public boolean isInput(ItemStack stack) {
            if (stack.m_41720_() != Items.f_42589_ && stack.m_41720_() != Items.f_42736_ && stack.m_41720_() != Items.f_42739_) {
                return false;
            }
            String inputBase = stack.m_41784_().m_128461_("BasePotion");
            Potion inputPotion = PotionUtils.m_43579_((ItemStack)stack);
            if (!inputBase.isEmpty()) {
                return inputBase.equals(this.basePotionId);
            }
            return inputPotion == this.basePotion;
        }

        public boolean isIngredient(ItemStack stack) {
            return this.ingredient.test(stack);
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (!this.isInput(input) || !this.isIngredient(ingredient)) {
                return ItemStack.f_41583_;
            }
            Item outputItem = input.m_41720_();
            ItemStack result = new ItemStack((ItemLike)outputItem);
            CompoundTag tag = this.outputTemplate.m_41783_();
            if (tag != null) {
                result.m_41751_(tag.m_6426_());
            }
            return result;
        }
    }

    public static class GunpowderConversionRecipe
    implements IBrewingRecipe {
        public boolean isInput(ItemStack input) {
            return input.m_41720_() == Items.f_42589_ && !PotionUtils.m_43571_((ItemStack)input).isEmpty();
        }

        public boolean isIngredient(ItemStack ingredient) {
            return ingredient.m_41720_() == Items.f_42403_;
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (!this.isInput(input) || !this.isIngredient(ingredient)) {
                return ItemStack.f_41583_;
            }
            return PotionBrewingSystem.gunpowderConversion(input);
        }
    }

    public static class DragonBreathConversionRecipe
    implements IBrewingRecipe {
        public boolean isInput(ItemStack input) {
            return input.m_41720_() == Items.f_42736_ && !PotionUtils.m_43571_((ItemStack)input).isEmpty();
        }

        public boolean isIngredient(ItemStack ingredient) {
            return ingredient.m_41720_() == Items.f_42735_;
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (!this.isInput(input) || !this.isIngredient(ingredient)) {
                return ItemStack.f_41583_;
            }
            return PotionBrewingSystem.dragonBreathConversion(input);
        }
    }
}

