/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.init;

import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.yixixun.more_potion_effects.init.MorePotionEffectsModMobEffects;

public class MorePotionEffectsModPotions {
    public static final DeferredRegister<Potion> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"more_potion_effects");
    private static final int NORMAL_DURATION = 3600;

    private static void registerAllPotions() {
        MorePotionEffectsModPotions.registerPotionsFromEffects(MorePotionEffectsModMobEffects.REGISTRY);
        MorePotionEffectsModPotions.register("fate", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.RANDOM_EFFECT.get(), 7200, 4)}));
    }

    private static void registerPotionsFromEffects(DeferredRegister<MobEffect> effectsRegistry) {
        for (RegistryObject effectRO : effectsRegistry.getEntries()) {
            String effectName = effectRO.getId().m_135815_();
            if (MorePotionEffectsModPotions.shouldSkipEffect(effectName)) continue;
            MorePotionEffectsModPotions.createPotionVariants(effectName, (RegistryObject<MobEffect>)effectRO);
        }
    }

    private static boolean shouldSkipEffect(String effectName) {
        return Set.of("rank", "companion").contains(effectName);
    }

    private static void createPotionVariants(String baseName, RegistryObject<MobEffect> effect) {
        if (effect.isPresent() && ((MobEffect)effect.get()).m_8093_()) {
            MorePotionEffectsModPotions.register(baseName, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)effect.get(), 1)}));
        } else {
            MorePotionEffectsModPotions.register(baseName, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)effect.get(), 3600)}));
        }
    }

    public static RegistryObject<Potion> register(String name, Supplier<Potion> supplier) {
        return REGISTRY.register(name, supplier);
    }

    static {
        MorePotionEffectsModPotions.registerAllPotions();
    }
}

