/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.yixixun.more_potion_effects.MorePotionEffectsMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MorePotionEffectsModVeiledPresence {
    public static final Capability<EntityVariables> ENTITY_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MorePotionEffectsMod.addNetworkMessage(EntityVariablesSyncMessage.class, EntityVariablesSyncMessage::buffer, EntityVariablesSyncMessage::new, EntityVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(EntityVariables.class);
    }

    public static class EntityVariablesSyncMessage {
        private final EntityVariables data;
        private final int entityId;

        public EntityVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new EntityVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.entityId = buffer.readInt();
        }

        public EntityVariablesSyncMessage(EntityVariables data, int entityId) {
            this.data = data;
            this.entityId = entityId;
        }

        public static void buffer(EntityVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.entityId);
        }

        public static void handler(EntityVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                Entity entity;
                if (!context.getDirection().getReceptionSide().isServer() && (entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityId)) instanceof LivingEntity) {
                    entity.getCapability(ENTITY_VARIABLES_CAPABILITY).ifPresent(cap -> {
                        cap.isVeiled = message.data.isVeiled;
                    });
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class EntityVariables {
        public boolean isVeiled = false;

        public void syncEntityVariables(Entity entity) {
            if (entity.m_9236_() instanceof ServerLevel) {
                MorePotionEffectsMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new EntityVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("isVeiled", this.isVeiled);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.isVeiled = nbt.m_128471_("isVeiled");
        }
    }

    @Mod.EventBusSubscriber
    public static class EntityVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final EntityVariables entityVariables = new EntityVariables();
        private final LazyOptional<EntityVariables> instance = LazyOptional.of(() -> this.entityVariables);

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof LivingEntity && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("more_potion_effects", "entity_variables"), (ICapabilityProvider)new EntityVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == ENTITY_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.entityVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.entityVariables.readNBT(nbt);
        }
    }
}

