/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.potion;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.yixixun.more_potion_effects.init.MorePotionEffectsModMobEffects;
import net.yixixun.more_potion_effects.network.MorePotionEffectsModVeiledPresence;

public class VeiledPresenceMobEffect
extends MobEffect {
    public static final Map<UUID, UUID> attackRelations = new HashMap<UUID, UUID>();

    public VeiledPresenceMobEffect() {
        super(MobEffectCategory.BENEFICIAL, MobEffects.f_19609_.m_19484_());
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        entity.m_6842_(true);
        if (entity.m_9236_().m_46467_() % 100L == 0L) {
            this.cleanupInvalidRelations(entity);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    private void cleanupInvalidRelations(LivingEntity entity) {
        attackRelations.entrySet().removeIf(entry -> entity.m_9236_().m_46003_((UUID)entry.getValue()) == null);
    }

    public static void onAttack(LivingEntity attacker, LivingEntity target) {
        if (target.m_21023_((MobEffect)MorePotionEffectsModMobEffects.VEILED_PRESENCE.get())) {
            attackRelations.put(attacker.m_20148_(), target.m_20148_());
            if (attacker instanceof Mob) {
                Mob mob = (Mob)attacker;
                mob.m_6710_(target);
                mob.m_6274_().m_21936_(MemoryModuleType.f_26326_);
            }
        }
    }

    public static boolean canAttack(LivingEntity attacker, LivingEntity target) {
        if (target.m_21023_((MobEffect)MorePotionEffectsModMobEffects.VEILED_PRESENCE.get())) {
            if (attacker instanceof Player) {
                return true;
            }
            return attackRelations.getOrDefault(attacker.m_20148_(), UUID.randomUUID()).equals(target.m_20148_());
        }
        return true;
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        super.m_6385_(entity, attributes, amplifier);
        entity.getCapability(MorePotionEffectsModVeiledPresence.ENTITY_VARIABLES_CAPABILITY).ifPresent(cap -> {
            cap.isVeiled = true;
            if (!entity.m_9236_().m_5776_()) {
                cap.syncEntityVariables((Entity)entity);
            }
        });
        entity.m_6842_(true);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        super.m_6386_(entity, attributes, amplifier);
        entity.getCapability(MorePotionEffectsModVeiledPresence.ENTITY_VARIABLES_CAPABILITY).ifPresent(cap -> {
            cap.isVeiled = false;
            if (!entity.m_9236_().m_5776_()) {
                cap.syncEntityVariables((Entity)entity);
            }
        });
        VeiledPresenceMobEffect.removeRelations(entity);
    }

    public static void removeRelations(LivingEntity entity) {
        UUID uuid = entity.m_20148_();
        attackRelations.values().removeIf(uuid::equals);
        attackRelations.remove(uuid);
    }
}

