/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.procedures;

import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.yixixun.more_potion_effects.api.EffectUtils;
import net.yixixun.more_potion_effects.configuration.MPEconfigConfiguration;
import net.yixixun.more_potion_effects.init.MorePotionEffectsModEnchantments;
import net.yixixun.more_potion_effects.init.MorePotionEffectsModMobEffects;

@Mod.EventBusSubscriber
public class EnchantmentAbilityProcedure {
    private static final RandomSource random = RandomSource.m_216327_();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityAttacked(LivingHurtEvent event) {
        LivingEntity attacker;
        block6: {
            block5: {
                if (event == null || event.getEntity() == null || event.getSource().m_7639_() == null) {
                    return;
                }
                Entity entity = event.getSource().m_7639_();
                if (!(entity instanceof LivingEntity)) break block5;
                attacker = (LivingEntity)entity;
                if (event.getEntity() instanceof LivingEntity) break block6;
            }
            return;
        }
        LivingEntity defender = event.getEntity();
        if (attacker == event.getSource().m_7640_()) {
            EnchantmentAbilityProcedure.handleBlessingEffect(attacker, defender);
            EnchantmentAbilityProcedure.handleCurseEffect(attacker, defender);
            EnchantmentAbilityProcedure.handleEliminationEffect(attacker, defender, event);
            EnchantmentAbilityProcedure.handleSunderArmorEffect(attacker, defender);
            EnchantmentAbilityProcedure.handlePunisherEffect(attacker, defender, event);
            EnchantmentAbilityProcedure.handleToxicBladeEffect(attacker, defender);
            EnchantmentAbilityProcedure.handleCorrosionEffect(attacker, defender);
            EnchantmentAbilityProcedure.handleInhibitEffect(attacker, defender);
        }
    }

    private static boolean canTriggerEffect(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_36403_(0.5f) >= 0.95f;
        }
        return true;
    }

    private static int calculateTriggerCount(double probability) {
        int count = (int)probability;
        double remaining = probability - (double)count;
        if (random.m_188500_() < remaining) {
            ++count;
        }
        return Math.max(1, count);
    }

    private static void handleBlessingEffect(LivingEntity attacker, LivingEntity defender) {
        if (!((Boolean)MPEconfigConfiguration.SOURCE_OF_BLESSING.get()).booleanValue() || !EnchantmentAbilityProcedure.canTriggerEffect((Entity)attacker)) {
            return;
        }
        ItemStack mainHand = attacker.m_21205_();
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)MorePotionEffectsModEnchantments.SOURCE_OF_BLESSING.get()), (ItemStack)mainHand);
        double baseProbability = (Double)MPEconfigConfiguration.SOURCE_OF_BLESSING_PROBABILITY.get();
        double totalProbability = (double)level * baseProbability;
        if (level > 0 && totalProbability > 0.0) {
            int triggerCount = EnchantmentAbilityProcedure.calculateTriggerCount(totalProbability);
            for (int i = 0; i < triggerCount; ++i) {
                int amplifier = random.m_188503_(level);
                MobEffect effect = EffectUtils.getRandomGoodEffect();
                int duration = effect.m_8093_() ? level : level * 100;
                attacker.m_7292_(new MobEffectInstance(effect, duration, amplifier));
            }
        }
    }

    private static void handleCurseEffect(LivingEntity attacker, LivingEntity defender) {
        if (!((Boolean)MPEconfigConfiguration.SOURCE_OF_CURSES.get()).booleanValue() || !EnchantmentAbilityProcedure.canTriggerEffect((Entity)attacker)) {
            return;
        }
        ItemStack mainHand = attacker.m_21205_();
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)MorePotionEffectsModEnchantments.SOURCE_OF_CURSES.get()), (ItemStack)mainHand);
        double baseProbability = (Double)MPEconfigConfiguration.SOURCE_OF_CURSES_PROBABILITY.get();
        double totalProbability = (double)level * baseProbability;
        if (level > 0 && totalProbability > 0.0) {
            int triggerCount = EnchantmentAbilityProcedure.calculateTriggerCount(totalProbability);
            for (int i = 0; i < triggerCount; ++i) {
                int amplifier = random.m_188503_(level);
                MobEffect effect = EffectUtils.getRandomBadEffect();
                int duration = effect.m_8093_() ? level : level * 100;
                defender.m_7292_(new MobEffectInstance(effect, duration, amplifier));
            }
        }
    }

    private static void handleEliminationEffect(LivingEntity attacker, LivingEntity defender, LivingHurtEvent event) {
        if (!EnchantmentAbilityProcedure.canTriggerEffect((Entity)attacker) || defender.m_21023_((MobEffect)MorePotionEffectsModMobEffects.LOCK.get())) {
            return;
        }
        ItemStack mainHand = attacker.m_21205_();
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)MorePotionEffectsModEnchantments.ELIMINATION_EFFECT.get()), (ItemStack)mainHand);
        if (level == 0) {
            return;
        }
        ArrayList effects = new ArrayList(defender.m_21220_());
        if (effects.isEmpty()) {
            return;
        }
        double baseProbability = (Double)MPEconfigConfiguration.ELIMINATION_EFFECT_PROBABILITY.get();
        double totalProbability = (double)level * baseProbability;
        int maxRemovals = effects.size();
        int removedCount = 0;
        if (totalProbability > 0.0) {
            int triggerCount = EnchantmentAbilityProcedure.calculateTriggerCount(totalProbability);
            for (int i = 0; i < triggerCount && removedCount < maxRemovals; ++removedCount, ++i) {
                int index = random.m_188503_(effects.size());
                MobEffect effect = ((MobEffectInstance)effects.remove(index)).m_19544_();
                defender.m_21195_(effect);
            }
        }
    }

    private static void handleSunderArmorEffect(LivingEntity attacker, LivingEntity defender) {
        if (!EnchantmentAbilityProcedure.canTriggerEffect((Entity)attacker)) {
            return;
        }
        ItemStack mainHand = attacker.m_21205_();
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)MorePotionEffectsModEnchantments.SUNDER_ARMOR.get()), (ItemStack)mainHand);
        double baseProbability = (Double)MPEconfigConfiguration.SUNDER_ARMOR_PROBABILITY.get();
        double totalProbability = (double)level * baseProbability;
        if (level > 0 && totalProbability > 0.0) {
            int triggerCount = EnchantmentAbilityProcedure.calculateTriggerCount(totalProbability);
            int existingLevel = defender.m_21023_((MobEffect)MorePotionEffectsModMobEffects.ARMOR_BROKEN.get()) ? defender.m_21124_((MobEffect)MorePotionEffectsModMobEffects.ARMOR_BROKEN.get()).m_19564_() + 1 : 0;
            int newLevel = Math.min(level - 1, existingLevel);
            for (int i = 0; i < triggerCount; ++i) {
                defender.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.ARMOR_BROKEN.get(), 80 * level, newLevel));
                mainHand.m_220157_(Math.min(level * 4, defender.m_21230_()), random, null);
            }
        }
    }

    private static void handlePunisherEffect(LivingEntity attacker, LivingEntity defender, LivingHurtEvent event) {
        ArrayList effects;
        if (!EnchantmentAbilityProcedure.canTriggerEffect((Entity)attacker)) {
            return;
        }
        ItemStack mainHand = attacker.m_21205_();
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)MorePotionEffectsModEnchantments.POTION_PUNISHER.get()), (ItemStack)mainHand);
        if (level > 0 && !(effects = new ArrayList(defender.m_21220_())).isEmpty()) {
            int finalListSize = Math.min(effects.size(), level + 3);
            double damageMultiplier = 1.0 + (double)(level * effects.size()) * 0.05;
            float additionalDamage = level * finalListSize;
            event.setAmount((float)((double)event.getAmount() * damageMultiplier + (double)additionalDamage));
        }
    }

    private static void handleToxicBladeEffect(LivingEntity attacker, LivingEntity defender) {
        if (!EnchantmentAbilityProcedure.canTriggerEffect((Entity)attacker)) {
            return;
        }
        ItemStack mainHand = attacker.m_21205_();
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)MorePotionEffectsModEnchantments.HIGHLY_TOXIC_BLADE.get()), (ItemStack)mainHand);
        double baseProbability = (Double)MPEconfigConfiguration.ADMINISTER_POISON_PROBABILITY.get();
        double totalProbability = (double)level * baseProbability;
        if (level > 0 && totalProbability > 0.0) {
            int triggerCount = EnchantmentAbilityProcedure.calculateTriggerCount(totalProbability);
            int existingLevel = defender.m_21023_((MobEffect)MorePotionEffectsModMobEffects.HIGHLY_TOXIC.get()) ? defender.m_21124_((MobEffect)MorePotionEffectsModMobEffects.HIGHLY_TOXIC.get()).m_19564_() + 1 : 0;
            int newLevel = Math.min(level - 1, existingLevel);
            for (int i = 0; i < triggerCount; ++i) {
                defender.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.HIGHLY_TOXIC.get(), 40 * level, newLevel));
            }
        }
    }

    private static void handleCorrosionEffect(LivingEntity attacker, LivingEntity defender) {
        if (!EnchantmentAbilityProcedure.canTriggerEffect((Entity)attacker)) {
            return;
        }
        ItemStack mainHand = attacker.m_21205_();
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)MorePotionEffectsModEnchantments.INFLICTION_CORROSION.get()), (ItemStack)mainHand);
        double baseProbability = (Double)MPEconfigConfiguration.INFLICTION_CORROSION_PROBABILITY.get();
        double totalProbability = (double)level * baseProbability;
        if (level > 0 && totalProbability > 0.0) {
            int triggerCount = EnchantmentAbilityProcedure.calculateTriggerCount(totalProbability);
            int existingLevel = defender.m_21023_((MobEffect)MorePotionEffectsModMobEffects.CORROSION.get()) ? defender.m_21124_((MobEffect)MorePotionEffectsModMobEffects.CORROSION.get()).m_19564_() + 1 : 0;
            int newLevel = Math.min(level - 1, existingLevel);
            for (int i = 0; i < triggerCount; ++i) {
                defender.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.CORROSION.get(), 100 * level, newLevel));
            }
        }
    }

    private static void handleInhibitEffect(LivingEntity attacker, LivingEntity defender) {
        if (!EnchantmentAbilityProcedure.canTriggerEffect((Entity)attacker)) {
            return;
        }
        ItemStack mainHand = attacker.m_21205_();
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)MorePotionEffectsModEnchantments.INHIBIT_THERAPY.get()), (ItemStack)mainHand);
        double baseProbability = (Double)MPEconfigConfiguration.INHIBIT_THERAPY_PROBABILITY.get();
        double totalProbability = (double)level * baseProbability;
        if (level > 0 && totalProbability > 0.0) {
            int triggerCount = EnchantmentAbilityProcedure.calculateTriggerCount(totalProbability);
            int existingLevel = defender.m_21023_((MobEffect)MorePotionEffectsModMobEffects.WEAKENING_RECOVERY.get()) ? defender.m_21124_((MobEffect)MorePotionEffectsModMobEffects.WEAKENING_RECOVERY.get()).m_19564_() + 1 : 0;
            int newLevel = Math.min(level - 1, existingLevel);
            for (int i = 0; i < triggerCount; ++i) {
                defender.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.WEAKENING_RECOVERY.get(), 100 * level, newLevel));
            }
        }
    }

    @SubscribeEvent
    public static void onEquipmentSlotChange(LivingEquipmentChangeEvent event) {
        if (event.getSlot() == EquipmentSlot.CHEST) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                EnchantmentAbilityProcedure.handleEquipmentEffect((LivingEntity)player, event.getFrom(), event.getTo(), (Enchantment)MorePotionEffectsModEnchantments.FLYING.get(), (MobEffect)MorePotionEffectsModMobEffects.FLIGHT.get());
            }
            EnchantmentAbilityProcedure.handleEquipmentEffect(event.getEntity(), event.getFrom(), event.getTo(), (Enchantment)MorePotionEffectsModEnchantments.VIBRANT.get(), (MobEffect)MorePotionEffectsModMobEffects.STRONG_HEART.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleEquipmentEffect(LivingEntity livingEntity, ItemStack from, ItemStack to, Enchantment enchantment, MobEffect effect) {
        if (livingEntity.getPersistentData().m_128471_("EquipmentEffect")) {
            return;
        }
        livingEntity.getPersistentData().m_128379_("EquipmentEffect", true);
        try {
            MobEffectInstance current = livingEntity.m_21124_(effect);
            int oldLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)from);
            int newLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)to);
            boolean isOld = current != null && current.m_267577_() && current.m_19564_() + 1 == oldLevel;
            MobEffectInstance newInstance = new MobEffectInstance(effect, -1, Math.max(0, newLevel - 1), false, true, false);
            if (newLevel > oldLevel) {
                livingEntity.m_7292_(newInstance);
            } else if (newLevel < oldLevel && newLevel > 0) {
                if (isOld) {
                    livingEntity.m_21195_(effect);
                    livingEntity.m_7292_(newInstance);
                } else {
                    livingEntity.m_7292_(newInstance);
                }
            } else if (current != null && newLevel == 0) {
                livingEntity.m_21195_(effect);
                if (!isOld) {
                    livingEntity.m_7292_(current);
                }
            }
        }
        finally {
            livingEntity.getPersistentData().m_128473_("EquipmentEffect");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        double damage = event.getAmount();
        if (entity == null || damage < (double)entity.m_21223_()) {
            return;
        }
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)MorePotionEffectsModEnchantments.UNYIELDING.get()), (ItemStack)chest);
        if (level > 0) {
            entity.getPersistentData().m_128347_("static_damage", damage);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                double multiplier = 1.0 - 0.25 * (double)(level - 1);
                String message = String.format("\u00a76\u4f60\u5c06\u5728\u751f\u547d\u91cd\u65b0\u6d41\u901d\u540e\u53d7\u5230\u00a7c%.1f\u00a76\u70b9\u4f24\u5bb3\uff01", damage * multiplier);
                player.m_5661_((Component)Component.m_237113_((String)message), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)MorePotionEffectsModEnchantments.UNYIELDING.get()), (ItemStack)chest);
        if (level > 0 && !player.m_36335_().m_41519_(chest.m_41720_())) {
            player.m_21153_(1.0f);
            event.setCanceled(true);
            int duration = (int)Math.pow(2.0, level - 1) * 100;
            player.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.STATIC_LIFE.get(), duration, level - 1, false, true, false));
            player.m_36335_().m_41524_(chest.m_41720_(), (int)(3600.0 / (double)(level - 1)));
            player.m_216990_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.totem.use")));
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance ins = event.getEffectInstance();
        LivingEntity entity = event.getEntity();
        if (ins == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (ins.m_19544_() == MorePotionEffectsModMobEffects.FLIGHT.get()) {
                EnchantmentAbilityProcedure.handleEquipmentEffect((LivingEntity)player, ItemStack.f_41583_, player.m_6844_(EquipmentSlot.CHEST), (Enchantment)MorePotionEffectsModEnchantments.FLYING.get(), (MobEffect)MorePotionEffectsModMobEffects.FLIGHT.get());
            }
        }
        if (ins.m_19544_() == MorePotionEffectsModMobEffects.STRONG_HEART.get()) {
            EnchantmentAbilityProcedure.handleEquipmentEffect(entity, ItemStack.f_41583_, entity.m_6844_(EquipmentSlot.CHEST), (Enchantment)MorePotionEffectsModEnchantments.VIBRANT.get(), (MobEffect)MorePotionEffectsModMobEffects.STRONG_HEART.get());
        }
    }
}

