/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.commands.subcommands.AlertCommand;
import org.myplugin.deepGuardXray.commands.subcommands.AppealCommand;
import org.myplugin.deepGuardXray.commands.subcommands.CommandHidingCommand;
import org.myplugin.deepGuardXray.commands.subcommands.DebugCommand;
import org.myplugin.deepGuardXray.commands.subcommands.HighlightDecoyCommand;
import org.myplugin.deepGuardXray.commands.subcommands.MLCommand;
import org.myplugin.deepGuardXray.commands.subcommands.ModifySuspiciousCommand;
import org.myplugin.deepGuardXray.commands.subcommands.PunishCommand;
import org.myplugin.deepGuardXray.commands.subcommands.ReloadCommand;
import org.myplugin.deepGuardXray.commands.subcommands.StaffGuiCommand;
import org.myplugin.deepGuardXray.commands.subcommands.TeleportCommand;
import org.myplugin.deepGuardXray.commands.subcommands.UpdateCommand;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.utils.UpdateChecker;

public class AntiXrayCommand
implements CommandExecutor,
TabCompleter {
    private final deepGuardXray plugin;
    private final TeleportCommand teleportCommand;
    private final AlertCommand alertCommand;
    private final ReloadCommand reloadCommand;
    private final DebugCommand debugCommand;
    private final StaffGuiCommand staffguiCommand;
    private final ModifySuspiciousCommand pointsCommand;
    private final HighlightDecoyCommand highlightCommand;
    private final PunishCommand punishCommand;
    private final UpdateCommand updateCommand;
    private final AppealCommand appealCommand;
    private final MLCommand mlCommand;
    private final CommandHidingCommand commandHidingCommand;

    public AntiXrayCommand(deepGuardXray plugin, UpdateChecker updateChecker) {
        this.plugin = plugin;
        this.teleportCommand = new TeleportCommand();
        this.alertCommand = new AlertCommand(plugin);
        this.reloadCommand = new ReloadCommand(plugin);
        this.debugCommand = new DebugCommand(plugin);
        this.staffguiCommand = new StaffGuiCommand();
        this.pointsCommand = new ModifySuspiciousCommand(plugin);
        this.highlightCommand = new HighlightDecoyCommand(plugin);
        this.punishCommand = new PunishCommand(plugin);
        this.updateCommand = new UpdateCommand(plugin, updateChecker);
        this.appealCommand = new AppealCommand(plugin, plugin.getAppealManager());
        this.mlCommand = new MLCommand(plugin, plugin.getMLManager());
        this.commandHidingCommand = new CommandHidingCommand(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            ArrayList<String> available = new ArrayList<String>();
            if (player.hasPermission("deepguardx.teleport")) {
                available.add("teleport <x> <y> <z>");
            }
            if (player.hasPermission("deepguardx.togglealert")) {
                available.add("togglealert");
            }
            if (player.hasPermission("deepguardx.reload")) {
                available.add("reload");
            }
            if (player.hasPermission("deepguardx.debug")) {
                available.add("debug <true/false>");
            }
            if (player.hasPermission("deepguardx.gui")) {
                available.add("staff GUI menu");
            }
            if (player.hasPermission("deepguardx.punish")) {
                available.add("punish <set|remove|check> <player> [level]");
            }
            if (player.hasPermission("deepguardx.modify")) {
                available.add("points <add|remove|set|check> <player> [amount]");
            }
            if (player.hasPermission("deepguardx.highlight")) {
                available.add("highlight [radius|off|nearest]");
            }
            if (player.hasPermission("deepguardx.autoupdate")) {
                available.add("update <check|auto>");
            }
            if (player.hasPermission("deepguardx.ml.train") || player.hasPermission("deepguardx.ml.analyze") || player.hasPermission("deepguardx.ml.toggle") || player.hasPermission("deepguardx.ml.status")) {
                available.add("ml <train|analyze|enable|disable|status>");
            }
            if (player.hasPermission("deepguardx.staff")) {
                available.add("commandhiding <enable|disable>");
            }
            available.add("appeal");
            if (available.isEmpty()) {
                String version = this.plugin.getDescription().getVersion();
                player.sendMessage(((TextComponent)Component.text((String)"DeepGuard-XRay Plugin ", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)("v" + version), (TextColor)NamedTextColor.AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Running version " + version)))));
            } else {
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u25b6 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"DeepGuard-XRay ", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"Commands", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" \u25c0", (TextColor)NamedTextColor.GOLD)));
                for (String cmd : available) {
                    String commandText = "/" + label + " " + cmd;
                    String[] parts = cmd.split(" ", 2);
                    String baseCmd = parts[0];
                    String cmdArgs = parts.length > 1 ? " " + parts[1] : "";
                    Component message = ((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)("/" + label + " "), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)baseCmd, (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)cmdArgs, (TextColor)NamedTextColor.YELLOW));
                    message = !cmd.contains("[") && !cmd.contains("<") ? message.clickEvent(ClickEvent.runCommand((String)commandText)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Click to execute: " + commandText)))) : message.clickEvent(ClickEvent.suggestCommand((String)("/" + label + " " + baseCmd + " "))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Click to suggest: /" + label + " " + baseCmd))));
                    player.sendMessage(message);
                }
            }
            return true;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand) {
            case "commandhiding": {
                if (!player.isOp()) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"Only server operators can manage command hiding.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.commandHidingCommand.onCommand(sender, command, label, subArgs);
            }
            case "teleport": {
                if (!player.hasPermission("deepguardx.teleport")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to use teleport.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.teleportCommand.onCommand(sender, command, label, subArgs);
            }
            case "togglealert": {
                if (!player.hasPermission("deepguardx.togglealert")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to toggle alerts.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.alertCommand.onCommand(sender, command, label, subArgs);
            }
            case "reload": {
                if (!player.hasPermission("deepguardx.reload")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to reload the plugin.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.reloadCommand.onCommand(sender, command, label, subArgs);
            }
            case "debug": {
                if (!player.hasPermission("deepguardx.debug")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to change debug settings.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.debugCommand.onCommand(sender, command, label, subArgs);
            }
            case "staff": {
                if (!player.hasPermission("deepguardx.gui")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to access Staff GUI settings.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.staffguiCommand.onCommand(sender, command, label, subArgs);
            }
            case "punish": {
                if (!player.hasPermission("deepguardx.punish")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to manage punishments.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.punishCommand.onCommand(sender, command, label, subArgs);
            }
            case "points": {
                if (!player.hasPermission("deepguardx.modify")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to modify player points.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.pointsCommand.onCommand(sender, command, label, subArgs);
            }
            case "highlight": {
                if (!player.hasPermission("deepguardx.highlight")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to highlight decoy veins.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.highlightCommand.onCommand(sender, command, label, subArgs);
            }
            case "update": {
                if (!player.hasPermission("deepguardx.autoupdate")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to auto-update the plugin.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.updateCommand.onCommand(sender, command, label, subArgs);
            }
            case "appeal": {
                return this.appealCommand.onCommand(sender, command, label, subArgs);
            }
            case "ml": {
                if (!(player.hasPermission("deepguardx.ml.train") || player.hasPermission("deepguardx.ml.analyze") || player.hasPermission("deepguardx.ml.toggle") || player.hasPermission("deepguardx.ml.status"))) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to use ML commands.", (TextColor)NamedTextColor.RED)));
                    return true;
                }
                return this.mlCommand.onCommand(sender, command, label, subArgs);
            }
        }
        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u274c ", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"Unknown command: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)subCommand, (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)". Use ", (TextColor)NamedTextColor.RED))).append(((TextComponent)Component.text((String)("/" + label), (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).clickEvent(ClickEvent.runCommand((String)("/" + label)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Click to run: /" + label)))))).append((Component)Component.text((String)" for help.", (TextColor)NamedTextColor.RED)));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return suggestions;
        }
        if (args.length == 1) {
            String partial = args[0].toLowerCase();
            if (sender.isOp() && "commandhiding".startsWith(partial)) {
                suggestions.add("commandhiding");
            }
            if (sender.hasPermission("deepguardx.teleport") && "teleport".startsWith(partial)) {
                suggestions.add("teleport");
            }
            if (sender.hasPermission("deepguardx.togglealert") && "togglealert".startsWith(partial)) {
                suggestions.add("togglealert");
            }
            if (sender.hasPermission("deepguardx.reload") && "reload".startsWith(partial)) {
                suggestions.add("reload");
            }
            if (sender.hasPermission("deepguardx.debug") && "debug".startsWith(partial)) {
                suggestions.add("debug");
            }
            if (sender.hasPermission("deepguardx.gui") && "staff".startsWith(partial)) {
                suggestions.add("staff");
            }
            if (sender.hasPermission("deepguardx.punish") && "punish".startsWith(partial)) {
                suggestions.add("punish");
            }
            if (sender.hasPermission("deepguardx.modify") && "points".startsWith(partial)) {
                suggestions.add("points");
            }
            if (sender.hasPermission("deepguardx.highlight") && "highlight".startsWith(partial)) {
                suggestions.add("highlight");
            }
            if (sender.hasPermission("deepguardx.autoupdate") && "update".startsWith(partial)) {
                suggestions.add("update");
            }
            if ((sender.hasPermission("deepguardx.ml.train") || sender.hasPermission("deepguardx.ml.analyze") || sender.hasPermission("deepguardx.ml.toggle") || sender.hasPermission("deepguardx.ml.status")) && "ml".startsWith(partial)) {
                suggestions.add("ml");
            }
            if ("appeal".startsWith(partial)) {
                suggestions.add("appeal");
            }
        } else {
            if (args.length >= 2 && args[0].equalsIgnoreCase("ml")) {
                return this.mlCommand.getTabCompletions(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("update")) {
                if (sender.hasPermission("deepguardx.autoupdate")) {
                    String partial = args[1].toLowerCase();
                    if ("check".startsWith(partial)) {
                        suggestions.add("check");
                    }
                    if ("auto".startsWith(partial)) {
                        suggestions.add("auto");
                    }
                    if ("apply".startsWith(partial)) {
                        suggestions.add("apply");
                    }
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("punish")) {
                if (sender.hasPermission("deepguardx.punish")) {
                    String partial = args[1].toLowerCase();
                    if ("set".startsWith(partial)) {
                        suggestions.add("set");
                    }
                    if ("remove".startsWith(partial)) {
                        suggestions.add("remove");
                    }
                    if ("check".startsWith(partial)) {
                        suggestions.add("check");
                    }
                }
            } else if (args.length == 3 && args[0].equalsIgnoreCase("punish")) {
                if (sender.hasPermission("deepguardx.punish")) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        suggestions.add(player.getName());
                    }
                }
            } else if (args.length == 4 && args[0].equalsIgnoreCase("punish") && args[1].equalsIgnoreCase("set")) {
                if (sender.hasPermission("deepguardx.punish")) {
                    String partial = args[3].toLowerCase();
                    for (int i = 0; i <= 6; ++i) {
                        if (!String.valueOf(i).startsWith(partial)) continue;
                        suggestions.add(String.valueOf(i));
                    }
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("highlight")) {
                if (sender.hasPermission("deepguardx.highlight")) {
                    suggestions.add("off");
                    suggestions.add("nearest");
                    suggestions.add("return");
                    suggestions.add("20");
                    suggestions.add("30");
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("points")) {
                if (sender.hasPermission("deepguardx.modify")) {
                    suggestions.add("add");
                    suggestions.add("remove");
                    suggestions.add("set");
                    suggestions.add("check");
                }
            } else if (args.length == 3 && args[0].equalsIgnoreCase("points")) {
                if (sender.hasPermission("deepguardx.modify")) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        suggestions.add(player.getName());
                    }
                }
            } else if (args.length >= 2 && args[0].equalsIgnoreCase("commandhiding") && sender.isOp()) {
                return this.commandHidingCommand.getTabCompletions(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        return suggestions;
    }
}

