/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands.subcommands;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.SuspiciousManager;

public class ModifySuspiciousCommand
implements CommandExecutor {
    private final deepGuardXray plugin;

    public ModifySuspiciousCommand(deepGuardXray plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int currentCount;
        int amount;
        if (!sender.hasPermission("deepguardx.modify")) {
            sender.sendMessage(Component.text((String)"You do not have permission to modify player points.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length < 2) {
            this.showUsage(sender);
            return true;
        }
        String action = args[0].toLowerCase();
        if (action.equals("check") && args.length >= 2) {
            String targetName = args[1];
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
            if (target == null || !target.isOnline() && !target.hasPlayedBefore()) {
                sender.sendMessage(Component.text((String)("Player not found: " + targetName)).color((TextColor)NamedTextColor.RED));
                return true;
            }
            int currentPoints = SuspiciousManager.getSuspiciousCounts().getOrDefault(target.getUniqueId(), 0);
            sender.sendMessage(((TextComponent)Component.text((String)(target.getName() + "'s suspicious points: ")).color((TextColor)NamedTextColor.YELLOW)).append(Component.text((int)currentPoints).color((TextColor)NamedTextColor.WHITE)));
            if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                String adminName = sender.getName();
                if (!(sender instanceof Player)) {
                    adminName = "Console";
                }
                this.plugin.getWebhookManager().sendStaffActionLog(adminName, "Checked suspicious points for " + target.getName(), "Current points: " + currentPoints);
            }
            return true;
        }
        if (args.length < 3) {
            this.showUsage(sender);
            return true;
        }
        String targetName = args[1];
        try {
            amount = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Component.text((String)("Invalid amount: " + args[2])).color((TextColor)NamedTextColor.RED));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (target == null || !target.isOnline() && !target.hasPlayedBefore()) {
            sender.sendMessage(Component.text((String)("Player not found: " + targetName)).color((TextColor)NamedTextColor.RED));
            return true;
        }
        int newCount = currentCount = SuspiciousManager.getSuspiciousCounts().getOrDefault(target.getUniqueId(), 0).intValue();
        switch (action) {
            case "add": {
                newCount = currentCount + amount;
                break;
            }
            case "remove": {
                newCount = currentCount - amount;
                if (newCount >= 0) break;
                newCount = 0;
                break;
            }
            case "set": {
                newCount = amount;
                break;
            }
            default: {
                this.showUsage(sender);
                return true;
            }
        }
        SuspiciousManager.getSuspiciousCounts().put(target.getUniqueId(), newCount);
        if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
            String adminName = sender.getName();
            if (!(sender instanceof Player)) {
                adminName = "Console";
            }
            String actionDescription = switch (action) {
                case "add" -> "Added " + amount + " suspicious points to " + target.getName();
                case "remove" -> "Removed " + amount + " suspicious points from " + target.getName();
                case "set" -> "Set " + target.getName() + "'s suspicious points to " + amount;
                default -> "Modified " + target.getName() + "'s suspicious points";
            };
            String details = "Previous: " + currentCount + " \u2192 New: " + newCount;
            this.plugin.getWebhookManager().sendStaffActionLog(adminName, actionDescription, details);
        }
        sender.sendMessage(Component.text((String)("Updated " + target.getName() + "'s suspicious points from " + currentCount + " to " + newCount + ".")).color((TextColor)NamedTextColor.GREEN));
        return true;
    }

    private void showUsage(CommandSender sender) {
        sender.sendMessage(Component.text((String)"Usage:").color((TextColor)NamedTextColor.RED));
        sender.sendMessage(Component.text((String)"/deepguard points add <player> <amount>").color((TextColor)NamedTextColor.RED));
        sender.sendMessage(Component.text((String)"/deepguard points remove <player> <amount>").color((TextColor)NamedTextColor.RED));
        sender.sendMessage(Component.text((String)"/deepguard points set <player> <amount>").color((TextColor)NamedTextColor.RED));
        sender.sendMessage(Component.text((String)"/deepguard points check <player>").color((TextColor)NamedTextColor.RED));
    }
}

