/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands.subcommands;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.deepGuardXray;

public class PunishCommand
implements CommandExecutor {
    private final deepGuardXray plugin;

    public PunishCommand(deepGuardXray plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("deepguardx.punish")) {
            sender.sendMessage(Component.text((String)"You don't have permission to manage punishments.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(Component.text((String)"Usage: /deepguard punish <set|remove|check> <player> [level]").color((TextColor)NamedTextColor.RED));
            return true;
        }
        String action = args[0].toLowerCase();
        String playerName = args[1];
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            sender.sendMessage(Component.text((String)("Player " + playerName + " not found or not online.")).color((TextColor)NamedTextColor.RED));
            return true;
        }
        switch (action) {
            case "set": {
                int level;
                if (args.length < 3) {
                    sender.sendMessage(Component.text((String)"Usage: /deepguard punish set <player> <level>").color((TextColor)NamedTextColor.RED));
                    return true;
                }
                try {
                    level = Integer.parseInt(args[2]);
                    if (level < 0 || level > 6) {
                        sender.sendMessage(Component.text((String)"Punishment level must be between 0 and 6.").color((TextColor)NamedTextColor.RED));
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(Component.text((String)"Invalid level format. Must be a number between 0 and 6.").color((TextColor)NamedTextColor.RED));
                    return true;
                }
                this.plugin.getPunishmentManager().setPunishmentLevel(targetPlayer, level);
                if (level > 0 && this.plugin.getConfigManager().isWebhookAlertEnabled("punishment_applied")) {
                    String adminName = sender.getName();
                    if (!(sender instanceof Player)) {
                        adminName = "Console";
                    }
                    this.plugin.getWebhookManager().sendPunishmentAlertWithAdmin(targetPlayer, level, (String)(switch (level) {
                        case 1 -> "Warning Phase";
                        case 2 -> "Minor Consequences";
                        case 3 -> "Moderate Punishment";
                        case 4 -> "Severe Consequences";
                        case 5 -> "Critical Response";
                        case 6 -> "Maximum Enforcement";
                        default -> "Level " + level + " Punishment";
                    }), adminName);
                } else if (level == 0 && this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                    String adminName = sender.getName();
                    if (!(sender instanceof Player)) {
                        adminName = "Console";
                    }
                    this.plugin.getWebhookManager().sendStaffActionLog(adminName, "Removed punishment from " + targetPlayer.getName(), "Set to level 0");
                }
                if (level == 0) {
                    sender.sendMessage(Component.text((String)("Removed all punishments from " + targetPlayer.getName())).color((TextColor)NamedTextColor.GREEN));
                    break;
                }
                sender.sendMessage(Component.text((String)("Applied punishment level " + level + " to " + targetPlayer.getName())).color((TextColor)NamedTextColor.GREEN));
                break;
            }
            case "remove": {
                int currentPunishmentLevel = this.plugin.getPunishmentManager().getPlayerPunishmentLevel(targetPlayer.getUniqueId());
                this.plugin.getPunishmentManager().removePunishment(targetPlayer);
                if (currentPunishmentLevel > 0 && this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                    String adminName = sender.getName();
                    if (!(sender instanceof Player)) {
                        adminName = "Console";
                    }
                    this.plugin.getWebhookManager().sendStaffActionLog(adminName, "Removed punishment from " + targetPlayer.getName(), "Previous level: " + currentPunishmentLevel);
                }
                sender.sendMessage(Component.text((String)("Removed all punishments from " + targetPlayer.getName())).color((TextColor)NamedTextColor.GREEN));
                break;
            }
            case "check": {
                int currentLevel = this.plugin.getPunishmentManager().getPlayerPunishmentLevel(targetPlayer.getUniqueId());
                if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                    String adminName = sender.getName();
                    if (!(sender instanceof Player)) {
                        adminName = "Console";
                    }
                    this.plugin.getWebhookManager().sendStaffActionLog(adminName, "Checked punishment status for " + targetPlayer.getName(), "Current level: " + String.valueOf(currentLevel > 0 ? Integer.valueOf(currentLevel) : "None"));
                }
                if (currentLevel > 0) {
                    sender.sendMessage(Component.text((String)(targetPlayer.getName() + " is currently at punishment level " + currentLevel)).color((TextColor)NamedTextColor.GREEN));
                    break;
                }
                sender.sendMessage(Component.text((String)(targetPlayer.getName() + " currently has no active punishments")).color((TextColor)NamedTextColor.GREEN));
                break;
            }
            default: {
                sender.sendMessage(Component.text((String)"Invalid action. Use 'set', 'remove', or 'check'.").color((TextColor)NamedTextColor.RED));
            }
        }
        return true;
    }
}

