/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands.subcommands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Properties;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.utils.UpdateChecker;

public class UpdateCommand {
    private final deepGuardXray plugin;
    private final UpdateChecker updateChecker;

    public UpdateCommand(deepGuardXray plugin, UpdateChecker updateChecker) {
        this.plugin = plugin;
        this.updateChecker = updateChecker;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String action;
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"This command can only be used by players.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("deepguardx.autoupdate")) {
            player.sendMessage(Component.text((String)"You don't have permission to auto-update the plugin.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(Component.text((String)("Usage: /" + label + " update [check|auto|apply]")).color((TextColor)NamedTextColor.GREEN));
            return true;
        }
        switch (action = args[0].toLowerCase()) {
            case "check": {
                player.sendMessage(Component.text((String)"Checking for updates...").color((TextColor)NamedTextColor.YELLOW));
                this.updateChecker.getVersion(version -> {
                    String currentVersion = this.plugin.getPluginMeta().getVersion();
                    if (!version.equalsIgnoreCase(currentVersion)) {
                        player.sendMessage(Component.text((String)"=================================================").color((TextColor)NamedTextColor.GREEN));
                        player.sendMessage(Component.text((String)" DeepGuard-XRay: New update available!").color((TextColor)NamedTextColor.GREEN));
                        player.sendMessage(((TextComponent)Component.text((String)" Current version: ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)currentVersion).color((TextColor)NamedTextColor.RED)));
                        player.sendMessage(((TextComponent)Component.text((String)" New version: ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)version).color((TextColor)NamedTextColor.GREEN)));
                        player.sendMessage(Component.text((String)" Type '/deepguard update auto' to download the update").color((TextColor)NamedTextColor.GREEN));
                        player.sendMessage(Component.text((String)"=================================================").color((TextColor)NamedTextColor.GREEN));
                    } else {
                        player.sendMessage(Component.text((String)"DeepGuard-XRay is up to date!").color((TextColor)NamedTextColor.GREEN));
                    }
                });
                break;
            }
            case "auto": {
                if (!this.updateChecker.isUpdateAvailable()) {
                    player.sendMessage(Component.text((String)"Checking for updates first...").color((TextColor)NamedTextColor.YELLOW));
                    this.updateChecker.getVersion(version -> {
                        String currentVersion = this.plugin.getPluginMeta().getVersion();
                        if (!version.equalsIgnoreCase(currentVersion)) {
                            this.downloadUpdate(player);
                        } else {
                            player.sendMessage(Component.text((String)"DeepGuard-XRay is already up to date!").color((TextColor)NamedTextColor.GREEN));
                        }
                    });
                    break;
                }
                this.downloadUpdate(player);
                break;
            }
            case "apply": {
                this.applyUpdate(player);
                break;
            }
            default: {
                player.sendMessage(Component.text((String)"Unknown action. Use 'check' to check for updates, 'auto' to download the latest version, or 'apply' to finalize an update.").color((TextColor)NamedTextColor.RED));
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyUpdate(Player player) {
        boolean deleteSuccess;
        String newVersion;
        block33: {
            File oldPluginFile;
            block34: {
                block35: {
                    File newPluginFile;
                    block30: {
                        File pluginsDir = this.plugin.getServer().getUpdateFolderFile().getParentFile();
                        String pluginName = "DeepGuard-XRay";
                        String currentVersion = this.plugin.getPluginMeta().getVersion();
                        newVersion = this.updateChecker.getLatestVersion();
                        oldPluginFile = new File(pluginsDir, pluginName + "-" + currentVersion + ".jar");
                        newPluginFile = new File(pluginsDir, pluginName + "-" + newVersion + ".jar");
                        if (!oldPluginFile.exists() || !newPluginFile.exists()) {
                            player.sendMessage(Component.text((String)"Using update marker to identify files...").color((TextColor)NamedTextColor.YELLOW));
                            File updateMarker = new File(this.plugin.getDataFolder(), "pending_update.txt");
                            if (!updateMarker.exists()) {
                                File[] jarFiles = pluginsDir.listFiles((dir, name) -> name.toLowerCase().startsWith(pluginName.toLowerCase()) && name.toLowerCase().endsWith(".jar"));
                                if (jarFiles != null && jarFiles.length > 0) {
                                    player.sendMessage(Component.text((String)("Found " + jarFiles.length + " plugin JARs in directory.")).color((TextColor)NamedTextColor.YELLOW));
                                    Arrays.sort(jarFiles, (f1, f2) -> Long.compare(f2.lastModified(), f1.lastModified()));
                                    if (jarFiles.length < 2) {
                                        player.sendMessage(Component.text((String)"Could not find both versions of the plugin. Download the update first.").color((TextColor)NamedTextColor.RED));
                                        return;
                                    }
                                    newPluginFile = jarFiles[0];
                                    oldPluginFile = jarFiles[1];
                                    break block30;
                                } else {
                                    player.sendMessage(Component.text((String)"No pending update found. Use '/deepguard update auto' to download an update first.").color((TextColor)NamedTextColor.RED));
                                    return;
                                }
                            }
                            try {
                                Properties props = new Properties();
                                try (FileInputStream fis = new FileInputStream(updateMarker);){
                                    props.load(fis);
                                }
                                String currentPluginPath = props.getProperty("current_plugin");
                                String newPluginPath = props.getProperty("new_plugin");
                                boolean alreadyDeleted = Boolean.parseBoolean(props.getProperty("already_deleted", "false"));
                                if (alreadyDeleted) {
                                    player.sendMessage(Component.text((String)("The old plugin file was already deleted. Server restart is required to use version " + newVersion)).color((TextColor)NamedTextColor.YELLOW));
                                    return;
                                }
                                if (currentPluginPath == null || newPluginPath == null) {
                                    player.sendMessage(Component.text((String)"Invalid update information. Please try downloading the update again.").color((TextColor)NamedTextColor.RED));
                                    return;
                                }
                                oldPluginFile = new File(currentPluginPath);
                                newPluginFile = new File(newPluginPath);
                            }
                            catch (Exception e) {
                                player.sendMessage(Component.text((String)("Error reading update marker: " + e.getMessage())).color((TextColor)NamedTextColor.RED));
                                this.plugin.getLogger().warning("Error reading update marker: " + e.getMessage());
                                e.printStackTrace();
                                return;
                            }
                        }
                    }
                    if (!newPluginFile.exists()) {
                        player.sendMessage(Component.text((String)("New plugin file not found: " + newPluginFile.getAbsolutePath())).color((TextColor)NamedTextColor.RED));
                        return;
                    }
                    this.plugin.getLogger().info("Old plugin file: " + (oldPluginFile.exists() ? oldPluginFile.getAbsolutePath() : "Not found"));
                    this.plugin.getLogger().info("New plugin file: " + newPluginFile.getAbsolutePath());
                    deleteSuccess = false;
                    if (!oldPluginFile.exists()) break block34;
                    deleteSuccess = oldPluginFile.delete();
                    if (!deleteSuccess) break block35;
                    player.sendMessage(Component.text((String)("Successfully deleted old plugin JAR: " + oldPluginFile.getName())).color((TextColor)NamedTextColor.GREEN));
                    File updateMarker = new File(this.plugin.getDataFolder(), "pending_update.txt");
                    if (updateMarker.exists()) {
                        try {
                            Properties props = new Properties();
                            try (FileInputStream fis = new FileInputStream(updateMarker);){
                                props.load(fis);
                            }
                            props.setProperty("already_deleted", "true");
                            try (FileOutputStream fos = new FileOutputStream(updateMarker);){
                                props.store(fos, "Update status");
                                break block33;
                            }
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Failed to update marker file: " + e.getMessage());
                        }
                    }
                    break block33;
                }
                player.sendMessage(Component.text((String)"Failed to delete old plugin JAR. The file may be in use.").color((TextColor)NamedTextColor.RED));
                player.sendMessage(Component.text((String)"A server restart is required to apply the update.").color((TextColor)NamedTextColor.YELLOW));
                break block33;
            }
            player.sendMessage(Component.text((String)("Old plugin JAR not found at " + oldPluginFile.getAbsolutePath())).color((TextColor)NamedTextColor.YELLOW));
            player.sendMessage(Component.text((String)"It may have been already deleted or moved.").color((TextColor)NamedTextColor.YELLOW));
            deleteSuccess = true;
        }
        if (deleteSuccess) {
            player.sendMessage(Component.text((String)"=================================================").color((TextColor)NamedTextColor.GREEN));
            player.sendMessage(Component.text((String)(" DeepGuard-XRay update to version " + newVersion + " prepared.")).color((TextColor)NamedTextColor.GREEN));
            player.sendMessage(Component.text((String)" Please restart your server to use the new version.").color((TextColor)NamedTextColor.GREEN));
            if (player.isOp()) {
                Component restartMessage = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)" Click here to restart the server now ").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD)).clickEvent(ClickEvent.suggestCommand((String)"/restart"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to get the restart command")));
                player.sendMessage(restartMessage);
            }
            player.sendMessage(Component.text((String)"=================================================").color((TextColor)NamedTextColor.GREEN));
            this.plugin.getLogger().info("DeepGuard-XRay update to version " + newVersion + " prepared.");
            this.plugin.getLogger().info("The old plugin JAR has been deleted.");
            this.plugin.getLogger().info("Please restart your server to use the new version.");
        }
    }

    private void downloadUpdate(Player player) {
        player.sendMessage(Component.text((String)"Starting download of the latest version...").color((TextColor)NamedTextColor.YELLOW));
        this.updateChecker.downloadUpdate((Boolean success) -> {
            if (success.booleanValue()) {
                player.sendMessage(Component.text((String)"=================================================").color((TextColor)NamedTextColor.GREEN));
                player.sendMessage(Component.text((String)" DeepGuard-XRay update downloaded successfully!").color((TextColor)NamedTextColor.GREEN));
                Component applyMessage = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)" Click here to apply the update now ").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD)).clickEvent(ClickEvent.runCommand((String)"/deepguard update apply"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to prepare the update for next restart")));
                player.sendMessage(applyMessage);
                player.sendMessage(Component.text((String)" Or restart your server to apply automatically.").color((TextColor)NamedTextColor.GREEN));
                player.sendMessage(Component.text((String)"=================================================").color((TextColor)NamedTextColor.GREEN));
                this.plugin.getLogger().info("DeepGuard-XRay update downloaded successfully!");
                this.plugin.getLogger().info("Use '/deepguard update apply' to prepare the update");
                this.plugin.getLogger().info("or restart your server to apply automatically.");
            } else {
                player.sendMessage(Component.text((String)"Failed to download the update. Check the console for more details.").color((TextColor)NamedTextColor.RED));
            }
        });
    }
}

