/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.gui.subgui.AppealDetailsGUI;
import org.myplugin.deepGuardXray.gui.subgui.AppealGUI;
import org.myplugin.deepGuardXray.gui.subgui.AutoAnalysisGUI;
import org.myplugin.deepGuardXray.gui.subgui.AutoSaveSettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.ConfigSettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.DecoySettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.LevelPunishmentSettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.MLAnalysisGUI;
import org.myplugin.deepGuardXray.gui.subgui.MLReportsGUI;
import org.myplugin.deepGuardXray.gui.subgui.OreConfigGUI;
import org.myplugin.deepGuardXray.gui.subgui.PlayerMiningStatsGUI;
import org.myplugin.deepGuardXray.gui.subgui.PlayerSelectorGUI;
import org.myplugin.deepGuardXray.gui.subgui.PlayerStatsMainGUI;
import org.myplugin.deepGuardXray.gui.subgui.PunishmentSettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.StaffSettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.SuspiciousPlayersGUI;
import org.myplugin.deepGuardXray.gui.subgui.WebhookSettingsGUI;

public class GuiListener
implements Listener {
    private final deepGuardXray plugin;

    public GuiListener(deepGuardXray plugin) {
        this.plugin = plugin;
        StaffMenuGUI.setPlugin(plugin);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Component title = event.getView().title();
        String titlePlainText = PlainTextComponentSerializer.plainText().serialize(title);
        if (titlePlainText.contains("DeepGuard-XRay Control Panel") || titlePlainText.contains("\ud83d\udd0d Suspicious Activity") || titlePlainText.contains("\u2696 Punishment System") || titlePlainText.contains("\u2699 Plugin Configuration") || titlePlainText.contains("\u2699 Decoy Settings") || titlePlainText.contains("\u2699 Auto-Save Settings") || titlePlainText.contains("\u2699 Staff Settings") || titlePlainText.contains("\ud83d\udcca Player Analytics") || titlePlainText.contains("\ud83e\udd16 ML Analysis") || titlePlainText.contains("\ud83d\udccb ML Analysis Reports") || titlePlainText.contains("\u2699 Auto ML Analysis Settings") || titlePlainText.contains("\ud83d\udcca Select Player to Analyze") || titlePlainText.contains("\ud83d\udcc8 Select Normal Player for Training") || titlePlainText.contains("\ud83d\udd0d Select Cheater for Training") || titlePlainText.contains("Mining Stats") || titlePlainText.contains("Settings for Level") || titlePlainText.contains("\u26cf Ore Management") || titlePlainText.contains("\ud83d\udd14 Discord Webhook Settings") || titlePlainText.contains("\ud83d\udccb DeepGuardX Appeal System") || titlePlainText.contains("Appeal #") && titlePlainText.contains("Details")) {
            event.setCancelled(true);
            ItemStack clicked = event.getCurrentItem();
            if (clicked == null || !clicked.hasItemMeta() || !clicked.getItemMeta().hasDisplayName()) {
                return;
            }
            Component nameComponent = clicked.getItemMeta().displayName();
            String plainName = PlainTextComponentSerializer.plainText().serialize(nameComponent);
            Player player = (Player)event.getWhoClicked();
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.2f);
            if (titlePlainText.contains("DeepGuard-XRay Control Panel")) {
                if (plainName.contains("Player Analytics")) {
                    new PlayerStatsMainGUI(0).openInventory(player);
                } else if (plainName.contains("Suspicious Activity")) {
                    new SuspiciousPlayersGUI(0).openInventory(player);
                } else if (plainName.contains("Punishment System")) {
                    new PunishmentSettingsGUI(this.plugin.getConfigManager()).openInventory(player);
                } else if (plainName.contains("Ore Management")) {
                    new OreConfigGUI(this.plugin.getConfigManager()).openInventory(player);
                } else if (plainName.contains("Plugin Configuration")) {
                    if (player.hasPermission("deepguardx.gui_config")) {
                        new ConfigSettingsGUI(this.plugin.getConfigManager(), this.plugin).openInventory(player);
                    } else {
                        player.sendMessage(Component.text((String)"You don't have permission to access the config settings.").color((TextColor)NamedTextColor.RED));
                    }
                } else if (plainName.contains("Discord Webhook")) {
                    if (player.hasPermission("deepguardx.gui_webhook")) {
                        new WebhookSettingsGUI(this.plugin.getConfigManager(), this.plugin).openInventory(player);
                    } else {
                        player.sendMessage(Component.text((String)"You don't have permission to access webhook settings.").color((TextColor)NamedTextColor.RED));
                    }
                } else if (plainName.contains("ML Analysis")) {
                    if (player.hasPermission("deepguardx.gui_ml")) {
                        new MLAnalysisGUI(this.plugin).openInventory(player);
                    } else {
                        player.sendMessage(Component.text((String)"You don't have permission to access ML Analysis.").color((TextColor)NamedTextColor.RED));
                    }
                } else if (plainName.contains("Player Appeals")) {
                    if (player.hasPermission("deepguardx.gui_Appeal")) {
                        new AppealGUI(this.plugin, this.plugin.getAppealManager(), 0).openInventory(player);
                    } else {
                        player.sendMessage(Component.text((String)"You don't have permission to access the appeals system.").color((TextColor)NamedTextColor.RED));
                    }
                } else if (clicked.getType() == Material.NETHER_STAR || clicked.getType() == Material.BOOK || clicked.getType() == Material.REDSTONE || clicked.getType() == Material.COMPASS || clicked.getType() == Material.BARRIER || clicked.getType() == Material.OBSERVER || clicked.getType() == Material.LODESTONE) {
                    return;
                }
            } else if (titlePlainText.contains("\ud83e\udd16 ML Analysis")) {
                if (!player.hasPermission("deepguardx.gui_ml")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access ML Analysis.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                MLAnalysisGUI.handleClick(player, event.getRawSlot(), event.getInventory(), this.plugin);
            } else if (titlePlainText.contains("\u2699 Auto ML Analysis Settings")) {
                if (!player.hasPermission("deepguardx.gui_ml")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access ML Analysis settings.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                AutoAnalysisGUI.handleClick(player, event.getRawSlot(), event.getInventory(), this.plugin);
            } else if (titlePlainText.contains("\ud83d\udcca Select Player to Analyze")) {
                if (!player.hasPermission("deepguardx.gui_ml")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access ML Analysis.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                PlayerSelectorGUI.handleClick(player, event.getRawSlot(), event.getInventory(), this.plugin, PlayerSelectorGUI.SelectionType.ANALYZE);
            } else if (titlePlainText.contains("\ud83d\udccb ML Analysis Reports")) {
                if (!player.hasPermission("deepguardx.gui_ml")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access ML Reports.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                MLReportsGUI.handleClick(player, event.getRawSlot(), event.getInventory(), this.plugin);
            } else if (titlePlainText.contains("\ud83d\udcc8 Select Normal Player for Training")) {
                if (!player.hasPermission("deepguardx.gui_ml")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access ML Analysis.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                PlayerSelectorGUI.handleClick(player, event.getRawSlot(), event.getInventory(), this.plugin, PlayerSelectorGUI.SelectionType.TRAIN_NORMAL);
            } else if (titlePlainText.contains("\ud83d\udd0d Select Cheater for Training")) {
                if (!player.hasPermission("deepguardx.gui_ml")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access ML Analysis.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                PlayerSelectorGUI.handleClick(player, event.getRawSlot(), event.getInventory(), this.plugin, PlayerSelectorGUI.SelectionType.TRAIN_CHEATER);
            } else if (titlePlainText.contains("\ud83d\udccb DeepGuardX Appeal System")) {
                if (!player.hasPermission("deepguardx.gui_Appeal")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access the appeals system.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                AppealGUI.handleClick(player, event.getRawSlot(), event.getInventory(), this.plugin, this.plugin.getAppealManager());
            } else if (titlePlainText.contains("Appeal #") && titlePlainText.contains("Details")) {
                if (!player.hasPermission("deepguardx.gui_Appeal")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access the appeals system.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                AppealDetailsGUI.handleClick(player, event.getRawSlot(), event.getClick(), event.getInventory(), this.plugin, this.plugin.getAppealManager());
            } else if (titlePlainText.contains("\ud83d\udd14 Discord Webhook Settings")) {
                if (!player.hasPermission("deepguardx.gui_webhook")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access webhook settings.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                WebhookSettingsGUI.handleClick(player, event.getRawSlot(), event.getInventory(), this.plugin.getConfigManager(), this.plugin);
            } else if (titlePlainText.contains("\u2696 Punishment System")) {
                if (clicked.getType() == Material.GREEN_WOOL || clicked.getType() == Material.RED_WOOL) {
                    int slot = event.getRawSlot();
                    int level = slot / 9 + 1;
                    boolean currentlyEnabled = this.plugin.getConfigManager().isPunishmentEnabled(level);
                    this.plugin.getConfigManager().setPunishmentEnabled(level, !currentlyEnabled);
                    if (currentlyEnabled) {
                        this.plugin.getPunishmentManager().onPunishmentLevelDisabled(level, player.getName());
                        player.sendMessage((Component)Component.text((String)("Punishment level " + level + " disabled. All affected players have been notified."), (TextColor)NamedTextColor.GREEN));
                        if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                            this.plugin.getWebhookManager().sendStaffActionLog(player.getName(), "Disabled Punishment Level " + level, "All affected players");
                        }
                    } else {
                        player.sendMessage((Component)Component.text((String)("Punishment level " + level + " enabled."), (TextColor)NamedTextColor.GREEN));
                        this.plugin.getLogger().info("Admin " + player.getName() + " enabled punishment level " + level);
                        if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                            this.plugin.getWebhookManager().sendStaffActionLog(player.getName(), "Enabled Punishment Level " + level, "Server-wide setting");
                        }
                    }
                    new PunishmentSettingsGUI(this.plugin.getConfigManager()).openInventory(player);
                } else if (clicked.getType() == Material.BELL || clicked.getType() == Material.GRAY_DYE && plainName.contains("Admin Alerts")) {
                    int slot = event.getRawSlot();
                    int level = slot / 9 + 1;
                    boolean current = this.plugin.getConfigManager().isPunishmentOptionEnabled(level, "admin_alert");
                    this.plugin.getConfigManager().setPunishmentOptionEnabled(level, "admin_alert", !current);
                    this.plugin.getLogger().info("Admin " + player.getName() + " " + (current ? "disabled" : "enabled") + " admin alerts for punishment level " + level);
                    if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                        this.plugin.getWebhookManager().sendStaffActionLog(player.getName(), (current ? "Disabled" : "Enabled") + " Admin Alerts for Punishment Level " + level, "Configuration Change");
                    }
                    new PunishmentSettingsGUI(this.plugin.getConfigManager()).openInventory(player);
                } else if (clicked.getType() == Material.BOOK || clicked.getType() == Material.GRAY_DYE && plainName.contains("Warning Messages")) {
                    int slot = event.getRawSlot();
                    int level = slot / 9 + 1;
                    boolean current = this.plugin.getConfigManager().isPunishmentOptionEnabled(level, "warning_message");
                    this.plugin.getConfigManager().setPunishmentOptionEnabled(level, "warning_message", !current);
                    if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                        this.plugin.getWebhookManager().sendStaffActionLog(player.getName(), (current ? "Disabled" : "Enabled") + " Warning Messages for Punishment Level " + level, "Configuration Change");
                    }
                    new PunishmentSettingsGUI(this.plugin.getConfigManager()).openInventory(player);
                } else if (plainName.contains("Advanced settings")) {
                    int slot = event.getRawSlot();
                    int level = slot / 9 + 1;
                    new LevelPunishmentSettingsGUI(this.plugin.getConfigManager(), level).openInventory(player);
                } else if (!plainName.contains("Icon Guide") && plainName.contains("Back to")) {
                    new StaffMenuGUI().openInventory(player);
                }
            } else if (titlePlainText.contains("Settings for Level")) {
                int level = Integer.parseInt(titlePlainText.substring(titlePlainText.indexOf("Level ") + 6, titlePlainText.indexOf(" Punishment")));
                if (plainName.contains("Back to")) {
                    new PunishmentSettingsGUI(this.plugin.getConfigManager()).openInventory(player);
                } else {
                    LevelPunishmentSettingsGUI.handleClick(player, event.getRawSlot(), level, this.plugin.getConfigManager());
                }
            } else if (titlePlainText.contains("\ud83d\udcca Player Analytics")) {
                PlayerStatsMainGUI.handleClick(player, event.getRawSlot(), event.getInventory());
            } else if (titlePlainText.contains("Mining Stats")) {
                PlayerMiningStatsGUI.handleClick(player, event.getRawSlot());
            } else if (titlePlainText.contains("\u26cf Ore Management")) {
                if (plainName.contains("Back to")) {
                    new StaffMenuGUI().openInventory(player);
                    return;
                }
                Material oreMaterial = clicked.getType();
                if (this.plugin.getConfigManager().getNaturalOres().contains(oreMaterial)) {
                    this.plugin.getConfigManager().getNaturalOres().remove(oreMaterial);
                    this.plugin.getConfig().set("ores.natural", this.plugin.getConfigManager().getNaturalOres().stream().map(Enum::name).toList());
                    this.plugin.saveConfig();
                    player.sendMessage(Component.text((String)(oreMaterial.name() + " removed from natural ores.")).color((TextColor)NamedTextColor.YELLOW));
                    if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                        this.plugin.getWebhookManager().sendStaffActionLog(player.getName(), "Ore Configuration", "Removed " + oreMaterial.name() + " from natural ores");
                    }
                } else {
                    this.plugin.getConfigManager().getNaturalOres().add(oreMaterial);
                    this.plugin.getConfig().set("ores.natural", this.plugin.getConfigManager().getNaturalOres().stream().map(Enum::name).toList());
                    this.plugin.saveConfig();
                    player.sendMessage(Component.text((String)(oreMaterial.name() + " added to natural ores.")).color((TextColor)NamedTextColor.GREEN));
                    if (this.plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                        this.plugin.getWebhookManager().sendStaffActionLog(player.getName(), "Ore Configuration", "Added " + oreMaterial.name() + " to natural ores");
                    }
                }
                new OreConfigGUI(this.plugin.getConfigManager()).openInventory(player);
            } else if (titlePlainText.contains("\ud83d\udd0d Suspicious Activity")) {
                SuspiciousPlayersGUI.handleClick(player, event.getRawSlot(), event.getInventory());
            } else if (titlePlainText.equals("\u2699 Plugin Configuration")) {
                if (!player.hasPermission("deepguardx.gui_config")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access config settings.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                ConfigSettingsGUI.handleClick(player, event.getRawSlot(), event.getInventory(), this.plugin.getConfigManager(), this.plugin);
            } else if (titlePlainText.equals("\u2699 Decoy Settings")) {
                if (!player.hasPermission("deepguardx.gui_config")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access config settings.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                DecoySettingsGUI.handleClick(player, event.getRawSlot(), event.getInventory(), event.getClick(), this.plugin.getConfigManager(), this.plugin);
            } else if (titlePlainText.equals("\u2699 Auto-Save Settings")) {
                if (!player.hasPermission("deepguardx.gui_config")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access config settings.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                AutoSaveSettingsGUI.handleClick(player, event.getRawSlot(), event.getInventory(), event.getClick(), this.plugin.getConfigManager(), this.plugin);
            } else if (titlePlainText.equals("\u2699 Staff Settings")) {
                if (!player.hasPermission("deepguardx.gui_config")) {
                    player.sendMessage(Component.text((String)"You don't have permission to access config settings.").color((TextColor)NamedTextColor.RED));
                    player.closeInventory();
                    return;
                }
                StaffSettingsGUI.handleClick(player, event.getRawSlot(), event.getInventory(), event.getClick(), this.plugin.getConfigManager(), this.plugin);
            }
        }
    }
}

