/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.subgui.AppealGUI;
import org.myplugin.deepGuardXray.managers.AppealManager;

public class AppealDetailsGUI {
    private final Inventory inv;
    private final deepGuardXray plugin;
    private final AppealManager appealManager;
    private final AppealManager.Appeal appeal;
    private static final Map<UUID, Integer> staffEnteringResponse = new HashMap<UUID, Integer>();

    public AppealDetailsGUI(deepGuardXray plugin, AppealManager appealManager, AppealManager.Appeal appeal) {
        this.plugin = plugin;
        this.appealManager = appealManager;
        this.appeal = appeal;
        this.inv = Bukkit.createInventory(null, (int)54, (Component)((TextComponent)Component.text((String)("Appeal #" + appeal.getId() + " Details")).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.BOLD, true));
        this.initializeItems();
    }

    private void initializeItems() {
        this.createBorder();
        this.addPlayerInfo();
        this.addAppealDetails();
        this.addActionButtons();
    }

    private void createBorder() {
        int i;
        ItemStack borderItem = this.createGuiItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, Component.text((String)" ").color((TextColor)NamedTextColor.WHITE), false, new Component[0]);
        for (i = 0; i < 9; ++i) {
            this.inv.setItem(i, borderItem);
            this.inv.setItem(45 + i, borderItem);
        }
        for (i = 1; i < 5; ++i) {
            this.inv.setItem(i * 9, borderItem);
            this.inv.setItem(i * 9 + 8, borderItem);
        }
    }

    private void addPlayerInfo() {
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)playerHead.getItemMeta();
        Player targetPlayer = Bukkit.getPlayer((UUID)this.appeal.getPlayerId());
        if (targetPlayer != null) {
            skullMeta.setOwningPlayer((OfflinePlayer)targetPlayer);
        } else {
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)this.appeal.getPlayerId()));
        }
        skullMeta.displayName(((TextComponent)Component.text((String)this.appeal.getPlayerName()).color((TextColor)NamedTextColor.AQUA)).decoration(TextDecoration.BOLD, true));
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(((TextComponent)Component.text((String)"Punishment Level: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((int)this.appeal.getPunishmentLevel()).color((TextColor)NamedTextColor.RED)));
        lore.add(((TextComponent)Component.text((String)"Appeal Date: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.appeal.getFormattedTimestamp()).color((TextColor)NamedTextColor.YELLOW)));
        lore.add(((TextComponent)Component.text((String)"Status: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.appeal.getStatus().getDisplayName()).color(this.appeal.getStatus().getColor())));
        skullMeta.lore(lore);
        playerHead.setItemMeta((ItemMeta)skullMeta);
        this.inv.setItem(4, playerHead);
    }

    private void addAppealDetails() {
        String reason = this.appeal.getReason();
        List<String> reasonLines = this.breakIntoLines(reason, 30);
        for (int i = 0; i < Math.min(reasonLines.size(), 15); ++i) {
            Material material = i == 0 ? Material.WRITABLE_BOOK : Material.PAPER;
            Component name = i == 0 ? ((TextComponent)Component.text((String)"Appeal Reason:").color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.BOLD, true) : Component.text((String)"Continued...").color((TextColor)NamedTextColor.YELLOW);
            ItemStack reasonItem = this.createGuiItem(material, name, false, Component.text((String)reasonLines.get(i)).color((TextColor)NamedTextColor.WHITE));
            int row = 2 + i / 5;
            int col = 2 + i % 5;
            this.inv.setItem(row * 9 + col, reasonItem);
        }
    }

    private void addActionButtons() {
        ItemStack approveItem = this.createGuiItem(Material.LIME_WOOL, ((TextComponent)Component.text((String)"APPROVE APPEAL").color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.BOLD, true), true, new Component[]{Component.text((String)"Click to approve this appeal").color((TextColor)NamedTextColor.GRAY), Component.text((String)"This will remove the player's punishment").color((TextColor)NamedTextColor.GRAY), Component.empty(), Component.text((String)"You'll be asked to enter a response").color((TextColor)NamedTextColor.YELLOW)});
        this.inv.setItem(38, approveItem);
        ItemStack denyItem = this.createGuiItem(Material.RED_WOOL, ((TextComponent)Component.text((String)"DENY APPEAL").color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.BOLD, true), true, new Component[]{Component.text((String)"Click to deny this appeal").color((TextColor)NamedTextColor.GRAY), Component.text((String)"The punishment will remain active").color((TextColor)NamedTextColor.GRAY), Component.empty(), Component.text((String)"You'll be asked to enter a response").color((TextColor)NamedTextColor.YELLOW)});
        this.inv.setItem(42, denyItem);
        ItemStack reviewItem = this.createGuiItem(Material.ORANGE_WOOL, ((TextComponent)Component.text((String)"MARK AS UNDER REVIEW").color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.BOLD, true), true, Component.text((String)"Click to mark as under review").color((TextColor)NamedTextColor.GRAY), Component.text((String)"This will notify the player").color((TextColor)NamedTextColor.GRAY), Component.text((String)"that their appeal is being reviewed").color((TextColor)NamedTextColor.GRAY));
        this.inv.setItem(40, reviewItem);
        ItemStack backItem = this.createGuiItem(Material.ARROW, Component.text((String)"\u2190 Back to Appeal List").color((TextColor)NamedTextColor.YELLOW), false, new Component[0]);
        this.inv.setItem(49, backItem);
    }

    private ItemStack createGuiItem(Material material, Component name, boolean enchanted, Component ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(name);
        if (lore.length > 0) {
            ArrayList loreList = new ArrayList();
            Collections.addAll(loreList, lore);
            meta.lore(loreList);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.DENSITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    private List<String> breakIntoLines(String text, int maxLength) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text.length() <= maxLength) {
            lines.add(text);
            return lines;
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > maxLength) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
        player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.7f, 1.0f);
    }

    public static boolean handleClick(Player player, int slot, ClickType clickType, Inventory inventory, deepGuardXray plugin, AppealManager appealManager) {
        Component title = player.getOpenInventory().title();
        if (title == null || !title.toString().contains("Appeal #")) {
            return false;
        }
        String titleStr = title.toString();
        int appealId = Integer.parseInt(titleStr.substring(titleStr.indexOf("#") + 1, titleStr.indexOf(" Details")));
        AppealManager.Appeal appeal = appealManager.getAppeal(appealId);
        if (appeal == null) {
            player.sendMessage(Component.text((String)"Appeal not found!").color((TextColor)NamedTextColor.RED));
            player.closeInventory();
            return true;
        }
        if (slot == 49) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
            new AppealGUI(plugin, appealManager, 0).openInventory(player);
            return true;
        }
        if (slot == 38) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.7f, 1.5f);
            player.closeInventory();
            staffEnteringResponse.put(player.getUniqueId(), appealId);
            player.sendMessage((Component)Component.empty());
            player.sendMessage(Component.text((String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557").color((TextColor)NamedTextColor.GREEN));
            player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)"Enter your response for this appeal:").color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.GREEN)));
            player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)"Your next message will be sent to the").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.GREEN)));
            player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)"player as part of the approval.").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.GREEN)));
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)"Type ").color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)"cancel").color((TextColor)NamedTextColor.RED))).append(Component.text((String)" to cancel this action.").color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.GREEN)));
            player.sendMessage(Component.text((String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d").color((TextColor)NamedTextColor.GREEN));
            AppealDetailsGUI.listenForChatResponse(player, plugin, appealManager, appeal, AppealManager.AppealStatus.APPROVED);
            return true;
        }
        if (slot == 42) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.7f, 1.0f);
            player.closeInventory();
            staffEnteringResponse.put(player.getUniqueId(), appealId);
            player.sendMessage((Component)Component.empty());
            player.sendMessage(Component.text((String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557").color((TextColor)NamedTextColor.RED));
            player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.RED)).append(Component.text((String)"Enter your reason for denying:").color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.RED)));
            player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.RED)).append(Component.text((String)"Your next message will be sent to the").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.RED)));
            player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.RED)).append(Component.text((String)"player as part of the denial.").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.RED)));
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.RED)).append(Component.text((String)"Type ").color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)"cancel").color((TextColor)NamedTextColor.RED))).append(Component.text((String)" to cancel this action.").color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.RED)));
            player.sendMessage(Component.text((String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d").color((TextColor)NamedTextColor.RED));
            AppealDetailsGUI.listenForChatResponse(player, plugin, appealManager, appeal, AppealManager.AppealStatus.DENIED);
            return true;
        }
        if (slot == 40) {
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.2f);
            appealManager.updateAppealStatus(appealId, AppealManager.AppealStatus.UNDER_REVIEW, player.getName(), "");
            player.sendMessage(Component.text((String)("Appeal #" + appealId + " marked as under review.")).color((TextColor)NamedTextColor.GOLD));
            new AppealGUI(plugin, appealManager, 0).openInventory(player);
            return true;
        }
        return false;
    }

    private static void listenForChatResponse(final Player player, final deepGuardXray plugin, final AppealManager appealManager, final AppealManager.Appeal appeal, final AppealManager.AppealStatus newStatus) {
        plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerChat(AsyncPlayerChatEvent event) {
                if (!event.getPlayer().equals((Object)player)) {
                    return;
                }
                if (!staffEnteringResponse.containsKey(player.getUniqueId())) {
                    return;
                }
                event.setCancelled(true);
                String message = event.getMessage();
                if (message.equalsIgnoreCase("cancel")) {
                    staffEnteringResponse.remove(player.getUniqueId());
                    player.sendMessage(Component.text((String)"Appeal response canceled.").color((TextColor)NamedTextColor.YELLOW));
                    HandlerList.unregisterAll((Listener)this);
                    plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> new AppealDetailsGUI(plugin, appealManager, appeal).openInventory(player));
                    return;
                }
                int appealId = staffEnteringResponse.get(player.getUniqueId());
                staffEnteringResponse.remove(player.getUniqueId());
                HandlerList.unregisterAll((Listener)this);
                plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> {
                    appealManager.updateAppealStatus(appealId, newStatus, player.getName(), message);
                    if (newStatus == AppealManager.AppealStatus.APPROVED) {
                        player.sendMessage(Component.text((String)("Appeal #" + appealId + " approved successfully!")).color((TextColor)NamedTextColor.GREEN));
                    } else {
                        player.sendMessage(Component.text((String)("Appeal #" + appealId + " denied.")).color((TextColor)NamedTextColor.RED));
                    }
                    new AppealGUI(plugin, appealManager, 0).openInventory(player);
                });
            }
        }, (Plugin)plugin);
    }
}

