/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.subgui.MLAnalysisGUI;
import org.myplugin.deepGuardXray.ml.MLManager;

public class PlayerSelectorGUI {
    private final deepGuardXray plugin;
    private final SelectionType type;
    private static final int ROWS = 5;
    private static final int SLOTS_PER_PAGE = 45;
    private static final Map<UUID, Integer> playerPages = new HashMap<UUID, Integer>();
    private static final int PREV_PAGE_SLOT = 45;
    private static final int BACK_BUTTON_SLOT = 49;
    private static final int NEXT_PAGE_SLOT = 53;

    public PlayerSelectorGUI(deepGuardXray plugin, SelectionType type) {
        this.plugin = plugin;
        this.type = type;
    }

    public void openInventory(Player player) {
        this.openInventory(player, 0);
    }

    public void openInventory(Player player, int page) {
        Object title;
        playerPages.put(player.getUniqueId(), page);
        ArrayList onlinePlayers = new ArrayList(Bukkit.getOnlinePlayers());
        int invSize = 54;
        switch (this.type.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object object = "\ud83d\udcca Select Player to Analyze";
                break;
            }
            case 1: {
                Object object = "\ud83d\udcc8 Select Normal Player for Training";
                break;
            }
            case 2: {
                Object object = title = "\ud83d\udd0d Select Cheater for Training";
            }
        }
        if (onlinePlayers.size() > 45) {
            title = (String)title + " (Page " + (page + 1) + ")";
        }
        Inventory inventory = Bukkit.createInventory(null, (int)invSize, (Component)Component.text((String)title).color((TextColor)NamedTextColor.DARK_AQUA));
        if (onlinePlayers.isEmpty()) {
            ItemStack noPlayers = PlayerSelectorGUI.createItem(Material.BARRIER, "No Players Available", List.of("There are no players available for selection"));
            inventory.setItem(22, noPlayers);
        }
        MLManager mlManager = this.plugin.getMLManager();
        int totalPages = (int)Math.ceil((double)onlinePlayers.size() / 45.0);
        int startIndex = page * 45;
        int endIndex = Math.min(startIndex + 45, onlinePlayers.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Player target = (Player)onlinePlayers.get(i);
            int slot = i - startIndex;
            ItemStack head = this.createPlayerHead(target, player, mlManager);
            inventory.setItem(slot, head);
        }
        if (page > 0) {
            inventory.setItem(45, PlayerSelectorGUI.createItem(Material.ARROW, "Previous Page", List.of("Go to page " + page)));
        }
        inventory.setItem(49, PlayerSelectorGUI.createItem(Material.BARRIER, "Back to ML Analysis", List.of("Return to the ML Analysis menu")));
        if (page < totalPages - 1) {
            inventory.setItem(53, PlayerSelectorGUI.createItem(Material.ARROW, "Next Page", List.of("Go to page " + (page + 2))));
        }
        if (this.type == SelectionType.TRAIN_NORMAL) {
            inventory.setItem(48, this.createNormalTrainingInstructionsItem());
        } else if (this.type == SelectionType.TRAIN_CHEATER) {
            inventory.setItem(48, this.createCheaterTrainingInstructionsItem());
        }
        player.openInventory(inventory);
    }

    private ItemStack createNormalTrainingInstructionsItem() {
        return PlayerSelectorGUI.createItem(Material.BOOK, "\u00a7a\u00a7l\ud83d\udccb How To Train Normal Players", List.of("\u00a7e\u00a7lFor good NORMAL player training data:", "\u00a7f\u2022 Mine normally (straight, branch mine)", "\u00a7f\u2022 Explore caves naturally", "\u00a7f\u2022 Mine various ore types, not just diamonds", "\u00a7f\u2022 Play legitimately without any cheats", "\u00a7c\u2022 DO NOT stay AFK during training", "\u00a7c\u2022 DO NOT use unusual mining patterns", "", "\u00a7e\u00a7lWHO TO SELECT:", "\u00a7f\u2022 Yourself (best option)", "\u00a7f\u2022 Trusted staff members", "\u00a7f\u2022 Players you're 100% confident are legitimate", "\u00a7c\u2022 NEVER guess or assume a player is legitimate"));
    }

    private ItemStack createCheaterTrainingInstructionsItem() {
        return PlayerSelectorGUI.createItem(Material.ENCHANTED_BOOK, "\u00a7c\u00a7l\ud83d\udccb How To Train Cheater Data", List.of("\u00a7e\u00a7lFor accurate CHEATER training data:", "\u00a7f\u2022 Enable X-ray yourself", "\u00a7f\u2022 Mine directly to valuable ores", "\u00a7f\u2022 Skip iron/coal, focus on diamonds", "\u00a7f\u2022 Use unusual mining patterns", "\u00a7f\u2022 Dig straight to ores through stone", "\u00a7c\u2022 DO NOT stay AFK during training", "\u00a7c\u2022 DO NOT mine randomly or normally", "", "\u00a7e\u00a7lWHO TO SELECT:", "\u00a7f\u2022 Yourself using X-ray (best option)", "\u00a7f\u2022 Trusted staff mimicking X-ray behavior", "\u00a7f\u2022 ONLY players with confirmed X-ray use", "\u00a7c\u2022 NEVER label someone as cheater without proof"));
    }

    private ItemStack createPlayerHead(Player target, Player viewer, MLManager mlManager) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer((OfflinePlayer)target);
        boolean inAnalysis = mlManager.getPlayersUnderAnalysis().contains(target.getUniqueId());
        boolean inTrainingNormal = mlManager.getPlayersInTraining().containsKey(target.getUniqueId()) && mlManager.getPlayersInTraining().get(target.getUniqueId()) == false;
        boolean inTrainingCheater = mlManager.getPlayersInTraining().containsKey(target.getUniqueId()) && mlManager.getPlayersInTraining().get(target.getUniqueId()) != false;
        boolean canBeSelected = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (!(inAnalysis || inTrainingNormal || inTrainingCheater)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (!(inAnalysis || inTrainingNormal || inTrainingCheater)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> !inAnalysis && !inTrainingNormal && !inTrainingCheater;
        };
        ArrayList<Object> loreComponents = new ArrayList<Object>();
        NamedTextColor nameColor = NamedTextColor.WHITE;
        if (canBeSelected) {
            switch (this.type.ordinal()) {
                case 0: {
                    nameColor = NamedTextColor.AQUA;
                    loreComponents.add(Component.text((String)"Click to analyze this player").color((TextColor)NamedTextColor.YELLOW));
                    loreComponents.add(Component.text((String)"for potential X-ray usage").color((TextColor)NamedTextColor.YELLOW));
                    break;
                }
                case 1: {
                    nameColor = NamedTextColor.GREEN;
                    loreComponents.add(Component.text((String)"Click to use this player's data").color((TextColor)NamedTextColor.YELLOW));
                    loreComponents.add(Component.text((String)"for training as a NORMAL player").color((TextColor)NamedTextColor.GREEN));
                    loreComponents.add(Component.empty());
                    loreComponents.add(Component.text((String)"\u26a0 WARNING:").color((TextColor)NamedTextColor.RED));
                    loreComponents.add(Component.text((String)"Only select players you are CERTAIN").color((TextColor)NamedTextColor.WHITE));
                    loreComponents.add(Component.text((String)"are legitimate. Bad training data").color((TextColor)NamedTextColor.WHITE));
                    loreComponents.add(Component.text((String)"will reduce detection accuracy.").color((TextColor)NamedTextColor.WHITE));
                    loreComponents.add(Component.empty());
                    loreComponents.add(Component.text((String)"Recommended: Use yourself or other").color((TextColor)NamedTextColor.WHITE));
                    loreComponents.add(Component.text((String)"trusted staff members for training.").color((TextColor)NamedTextColor.WHITE));
                    break;
                }
                case 2: {
                    nameColor = NamedTextColor.RED;
                    loreComponents.add(Component.text((String)"Click to use this player's data").color((TextColor)NamedTextColor.YELLOW));
                    loreComponents.add(Component.text((String)"for training as a CHEATER").color((TextColor)NamedTextColor.RED));
                    loreComponents.add(Component.empty());
                    loreComponents.add(Component.text((String)"\u26a0 WARNING:").color((TextColor)NamedTextColor.RED));
                    loreComponents.add(Component.text((String)"Only select players you have CONFIRMED").color((TextColor)NamedTextColor.WHITE));
                    loreComponents.add(Component.text((String)"are using X-ray. Never guess or assume.").color((TextColor)NamedTextColor.WHITE));
                    loreComponents.add(Component.text((String)"False data will harm the ML system.").color((TextColor)NamedTextColor.WHITE));
                    loreComponents.add(Component.empty());
                    loreComponents.add(Component.text((String)"Recommended: Ask trusted staff members").color((TextColor)NamedTextColor.WHITE));
                    loreComponents.add(Component.text((String)"or use X-ray yourself and mine diamonds").color((TextColor)NamedTextColor.WHITE));
                    loreComponents.add(Component.text((String)"to generate accurate training data.").color((TextColor)NamedTextColor.WHITE));
                }
            }
        } else {
            nameColor = NamedTextColor.GRAY;
            loreComponents.add(Component.text((String)"Cannot select this player").color((TextColor)NamedTextColor.RED));
            if (inAnalysis) {
                loreComponents.add(Component.text((String)"Player is already being analyzed").color((TextColor)NamedTextColor.RED));
            }
            if (inTrainingNormal) {
                loreComponents.add(Component.text((String)"Player is in training as NORMAL").color((TextColor)NamedTextColor.RED));
            }
            if (inTrainingCheater) {
                loreComponents.add(Component.text((String)"Player is in training as CHEATER").color((TextColor)NamedTextColor.RED));
            }
        }
        meta.displayName(Component.text((String)target.getName()).color((TextColor)nameColor));
        meta.lore(loreComponents);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public static void handleClick(Player player, int slot, Inventory inventory, deepGuardXray plugin, SelectionType type) {
        Player target;
        SkullMeta meta;
        ItemStack clicked;
        int currentPage = playerPages.getOrDefault(player.getUniqueId(), 0);
        if (slot == 45 && inventory.getItem(45) != null) {
            new PlayerSelectorGUI(plugin, type).openInventory(player, currentPage - 1);
            return;
        }
        if (slot == 53 && inventory.getItem(53) != null) {
            new PlayerSelectorGUI(plugin, type).openInventory(player, currentPage + 1);
            return;
        }
        if (slot == 49) {
            new MLAnalysisGUI(plugin).openInventory(player);
            return;
        }
        if (slot == 48 && (type == SelectionType.TRAIN_NORMAL || type == SelectionType.TRAIN_CHEATER)) {
            return;
        }
        if (slot < 45 && (clicked = inventory.getItem(slot)) != null && clicked.getType() == Material.PLAYER_HEAD && (meta = (SkullMeta)clicked.getItemMeta()).getOwningPlayer() != null && (target = Bukkit.getPlayer((UUID)meta.getOwningPlayer().getUniqueId())) != null) {
            MLManager mlManager = plugin.getMLManager();
            if (meta.displayName().color() == NamedTextColor.GRAY) {
                player.sendMessage(Component.text((String)"This player cannot be selected. They are already in another category.").color((TextColor)NamedTextColor.RED));
                return;
            }
            boolean inAnalysis = mlManager.getPlayersUnderAnalysis().contains(target.getUniqueId());
            boolean inTraining = mlManager.getPlayersInTraining().containsKey(target.getUniqueId());
            if (inAnalysis || inTraining) {
                player.sendMessage(Component.text((String)"This player is already in analysis or training. Cannot select.").color((TextColor)NamedTextColor.RED));
                player.closeInventory();
                new PlayerSelectorGUI(plugin, type).openInventory(player, currentPage);
                return;
            }
            switch (type.ordinal()) {
                case 0: {
                    if (mlManager.getPlayersUnderAnalysis().size() >= 5) {
                        player.sendMessage(Component.text((String)"Maximum number of players already being analyzed!").color((TextColor)NamedTextColor.RED));
                        return;
                    }
                    mlManager.startAnalysis(target);
                    player.sendMessage(Component.text((String)("Started analyzing " + target.getName())).color((TextColor)NamedTextColor.GREEN));
                    break;
                }
                case 1: 
                case 2: {
                    boolean isCheater = type == SelectionType.TRAIN_CHEATER;
                    long currentCount = mlManager.getPlayersInTraining().entrySet().stream().filter(e -> (Boolean)e.getValue() == isCheater).count();
                    if (currentCount >= 5L) {
                        player.sendMessage(Component.text((String)"Maximum number of players already in training!").color((TextColor)NamedTextColor.RED));
                        return;
                    }
                    PlayerSelectorGUI.openTrainingConfirmationGUI(player, target, isCheater, plugin);
                    return;
                }
            }
            new MLAnalysisGUI(plugin).openInventory(player);
        }
    }

    private static void openTrainingConfirmationGUI(Player staff, Player target, boolean isCheater, deepGuardXray plugin) {
        Inventory confirmInventory = Bukkit.createInventory(null, (int)27, (Component)Component.text((String)(isCheater ? "\u26a0 CONFIRM CHEATER TRAINING \u26a0" : "\u26a0 CONFIRM NORMAL TRAINING \u26a0")).color((TextColor)(isCheater ? NamedTextColor.RED : NamedTextColor.GREEN)));
        ItemStack filler = PlayerSelectorGUI.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", Collections.emptyList());
        for (int i = 0; i < 27; ++i) {
            confirmInventory.setItem(i, filler);
        }
        ArrayList<String> warningLore = new ArrayList<String>();
        warningLore.add("\u00a7cBy proceeding, you confirm that:");
        if (isCheater) {
            warningLore.add("\u00a7f\u2022 You have DEFINITIVE PROOF that");
            warningLore.add("\u00a7f  " + target.getName() + " is using X-ray");
            warningLore.add("\u00a7f\u2022 You understand incorrect labeling will");
            warningLore.add("\u00a7f  significantly damage the ML model");
            warningLore.add("");
            warningLore.add("\u00a7eRemember: It's better to use yourself or");
            warningLore.add("\u00a7etrusted staff to generate cheater data");
        } else {
            warningLore.add("\u00a7f\u2022 You are CERTAIN that");
            warningLore.add("\u00a7f  " + target.getName() + " is a legitimate player");
            warningLore.add("\u00a7f\u2022 You understand incorrect labeling will");
            warningLore.add("\u00a7f  cause false positives/negatives");
            warningLore.add("");
            warningLore.add("\u00a7eRemember: It's better to use yourself or");
            warningLore.add("\u00a7etrusted staff for normal player data");
        }
        ItemStack warningSign = PlayerSelectorGUI.createItem(Material.OAK_SIGN, isCheater ? "\u00a7c\u26a0 TRAINING AS CHEATER \u26a0" : "\u00a7a\u26a0 TRAINING AS NORMAL PLAYER \u26a0", warningLore);
        confirmInventory.setItem(4, warningSign);
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
        meta.setOwningPlayer((OfflinePlayer)target);
        meta.displayName(Component.text((String)("Selected Player: " + target.getName())).color((TextColor)(isCheater ? NamedTextColor.RED : NamedTextColor.GREEN)));
        playerHead.setItemMeta((ItemMeta)meta);
        confirmInventory.setItem(13, playerHead);
        ItemStack confirmButton = PlayerSelectorGUI.createItem(Material.LIME_CONCRETE, "\u00a7a\u2713 I UNDERSTAND - PROCEED", List.of("\u00a7eClick to start training with", "\u00a7e" + target.getName() + " as " + (isCheater ? "CHEATER" : "NORMAL PLAYER"), "", "\u00a7cYou will be held responsible for", "\u00a7cthe accuracy of this training data"));
        confirmInventory.setItem(11, confirmButton);
        ItemStack cancelButton = PlayerSelectorGUI.createItem(Material.RED_CONCRETE, "\u00a7c\u2717 CANCEL", List.of("\u00a7eReturn to player selection"));
        confirmInventory.setItem(15, cancelButton);
        staff.openInventory(confirmInventory);
        plugin.getServer().getPluginManager().registerEvents((Listener)new TrainingConfirmationListener(staff, target, isCheater, plugin), (Plugin)plugin);
    }

    private static ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.text((String)name));
        if (!lore.isEmpty()) {
            List loreComponents = lore.stream().map(line -> {
                if (line.startsWith("\u00a7")) {
                    return Component.text((String)line);
                }
                return (TextComponent)Component.text((String)line).color((TextColor)NamedTextColor.GRAY);
            }).collect(Collectors.toList());
            meta.lore(loreComponents);
        }
        item.setItemMeta(meta);
        return item;
    }

    public static enum SelectionType {
        ANALYZE,
        TRAIN_NORMAL,
        TRAIN_CHEATER;

    }

    public static class TrainingConfirmationListener
    implements Listener {
        private final Player staff;
        private final Player target;
        private final boolean isCheater;
        private final deepGuardXray plugin;

        public TrainingConfirmationListener(Player staff, Player target, boolean isCheater, deepGuardXray plugin) {
            this.staff = staff;
            this.target = target;
            this.isCheater = isCheater;
            this.plugin = plugin;
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent event) {
            if (event.getWhoClicked() != this.staff) {
                return;
            }
            if (event.getView().title().toString().contains("CONFIRM")) {
                event.setCancelled(true);
                if (event.getRawSlot() == 11) {
                    MLManager mlManager = this.plugin.getMLManager();
                    mlManager.startTraining(this.target, this.isCheater);
                    this.staff.sendMessage(Component.text((String)("Started training " + this.target.getName() + " as " + (this.isCheater ? "cheater" : "normal player"))).color((TextColor)NamedTextColor.GREEN));
                    this.plugin.getLogger().info(this.staff.getName() + " confirmed training " + this.target.getName() + " as " + (this.isCheater ? "CHEATER" : "NORMAL PLAYER"));
                    this.staff.closeInventory();
                    HandlerList.unregisterAll((Listener)this);
                    new MLAnalysisGUI(this.plugin).openInventory(this.staff);
                } else if (event.getRawSlot() == 15) {
                    this.staff.closeInventory();
                    HandlerList.unregisterAll((Listener)this);
                    new PlayerSelectorGUI(this.plugin, this.isCheater ? SelectionType.TRAIN_CHEATER : SelectionType.TRAIN_NORMAL).openInventory(this.staff);
                }
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            if (event.getPlayer() == this.staff) {
                HandlerList.unregisterAll((Listener)this);
            }
        }
    }
}

