/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.gui.subgui.PlayerMiningStatsGUI;
import org.myplugin.deepGuardXray.managers.StatsManager;

public class PlayerStatsMainGUI {
    private Inventory inv;
    private int currentPage;
    private final int itemsPerPage = 45;
    private final List<OfflinePlayer> playersWithStats;
    private final int totalPages;
    private final Map<Integer, UUID> playerSlots = new HashMap<Integer, UUID>();

    public PlayerStatsMainGUI(int currentPage) {
        this.currentPage = currentPage;
        this.inv = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)"\ud83d\udcca Player Analytics").color((TextColor)NamedTextColor.AQUA));
        this.playersWithStats = this.getPlayersWithStats();
        this.totalPages = Math.max(1, (int)Math.ceil((double)this.playersWithStats.size() / 45.0));
        this.initializeItems();
    }

    private List<OfflinePlayer> getPlayersWithStats() {
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>();
        for (UUID playerId : StatsManager.getAllPlayerIds()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerId);
            if (offlinePlayer == null || offlinePlayer.getName() == null) continue;
            players.add(offlinePlayer);
        }
        return players;
    }

    private void initializeItems() {
        int slot;
        this.inv.clear();
        this.playerSlots.clear();
        this.setNavigationItems();
        int startIndex = this.currentPage * 45;
        int endIndex = Math.min(startIndex + 45, this.playersWithStats.size());
        for (int i = startIndex; i < endIndex && (slot = i - startIndex) < 45; ++i) {
            OfflinePlayer p = this.playersWithStats.get(i);
            this.inv.setItem(slot, this.createPlayerHead(p));
            this.playerSlots.put(slot, p.getUniqueId());
        }
    }

    private void setNavigationItems() {
        if (this.currentPage > 0) {
            this.inv.setItem(45, this.createNavItem(Material.ARROW, "Previous Page", NamedTextColor.GREEN));
        } else {
            this.inv.setItem(45, this.createNavItem(Material.BARRIER, "No Previous Page", NamedTextColor.RED));
        }
        this.inv.setItem(47, this.createNavItem(Material.BARRIER, "Back to \u26cf Staff Control Panel", NamedTextColor.RED));
        this.inv.setItem(49, this.createNavItem(Material.PAPER, "Page " + (this.currentPage + 1) + " / " + Math.max(1, this.totalPages), NamedTextColor.YELLOW));
        if (this.currentPage < this.totalPages - 1) {
            this.inv.setItem(53, this.createNavItem(Material.ARROW, "Next Page", NamedTextColor.GREEN));
        } else {
            this.inv.setItem(53, this.createNavItem(Material.BARRIER, "No Next Page", NamedTextColor.RED));
        }
    }

    private ItemStack createNavItem(Material material, String name, NamedTextColor color) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)name).color((TextColor)color));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createPlayerHead(OfflinePlayer player) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer(player);
        meta.displayName(Component.text((String)player.getName()).color((TextColor)NamedTextColor.GOLD));
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)"Click to view mining stats").color((TextColor)NamedTextColor.GRAY));
        boolean isOnline = player.isOnline();
        lore.add(Component.text((String)("Status: " + (isOnline ? "Online" : "Offline"))).color((TextColor)(isOnline ? NamedTextColor.GREEN : NamedTextColor.RED)));
        lore.add(Component.text((String)("Player: " + player.getName())).color((TextColor)NamedTextColor.WHITE));
        meta.lore(lore);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
    }

    public static void handleClick(Player staff, int slot, Inventory clickedInventory) {
        if (slot < 45 && clickedInventory.getItem(slot) != null && clickedInventory.getItem(slot).getType() == Material.PLAYER_HEAD) {
            PlayerStatsMainGUI gui = new PlayerStatsMainGUI(0);
            UUID targetId = gui.playerSlots.get(slot);
            if (targetId != null) {
                ItemStack head = clickedInventory.getItem(slot);
                String playerName = "Unknown";
                if (head.hasItemMeta() && head.getItemMeta().hasDisplayName()) {
                    Component nameComponent = head.getItemMeta().displayName();
                    playerName = nameComponent.toString().replace("\"", "");
                }
                new PlayerMiningStatsGUI(targetId, playerName).openInventory(staff);
            }
        } else if (slot == 45 && clickedInventory.getItem(45).getType() == Material.ARROW) {
            Component title = clickedInventory.getItem(49).getItemMeta().displayName();
            String titleText = title.toString();
            int currentPage = Integer.parseInt(titleText.split("/")[0].split(" ")[1].trim()) - 1;
            new PlayerStatsMainGUI(currentPage - 1).openInventory(staff);
        } else if (slot == 53 && clickedInventory.getItem(53).getType() == Material.ARROW) {
            Component title = clickedInventory.getItem(49).getItemMeta().displayName();
            String titleText = title.toString();
            int currentPage = Integer.parseInt(titleText.split("/")[0].split(" ")[1].trim()) - 1;
            new PlayerStatsMainGUI(currentPage + 1).openInventory(staff);
        } else if (slot == 47) {
            new StaffMenuGUI().openInventory(staff);
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public Map<Integer, UUID> getPlayerSlots() {
        return this.playerSlots;
    }
}

