/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.myplugin.deepGuardXray.config.ConfigManager;

public class PunishmentSettingsGUI {
    private final Inventory inv;
    private final ConfigManager configManager;
    public static final String PERMISSION = "deepguardx.gui_punishment";

    public PunishmentSettingsGUI(ConfigManager configManager) {
        this.configManager = configManager;
        this.inv = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)"\u2696 Punishment System").color((TextColor)NamedTextColor.AQUA));
        this.initializeItems();
    }

    private void initializeItems() {
        for (int level = 1; level <= 6; ++level) {
            int row = level - 1;
            int labelSlot = row * 9;
            int punishmentSlot = row * 9 + 1;
            int adminAlertSlot = row * 9 + 2;
            int warningMsgSlot = row * 9 + 3;
            int additionalSlot = row * 9 + 5;
            String levelTitle = "";
            String levelDescription = "";
            switch (level) {
                case 1: {
                    levelTitle = "Level 1: Warning Phase";
                    levelDescription = "Initial warnings and minor effects";
                    break;
                }
                case 2: {
                    levelTitle = "Level 2: Minor Consequences";
                    levelDescription = "Minor penalties and annoyances";
                    break;
                }
                case 3: {
                    levelTitle = "Level 3: Moderate Punishment";
                    levelDescription = "Temporary kicks and mining restrictions";
                    break;
                }
                case 4: {
                    levelTitle = "Level 4: Severe Consequences";
                    levelDescription = "Extended bans and significant restrictions";
                    break;
                }
                case 5: {
                    levelTitle = "Level 5: Critical Response";
                    levelDescription = "Long-term ban and permanent effects";
                    break;
                }
                case 6: {
                    levelTitle = "Level 6: Maximum Enforcement";
                    levelDescription = "Permanent ban and security measures";
                }
            }
            this.inv.setItem(labelSlot, this.createGuiItem(Material.PAPER, levelTitle, Component.text((String)levelDescription).color((TextColor)NamedTextColor.GRAY)));
            boolean punishmentEnabled = this.configManager.isPunishmentEnabled(level);
            Material toggleMaterial = punishmentEnabled ? Material.GREEN_WOOL : Material.RED_WOOL;
            String toggleStatus = punishmentEnabled ? "Enabled" : "Disabled";
            this.inv.setItem(punishmentSlot, this.createGuiItem(toggleMaterial, "Level " + level + " Punishment", Component.text((String)("Status: " + toggleStatus)).color((TextColor)(punishmentEnabled ? NamedTextColor.GREEN : NamedTextColor.RED))));
            boolean adminAlertEnabled = this.configManager.isPunishmentOptionEnabled(level, "admin_alert");
            Material adminAlertMaterial = adminAlertEnabled ? Material.BELL : Material.GRAY_DYE;
            String adminAlertStatus = adminAlertEnabled ? "Enabled" : "Disabled";
            this.inv.setItem(adminAlertSlot, this.createGuiItem(adminAlertMaterial, "Admin Alerts", Component.text((String)("Status: " + adminAlertStatus)).color((TextColor)(adminAlertEnabled ? NamedTextColor.GREEN : NamedTextColor.RED)), Component.text((String)"Notify staff when this punishment is triggered").color((TextColor)NamedTextColor.GRAY)));
            boolean warningMsgEnabled = this.configManager.isPunishmentOptionEnabled(level, "warning_message");
            Material warningMsgMaterial = warningMsgEnabled ? Material.BOOK : Material.GRAY_DYE;
            String warningMsgStatus = warningMsgEnabled ? "Enabled" : "Disabled";
            this.inv.setItem(warningMsgSlot, this.createGuiItem(warningMsgMaterial, "Warning Messages", Component.text((String)("Status: " + warningMsgStatus)).color((TextColor)(warningMsgEnabled ? NamedTextColor.GREEN : NamedTextColor.RED)), Component.text((String)"Show warning messages to players").color((TextColor)NamedTextColor.GRAY)));
            this.inv.setItem(additionalSlot, this.createGuiItem(Material.WRITABLE_BOOK, "Advanced settings", Component.text((String)("Click to configure Level " + level)).color((TextColor)NamedTextColor.GRAY)));
        }
        this.inv.setItem(52, this.createGuiItem(Material.OAK_SIGN, "Icon Guide", Component.text((String)"\ud83d\udfe2/\ud83d\udd34 - Enable/Disable level").color((TextColor)NamedTextColor.GRAY), Component.text((String)"\ud83d\udd14 - Admin alerts").color((TextColor)NamedTextColor.GRAY), Component.text((String)"\ud83d\udcd6 - Warning messages").color((TextColor)NamedTextColor.GRAY), Component.text((String)"\ud83d\udcdd - Advanced settings").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(53, this.createGuiItem(Material.BARRIER, "Back to \u26cf Staff Control Panel", new Component[0]));
    }

    private ItemStack createGuiItem(Material material, String name, Component ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)name).color((TextColor)NamedTextColor.GOLD));
        if (lore.length > 0) {
            ArrayList<Component> loreList = new ArrayList<Component>();
            for (Component component : lore) {
                loreList.add(component);
            }
            meta.lore(loreList);
        }
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(Component.text((String)"You do not have permission to manage punishment settings.").color((TextColor)NamedTextColor.RED));
            return;
        }
        player.openInventory(this.inv);
    }
}

