/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.listeners;

import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.myplugin.deepGuardXray.alerts.StaffAlertManager;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.DecoyManager;
import org.myplugin.deepGuardXray.managers.PunishmentManager;
import org.myplugin.deepGuardXray.managers.StatsManager;
import org.myplugin.deepGuardXray.managers.SuspiciousManager;
import org.myplugin.deepGuardXray.punishments.PunishmentHandlerManager;
import org.myplugin.deepGuardXray.punishments.handlers.Paranoia.ParanoiaHandler;
import org.myplugin.deepGuardXray.utils.LocationUtils;

public class BlockListener
implements Listener {
    private final ConfigManager configManager;
    private final StaffAlertManager staffAlertManager;
    private final DecoyManager decoyManager;
    private final PunishmentManager punishmentManager;
    private final deepGuardXray plugin;
    private ParanoiaHandler paranoiaHandler;
    private final PunishmentHandlerManager punishmentHandlerManager;

    public BlockListener(ConfigManager configManager, StaffAlertManager staffAlertManager, DecoyManager decoyManager, PunishmentManager punishmentManager, ParanoiaHandler paranoiaHandler) {
        this.configManager = configManager;
        this.staffAlertManager = staffAlertManager;
        this.decoyManager = decoyManager;
        this.punishmentManager = punishmentManager;
        this.paranoiaHandler = paranoiaHandler;
        this.plugin = deepGuardXray.getInstance();
        this.punishmentHandlerManager = new PunishmentHandlerManager(this.plugin, configManager, punishmentManager, paranoiaHandler);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Material mat = block.getType();
        if (this.configManager.getNaturalOres().contains(mat)) {
            Location loc = block.getLocation();
            this.decoyManager.addPlayerPlacedOre(loc);
            if (this.configManager.isDebugEnabled()) {
                Player player = event.getPlayer();
                this.plugin.getLogger().info("Player " + player.getName() + " placed " + String.valueOf(mat) + " at " + LocationUtils.formatLocation(loc) + ", added to player-placed tracking");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Material ore = block.getType();
        Location loc = block.getLocation();
        UUID playerId = player.getUniqueId();
        if (this.configManager.isDebugEnabled() && this.configManager.getNaturalOres().contains(ore)) {
            this.plugin.getLogger().info("[EARLY CHECK] BlockListener processing block break for " + player.getName() + " at " + LocationUtils.formatLocation(loc));
        }
        if (this.configManager.isDebugEnabled() && this.configManager.getNaturalOres().contains(ore)) {
            boolean isCurrentlyPlayerPlaced = this.decoyManager.isPlayerPlacedOre(loc);
            this.plugin.getLogger().info("isPlayerPlacedOre returns: " + isCurrentlyPlayerPlaced + " for location " + LocationUtils.formatLocation(loc));
        }
        if (this.decoyManager.isPlayerPlacedOre(loc)) {
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Player-placed ore detected for " + player.getName() + " at " + LocationUtils.formatLocation(loc) + ", skipping processing");
            }
            this.decoyManager.removePlayerPlacedOre(loc);
            return;
        }
        boolean cancelEvent = this.punishmentHandlerManager.processBlockBreak(event, player, block);
        if (cancelEvent) {
            event.setCancelled(true);
            return;
        }
        if (this.punishmentManager.hasParanoiaMode(playerId) || player.getLocation().getY() < 30.0) {
            this.paranoiaHandler.processBlockBreak(player, block);
        }
        StatsManager.addOreMined(player.getUniqueId(), ore);
        if (!this.configManager.getNaturalOres().contains(ore)) {
            return;
        }
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Processing natural ore break for " + player.getName() + " at " + LocationUtils.formatLocation(loc));
        }
        this.decoyManager.trackOreBreak(player, block, ore);
        if (this.decoyManager.isDecoy(loc)) {
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Decoy ore detected for " + player.getName() + " at " + LocationUtils.formatLocation(loc));
            }
            SuspiciousManager.addSuspicious(player.getUniqueId());
            this.punishmentManager.checkAndPunish(player);
            if (this.configManager.isWarnOnDecoy()) {
                player.sendMessage((Component)Component.text((String)"Suspicious mining behavior detected!", (TextColor)NamedTextColor.RED));
            }
            String friendlyWorld = LocationUtils.getFriendlyWorldName(loc.getWorld());
            String formattedLoc = LocationUtils.formatLocation(loc);
            String rawMessage = "Player " + player.getName() + " broke a decoy ore at " + friendlyWorld + " " + formattedLoc;
            event.getPlayer().getServer().getLogger().warning(rawMessage);
            if (this.configManager.isStaffAlertEnabled()) {
                this.staffAlertManager.alertStaffWithTeleport(player, loc, rawMessage);
            }
            this.staffAlertManager.logDecoyEvent(rawMessage);
            if (this.plugin.getConfigManager().isWebhookAlertEnabled("xray_detection")) {
                this.plugin.getWebhookManager().sendXrayAlert(player, ore.name(), loc, 100.0);
            }
            this.decoyManager.removeDecoy(loc);
            return;
        }
        if (this.configManager.isStaffOreAlerts()) {
            this.staffAlertManager.updateStaffOreCounter(player, ore, loc);
        }
    }
}

