/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.listeners;

import java.io.File;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.utils.UpdateChecker;

public class UpdateListener
implements Listener {
    private final deepGuardXray plugin;
    private final UpdateChecker updateChecker;

    public UpdateListener(deepGuardXray plugin, UpdateChecker updateChecker) {
        this.plugin = plugin;
        this.updateChecker = updateChecker;
        updateChecker.checkForUpdates();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("deepguardx.staff") && this.updateChecker.isUpdateAvailable()) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                Component divider = Component.text((String)"=================================================").color((TextColor)NamedTextColor.GREEN);
                player.sendMessage(divider);
                player.sendMessage(Component.text((String)" DeepGuard-XRay: New update available!").color((TextColor)NamedTextColor.GREEN));
                player.sendMessage(((TextComponent)Component.text((String)" Current version: ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)this.plugin.getPluginMeta().getVersion()).color((TextColor)NamedTextColor.RED)));
                player.sendMessage(((TextComponent)Component.text((String)" New version: ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)this.updateChecker.getLatestVersion()).color((TextColor)NamedTextColor.GREEN)));
                boolean updateDownloaded = this.isUpdateDownloaded();
                if (player.hasPermission("deepguardx.autoupdate")) {
                    if (!updateDownloaded) {
                        Component updateMessage = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)" Click here to auto-update the plugin ").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD)).clickEvent(ClickEvent.runCommand((String)"/deepguard update auto"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to download and prepare the update for next restart")));
                        player.sendMessage(updateMessage);
                    } else {
                        Component applyMessage = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)" Click here to apply the downloaded update ").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD)).clickEvent(ClickEvent.runCommand((String)"/deepguard update apply"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to apply the update (server restart still required)")));
                        player.sendMessage(applyMessage);
                    }
                }
                Component downloadMessage = Component.text((String)" Download manually: ").color((TextColor)NamedTextColor.YELLOW);
                Component downloadLink = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Click here").color((TextColor)NamedTextColor.AQUA)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)"https://www.spigotmc.org/resources/122967"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Open download page in your browser")));
                player.sendMessage(downloadMessage.append(downloadLink));
                player.sendMessage(divider);
            }, 60L);
        }
    }

    private boolean isUpdateDownloaded() {
        File updateMarker = new File(this.plugin.getDataFolder(), "pending_update.txt");
        return updateMarker.exists();
    }
}

