/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.managers;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.Ticks;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.listeners.PunishmentListener;
import org.myplugin.deepGuardXray.managers.SuspiciousManager;

public class PunishmentManager {
    private final ConfigManager configManager;
    private final deepGuardXray plugin;
    private File punishmentDataFile;
    private FileConfiguration punishmentConfig;
    private int autoSaveTaskId = -1;
    private final Map<UUID, Long> miningLicenseSuspension = new HashMap<UUID, Long>();
    private final Map<UUID, Long> restrictedAreas = new HashMap<UUID, Long>();
    private final Map<UUID, Long> resourceTaxActive = new HashMap<UUID, Long>();
    private final Map<UUID, Long> cursedPickaxeActive = new HashMap<UUID, Long>();
    private final Map<UUID, Long> stoneVisionActive = new HashMap<UUID, Long>();
    private final Map<UUID, Long> paranoiaModeActive = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> fakeDiamondsRemaining = new HashMap<UUID, Integer>();
    private final Set<UUID> permanentMiningDebuff = new HashSet<UUID>();
    private final Set<Block> fakeOreBlocks = new HashSet<Block>();
    private final Map<UUID, Long> fakeOreVeinsActive = new HashMap<UUID, Long>();
    private final Map<UUID, Long> foolsGoldActive = new HashMap<UUID, Long>();
    private final Map<UUID, Map.Entry<Component, Long>> miningReputations = new HashMap<UUID, Map.Entry<Component, Long>>();
    private final Map<UUID, Integer> playerPunishmentLevels = new HashMap<UUID, Integer>();

    public PunishmentManager(ConfigManager configManager, deepGuardXray plugin) {
        this.configManager = configManager;
        this.plugin = plugin;
        this.initializeDataStorage();
        Bukkit.getPluginManager().registerEvents((Listener)new PunishmentListener(this, plugin.getDecoyManager(), configManager, plugin), (Plugin)plugin);
        this.startCleanupTask();
        this.startDisabledLevelCheckTask();
    }

    private void initializeDataStorage() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.punishmentDataFile = new File(this.plugin.getDataFolder(), "punishment_data.yml");
        if (!this.punishmentDataFile.exists()) {
            try {
                this.punishmentDataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create punishment_data.yml", e);
            }
        }
        this.punishmentConfig = YamlConfiguration.loadConfiguration((File)this.punishmentDataFile);
        this.loadPunishmentData();
        if (this.configManager.isPunishmentAutoSaveEnabled()) {
            this.startAutoSaveTask();
        }
    }

    private void startAutoSaveTask() {
        if (this.autoSaveTaskId != -1) {
            this.plugin.getServer().getScheduler().cancelTask(this.autoSaveTaskId);
        }
        long autoSaveInterval = (long)this.configManager.getPunishmentAutoSaveInterval() * 1200L;
        this.autoSaveTaskId = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            if (this.configManager.isPunishmentAutoSaveLoggingEnabled()) {
                this.plugin.getLogger().info("Auto-saving punishment data...");
            }
            this.savePunishmentData();
            if (this.configManager.isPunishmentAutoSaveLoggingEnabled()) {
                this.plugin.getLogger().info("Auto-save complete for punishment data");
            }
        }, autoSaveInterval, autoSaveInterval);
        if (this.configManager.isPunishmentAutoSaveLoggingEnabled()) {
            this.plugin.getLogger().info("Started auto-save task for punishment data (every " + this.configManager.getPunishmentAutoSaveInterval() + " minutes)");
        }
    }

    public void updateAutoSaveSettings() {
        if (this.configManager.isPunishmentAutoSaveEnabled() && this.autoSaveTaskId == -1) {
            this.startAutoSaveTask();
        } else if (!this.configManager.isPunishmentAutoSaveEnabled() && this.autoSaveTaskId != -1) {
            this.plugin.getServer().getScheduler().cancelTask(this.autoSaveTaskId);
            this.autoSaveTaskId = -1;
            if (this.configManager.isPunishmentAutoSaveLoggingEnabled()) {
                this.plugin.getLogger().info("Auto-save for punishment data has been disabled");
            }
        } else if (this.configManager.isPunishmentAutoSaveEnabled()) {
            this.startAutoSaveTask();
        }
    }

    public void savePunishmentData() {
        try {
            this.punishmentConfig.set("punishments", null);
            this.saveLongMap("miningLicenseSuspension", this.miningLicenseSuspension);
            this.saveLongMap("restrictedAreas", this.restrictedAreas);
            this.saveLongMap("resourceTaxActive", this.resourceTaxActive);
            this.saveLongMap("cursedPickaxeActive", this.cursedPickaxeActive);
            this.saveLongMap("stoneVisionActive", this.stoneVisionActive);
            this.saveLongMap("paranoiaModeActive", this.paranoiaModeActive);
            this.saveLongMap("fakeOreVeinsActive", this.fakeOreVeinsActive);
            this.saveLongMap("foolsGoldActive", this.foolsGoldActive);
            this.saveIntegerMap("fakeDiamondsRemaining", this.fakeDiamondsRemaining);
            this.saveIntegerMap("playerPunishmentLevels", this.playerPunishmentLevels);
            this.saveUUIDSet("permanentMiningDebuff", this.permanentMiningDebuff);
            this.saveMiningReputations();
            this.punishmentConfig.save(this.punishmentDataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save punishment data", e);
        }
    }

    private void loadPunishmentData() {
        ConfigurationSection section = this.punishmentConfig.getConfigurationSection("punishments");
        if (section == null) {
            this.plugin.getLogger().info("No saved punishment data found.");
            return;
        }
        this.loadLongMap("miningLicenseSuspension", this.miningLicenseSuspension);
        this.loadLongMap("restrictedAreas", this.restrictedAreas);
        this.loadLongMap("resourceTaxActive", this.resourceTaxActive);
        this.loadLongMap("cursedPickaxeActive", this.cursedPickaxeActive);
        this.loadLongMap("stoneVisionActive", this.stoneVisionActive);
        this.loadLongMap("paranoiaModeActive", this.paranoiaModeActive);
        this.loadLongMap("fakeOreVeinsActive", this.fakeOreVeinsActive);
        this.loadLongMap("foolsGoldActive", this.foolsGoldActive);
        this.loadIntegerMap("fakeDiamondsRemaining", this.fakeDiamondsRemaining);
        this.loadIntegerMap("playerPunishmentLevels", this.playerPunishmentLevels);
        this.loadUUIDSet("permanentMiningDebuff", this.permanentMiningDebuff);
        this.loadMiningReputations();
        this.plugin.getLogger().info("Loaded punishment data successfully");
        this.cleanupExpiredPunishments();
    }

    private void cleanupExpiredPunishments() {
        long currentTime = System.currentTimeMillis();
        this.cleanupExpiredMaps(currentTime);
        this.plugin.getLogger().info("Cleaned up expired punishments");
    }

    private void saveLongMap(String mapName, Map<UUID, Long> map) {
        for (Map.Entry<UUID, Long> entry : map.entrySet()) {
            this.punishmentConfig.set("punishments." + mapName + "." + entry.getKey().toString(), (Object)entry.getValue());
        }
    }

    private void loadLongMap(String mapName, Map<UUID, Long> map) {
        map.clear();
        ConfigurationSection section = this.punishmentConfig.getConfigurationSection("punishments." + mapName);
        if (section != null) {
            for (String uuidString : section.getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    long value = section.getLong(uuidString);
                    map.put(uuid, value);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid UUID in punishment data: " + uuidString);
                }
            }
        }
    }

    private void saveIntegerMap(String mapName, Map<UUID, Integer> map) {
        for (Map.Entry<UUID, Integer> entry : map.entrySet()) {
            this.punishmentConfig.set("punishments." + mapName + "." + entry.getKey().toString(), (Object)entry.getValue());
        }
    }

    private void loadIntegerMap(String mapName, Map<UUID, Integer> map) {
        map.clear();
        ConfigurationSection section = this.punishmentConfig.getConfigurationSection("punishments." + mapName);
        if (section != null) {
            for (String uuidString : section.getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    int value = section.getInt(uuidString);
                    map.put(uuid, value);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid UUID in punishment data: " + uuidString);
                }
            }
        }
    }

    private void saveUUIDSet(String setName, Set<UUID> set) {
        ArrayList<String> uuidStrings = new ArrayList<String>();
        for (UUID uuid : set) {
            uuidStrings.add(uuid.toString());
        }
        this.punishmentConfig.set("punishments." + setName, uuidStrings);
    }

    private void loadUUIDSet(String setName, Set<UUID> set) {
        set.clear();
        List uuidStrings = this.punishmentConfig.getStringList("punishments." + setName);
        for (String uuidString : uuidStrings) {
            try {
                set.add(UUID.fromString(uuidString));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid UUID in punishment data: " + uuidString);
            }
        }
    }

    private void saveMiningReputations() {
        for (Map.Entry<UUID, Map.Entry<Component, Long>> entry : this.miningReputations.entrySet()) {
            UUID uuid = entry.getKey();
            Component reputation = entry.getValue().getKey();
            Long expiry = entry.getValue().getValue();
            String serializedComponent = (String)GsonComponentSerializer.gson().serialize(reputation);
            this.punishmentConfig.set("punishments.miningReputations." + uuid.toString() + ".reputation", (Object)serializedComponent);
            this.punishmentConfig.set("punishments.miningReputations." + uuid.toString() + ".expiry", (Object)expiry);
        }
    }

    private void loadMiningReputations() {
        this.miningReputations.clear();
        ConfigurationSection section = this.punishmentConfig.getConfigurationSection("punishments.miningReputations");
        if (section != null) {
            for (String uuidString : section.getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    String serializedComponent = section.getString(uuidString + ".reputation");
                    Long expiry = section.getLong(uuidString + ".expiry");
                    Component reputation = GsonComponentSerializer.gson().deserialize((Object)serializedComponent);
                    this.miningReputations.put(uuid, new AbstractMap.SimpleEntry<Component, Long>(reputation, expiry));
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error loading mining reputation for: " + uuidString + " - " + e.getMessage());
                }
            }
        }
    }

    public void setPunishmentLevel(Player player, int level) {
        UUID playerId = player.getUniqueId();
        int currentLevel = this.playerPunishmentLevels.getOrDefault(playerId, 0);
        if (currentLevel > 0) {
            this.removeAllPunishmentEffects(player, currentLevel);
        }
        if (level > 0 && level <= 6) {
            this.applyPunishment(player, level);
            this.playerPunishmentLevels.put(playerId, level);
        } else if (level == 0) {
            this.playerPunishmentLevels.remove(playerId);
        }
    }

    public void removePunishment(Player player) {
        UUID playerId = player.getUniqueId();
        int currentLevel = this.playerPunishmentLevels.getOrDefault(playerId, 0);
        if (currentLevel > 0) {
            this.removeAllPunishmentEffects(player, currentLevel);
            this.playerPunishmentLevels.remove(playerId);
        }
    }

    private void startDisabledLevelCheckTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    UUID playerId = player.getUniqueId();
                    Integer currentLevel = PunishmentManager.this.playerPunishmentLevels.get(playerId);
                    if (currentLevel == null || currentLevel <= 0 || PunishmentManager.this.configManager.isPunishmentEnabled(currentLevel)) continue;
                    PunishmentManager.this.removeAllPunishmentEffects(player, currentLevel);
                    PunishmentManager.this.playerPunishmentLevels.remove(playerId);
                    player.sendMessage((Component)Component.text((String)"Your punishment has been lifted due to a system update.", (TextColor)NamedTextColor.GREEN));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1200L, 6000L);
    }

    private void startCleanupTask() {
        new BukkitRunnable(){
            private int runCount = 0;

            public void run() {
                long currentTime = System.currentTimeMillis();
                PunishmentManager.this.cleanupExpiredMaps(currentTime);
                if (this.getRunCount() % 3 == 0) {
                    PunishmentManager.this.cleanupFakeOreBlocks();
                }
            }

            private int getRunCount() {
                return this.runCount++;
            }
        }.runTaskTimer((Plugin)this.plugin, 1200L, 6000L);
    }

    private void cleanupExpiredMaps(long currentTime) {
        this.miningLicenseSuspension.values().removeIf(expiry -> expiry < currentTime);
        this.restrictedAreas.values().removeIf(expiry -> expiry < currentTime);
        this.resourceTaxActive.values().removeIf(expiry -> expiry < currentTime);
        this.cursedPickaxeActive.values().removeIf(expiry -> expiry < currentTime);
        this.stoneVisionActive.values().removeIf(expiry -> expiry < currentTime);
        this.paranoiaModeActive.values().removeIf(expiry -> expiry < currentTime);
        this.fakeOreVeinsActive.values().removeIf(expiry -> expiry < currentTime);
        this.foolsGoldActive.values().removeIf(expiry -> expiry < currentTime);
        this.miningReputations.entrySet().removeIf(entry -> (Long)((Map.Entry)entry.getValue()).getValue() < currentTime);
    }

    private void cleanupFakeOreBlocks() {
        this.fakeOreBlocks.removeIf(block -> !this.isOre(block.getType()));
    }

    private boolean isOre(Material material) {
        switch (material) {
            case COAL_ORE: 
            case DEEPSLATE_COAL_ORE: 
            case COPPER_ORE: 
            case DEEPSLATE_COPPER_ORE: 
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: 
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: 
            case REDSTONE_ORE: 
            case DEEPSLATE_REDSTONE_ORE: 
            case EMERALD_ORE: 
            case DEEPSLATE_EMERALD_ORE: 
            case LAPIS_ORE: 
            case DEEPSLATE_LAPIS_ORE: 
            case DIAMOND_ORE: 
            case DEEPSLATE_DIAMOND_ORE: 
            case NETHER_GOLD_ORE: 
            case NETHER_QUARTZ_ORE: 
            case ANCIENT_DEBRIS: {
                return true;
            }
        }
        return false;
    }

    public void resetMiningReputation(UUID playerId) {
        this.miningReputations.remove(playerId);
    }

    public void setMiningReputation(UUID playerId, Component reputation, long duration) {
        long expiry = System.currentTimeMillis() + duration;
        this.miningReputations.put(playerId, new AbstractMap.SimpleEntry<Component, Long>(reputation, expiry));
    }

    public boolean isUntrustedMiner(UUID playerId) {
        Component reputation = this.getMiningReputation(playerId);
        return reputation != null && reputation.color() == NamedTextColor.RED && reputation.toString().contains("Untrusted Miner");
    }

    public Component getMiningReputation(UUID playerId) {
        if (this.miningReputations.containsKey(playerId)) {
            Map.Entry<Component, Long> entry = this.miningReputations.get(playerId);
            if (entry.getValue() > System.currentTimeMillis()) {
                return entry.getKey();
            }
            this.miningReputations.remove(playerId);
        }
        return Component.text((String)"Trusted Miner");
    }

    public boolean hasMiningLicenseSuspension(UUID playerId) {
        return this.miningLicenseSuspension.containsKey(playerId) && this.miningLicenseSuspension.get(playerId) > System.currentTimeMillis();
    }

    public long getMiningLicenseSuspensionTime(UUID playerId) {
        if (!this.hasMiningLicenseSuspension(playerId)) {
            return 0L;
        }
        return this.miningLicenseSuspension.get(playerId) - System.currentTimeMillis();
    }

    public boolean hasAreaRestriction(UUID playerId) {
        return this.restrictedAreas.containsKey(playerId) && this.restrictedAreas.get(playerId) > System.currentTimeMillis();
    }

    public boolean hasResourceTax(UUID playerId) {
        return this.resourceTaxActive.containsKey(playerId) && this.resourceTaxActive.get(playerId) > System.currentTimeMillis();
    }

    public boolean hasCursedPickaxe(UUID playerId) {
        return this.cursedPickaxeActive.containsKey(playerId) && this.cursedPickaxeActive.get(playerId) > System.currentTimeMillis();
    }

    public boolean hasStoneVision(UUID playerId) {
        return this.stoneVisionActive.containsKey(playerId) && this.stoneVisionActive.get(playerId) > System.currentTimeMillis();
    }

    public boolean hasFoolsGold(UUID playerId) {
        return this.foolsGoldActive.containsKey(playerId) && this.foolsGoldActive.get(playerId) > System.currentTimeMillis();
    }

    public boolean hasParanoiaMode(UUID playerId) {
        return this.paranoiaModeActive.containsKey(playerId) && this.paranoiaModeActive.get(playerId) > System.currentTimeMillis();
    }

    public boolean hasFakeDiamonds(UUID playerId) {
        return this.fakeDiamondsRemaining.containsKey(playerId) && this.fakeDiamondsRemaining.get(playerId) > 0;
    }

    public int getFakeDiamondsRemaining(UUID playerId) {
        return this.fakeDiamondsRemaining.getOrDefault(playerId, 0);
    }

    public void decrementFakeDiamonds(UUID playerId) {
        int remaining = this.fakeDiamondsRemaining.getOrDefault(playerId, 0) - 1;
        if (remaining <= 0) {
            this.fakeDiamondsRemaining.remove(playerId);
        } else {
            this.fakeDiamondsRemaining.put(playerId, remaining);
        }
    }

    public boolean hasPermanentMiningDebuff(UUID playerId) {
        return this.permanentMiningDebuff.contains(playerId);
    }

    public boolean isFakeOre(Block block) {
        return this.fakeOreBlocks.contains(block);
    }

    public boolean hasFakeOreVeins(UUID playerId) {
        return this.fakeOreVeinsActive.containsKey(playerId) && this.fakeOreVeinsActive.get(playerId) > System.currentTimeMillis();
    }

    public void registerFakeOre(final Block block) {
        if (!this.fakeOreBlocks.contains(block)) {
            this.fakeOreBlocks.add(block);
            new BukkitRunnable(this){
                final /* synthetic */ PunishmentManager this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.fakeOreBlocks.remove(block);
                }
            }.runTaskLater((Plugin)this.plugin, 36000L);
        }
    }

    public void removeFakeOre(Block block) {
        this.fakeOreBlocks.remove(block);
    }

    public void checkAndPunish(Player player) {
        UUID playerId = player.getUniqueId();
        int suspiciousCount = SuspiciousManager.getSuspiciousCounts().getOrDefault(playerId, 0);
        int level = suspiciousCount / 10;
        if (level < 1 || level > 6) {
            return;
        }
        if (this.configManager.isPunishmentEnabled(level)) {
            int currentLevel = this.playerPunishmentLevels.getOrDefault(playerId, 0);
            if (currentLevel > 0 && currentLevel < level) {
                this.removeAllPunishmentEffects(player, currentLevel);
            }
            if (currentLevel != level) {
                this.applyPunishment(player, level);
                this.playerPunishmentLevels.put(playerId, level);
            }
        }
    }

    public void onPunishmentLevelDisabled(int level, String adminName) {
        if (level < 1 || level > 6) {
            return;
        }
        int affectedPlayers = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID playerId = player.getUniqueId();
            Integer currentLevel = this.playerPunishmentLevels.get(playerId);
            if (currentLevel == null || currentLevel != level) continue;
            this.removeAllPunishmentEffects(player, level);
            this.playerPunishmentLevels.remove(playerId);
            player.sendMessage((Component)Component.text((String)"Your punishment has been lifted due to a system update.", (TextColor)NamedTextColor.GREEN));
            ++affectedPlayers;
        }
        this.plugin.getLogger().info("Admin " + adminName + " disabled punishment level " + level + ", affecting " + affectedPlayers + " players.");
        this.notifyAdminsAboutRemoval(level, adminName, affectedPlayers);
    }

    private void notifyAdminsAboutRemoval(int level, String adminName, int affectedCount) {
        Component message = ((TextComponent)((TextComponent)Component.text((String)"[DeepGuardX] ", (TextColor)NamedTextColor.BLUE).append((Component)Component.text((String)("Punishment level " + level + " was disabled by "), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)adminName, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)(", affecting " + affectedCount + " player" + (affectedCount == 1 ? "" : "s") + "."), (TextColor)NamedTextColor.AQUA));
        for (Player admin : Bukkit.getOnlinePlayers()) {
            if (!admin.hasPermission("deepguardx.staff")) continue;
            admin.sendMessage(message);
        }
    }

    public void removeAllPunishmentEffects(Player player, int level) {
        UUID playerId = player.getUniqueId();
        switch (level) {
            case 1: {
                if (this.configManager.isPunishmentOptionEnabled(level, "mining_fatigue")) {
                    player.removePotionEffect(PotionEffectType.MINING_FATIGUE);
                }
                this.fakeDiamondsRemaining.remove(playerId);
                if (!this.configManager.isPunishmentOptionEnabled(level, "heavy_pickaxe")) break;
                player.removePotionEffect(PotionEffectType.MINING_FATIGUE);
                break;
            }
            case 2: {
                this.fakeOreVeinsActive.remove(playerId);
                if (this.configManager.isPunishmentOptionEnabled(level, "xray_vision_blur")) {
                    player.removePotionEffect(PotionEffectType.NAUSEA);
                }
                this.paranoiaModeActive.remove(playerId);
                break;
            }
            case 3: {
                this.miningLicenseSuspension.remove(playerId);
                this.resourceTaxActive.remove(playerId);
                player.removeMetadata("decoy_attraction", (Plugin)this.plugin);
                this.foolsGoldActive.remove(playerId);
                break;
            }
            case 4: {
                this.miningReputations.remove(playerId);
                this.restrictedAreas.remove(playerId);
                this.cursedPickaxeActive.remove(playerId);
            }
            case 5: {
                this.permanentMiningDebuff.remove(playerId);
                player.removeMetadata("requires_staff_review", (Plugin)this.plugin);
                this.stoneVisionActive.remove(playerId);
                break;
            }
        }
    }

    private String getPunishmentName(int level) {
        switch (level) {
            case 1: {
                return "Warning Phase";
            }
            case 2: {
                return "Minor Consequences";
            }
            case 3: {
                return "Moderate Punishment";
            }
            case 4: {
                return "Severe Consequences";
            }
            case 5: {
                return "Critical Response";
            }
            case 6: {
                return "Maximum Enforcement";
            }
        }
        return "Level " + level + " Punishment";
    }

    private void applyPunishment(final Player player, int level) {
        UUID playerId = player.getUniqueId();
        if (this.plugin.getConfigManager().isWebhookAlertEnabled("punishment_applied")) {
            this.plugin.getWebhookManager().sendPunishmentAlert(player, level, this.getPunishmentName(level));
        }
        if (this.configManager.isPunishmentOptionEnabled(level, "admin_alert")) {
            this.alertAdmins(player, level);
        }
        if (this.configManager.isPunishmentOptionEnabled(level, "warning_message")) {
            this.sendWarningMessage(player, level);
        }
        switch (level) {
            case 1: {
                if (this.configManager.isPunishmentOptionEnabled(level, "mining_fatigue")) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, 6000, 0, false, false, false));
                    player.sendMessage((Component)Component.text((String)"Your arms feel tired from suspicious mining techniques...", (TextColor)NamedTextColor.RED));
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "fake_diamonds")) {
                    int fakeCount = ThreadLocalRandom.current().nextInt(1, 4);
                    this.fakeDiamondsRemaining.put(playerId, fakeCount);
                }
                if (!this.configManager.isPunishmentOptionEnabled(level, "heavy_pickaxe")) break;
                player.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, 12000, 1, false, false, false));
                player.sendMessage((Component)Component.text((String)"Your pickaxe feels suspiciously heavy...", (TextColor)NamedTextColor.RED));
                break;
            }
            case 2: {
                if (this.configManager.isPunishmentOptionEnabled(level, "fake_ore_veins")) {
                    this.spawnFakeOreVeins(player);
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "inventory_drop")) {
                    this.dropInventoryItems(player, 25);
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "xray_vision_blur")) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, 6000, 0, false, false, false));
                    player.sendMessage((Component)Component.text((String)"Your suspicious vision is becoming blurry underground...", (TextColor)NamedTextColor.RED));
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "tool_damage")) {
                    this.damageCurrentTool(player, 50);
                }
                if (!this.configManager.isPunishmentOptionEnabled(level, "paranoia_mode")) break;
                long duration = System.currentTimeMillis() + 1800000L;
                this.paranoiaModeActive.put(playerId, duration);
                player.sendMessage((Component)Component.text((String)"The caves seem to be unusually active around you...", (TextColor)NamedTextColor.RED));
                break;
            }
            case 3: {
                if (this.configManager.isPunishmentOptionEnabled(level, "temporary_kick")) {
                    Component kickMessage = Component.text((String)"\u274c DeepGuardX has detected suspicious X-ray patterns.\n", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"Please rejoin and mine responsibly.", (TextColor)NamedTextColor.YELLOW));
                    player.kick(kickMessage);
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "mining_license_suspension")) {
                    long duration = System.currentTimeMillis() + 0x6DDD00L;
                    this.miningLicenseSuspension.put(playerId, duration);
                    player.sendMessage((Component)Component.text((String)"Your mining license for valuable ores has been suspended for 2 hours!", (TextColor)NamedTextColor.RED));
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "resource_tax")) {
                    long duration = System.currentTimeMillis() + 10800000L;
                    this.resourceTaxActive.put(playerId, duration);
                    player.sendMessage((Component)Component.text((String)"The mining authorities have imposed a 50% resource tax on your mining!", (TextColor)NamedTextColor.RED));
                    player.sendMessage((Component)Component.text((String)"All mining drops will be reduced by half (rounded down).", (TextColor)NamedTextColor.YELLOW));
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "decoy_attraction")) {
                    player.setMetadata("decoy_attraction", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                    player.sendMessage((Component)Component.text((String)"Strange... the cave walls seem to shimmer with false promises...", (TextColor)NamedTextColor.RED));
                }
                if (!this.configManager.isPunishmentOptionEnabled(level, "fools_gold")) break;
                long duration = System.currentTimeMillis() + 1800000L;
                this.foolsGoldActive.put(playerId, duration);
                player.sendMessage((Component)Component.text((String)"Your treasure detection appears to be malfunctioning...", (TextColor)NamedTextColor.RED));
                player.sendMessage((Component)Component.text((String)"For the next 30 minutes, your diamonds might not be what they seem.", (TextColor)NamedTextColor.YELLOW));
                break;
            }
            case 4: {
                if (this.configManager.isPunishmentOptionEnabled(level, "extended_ban")) {
                    Component banReason = Component.text((String)"DeepGuardX: Suspicious mining patterns detected\n", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"Your account is suspended for 3 days.", (TextColor)NamedTextColor.YELLOW));
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), banReason.toString(), new Date(System.currentTimeMillis() + 259200000L), "DeepGuardX System");
                    TextComponent kickMessage = Component.text((String)"DeepGuardX: You have been banned for 3 days due to suspicious mining behavior.", (TextColor)NamedTextColor.RED);
                    player.kick((Component)kickMessage);
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "mining_reputation")) {
                    long duration = 604800000L;
                    TextComponent reputationText = Component.text((String)"Untrusted Miner", (TextColor)NamedTextColor.RED);
                    this.setMiningReputation(playerId, (Component)reputationText, duration);
                    player.sendMessage(((TextComponent)Component.text((String)"You have been flagged as an ", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"Untrusted Miner", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"!", (TextColor)NamedTextColor.RED)));
                    player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"This status will be visible to ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"all players", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)" in chat for ", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)"7 days", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)".", (TextColor)NamedTextColor.YELLOW)));
                    player.sendMessage((Component)Component.text((String)"Your suspicious mining behavior will be publicly displayed.", (TextColor)NamedTextColor.GRAY));
                    player.playSound(player.getLocation(), Sound.ENTITY_WITHER_SPAWN, 0.5f, 1.5f);
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "restricted_areas")) {
                    long duration = System.currentTimeMillis() + 604800000L;
                    this.restrictedAreas.put(playerId, duration);
                    player.sendMessage((Component)Component.text((String)"You are now restricted from mining below Y-level -40 for 7 days!", (TextColor)NamedTextColor.RED));
                }
                if (!this.configManager.isPunishmentOptionEnabled(level, "cursed_pickaxe")) break;
                long duration = System.currentTimeMillis() + 604800000L;
                this.cursedPickaxeActive.put(playerId, duration);
                player.sendMessage((Component)Component.text((String)"Your mining tools have been cursed! They may break when mining valuable ores.", (TextColor)NamedTextColor.RED));
                break;
            }
            case 5: {
                if (this.configManager.isPunishmentOptionEnabled(level, "long_term_ban")) {
                    Component banReason = Component.text((String)"DeepGuardX: Critical level of suspicious activity detected\n", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"Your account is suspended for 14 days.", (TextColor)NamedTextColor.YELLOW));
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), banReason.toString(), new Date(System.currentTimeMillis() + 1209600000L), "DeepGuardX System");
                    TextComponent kickMessage = Component.text((String)"DeepGuardX: You have been banned for 14 days due to critical level of suspicious mining.", (TextColor)NamedTextColor.RED);
                    player.kick((Component)kickMessage);
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "public_notification")) {
                    player.setMetadata("public_notification", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "permanent_mining_debuff")) {
                    this.permanentMiningDebuff.add(playerId);
                    player.sendMessage((Component)Component.text((String)"Your mining abilities have been permanently restricted below Y-level 0!", (TextColor)NamedTextColor.RED));
                    player.sendMessage((Component)Component.text((String)"You will experience Mining Fatigue II when mining below this level.", (TextColor)NamedTextColor.YELLOW));
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "staff_review")) {
                    player.setMetadata("requires_staff_review", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                    player.sendMessage((Component)Component.text((String)"You now require staff approval to mine ores below Y-level 25!", (TextColor)NamedTextColor.RED));
                }
                if (!this.configManager.isPunishmentOptionEnabled(level, "stone_vision")) break;
                long duration = System.currentTimeMillis() + 604800000L;
                this.stoneVisionActive.put(playerId, duration);
                player.sendMessage((Component)Component.text((String)"Your vision has been altered - all ores now appear as stone to you!", (TextColor)NamedTextColor.RED));
                break;
            }
            case 6: {
                if (this.configManager.isPunishmentOptionEnabled(level, "permanent_ban")) {
                    if (this.configManager.isPunishmentOptionEnabled(level, "tnt_execution")) {
                        Location loc = player.getLocation();
                        World world = loc.getWorld();
                        world.spawnParticle(Particle.EXPLOSION, loc, 5, 0.5, 0.5, 0.5);
                        world.playSound(loc, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
                        player.damage(player.getHealth() - 1.0);
                        player.sendMessage((Component)Component.text((String)"The DeepGuard system has detected critical levels of X-ray usage!", (TextColor)NamedTextColor.RED));
                        new BukkitRunnable(this){

                            public void run() {
                                if (player.isOnline()) {
                                    Component banReason = Component.text((String)"DeepGuardX: Maximum level violation detected\n", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"Your account has been permanently banned.", (TextColor)NamedTextColor.YELLOW));
                                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), banReason.toString(), null, "DeepGuardX System");
                                    TextComponent kickMessage = Component.text((String)"DeepGuardX: You have been permanently banned for maximum-level X-ray detection.", (TextColor)NamedTextColor.RED);
                                    player.kick((Component)kickMessage);
                                }
                            }
                        }.runTaskLater((Plugin)this.plugin, 60L);
                    } else {
                        Component banReason = Component.text((String)"DeepGuardX: Maximum level violation detected\n", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"Your account has been permanently banned.", (TextColor)NamedTextColor.YELLOW));
                        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), banReason.toString(), null, "DeepGuardX System");
                        TextComponent kickMessage = Component.text((String)"DeepGuardX: You have been permanently banned for maximum-level X-ray detection.", (TextColor)NamedTextColor.RED);
                        player.kick((Component)kickMessage);
                    }
                }
                if (this.configManager.isPunishmentOptionEnabled(level, "ip_tracking")) {
                    String ip = player.getAddress().getAddress().getHostAddress();
                    List trackedIPs = this.plugin.getConfig().getStringList("tracked_ips");
                    if (!trackedIPs.contains(ip)) {
                        trackedIPs.add(ip);
                        this.plugin.getConfig().set("tracked_ips", (Object)trackedIPs);
                        this.plugin.saveConfig();
                    }
                }
                if (!this.configManager.isPunishmentOptionEnabled(level, "security_report")) break;
                this.generateSecurityReport(player);
                break;
            }
            default: {
                TextComponent kickMessage = Component.text((String)"Punished for suspicious behavior.", (TextColor)NamedTextColor.RED);
                player.kick((Component)kickMessage);
            }
        }
    }

    private void sendWarningMessage(Player player, int level) {
        float pitch;
        float volume;
        Sound alertSound;
        TextColor highlightColor;
        TextColor messageColor;
        TextColor borderColor;
        TextColor titleColor;
        String subtitleText;
        String message3;
        String message2;
        String message1;
        String titleText = "\u26a0 WARNING \u26a0";
        Particle warningParticle = switch (level) {
            case 1 -> {
                message1 = "Suspicious mining activity detected!";
                message2 = "This is your first warning.";
                message3 = "Further violations will be punished.";
                subtitleText = "Level 1 - First Warning";
                titleColor = TextColor.color((int)255, (int)255, (int)0);
                borderColor = TextColor.color((int)230, (int)126, (int)34);
                messageColor = TextColor.color((int)236, (int)240, (int)241);
                highlightColor = TextColor.color((int)241, (int)196, (int)15);
                alertSound = Sound.BLOCK_NOTE_BLOCK_PLING;
                volume = 0.8f;
                pitch = 1.0f;
                yield Particle.END_ROD;
            }
            case 2 -> {
                message1 = "Continued suspicious mining detected!";
                message2 = "This is your second warning.";
                message3 = "Your actions are being monitored closely.";
                subtitleText = "Level 2 - Second Warning";
                titleColor = TextColor.color((int)255, (int)165, (int)0);
                borderColor = TextColor.color((int)231, (int)76, (int)60);
                messageColor = TextColor.color((int)236, (int)240, (int)241);
                highlightColor = TextColor.color((int)230, (int)126, (int)34);
                alertSound = Sound.ENTITY_EXPERIENCE_ORB_PICKUP;
                volume = 1.0f;
                pitch = 0.8f;
                yield Particle.SMOKE;
            }
            case 3 -> {
                message1 = "Multiple violations of mining policy!";
                message2 = "This is a serious offense.";
                message3 = "Further violations will result in severe action.";
                subtitleText = "Level 3 - Serious Offense";
                titleColor = TextColor.color((int)255, (int)69, (int)0);
                borderColor = TextColor.color((int)192, (int)57, (int)43);
                messageColor = TextColor.color((int)236, (int)240, (int)241);
                highlightColor = TextColor.color((int)231, (int)76, (int)60);
                alertSound = Sound.ENTITY_ELDER_GUARDIAN_CURSE;
                volume = 0.4f;
                pitch = 1.0f;
                yield Particle.ANGRY_VILLAGER;
            }
            case 4 -> {
                message1 = "Severe mining violations detected!";
                message2 = "This is a major offense.";
                message3 = "Your mining privileges are now restricted.";
                subtitleText = "Level 4 - Major Offense";
                titleColor = TextColor.color((int)255, (int)0, (int)0);
                borderColor = TextColor.color((int)153, (int)0, (int)0);
                messageColor = TextColor.color((int)236, (int)240, (int)241);
                highlightColor = TextColor.color((int)192, (int)57, (int)43);
                alertSound = Sound.BLOCK_BELL_USE;
                volume = 1.0f;
                pitch = 0.6f;
                yield Particle.FLAME;
            }
            case 5 -> {
                message1 = "Critical violation of server mining policy!";
                message2 = "Your actions have been flagged for review.";
                message3 = "Mining privileges severely restricted.";
                subtitleText = "Level 5 - Critical Violation";
                titleColor = TextColor.color((int)139, (int)0, (int)0);
                borderColor = TextColor.color((int)88, (int)0, (int)0);
                messageColor = TextColor.color((int)236, (int)240, (int)241);
                highlightColor = TextColor.color((int)153, (int)0, (int)0);
                alertSound = Sound.ENTITY_WITHER_SPAWN;
                volume = 0.3f;
                pitch = 0.5f;
                yield Particle.SOUL_FIRE_FLAME;
            }
            case 6 -> {
                message1 = "MAXIMUM VIOLATION DETECTED!";
                message2 = "Your account is subject to permanent action.";
                message3 = "All mining activity has been logged for review.";
                subtitleText = "Level 6 - MAXIMUM VIOLATION";
                titleColor = TextColor.color((int)128, (int)0, (int)128);
                borderColor = TextColor.color((int)75, (int)0, (int)130);
                messageColor = TextColor.color((int)236, (int)240, (int)241);
                highlightColor = TextColor.color((int)139, (int)0, (int)139);
                alertSound = Sound.ENTITY_LIGHTNING_BOLT_THUNDER;
                volume = 0.7f;
                pitch = 0.3f;
                yield Particle.SOUL;
            }
            default -> {
                message1 = "Suspicious mining activity detected!";
                message2 = "This behavior is not permitted.";
                message3 = "Further violations will be punished.";
                subtitleText = "Mining Violation Detected";
                titleColor = TextColor.color((int)255, (int)255, (int)0);
                borderColor = TextColor.color((int)230, (int)126, (int)34);
                messageColor = TextColor.color((int)236, (int)240, (int)241);
                highlightColor = TextColor.color((int)241, (int)196, (int)15);
                alertSound = Sound.BLOCK_NOTE_BLOCK_BASS;
                volume = 0.8f;
                pitch = 1.0f;
                yield Particle.END_ROD;
            }
        };
        player.showTitle(Title.title((Component)((TextComponent)Component.text((String)titleText).color(titleColor)).decoration(TextDecoration.BOLD, true), (Component)Component.text((String)subtitleText).color(highlightColor), (Title.Times)Title.Times.times((Duration)Ticks.duration((long)10L), (Duration)Ticks.duration((long)70L), (Duration)Ticks.duration((long)20L))));
        Component topBorder = Component.text((String)("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 " + this.getStars(level) + " \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557")).color(borderColor);
        Component titleLine = ((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color(borderColor)).append(((TextComponent)Component.text((String)"DeepGuardX WARNING").color(titleColor)).decoration(TextDecoration.BOLD, true))).append(Component.text((String)" \u2551").color(borderColor));
        Component separator = Component.text((String)"\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563").color(borderColor);
        Component message1Line = ((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color(borderColor)).append(Component.text((String)message1).color(messageColor))).append(Component.text((String)" \u2551").color(borderColor));
        Component message2Line = ((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color(borderColor)).append(Component.text((String)message2).color(messageColor))).append(Component.text((String)" \u2551").color(borderColor));
        Component message3Line = ((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color(borderColor)).append(Component.text((String)message3).color(messageColor))).append(Component.text((String)" \u2551").color(borderColor));
        Component bottomBorder = Component.text((String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d").color(borderColor);
        Component appealLine = ((TextComponent)((TextComponent)Component.text((String)"\u2551      ").color(borderColor)).append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[APPEAL]").color(TextColor.color((int)255, (int)215, (int)0))).decoration(TextDecoration.BOLD, true)).clickEvent(ClickEvent.suggestCommand((String)"/dgx appeal "))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to appeal this warning to staff"))))).append(Component.text((String)"      \u2551").color(borderColor));
        player.sendMessage((Component)Component.text((String)""));
        player.sendMessage(topBorder);
        player.sendMessage(titleLine);
        player.sendMessage(separator);
        player.sendMessage(message1Line);
        player.sendMessage(message2Line);
        player.sendMessage(message3Line);
        player.sendMessage(separator);
        player.sendMessage(appealLine);
        player.sendMessage(bottomBorder);
        player.sendMessage((Component)Component.text((String)""));
        player.sendMessage(Component.text((String)"If you believe this detection was incorrect, click [APPEAL] to explain your case to the staff team.").color(TextColor.color((int)200, (int)200, (int)200)));
        player.playSound(player.getLocation(), alertSound, volume, pitch);
        Location loc = player.getLocation();
        for (int i = 0; i < 20; ++i) {
            double angle = (double)i * 0.3141592653589793;
            double x = Math.cos(angle) * 1.5;
            double z = Math.sin(angle) * 1.5;
            player.getWorld().spawnParticle(warningParticle, loc.getX() + x, loc.getY() + 1.0, loc.getZ() + z, 3, 0.0, 0.0, 0.0, 0.05);
        }
        Component actionBarMsg = Component.text((String)("\u26a0 Warning Level " + level + " \u26a0")).color(titleColor);
        player.sendActionBar(actionBarMsg);
        if (level >= 4) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 600, level - 3));
        }
    }

    private String getStars(int level) {
        int i;
        StringBuilder stars = new StringBuilder();
        for (i = 0; i < level; ++i) {
            stars.append("\u2605");
        }
        for (i = level; i < 6; ++i) {
            stars.append("\u2606");
        }
        return stars.toString();
    }

    private void alertAdmins(Player violator, int level) {
        String severityText;
        TextColor severityColor = switch (level) {
            case 1 -> {
                severityText = "potential";
                yield TextColor.color((int)255, (int)255, (int)0);
            }
            case 2 -> {
                severityText = "suspicious";
                yield TextColor.color((int)255, (int)165, (int)0);
            }
            case 3 -> {
                severityText = "concerning";
                yield TextColor.color((int)255, (int)69, (int)0);
            }
            case 4 -> {
                severityText = "severe";
                yield TextColor.color((int)255, (int)0, (int)0);
            }
            case 5 -> {
                severityText = "critical";
                yield TextColor.color((int)139, (int)0, (int)0);
            }
            case 6 -> {
                severityText = "MAXIMUM";
                yield TextColor.color((int)128, (int)0, (int)128);
            }
            default -> {
                severityText = "suspicious";
                yield TextColor.color((int)255, (int)165, (int)0);
            }
        };
        int blocksMinedRecently = this.getPlayerRecentBlocksMined(violator);
        String locationInfo = String.format("%.1f, %.1f, %.1f (%s)", violator.getLocation().getX(), violator.getLocation().getY(), violator.getLocation().getZ(), violator.getWorld().getName());
        Component prefix = ((TextComponent)((TextComponent)Component.text((String)"[").color(TextColor.color((int)169, (int)169, (int)169))).append(Component.text((String)"DeepGuardX").color(TextColor.color((int)220, (int)20, (int)60)))).append(Component.text((String)"] ").color(TextColor.color((int)169, (int)169, (int)169)));
        Component playerName = ((TextComponent)Component.text((String)violator.getName()).color(severityColor)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Player Info:\n").append((Component)Component.text((String)("UUID: " + String.valueOf(violator.getUniqueId()) + "\n")))).append((Component)Component.text((String)"IP: [Redacted]\n"))).append((Component)Component.text((String)("Join Date: " + this.getPlayerJoinDate(violator) + "\n")))).append((Component)Component.text((String)("Recent Blocks Mined: " + blocksMinedRecently)))));
        Component severityInfo = Component.text((String)(" triggered a " + severityText + " Level " + level + " X-ray detection.")).color(severityColor);
        Component message = prefix.append(playerName).append(severityInfo);
        for (Player admin : Bukkit.getOnlinePlayers()) {
            if (!admin.hasPermission("deepguardx.staff")) continue;
            admin.sendMessage(message);
            float pitch = Math.min(2.0f, 0.5f + (float)level * 0.25f);
            Sound alertSound = level >= 5 ? Sound.ENTITY_ELDER_GUARDIAN_DEATH : Sound.BLOCK_NOTE_BLOCK_PLING;
            admin.playSound(admin.getLocation(), alertSound, 0.5f, pitch);
            if (level < 4) continue;
            Component alertBar = ((TextComponent)((TextComponent)Component.text((String)"\u26a0 ").color(TextColor.color((int)255, (int)0, (int)0))).append((Component)Component.text((String)("X-RAY ALERT: " + violator.getName() + " - Level " + level)))).append(Component.text((String)" \u26a0").color(TextColor.color((int)255, (int)0, (int)0)));
            admin.sendActionBar(alertBar);
        }
        Bukkit.getConsoleSender().sendMessage("[DeepGuardX] ALERT: " + violator.getName() + " triggered a " + severityText + " Level " + level + " X-ray detection at " + locationInfo);
    }

    private String getPlayerJoinDate(Player player) {
        return "Unknown";
    }

    private int getPlayerRecentBlocksMined(Player player) {
        return 0;
    }

    private void spawnFakeOreVeins(Player player) {
        UUID playerId = player.getUniqueId();
        long duration = System.currentTimeMillis() + 0x6DDD00L;
        this.fakeOreVeinsActive.put(playerId, duration);
        player.sendMessage((Component)Component.text((String)"The ore veins around you seem... unstable. Mining valuable ores may yield only stone.", (TextColor)NamedTextColor.RED));
    }

    private void dropInventoryItems(Player player, int percentage) {
        if (percentage <= 0) {
            return;
        }
        UUID playerId = player.getUniqueId();
        Random random = new Random();
        PlayerInventory inventory = player.getInventory();
        ArrayList<AbstractMap.SimpleEntry<Integer, ItemStack>> oreItems = new ArrayList<AbstractMap.SimpleEntry<Integer, ItemStack>>();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || !this.isOreItem(item.getType())) continue;
            oreItems.add(new AbstractMap.SimpleEntry<Integer, ItemStack>(i, item));
        }
        if (oreItems.isEmpty()) {
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("No ore items found in inventory for player " + player.getName());
            }
            return;
        }
        int itemsToRemove = Math.max(1, oreItems.size() * percentage / 100);
        itemsToRemove = Math.min(itemsToRemove, oreItems.size());
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Removing " + itemsToRemove + " ore items from player " + player.getName() + "'s inventory (" + percentage + "% of " + oreItems.size() + " ore items)");
        }
        int totalItemsRemoved = 0;
        HashMap<Material, Integer> removedCounts = new HashMap<Material, Integer>();
        for (int i = 0; i < itemsToRemove && !oreItems.isEmpty(); ++i) {
            int randomIndex = random.nextInt(oreItems.size());
            Map.Entry selectedEntry = (Map.Entry)oreItems.remove(randomIndex);
            int slot = (Integer)selectedEntry.getKey();
            ItemStack selectedItem = (ItemStack)selectedEntry.getValue();
            Material material = selectedItem.getType();
            int amount = selectedItem.getAmount();
            totalItemsRemoved += amount;
            removedCounts.put(material, removedCounts.getOrDefault(material, 0) + amount);
            inventory.setItem(slot, null);
        }
        player.sendMessage((Component)Component.text((String)("The DeepGuard system has confiscated " + totalItemsRemoved + " ore items from your inventory!"), (TextColor)NamedTextColor.RED));
        if (!removedCounts.isEmpty()) {
            for (Map.Entry entry : removedCounts.entrySet()) {
                player.sendMessage((Component)Component.text((String)("- " + String.valueOf(entry.getValue()) + " " + this.formatItemName((Material)entry.getKey())), (TextColor)NamedTextColor.YELLOW));
            }
        }
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 0.5f);
    }

    private String formatItemName(Material material) {
        String name = material.name();
        name = name.replace('_', ' ').toLowerCase();
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == ' ') {
                capitalizeNext = true;
                result.append(c);
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private boolean isOreItem(Material material) {
        String name = material.name();
        return name.contains("ORE") || name.contains("INGOT") || name.contains("DIAMOND") || name.contains("EMERALD") || name.contains("GOLD") || name.contains("IRON") || name.contains("COPPER") || name.contains("COAL") || name.contains("LAPIS") || name.contains("REDSTONE") || name.contains("QUARTZ") || name.contains("NETHERITE") || name.contains("RAW_") || name.equals("ANCIENT_DEBRIS");
    }

    private void damageCurrentTool(Player player, int percentage) {
    }

    private void generateSecurityReport(Player player) {
    }

    private int getMinedCount(UUID playerId, Material material) {
        return ThreadLocalRandom.current().nextInt(100, 500);
    }

    public int getPlayerPunishmentLevel(UUID playerId) {
        return this.playerPunishmentLevels.getOrDefault(playerId, 0);
    }

    public void onDisable() {
        this.savePunishmentData();
        if (this.autoSaveTaskId != -1) {
            this.plugin.getServer().getScheduler().cancelTask(this.autoSaveTaskId);
            this.autoSaveTaskId = -1;
        }
    }
}

