/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.managers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;

public class StatsManager {
    public static final Set<Material> trackedOres = new HashSet<Material>(Arrays.asList(Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.REDSTONE_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.NETHER_GOLD_ORE, Material.NETHER_QUARTZ_ORE, Material.ANCIENT_DEBRIS));
    private static final Map<UUID, Map<Material, Integer>> cumulativeStats = new HashMap<UUID, Map<Material, Integer>>();
    private static deepGuardXray plugin;
    private static ConfigManager configManager;
    private static File statsFile;
    private static int autoSaveTaskId;

    public static void initialize(deepGuardXray pluginInstance, ConfigManager configManager) {
        plugin = pluginInstance;
        StatsManager.configManager = configManager;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdir();
        }
        if ((statsFile = new File(plugin.getDataFolder(), "mining_stats.yml")).exists()) {
            StatsManager.loadStats(statsFile);
        }
    }

    public static void addOreMined(UUID playerId, Material ore) {
        if (!trackedOres.contains(ore)) {
            return;
        }
        cumulativeStats.computeIfAbsent(playerId, k -> new HashMap()).merge(ore, 1, Integer::sum);
    }

    public static Map<Material, Integer> getOreStats(UUID playerId) {
        return cumulativeStats.getOrDefault(playerId, new HashMap());
    }

    public static boolean hasStats(UUID playerId) {
        return cumulativeStats.containsKey(playerId) && !cumulativeStats.get(playerId).isEmpty();
    }

    public static Set<UUID> getAllPlayerIds() {
        return cumulativeStats.keySet();
    }

    private static void startAutoSaveTask() {
        if (autoSaveTaskId != -1) {
            plugin.getServer().getScheduler().cancelTask(autoSaveTaskId);
        }
        long autoSaveInterval = (long)configManager.getStatsAutoSaveInterval() * 1200L;
        autoSaveTaskId = plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, () -> {
            if (configManager.isStatsAutoSaveLoggingEnabled()) {
                plugin.getLogger().info("Auto-saving mining statistics...");
            }
            StatsManager.saveStats(statsFile);
            if (configManager.isStatsAutoSaveLoggingEnabled()) {
                plugin.getLogger().info("Auto-save complete for mining statistics (" + cumulativeStats.size() + " players)");
            }
        }, autoSaveInterval, autoSaveInterval);
        if (configManager.isStatsAutoSaveLoggingEnabled()) {
            plugin.getLogger().info("Started auto-save task for mining statistics (every " + configManager.getStatsAutoSaveInterval() + " minutes)");
        }
    }

    public static void forceSave() {
        StatsManager.saveStats(statsFile);
        if (configManager.isStatsAutoSaveLoggingEnabled()) {
            plugin.getLogger().info("Force-saved mining statistics for " + cumulativeStats.size() + " players");
        }
    }

    public static void saveAllData() {
        if (statsFile != null && statsFile.exists()) {
            StatsManager.saveStats(statsFile);
            if (configManager != null && configManager.isStatsAutoSaveLoggingEnabled()) {
                plugin.getLogger().info("Saved mining statistics for " + cumulativeStats.size() + " players on shutdown");
            }
        } else if (plugin != null) {
            File newStatsFile = new File(plugin.getDataFolder(), "mining_stats.yml");
            if (!newStatsFile.exists()) {
                try {
                    newStatsFile.createNewFile();
                }
                catch (IOException e) {
                    if (plugin != null) {
                        plugin.getLogger().log(Level.SEVERE, "Could not create mining_stats.yml", e);
                    }
                    return;
                }
            }
            StatsManager.saveStats(newStatsFile);
        }
        if (autoSaveTaskId != -1 && plugin != null) {
            plugin.getServer().getScheduler().cancelTask(autoSaveTaskId);
            autoSaveTaskId = -1;
        }
    }

    public static void updateAutoSaveSettings() {
        if (configManager == null || plugin == null) {
            return;
        }
        if (configManager.isStatsAutoSaveEnabled() && autoSaveTaskId == -1) {
            StatsManager.startAutoSaveTask();
        } else if (!configManager.isStatsAutoSaveEnabled() && autoSaveTaskId != -1) {
            plugin.getServer().getScheduler().cancelTask(autoSaveTaskId);
            autoSaveTaskId = -1;
            if (configManager.isStatsAutoSaveLoggingEnabled()) {
                plugin.getLogger().info("Auto-save for mining statistics has been disabled");
            }
        } else if (configManager.isStatsAutoSaveEnabled()) {
            StatsManager.startAutoSaveTask();
        }
    }

    public static void saveStats(File file) {
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<UUID, Map<Material, Integer>> entry : cumulativeStats.entrySet()) {
            String uuid = entry.getKey().toString();
            Map<Material, Integer> ores = entry.getValue();
            for (Map.Entry<Material, Integer> oreEntry : ores.entrySet()) {
                String path = "stats." + uuid + "." + oreEntry.getKey().name();
                config.set(path, (Object)oreEntry.getValue());
            }
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "Could not save mining stats to " + file.getName(), e);
        }
    }

    public static void loadStats(File file) {
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (config.contains("stats")) {
            for (String uuidString : config.getConfigurationSection("stats").getKeys(false)) {
                UUID uuid = UUID.fromString(uuidString);
                HashMap<Material, Integer> ores = new HashMap<Material, Integer>();
                for (String oreName : config.getConfigurationSection("stats." + uuidString).getKeys(false)) {
                    int count = config.getInt("stats." + uuidString + "." + oreName);
                    Material ore = Material.getMaterial((String)oreName);
                    if (ore == null) continue;
                    ores.put(ore, count);
                }
                cumulativeStats.put(uuid, ores);
            }
        }
        if (configManager != null && configManager.isStatsAutoSaveLoggingEnabled()) {
            plugin.getLogger().info("Loaded mining statistics for " + cumulativeStats.size() + " players");
        }
    }

    static {
        autoSaveTaskId = -1;
    }
}

