/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.managers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.AppealManager;

public class WebhookManager {
    private static WebhookManager instance;
    private static deepGuardXray plugin;
    private static ConfigManager configManager;

    private WebhookManager(deepGuardXray pluginInstance, ConfigManager configManagerInstance) {
        plugin = pluginInstance;
        configManager = configManagerInstance;
    }

    public static void initialize(deepGuardXray pluginInstance, ConfigManager configManagerInstance) {
        if (instance == null) {
            instance = new WebhookManager(pluginInstance, configManagerInstance);
        }
        plugin = pluginInstance;
        configManager = configManagerInstance;
    }

    public static WebhookManager getInstance() {
        return instance;
    }

    public static void sendTestMessage(String webhookUrl, String staffName) {
        String serverName = Bukkit.getServer().getName();
        if (serverName.isEmpty()) {
            serverName = "Minecraft Server";
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"DeepGuardXray Test Message\",\"description\":\"This is a test message from DeepGuardXray plugin.\",\"color\":5814783,\"fields\":[{\"name\":\"Server\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Sent By\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Plugin Version\",\"value\":\"%s\",\"inline\":true}],\"footer\":{\"text\":\"DeepGuardXray Webhook \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://www.spigotmc.org/data/resource_icons/122/122967.jpg?1742479697\"}", serverName, staffName, plugin.getDescription().getVersion(), WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendMLAnalysisAlert(Player player, boolean isCheater, double confidence, String features) {
        String prediction;
        String title;
        int color;
        if (!WebhookManager.shouldSendAlert("ml_analysis")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        if (isCheater) {
            color = 0x992D22;
            title = "\ud83e\uddea ML DETECTION: X-Ray Cheater";
            prediction = "CHEATER";
        } else {
            color = 3066993;
            title = "\ud83e\uddea ML DETECTION: Legitimate Player";
            prediction = "LEGITIMATE";
        }
        String confidenceStr = String.format("%.2f%%", confidence);
        Object conclusion = "";
        if (features != null && !features.isEmpty()) {
            if (features.contains("Conclusion:")) {
                conclusion = features.substring(features.indexOf("Conclusion:") + "Conclusion:".length()).trim();
            } else {
                int endOfFirstSentence = features.indexOf(". ");
                conclusion = endOfFirstSentence > 0 ? features.substring(0, endOfFirstSentence + 1) : features;
                if (((String)conclusion).length() > 150) {
                    conclusion = ((String)conclusion).substring(0, 147) + "...";
                }
            }
        }
        String inGameNote = "Check in-game report for detailed analysis using `/dgx ml report " + player.getName() + "`";
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"%s\",\"description\":\"Machine Learning analysis has completed.\",\"color\":%d,\"fields\":[{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Prediction\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Confidence\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Conclusion\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Note\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Recommendation\",\"value\":\"**%s**\",\"inline\":false}],\"footer\":{\"text\":\"DeepGuardXray ML Detection \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://www.spigotmc.org/data/resource_icons/122/122967.jpg?1742479697\"}", title, color, player.getName(), prediction, confidenceStr, this.escapeJson((String)conclusion), this.escapeJson(inGameNote), this.getRecommendation(isCheater, confidence), WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    private String getRecommendation(boolean isCheater, double confidence) {
        if (isCheater) {
            if (confidence >= 90.0) {
                return "Take immediate action - extremely likely to be using X-ray";
            }
            if (confidence >= 75.0) {
                return "Monitor closely and consider action - highly likely to be using X-ray";
            }
            if (confidence >= 60.0) {
                return "Continue monitoring - moderately likely to be using X-ray";
            }
            return "Weak indication - gather more data before action";
        }
        if (confidence >= 90.0) {
            return "No action needed - extremely likely to be legitimate";
        }
        if (confidence >= 75.0) {
            return "No action needed - likely legitimate";
        }
        return "Continue monitoring - prediction uncertain";
    }

    public void sendAppealStatusAlert(int appealId, String playerName, int punishmentLevel, AppealManager.AppealStatus status, String staffName, String response) {
        int color;
        if (!WebhookManager.shouldSendAlert("appeal_updates")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String emoji = switch (status) {
            case AppealManager.AppealStatus.APPROVED -> {
                color = 5763719;
                yield "\u2705";
            }
            case AppealManager.AppealStatus.DENIED -> {
                color = 15548997;
                yield "\u274c";
            }
            case AppealManager.AppealStatus.UNDER_REVIEW -> {
                color = 0xFFFF00;
                yield "\u26a0\ufe0f";
            }
            default -> {
                color = 5814783;
                yield "\ud83d\udccb";
            }
        };
        Object displayResponse = response;
        if (displayResponse != null && ((String)displayResponse).length() > 300) {
            displayResponse = ((String)displayResponse).substring(0, 297) + "...";
        }
        String responseField = displayResponse != null && !((String)displayResponse).isEmpty() ? ",{\"name\":\"Staff Response\",\"value\":\"" + this.escapeJson((String)displayResponse) + "\",\"inline\":false}" : "";
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"%s Appeal Status Update\",\"description\":\"An appeal has been %s.\",\"color\":%d,\"fields\":[{\"name\":\"Appeal ID\",\"value\":\"#%d\",\"inline\":true},{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Punishment Level\",\"value\":\"%d\",\"inline\":true},{\"name\":\"Status\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Staff Member\",\"value\":\"%s\",\"inline\":true}%s],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://www.spigotmc.org/data/resource_icons/122/122967.jpg?1742479697\"}", emoji, status.getDisplayName().toLowerCase(), color, appealId, playerName, punishmentLevel, status.getDisplayName(), staffName, responseField, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendNewAppealAlert(int appealId, String playerName, int punishmentLevel, String reason) {
        if (!WebhookManager.shouldSendAlert("appeal_updates")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        Object displayReason = reason;
        if (displayReason != null && ((String)displayReason).length() > 300) {
            displayReason = ((String)displayReason).substring(0, 297) + "...";
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\ud83d\udccb New Appeal Submitted\",\"description\":\"A player has submitted a new appeal.\",\"color\":5814783,\"fields\":[{\"name\":\"Appeal ID\",\"value\":\"#%d\",\"inline\":true},{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Punishment Level\",\"value\":\"%d\",\"inline\":true},{\"name\":\"Reason\",\"value\":\"%s\",\"inline\":false}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://www.spigotmc.org/data/resource_icons/122/122967.jpg?1742479697\"}", appealId, playerName, punishmentLevel, this.escapeJson((String)displayReason), WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    private String escapeJson(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public void sendPunishmentAlertWithAdmin(Player player, int level, String punishmentType, String adminName) {
        if (!WebhookManager.shouldSendAlert("punishment_applied")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\ud83d\uded1 Punishment Applied\",\"description\":\"Punishment has been applied to a player.\",\"color\":10038562,\"fields\":[{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Level\",\"value\":\"%d\",\"inline\":true},{\"name\":\"Type\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Applied By\",\"value\":\"%s\",\"inline\":true}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://www.spigotmc.org/data/resource_icons/122/122967.jpg?1742479697\"}", player.getName(), level, punishmentType, adminName, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendXrayAlert(Player player, String oreType, Location location, double confidence) {
        if (!WebhookManager.shouldSendAlert("xray_detection")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String coords = String.format("X: %d, Y: %d, Z: %d", location.getBlockX(), location.getBlockY(), location.getBlockZ());
        String world = location.getWorld().getName();
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\u26cf X-Ray Detection Alert (Decoy Ore)\",\"description\":\"Player mined hidden decoy ore! Basic detection method.\",\"color\":16711680,\"fields\":[{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Ore Type\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Confidence\",\"value\":\"%.1f%%\",\"inline\":true},{\"name\":\"Location\",\"value\":\"%s, %s\",\"inline\":false},{\"name\":\"Note\",\"value\":\"This is a basic detection method and should be confirmed with ML Analysis\",\"inline\":false}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://www.spigotmc.org/data/resource_icons/122/122967.jpg?1742479697\"}", player.getName(), oreType, confidence, coords, world, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendSuspiciousMiningAlert(Player player, String pattern, double score) {
        if (!WebhookManager.shouldSendAlert("suspicious_mining")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\u26a0\ufe0f Suspicious Mining Pattern\",\"description\":\"Player mined unusually high amounts of ore in a short time.\",\"color\":16750848,\"fields\":[{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Pattern\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Suspicion Score\",\"value\":\"%.1f/100\",\"inline\":true},{\"name\":\"Note\",\"value\":\"May flag legitimate players. Use ML Analysis for confirmation.\",\"inline\":false}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://www.spigotmc.org/data/resource_icons/122/122967.jpg?1742479697\"}", player.getName(), pattern, score, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendPunishmentAlert(Player player, int level, String punishmentType) {
        if (!WebhookManager.shouldSendAlert("punishment_applied")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\ud83d\uded1 Punishment Applied\",\"description\":\"Punishment has been applied to a player.\",\"color\":10038562,\"fields\":[{\"name\":\"Player\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Level\",\"value\":\"%d\",\"inline\":true},{\"name\":\"Type\",\"value\":\"%s\",\"inline\":true}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://www.spigotmc.org/data/resource_icons/122/122967.jpg?1742479697\"}", player.getName(), level, punishmentType, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    public void sendStaffActionLog(String staffName, String action, String target) {
        if (!WebhookManager.shouldSendAlert("staff_actions")) {
            return;
        }
        String webhookUrl = configManager.getWebhookUrl();
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String jsonPayload = String.format("{\"embeds\":[{\"title\":\"\ud83d\udc6e Staff Action Log\",\"description\":\"A staff member performed an action.\",\"color\":3447003,\"fields\":[{\"name\":\"Staff\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Action\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Target\",\"value\":\"%s\",\"inline\":true}],\"footer\":{\"text\":\"DeepGuardXray \u2022 %s\"}}],\"username\":\"DeepGuardXray\",\"avatar_url\":\"https://www.spigotmc.org/data/resource_icons/122/122967.jpg?1742479697\"}", staffName, action, target, WebhookManager.getCurrentTimestamp());
        WebhookManager.sendWebhookAsync(webhookUrl, jsonPayload);
    }

    private static boolean shouldSendAlert(String alertType) {
        return configManager != null && configManager.isWebhookAlertEnabled(alertType);
    }

    private static void sendWebhookAsync(String webhookUrl, String jsonPayload) {
        if (webhookUrl == null || webhookUrl.isEmpty() || !webhookUrl.startsWith("https://discord.com/api/webhooks/") && !webhookUrl.startsWith("https://discordapp.com/api/webhooks/")) {
            plugin.getLogger().warning("Invalid webhook URL format. Must start with https://discord.com/api/webhooks/");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                URL url = new URL(webhookUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                byte[] postData = jsonPayload.getBytes(StandardCharsets.UTF_8);
                connection.setRequestProperty("Content-Length", String.valueOf(postData.length));
                try (OutputStream stream = connection.getOutputStream();){
                    stream.write(postData);
                }
                int responseCode = connection.getResponseCode();
                if (responseCode == 204) {
                    plugin.getLogger().info("Webhook message sent successfully");
                } else {
                    plugin.getLogger().warning("Failed to send webhook message. Response code: " + responseCode);
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));){
                        String line;
                        StringBuilder error = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            error.append(line);
                        }
                        plugin.getLogger().warning("Error details: " + error.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                connection.disconnect();
            }
            catch (Exception e) {
                plugin.getLogger().severe("Error sending webhook: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    private static String getCurrentTimestamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
}

