/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.ml;

import org.bukkit.configuration.file.FileConfiguration;
import org.myplugin.deepGuardXray.deepGuardXray;

public class MLConfig {
    private final deepGuardXray plugin;
    private boolean enabled = true;
    private int trainingSessionDuration = 600;
    private double detectionThreshold = 0.75;
    private int positionUpdateInterval = 5;
    private boolean autoAnalysisEnabled = true;
    private int suspiciousThreshold = 5;
    private int maxAutoAnalysisPlayers = 5;

    public MLConfig(deepGuardXray plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        if (!config.contains("ml.enabled")) {
            config.set("ml.enabled", (Object)this.enabled);
        }
        if (!config.contains("ml.trainingSessionDuration")) {
            config.set("ml.trainingSessionDuration", (Object)this.trainingSessionDuration);
        }
        if (!config.contains("ml.detectionThreshold")) {
            config.set("ml.detectionThreshold", (Object)this.detectionThreshold);
        }
        if (!config.contains("ml.positionUpdateInterval")) {
            config.set("ml.positionUpdateInterval", (Object)this.positionUpdateInterval);
        }
        if (!config.contains("ml.autoAnalysis.enabled")) {
            config.set("ml.autoAnalysis.enabled", (Object)this.autoAnalysisEnabled);
        }
        if (!config.contains("ml.autoAnalysis.suspiciousThreshold")) {
            config.set("ml.autoAnalysis.suspiciousThreshold", (Object)this.suspiciousThreshold);
        }
        if (!config.contains("ml.autoAnalysis.maxPlayers")) {
            config.set("ml.autoAnalysis.maxPlayers", (Object)this.maxAutoAnalysisPlayers);
        }
        this.plugin.saveConfig();
        this.enabled = config.getBoolean("ml.enabled");
        this.trainingSessionDuration = config.getInt("ml.trainingSessionDuration");
        this.detectionThreshold = config.getDouble("ml.detectionThreshold");
        this.positionUpdateInterval = config.getInt("ml.positionUpdateInterval");
        this.autoAnalysisEnabled = config.getBoolean("ml.autoAnalysis.enabled");
        this.suspiciousThreshold = config.getInt("ml.autoAnalysis.suspiciousThreshold");
        this.maxAutoAnalysisPlayers = config.getInt("ml.autoAnalysis.maxPlayers");
    }

    public void saveConfig() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("ml.enabled", (Object)this.enabled);
        config.set("ml.trainingSessionDuration", (Object)this.trainingSessionDuration);
        config.set("ml.detectionThreshold", (Object)this.detectionThreshold);
        config.set("ml.positionUpdateInterval", (Object)this.positionUpdateInterval);
        config.set("ml.autoAnalysis.enabled", (Object)this.autoAnalysisEnabled);
        config.set("ml.autoAnalysis.suspiciousThreshold", (Object)this.suspiciousThreshold);
        config.set("ml.autoAnalysis.maxPlayers", (Object)this.maxAutoAnalysisPlayers);
        this.plugin.saveConfig();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.saveConfig();
    }

    public int getTrainingSessionDuration() {
        return this.trainingSessionDuration;
    }

    public double getDetectionThreshold() {
        return this.detectionThreshold;
    }

    public void setDetectionThreshold(double detectionThreshold) {
        this.detectionThreshold = detectionThreshold;
        this.saveConfig();
    }

    public int getPositionUpdateInterval() {
        return this.positionUpdateInterval;
    }

    public boolean isAutoAnalysisEnabled() {
        return this.autoAnalysisEnabled;
    }

    public void setAutoAnalysisEnabled(boolean autoAnalysisEnabled) {
        this.autoAnalysisEnabled = autoAnalysisEnabled;
        this.saveConfig();
    }

    public int getSuspiciousThreshold() {
        return this.suspiciousThreshold;
    }

    public void setSuspiciousThreshold(int suspiciousThreshold) {
        this.suspiciousThreshold = suspiciousThreshold;
        this.saveConfig();
    }

    public int getMaxAutoAnalysisPlayers() {
        return this.maxAutoAnalysisPlayers;
    }

    public void setMaxAutoAnalysisPlayers(int maxAutoAnalysisPlayers) {
        this.maxAutoAnalysisPlayers = maxAutoAnalysisPlayers;
        this.saveConfig();
    }
}

