/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.ml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.ml.PlayerMiningData;
import org.myplugin.deepGuardXray.ml.ReasoningMLModel;

public class MLDataManager {
    private static deepGuardXray plugin;
    private static File dataDir;
    private static final String TRAINING_DIR = "training";
    private static final String ANALYSIS_DIR = "analysis";
    private static final String REPORTS_DIR = "reports";
    private static final SimpleDateFormat DATE_FORMAT;

    public static void initialize(deepGuardXray plugin) {
        MLDataManager.plugin = plugin;
        dataDir = new File(plugin.getDataFolder(), "ml-data");
        File trainingDir = new File(dataDir, TRAINING_DIR);
        File analysisDir = new File(dataDir, ANALYSIS_DIR);
        File reportsDir = new File(dataDir, REPORTS_DIR);
        if (!dataDir.exists() && !dataDir.mkdirs()) {
            plugin.getLogger().severe("Failed to create ML data directory!");
        }
        if (!trainingDir.exists() && !trainingDir.mkdirs()) {
            plugin.getLogger().severe("Failed to create ML training data directory!");
        }
        if (!analysisDir.exists() && !analysisDir.mkdirs()) {
            plugin.getLogger().severe("Failed to create ML analysis data directory!");
        }
        if (!reportsDir.exists() && !reportsDir.mkdirs()) {
            plugin.getLogger().severe("Failed to create ML reports directory!");
        }
        MLDataManager.extractBundledTrainingData();
    }

    public static void savePlayerData(PlayerMiningData data) {
        if (plugin == null) {
            Bukkit.getLogger().severe("MLDataManager not initialized!");
            return;
        }
        if (data.getFeatures().isEmpty()) {
            data.calculateDerivedFeatures();
        }
        String dirName = ANALYSIS_DIR;
        File saveDir = new File(dataDir, dirName);
        String timestamp = DATE_FORMAT.format(new Date());
        String label = ANALYSIS_DIR;
        String filename = String.format("%s_%s_%s.json", data.getPlayerName(), label, timestamp);
        File outputFile = new File(saveDir, filename);
        MLDataManager.savePlayerDataToFile(data, outputFile, label, timestamp);
    }

    public static void saveTrainingData(PlayerMiningData data) {
        if (plugin == null) {
            Bukkit.getLogger().severe("MLDataManager not initialized!");
            return;
        }
        if (data.getFeatures().isEmpty()) {
            data.calculateDerivedFeatures();
        }
        File saveDir = new File(dataDir, TRAINING_DIR);
        String timestamp = DATE_FORMAT.format(new Date());
        String label = data.isLabeledAsCheater() ? "cheater" : "normal";
        String filename = String.format("%s_%s_%s.json", data.getPlayerName(), label, timestamp);
        File outputFile = new File(saveDir, filename);
        MLDataManager.savePlayerDataToFile(data, outputFile, label, timestamp);
        plugin.getLogger().info("Saved ML training data for " + data.getPlayerName() + " labeled as " + label + " to " + outputFile.getName());
    }

    public static String saveDetectionReport(String playerName, ReasoningMLModel.DetectionResult result, PlayerMiningData playerData) {
        String string;
        if (plugin == null) {
            Bukkit.getLogger().severe("MLDataManager not initialized!");
            return null;
        }
        File saveDir = new File(dataDir, REPORTS_DIR);
        String timestamp = DATE_FORMAT.format(new Date());
        String suspicionLevel = MLDataManager.getSuspicionLevelTag(result.getProbability());
        String filename = String.format("%s_%s_%s.json", playerName, suspicionLevel, timestamp);
        File outputFile = new File(saveDir, filename);
        FileWriter writer = new FileWriter(outputFile);
        try {
            StringBuilder json = new StringBuilder("{\n");
            json.append("  \"playerName\": \"").append(playerName).append("\",\n");
            json.append("  \"timestamp\": \"").append(timestamp).append("\",\n");
            json.append("  \"suspicionScore\": ").append(result.getProbability()).append(",\n");
            json.append("  \"suspicionLevel\": \"").append(suspicionLevel).append("\",\n");
            json.append("  \"conclusion\": \"").append(MLDataManager.escapeJsonString(result.getConclusion())).append("\",\n");
            json.append("  \"reasoningSteps\": [\n");
            List<String> steps = result.getReasoningSteps();
            for (int i = 0; i < steps.size(); ++i) {
                json.append("    \"").append(MLDataManager.escapeJsonString(steps.get(i))).append("\"");
                if (i < steps.size() - 1) {
                    json.append(",");
                }
                json.append("\n");
            }
            json.append("  ]");
            if (playerData != null) {
                json.append(",\n  \"playerData\": {\n");
                json.append("    \"sessionDuration\": ").append((double)playerData.getTotalMiningTimeMs() / 1000.0).append(",\n");
                json.append("    \"features\": {\n");
                LinkedHashMap featureCategories = new LinkedHashMap();
                featureCategories.put("basic_metrics", new ArrayList());
                featureCategories.put("ore_counts", new ArrayList());
                featureCategories.put("ore_rates", new ArrayList());
                featureCategories.put("head_movement", new ArrayList());
                featureCategories.put("concurrent_actions", new ArrayList());
                featureCategories.put("other", new ArrayList());
                for (Map.Entry<String, Double> feature : playerData.getFeatures().entrySet()) {
                    String key = feature.getKey();
                    if (key.startsWith("total_") || key.equals("sessionDuration")) {
                        ((List)featureCategories.get("basic_metrics")).add(feature);
                        continue;
                    }
                    if (key.startsWith("ore_count_")) {
                        ((List)featureCategories.get("ore_counts")).add(feature);
                        continue;
                    }
                    if (key.startsWith("ore_rate_")) {
                        ((List)featureCategories.get("ore_rates")).add(feature);
                        continue;
                    }
                    if (key.startsWith("head_")) {
                        ((List)featureCategories.get("head_movement")).add(feature);
                        continue;
                    }
                    if (key.startsWith("concurrent_")) {
                        ((List)featureCategories.get("concurrent_actions")).add(feature);
                        continue;
                    }
                    ((List)featureCategories.get("other")).add(feature);
                }
                boolean firstCategory = true;
                for (Map.Entry category : featureCategories.entrySet()) {
                    if (((List)category.getValue()).isEmpty()) continue;
                    if (!firstCategory) {
                        json.append(",\n");
                    }
                    firstCategory = false;
                    json.append("      // ").append(((String)category.getKey()).replace("_", " ")).append("\n");
                    ((List)category.getValue()).sort(Comparator.comparing(Map.Entry::getKey));
                    boolean firstFeature = true;
                    for (Map.Entry feature : (List)category.getValue()) {
                        if (!firstFeature) {
                            json.append(",\n");
                        }
                        firstFeature = false;
                        json.append("      \"").append((String)feature.getKey()).append("\": ").append(feature.getValue());
                    }
                }
                json.append("\n    }\n");
                json.append("  }");
            }
            json.append("\n}");
            writer.write(json.toString());
            plugin.getLogger().info("Saved detection report for " + playerName + " to " + outputFile.getName());
            string = outputFile.getPath();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                plugin.getLogger().severe("Error saving detection report: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
        }
        writer.close();
        return string;
    }

    private static String getSuspicionLevelTag(double suspicionScore) {
        if (suspicionScore >= 0.8) {
            return "high_risk";
        }
        if (suspicionScore >= 0.6) {
            return "suspicious";
        }
        if (suspicionScore >= 0.4) {
            return "medium_risk";
        }
        if (suspicionScore >= 0.2) {
            return "low_risk";
        }
        return "normal";
    }

    private static String escapeJsonString(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private static void savePlayerDataToFile(PlayerMiningData data, File outputFile, String label, String timestamp) {
        try (FileWriter writer = new FileWriter(outputFile);){
            StringBuilder json = new StringBuilder("{\n");
            json.append("  \"playerName\": \"").append(data.getPlayerName()).append("\",\n");
            json.append("  \"label\": \"").append(label).append("\",\n");
            json.append("  \"timestamp\": \"").append(timestamp).append("\",\n");
            json.append("  \"sessionDuration\": ").append((double)data.getTotalMiningTimeMs() / 1000.0).append(",\n");
            json.append("  \"features\": {\n");
            LinkedHashMap featureCategories = new LinkedHashMap();
            featureCategories.put("basic_metrics", new ArrayList());
            featureCategories.put("ore_counts", new ArrayList());
            featureCategories.put("ore_rates", new ArrayList());
            featureCategories.put("head_movement", new ArrayList());
            featureCategories.put("concurrent_actions", new ArrayList());
            featureCategories.put("other", new ArrayList());
            for (Map.Entry<String, Double> feature : data.getFeatures().entrySet()) {
                String key = feature.getKey();
                if (key.startsWith("total_") || key.equals("sessionDuration")) {
                    ((List)featureCategories.get("basic_metrics")).add(feature);
                    continue;
                }
                if (key.startsWith("ore_count_")) {
                    ((List)featureCategories.get("ore_counts")).add(feature);
                    continue;
                }
                if (key.startsWith("ore_rate_")) {
                    ((List)featureCategories.get("ore_rates")).add(feature);
                    continue;
                }
                if (key.startsWith("head_")) {
                    ((List)featureCategories.get("head_movement")).add(feature);
                    continue;
                }
                if (key.startsWith("concurrent_")) {
                    ((List)featureCategories.get("concurrent_actions")).add(feature);
                    continue;
                }
                ((List)featureCategories.get("other")).add(feature);
            }
            boolean firstCategory = true;
            for (Map.Entry category : featureCategories.entrySet()) {
                if (((List)category.getValue()).isEmpty()) continue;
                if (!firstCategory) {
                    json.append(",\n");
                }
                firstCategory = false;
                json.append("    // ").append(((String)category.getKey()).replace("_", " ")).append("\n");
                ((List)category.getValue()).sort(Comparator.comparing(Map.Entry::getKey));
                boolean firstFeature = true;
                for (Map.Entry feature : (List)category.getValue()) {
                    if (!firstFeature) {
                        json.append(",\n");
                    }
                    firstFeature = false;
                    json.append("    \"").append((String)feature.getKey()).append("\": ").append(feature.getValue());
                }
            }
            json.append("\n  }\n");
            json.append("}");
            writer.write(json.toString());
            plugin.getLogger().info("Saved ML data for " + data.getPlayerName() + " to " + outputFile.getName());
        }
        catch (IOException e) {
            plugin.getLogger().severe("Error saving ML data: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static MLTrainingData loadTrainingData() {
        ArrayList<Map<String, Double>> normalFeatures = new ArrayList<Map<String, Double>>();
        ArrayList<Map<String, Double>> cheaterFeatures = new ArrayList<Map<String, Double>>();
        File trainingDir = new File(dataDir, TRAINING_DIR);
        if (!trainingDir.exists()) {
            plugin.getLogger().warning("Training data directory does not exist!");
            return new MLTrainingData(normalFeatures, cheaterFeatures);
        }
        File[] files = trainingDir.listFiles((dir, name) -> name.endsWith(".json"));
        if (files == null) {
            plugin.getLogger().warning("No training data files found!");
            return new MLTrainingData(normalFeatures, cheaterFeatures);
        }
        for (File file : files) {
            try {
                String[] lines;
                String content = new String(Files.readAllBytes(Paths.get(file.getPath(), new String[0])));
                HashMap<String, Double> features = new HashMap<String, Double>();
                String label = content.contains("\"label\": \"cheater\"") ? "cheater" : "normal";
                int featuresStart = content.indexOf("\"features\": {") + 13;
                int featuresEnd = content.lastIndexOf("}");
                String featuresStr = content.substring(featuresStart, featuresEnd);
                for (String line : lines = featuresStr.split("\n")) {
                    int keyEnd;
                    if ((line = line.trim()).isEmpty() || line.startsWith("//")) continue;
                    if (line.endsWith(",")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    if ((keyEnd = line.indexOf(":")) <= 0) continue;
                    String key = line.substring(0, keyEnd).trim().replace("\"", "");
                    String valueStr = line.substring(keyEnd + 1).trim();
                    try {
                        double value = Double.parseDouble(valueStr);
                        features.put(key, value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ("cheater".equals(label)) {
                    cheaterFeatures.add(features);
                    continue;
                }
                normalFeatures.add(features);
            }
            catch (IOException e) {
                plugin.getLogger().warning("Error reading training file " + file.getName() + ": " + e.getMessage());
            }
        }
        plugin.getLogger().info("Loaded " + normalFeatures.size() + " normal player records and " + cheaterFeatures.size() + " cheater records for training");
        return new MLTrainingData(normalFeatures, cheaterFeatures);
    }

    public static List<String> getPlayerReports(String playerName) {
        ArrayList<String> reports = new ArrayList<String>();
        File reportsDir = new File(dataDir, REPORTS_DIR);
        if (!reportsDir.exists()) {
            return reports;
        }
        File[] files = reportsDir.listFiles((dir, name) -> name.endsWith(".json"));
        if (files == null) {
            return reports;
        }
        for (File file : files) {
            if (playerName != null && !file.getName().startsWith(playerName + "_")) continue;
            reports.add(file.getPath());
        }
        reports.sort((path1, path2) -> {
            File file1 = new File((String)path1);
            File file2 = new File((String)path2);
            return Long.compare(file2.lastModified(), file1.lastModified());
        });
        return reports;
    }

    public static void extractBundledTrainingData() {
        File[] existingFiles;
        File trainingDir = new File(dataDir, TRAINING_DIR);
        if (!trainingDir.exists()) {
            trainingDir.mkdirs();
        }
        if ((existingFiles = trainingDir.listFiles((dir, name) -> name.endsWith(".json"))) != null && existingFiles.length > 0) {
            plugin.getLogger().info("Training data already exists, skipping extraction");
            return;
        }
        plugin.getLogger().info("No existing training data found, extracting bundled data...");
        try {
            String resourcePath = "ml-data/training";
            URL url = ((Object)((Object)plugin)).getClass().getClassLoader().getResource(resourcePath);
            if (url == null) {
                plugin.getLogger().warning("No bundled training data found in JAR");
                return;
            }
            if (url.getProtocol().equals("jar")) {
                String jarPath = url.getPath().substring(5, url.getPath().indexOf("!"));
                JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                Enumeration<JarEntry> entries = jar.entries();
                String pathToMatch = resourcePath + "/";
                int extractedCount = 0;
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name2 = entry.getName();
                    if (!name2.startsWith(pathToMatch) || entry.isDirectory() || !name2.endsWith(".json")) continue;
                    String filename = name2.substring(pathToMatch.length());
                    InputStream is = ((Object)((Object)plugin)).getClass().getClassLoader().getResourceAsStream(name2);
                    if (is == null) continue;
                    File outFile = new File(trainingDir, filename);
                    Files.copy(is, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    ++extractedCount;
                    is.close();
                }
                jar.close();
                plugin.getLogger().info("Extracted " + extractedCount + " training files from plugin JAR");
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("Error extracting bundled training data: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    }

    public static class MLTrainingData {
        private final List<Map<String, Double>> normalFeatures;
        private final List<Map<String, Double>> cheaterFeatures;

        public MLTrainingData(List<Map<String, Double>> normalFeatures, List<Map<String, Double>> cheaterFeatures) {
            this.normalFeatures = normalFeatures;
            this.cheaterFeatures = cheaterFeatures;
        }

        public List<Map<String, Double>> getNormalFeatures() {
            return this.normalFeatures;
        }

        public List<Map<String, Double>> getCheaterFeatures() {
            return this.cheaterFeatures;
        }

        public boolean hasEnoughData() {
            return this.normalFeatures.size() >= 3 && this.cheaterFeatures.size() >= 3;
        }
    }
}

