/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.ml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.SuspiciousManager;
import org.myplugin.deepGuardXray.managers.WebhookManager;
import org.myplugin.deepGuardXray.ml.MLConfig;
import org.myplugin.deepGuardXray.ml.MLDataManager;
import org.myplugin.deepGuardXray.ml.PlayerDataCollector;
import org.myplugin.deepGuardXray.ml.PlayerMiningData;
import org.myplugin.deepGuardXray.ml.ReasoningMLModel;
import org.myplugin.deepGuardXray.protocol.PlayerProtocolData;

public class MLManager
implements Listener {
    private final deepGuardXray plugin;
    private final MLConfig mlConfig;
    private final PlayerDataCollector dataCollector;
    private final ReasoningMLModel model;
    private final ConfigManager configManager;
    private final WebhookManager webhookManager;
    private final Map<UUID, BukkitTask> trainingTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, BukkitTask> analysisTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, Long> analysisEndTimes = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> trainingEndTimes = new ConcurrentHashMap<UUID, Long>();
    private final Queue<UUID> autoAnalysisQueue = new LinkedList<UUID>();
    private final Set<UUID> playersUnderAnalysis = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<UUID, ReasoningMLModel.DetectionResult> detectionResults = new ConcurrentHashMap<UUID, ReasoningMLModel.DetectionResult>();

    public MLManager(deepGuardXray plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.mlConfig = new MLConfig(plugin);
        this.dataCollector = new PlayerDataCollector(this.mlConfig);
        this.model = new ReasoningMLModel(plugin, this.mlConfig);
        this.webhookManager = WebhookManager.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        MLDataManager.initialize(plugin);
        this.initializeAutoAnalysis();
        if (!this.model.train()) {
            plugin.getLogger().warning("Not enough training data. Use '/dgx train <player> <cheater|normal>' to collect data.");
        } else {
            plugin.getLogger().info("ML model trained successfully!");
        }
    }

    public void startTraining(Player player, boolean isCheater) {
        if (!this.mlConfig.isEnabled()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        if (this.trainingTasks.containsKey(playerId)) {
            this.trainingTasks.get(playerId).cancel();
            this.trainingTasks.remove(playerId);
            this.trainingEndTimes.remove(playerId);
            this.dataCollector.stopCollecting(player);
        }
        this.dataCollector.startCollecting(player, isCheater);
        long endTime = System.currentTimeMillis() + (long)this.mlConfig.getTrainingSessionDuration() * 1000L;
        this.trainingEndTimes.put(playerId, endTime);
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            PlayerMiningData data = this.dataCollector.stopCollecting(player);
            this.trainingTasks.remove(playerId);
            this.trainingEndTimes.remove(playerId);
            if (data != null) {
                MLDataManager.saveTrainingData(data);
                String label = isCheater ? "cheater" : "normal player";
                for (Player staff : Bukkit.getOnlinePlayers()) {
                    if (!staff.hasPermission("deepguardx.staff")) continue;
                    staff.sendMessage("\u00a7a[DeepGuardX] \u00a7fTraining data collection complete for " + player.getName() + " as " + label + ".");
                    if (!this.model.train()) continue;
                    staff.sendMessage("\u00a7a[DeepGuardX] \u00a7fML model retrained successfully!");
                }
                this.plugin.getLogger().info("Training data collection complete for " + player.getName() + " as " + (isCheater ? "cheater" : "normal player"));
            }
        }, (long)this.mlConfig.getTrainingSessionDuration() * 20L);
        this.trainingTasks.put(playerId, task);
        String label = isCheater ? "cheater" : "normal player";
        for (Player staff : Bukkit.getOnlinePlayers()) {
            if (!staff.hasPermission("deepguardx.staff")) continue;
            staff.sendMessage("\u00a7a[DeepGuardX] \u00a7fStarted collecting training data from " + player.getName() + " as " + label + " for " + this.mlConfig.getTrainingSessionDuration() + " seconds.");
        }
        this.plugin.getLogger().info("Started collecting training data from " + player.getName() + " as " + (isCheater ? "cheater" : "normal player") + " for " + this.mlConfig.getTrainingSessionDuration() + " seconds.");
    }

    public void startAnalysis(Player player) {
        if (!this.mlConfig.isEnabled()) {
            return;
        }
        if (!this.model.isTrained()) {
            for (Player staff : Bukkit.getOnlinePlayers()) {
                if (!staff.hasPermission("deepguardx.staff")) continue;
                staff.sendMessage("\u00a7c[DeepGuardX] \u00a7fML model is not trained yet. Use '/dgx ml train' first.");
            }
            return;
        }
        UUID playerId = player.getUniqueId();
        if (this.analysisTasks.containsKey(playerId)) {
            this.analysisTasks.get(playerId).cancel();
            this.analysisTasks.remove(playerId);
            this.analysisEndTimes.remove(playerId);
            this.dataCollector.stopCollecting(player);
        }
        this.dataCollector.startCollecting(player, false);
        this.playersUnderAnalysis.add(playerId);
        long endTime = System.currentTimeMillis() + (long)this.mlConfig.getTrainingSessionDuration() * 1000L;
        this.analysisEndTimes.put(playerId, endTime);
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            PlayerMiningData data = this.dataCollector.stopCollecting(player);
            this.analysisTasks.remove(playerId);
            this.analysisEndTimes.remove(playerId);
            this.playersUnderAnalysis.remove(playerId);
            if (data != null) {
                this.analyzePlayerData(player, data);
            }
        }, (long)this.mlConfig.getTrainingSessionDuration() * 20L);
        this.analysisTasks.put(playerId, task);
        for (Player staff : Bukkit.getOnlinePlayers()) {
            if (!staff.hasPermission("deepguardx.staff") || staff.getUniqueId().equals(playerId)) continue;
            staff.sendMessage("\u00a7a[DeepGuardX] \u00a7fStarted analyzing " + player.getName() + "'s mining behavior for " + this.mlConfig.getTrainingSessionDuration() + " seconds.");
        }
        this.plugin.getLogger().info("Started analyzing " + player.getName() + " for potential X-ray usage");
    }

    private void initializeAutoAnalysis() {
        if (!this.mlConfig.isAutoAnalysisEnabled()) {
            this.autoAnalysisQueue.clear();
        }
    }

    private void processAutoAnalysisQueue() {
        if (!this.mlConfig.isAutoAnalysisEnabled() || !this.model.isTrained()) {
            return;
        }
        int maxPlayers = this.mlConfig.getMaxAutoAnalysisPlayers();
        int currentlyAnalyzing = this.playersUnderAnalysis.size();
        int availableSlots = Math.max(0, maxPlayers - currentlyAnalyzing);
        if (!this.autoAnalysisQueue.isEmpty()) {
            ArrayList<UUID> sortedQueue = new ArrayList<UUID>(this.autoAnalysisQueue);
            Map<UUID, Integer> suspiciousCounts = SuspiciousManager.getSuspiciousCounts();
            sortedQueue.sort((id1, id2) -> Integer.compare(suspiciousCounts.getOrDefault(id2, 0), suspiciousCounts.getOrDefault(id1, 0)));
            this.autoAnalysisQueue.clear();
            this.autoAnalysisQueue.addAll(sortedQueue);
        }
        int processed = 0;
        while (!this.autoAnalysisQueue.isEmpty() && processed < availableSlots) {
            UUID playerId = this.autoAnalysisQueue.peek();
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player != null && player.isOnline()) {
                if (!this.hasExistingReport(playerId, player.getName())) {
                    this.autoAnalysisQueue.poll();
                    this.startAnalysis(player);
                    ++processed;
                    for (Player staff : Bukkit.getOnlinePlayers()) {
                        if (!staff.hasPermission("deepguardx.staff")) continue;
                        int suspiciousCount = SuspiciousManager.getSuspiciousCounts().getOrDefault(playerId, 0);
                        staff.sendMessage("\u00a77[DeepGuardX] \u00a7fAuto-analyzing player \u00a7e" + player.getName() + " \u00a7fdue to high suspicious count (\u00a7e" + suspiciousCount + "\u00a7f)");
                    }
                    continue;
                }
                this.autoAnalysisQueue.poll();
                this.plugin.getLogger().info("Skipping auto-analysis for " + player.getName() + " as they already have a report");
                continue;
            }
            this.autoAnalysisQueue.poll();
        }
    }

    public void queuePlayerForAnalysis(UUID playerId) {
        Player player;
        if (!this.autoAnalysisQueue.contains(playerId) && !this.playersUnderAnalysis.contains(playerId) && (player = Bukkit.getPlayer((UUID)playerId)) != null && player.isOnline()) {
            this.autoAnalysisQueue.add(playerId);
            int suspiciousCount = SuspiciousManager.getSuspiciousCounts().getOrDefault(playerId, 0);
            this.plugin.getLogger().info("Added " + player.getName() + " to analysis queue with suspicious count: " + suspiciousCount);
            this.processAutoAnalysisQueue();
        }
    }

    private void analyzePlayerData(Player player, PlayerMiningData data) {
        data.calculateDerivedFeatures();
        ReasoningMLModel.DetectionResult result = this.model.predict(data.getFeatures());
        this.detectionResults.put(player.getUniqueId(), result);
        MLDataManager.savePlayerData(data);
        String reportPath = MLDataManager.saveDetectionReport(player.getName(), result, data);
        double cheatingProbability = result.getProbability();
        double cheatingPercentage = cheatingProbability * 100.0;
        StringBuilder keyFeaturesBuilder = new StringBuilder();
        List<String> steps = result.getReasoningSteps();
        for (int i = 0; i < Math.min(3, steps.size()); ++i) {
            String step = steps.get(i);
            int endPos = step.indexOf(". ");
            if (endPos > 0) {
                keyFeaturesBuilder.append("\u2022 ").append(step.substring(0, endPos + 1)).append("\n");
                continue;
            }
            keyFeaturesBuilder.append("\u2022 ").append(step).append("\n");
        }
        keyFeaturesBuilder.append("\nConclusion: ").append(result.getConclusion());
        boolean isSuspicious = cheatingProbability >= 0.65;
        boolean isHighlySuspicious = cheatingProbability >= this.mlConfig.getDetectionThreshold();
        String conclusion = result.getConclusion();
        this.webhookManager.sendMLAnalysisAlert(player, isSuspicious, cheatingPercentage, conclusion);
        Object summary = String.format("\u00a76Analysis for %s: %.1f%% chance of X-ray", player.getName(), cheatingPercentage);
        if (isHighlySuspicious) {
            summary = (String)summary + " \u00a7c[HIGHLY SUSPICIOUS]";
            this.plugin.getLogger().warning("Highly suspicious mining pattern detected for " + player.getName() + " (" + String.format("%.1f", cheatingPercentage) + "% confidence)");
            this.plugin.getLogger().info(result.getDetailedReport());
            this.plugin.getLogger().info("Full report saved to: " + reportPath);
            for (Player staff : Bukkit.getOnlinePlayers()) {
                if (!staff.hasPermission("deepguardx.staff")) continue;
                staff.sendMessage("\u00a7c[DeepGuardX] \u00a7fHighly suspicious mining pattern detected for " + player.getName() + " (" + String.format("%.1f", cheatingPercentage) + "% confidence)");
                staff.sendMessage("\u00a77Key findings: " + result.getConclusion());
                staff.sendMessage("\u00a77Use \u00a7f/dgx ml report " + player.getName() + " \u00a77to view analysis");
                staff.sendMessage("\u00a77Or check the ML Analysis section in the Staff Control Panel");
            }
        } else if (isSuspicious) {
            summary = (String)summary + " \u00a7e[SUSPICIOUS]";
            this.plugin.getLogger().warning("Suspicious mining pattern detected for " + player.getName() + " (" + String.format("%.1f", cheatingPercentage) + "% confidence)");
            this.plugin.getLogger().info(result.getDetailedReport());
            this.plugin.getLogger().info("Full report saved to: " + reportPath);
            for (Player staff : Bukkit.getOnlinePlayers()) {
                if (!staff.hasPermission("deepguardx.staff")) continue;
                staff.sendMessage("\u00a7e[DeepGuardX] \u00a7fSuspicious mining pattern detected for " + player.getName() + " (" + String.format("%.1f", cheatingPercentage) + "% confidence)");
                staff.sendMessage("\u00a77Key findings: " + result.getConclusion());
                staff.sendMessage("\u00a77Use \u00a7f/dgx ml report " + player.getName() + " \u00a77to view analysis");
                staff.sendMessage("\u00a77Or check the ML Analysis section in the Staff Control Panel");
            }
        } else {
            this.plugin.getLogger().info("Analysis completed for " + player.getName() + " (" + String.format("%.1f", cheatingPercentage) + "% suspicion level)");
            this.plugin.getLogger().info("Report saved to: " + reportPath);
        }
        player.sendMessage((String)summary);
    }

    public String getDetectionReport(UUID playerId) {
        ReasoningMLModel.DetectionResult result = this.detectionResults.get(playerId);
        if (result == null) {
            return null;
        }
        return result.getDetailedReport();
    }

    public double getDetectionScore(UUID playerId) {
        ReasoningMLModel.DetectionResult result = this.detectionResults.get(playerId);
        if (result == null) {
            return -1.0;
        }
        return result.getProbability();
    }

    public List<String> getSimplifiedReport(UUID playerId) {
        ReasoningMLModel.DetectionResult result = this.detectionResults.get(playerId);
        if (result == null) {
            return Collections.singletonList("\u00a7cNo analysis data available for this player");
        }
        ArrayList<String> report = new ArrayList<String>();
        report.add("\u00a76-------- X-Ray Detection Report --------");
        report.add("\u00a7fSuspicion Score: " + String.format("\u00a7%c%.1f%%", Character.valueOf(result.getProbability() > 0.7 ? (char)'c' : 'a'), result.getProbability() * 100.0));
        report.add("\u00a7fConclusion: \u00a77" + result.getConclusion());
        report.add("\u00a76-------- Key Analysis Factors --------");
        List<String> steps = result.getReasoningSteps();
        for (int i = 0; i < steps.size(); ++i) {
            String step = steps.get(i);
            int endPos = step.indexOf(". ");
            if (endPos > 0) {
                report.add("\u00a77" + step.substring(0, endPos + 1));
                continue;
            }
            report.add("\u00a77" + step);
        }
        return report;
    }

    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.mlConfig.isEnabled();
        this.mlConfig.setEnabled(enabled);
        if (wasEnabled != enabled && !enabled) {
            this.autoAnalysisQueue.clear();
        }
    }

    public boolean isEnabled() {
        return this.mlConfig.isEnabled();
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.mlConfig.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if ((this.playersUnderAnalysis.contains(playerId) || this.trainingTasks.containsKey(playerId)) && !event.getFrom().toVector().equals((Object)event.getTo().toVector())) {
            this.dataCollector.processPlayerMove(player);
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!this.mlConfig.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!this.dataCollector.isCollectingData(playerId)) {
            return;
        }
        PlayerProtocolData protocolData = this.dataCollector.getPlayerProtocolData(playerId);
        if (protocolData == null) {
            return;
        }
        boolean isDigging = false;
        if (this.plugin.getProtocolHandler().isPlayerDigging(playerId)) {
            isDigging = true;
        }
        if (isDigging) {
            protocolData.recordConcurrentAction("COMMAND_WHILE_DIGGING");
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.mlConfig.isEnabled()) {
            return;
        }
        this.dataCollector.processBlockBreak(event);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerMiningData data;
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.trainingTasks.containsKey(playerId)) {
            this.trainingTasks.get(playerId).cancel();
            this.trainingTasks.remove(playerId);
            this.trainingEndTimes.remove(playerId);
            data = this.dataCollector.stopCollecting(player);
            if (data != null) {
                MLDataManager.saveTrainingData(data);
            }
        }
        if (this.analysisTasks.containsKey(playerId)) {
            this.analysisTasks.get(playerId).cancel();
            this.analysisTasks.remove(playerId);
            this.analysisEndTimes.remove(playerId);
            data = this.dataCollector.stopCollecting(player);
            if (data != null) {
                data.calculateDerivedFeatures();
                MLDataManager.savePlayerData(data);
            }
            this.playersUnderAnalysis.remove(playerId);
        }
    }

    public Set<UUID> getPlayersUnderAnalysis() {
        return Collections.unmodifiableSet(this.playersUnderAnalysis);
    }

    public Map<UUID, Boolean> getPlayersInTraining() {
        HashMap<UUID, Boolean> result = new HashMap<UUID, Boolean>();
        for (Map.Entry<UUID, BukkitTask> entry : this.trainingTasks.entrySet()) {
            UUID playerId = entry.getKey();
            PlayerMiningData data = this.dataCollector.getPlayerData(playerId);
            if (data == null) continue;
            result.put(playerId, data.isLabeledAsCheater());
        }
        return result;
    }

    public long getRemainingAnalysisTime(UUID playerId) {
        Long endTime = this.analysisEndTimes.get(playerId);
        if (endTime == null) {
            return -1L;
        }
        long remainingMs = endTime - System.currentTimeMillis();
        return remainingMs > 0L ? remainingMs / 1000L : 0L;
    }

    public long getRemainingTrainingTime(UUID playerId) {
        Long endTime = this.trainingEndTimes.get(playerId);
        if (endTime == null) {
            return -1L;
        }
        long remainingMs = endTime - System.currentTimeMillis();
        return remainingMs > 0L ? remainingMs / 1000L : 0L;
    }

    public void cancelTraining(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.trainingTasks.containsKey(playerId)) {
            this.trainingTasks.get(playerId).cancel();
            this.trainingTasks.remove(playerId);
            this.trainingEndTimes.remove(playerId);
            this.dataCollector.stopCollecting(player);
            for (Player staff : Bukkit.getOnlinePlayers()) {
                if (!staff.hasPermission("deepguardx.staff")) continue;
                staff.sendMessage("\u00a7c[DeepGuardX] \u00a7fTraining data collection for " + player.getName() + " has been canceled.");
            }
            this.plugin.getLogger().info("Training data collection for " + player.getName() + " has been canceled");
        }
    }

    public void setAutoAnalysisEnabled(boolean enabled) {
        boolean wasEnabled = this.mlConfig.isAutoAnalysisEnabled();
        this.mlConfig.setAutoAnalysisEnabled(enabled);
        if (wasEnabled != enabled && !enabled) {
            this.autoAnalysisQueue.clear();
        }
    }

    public MLConfig getMLConfig() {
        return this.mlConfig;
    }

    public boolean isPlayerInAnalysisQueue(UUID playerId) {
        return this.autoAnalysisQueue.contains(playerId);
    }

    public boolean hasExistingReport(UUID playerId, String playerName) {
        List<String> playerReports = MLDataManager.getPlayerReports(playerName);
        return !playerReports.isEmpty();
    }

    public int getAutoAnalysisQueueSize() {
        return this.autoAnalysisQueue.size();
    }

    public boolean isTrained() {
        return this.model.isTrained();
    }

    public PlayerDataCollector getDataCollector() {
        return this.dataCollector;
    }
}

