/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.protocol;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.myplugin.deepGuardXray.ml.PlayerMiningData;

public class PlayerProtocolData
extends PlayerMiningData {
    private final Map<String, Integer> concurrentActionCounts = new HashMap<String, Integer>();
    private final Map<String, Long> lastActionRecordedTime = new HashMap<String, Long>();
    private static final long ACTION_DEDUP_THRESHOLD = 500L;
    private Logger logger;

    public PlayerProtocolData(String playerName, boolean labeledAsCheater, Logger logger) {
        super(playerName, labeledAsCheater);
        this.logger = logger;
    }

    public PlayerProtocolData(UUID playerId, Logger logger) {
        super("Unknown", false);
        this.logger = logger;
    }

    public PlayerProtocolData(String playerName, boolean labeledAsCheater) {
        super(playerName, labeledAsCheater);
    }

    public PlayerProtocolData(UUID playerId) {
        super("Unknown", false);
    }

    public void recordConcurrentAction(String actionType) {
        long currentTime = System.currentTimeMillis();
        Long lastRecorded = this.lastActionRecordedTime.get(actionType);
        if (lastRecorded != null && currentTime - lastRecorded < 500L) {
            return;
        }
        this.lastActionRecordedTime.put(actionType, currentTime);
        this.concurrentActionCounts.put(actionType, this.concurrentActionCounts.getOrDefault(actionType, 0) + 1);
    }

    public int getConcurrentActionCount(String actionType) {
        return this.concurrentActionCounts.getOrDefault(actionType, 0);
    }

    public Map<String, Integer> getAllConcurrentActionCounts() {
        return new HashMap<String, Integer>(this.concurrentActionCounts);
    }

    @Override
    public void calculateDerivedFeatures() {
        super.calculateDerivedFeatures();
        Map<String, Double> features = this.getFeatures();
        for (Map.Entry<String, Integer> entry : this.concurrentActionCounts.entrySet()) {
            features.put("concurrent_" + entry.getKey().toLowerCase(), (double)entry.getValue());
        }
    }
}

