/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.ml.PlayerDataCollector;
import org.myplugin.deepGuardXray.protocol.PlayerProtocolData;

public class ProtocolHandler {
    private final deepGuardXray plugin;
    private final ProtocolManager protocolManager;
    private final PlayerDataCollector dataCollector;
    private final Map<UUID, Boolean> inventoryOpenMap = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, PlayerActionTracker> playerActionTrackers = new ConcurrentHashMap<UUID, PlayerActionTracker>();

    public ProtocolHandler(deepGuardXray plugin, PlayerDataCollector dataCollector, ConfigManager configManager) {
        this.plugin = plugin;
        this.dataCollector = dataCollector;
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.registerInventoryListeners();
        this.registerConcurrentActionListeners();
        plugin.getLogger().info("Advanced packet-based detection enabled with ProtocolLib.");
    }

    private void registerInventoryListeners() {
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, new PacketType[]{PacketType.Play.Client.WINDOW_CLICK, PacketType.Play.Server.OPEN_WINDOW, PacketType.Play.Client.CLOSE_WINDOW}){

            public void onPacketReceiving(PacketEvent event) {
                Player player = event.getPlayer();
                UUID playerId = player.getUniqueId();
                if (!ProtocolHandler.this.dataCollector.isCollectingData(playerId)) {
                    return;
                }
                if (event.getPacketType() == PacketType.Play.Client.WINDOW_CLICK) {
                    ProtocolHandler.this.inventoryOpenMap.put(playerId, true);
                    ProtocolHandler.this.checkConcurrentActions(playerId, "INVENTORY_CLICK");
                } else if (event.getPacketType() == PacketType.Play.Client.CLOSE_WINDOW) {
                    ProtocolHandler.this.inventoryOpenMap.put(playerId, false);
                }
            }

            public void onPacketSending(PacketEvent event) {
                Player player = event.getPlayer();
                UUID playerId = player.getUniqueId();
                if (!ProtocolHandler.this.dataCollector.isCollectingData(playerId)) {
                    return;
                }
                if (event.getPacketType() == PacketType.Play.Server.OPEN_WINDOW) {
                    ProtocolHandler.this.inventoryOpenMap.put(playerId, true);
                }
            }
        });
    }

    private void registerConcurrentActionListeners() {
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, new PacketType[]{PacketType.Play.Client.BLOCK_DIG}){

            public void onPacketReceiving(PacketEvent event) {
                int action;
                Player player = event.getPlayer();
                UUID playerId = player.getUniqueId();
                if (!ProtocolHandler.this.dataCollector.isCollectingData(playerId)) {
                    return;
                }
                String actionType = null;
                if (event.getPacketType() == PacketType.Play.Client.BLOCK_DIG && ((action = ((EnumWrappers.PlayerDigType)event.getPacket().getEnumModifier(EnumWrappers.PlayerDigType.class, 2).read(0)).ordinal()) == 0 || action == 2)) {
                    PlayerProtocolData protocolData;
                    actionType = "DIGGING";
                    boolean inventoryOpen = ProtocolHandler.this.inventoryOpenMap.getOrDefault(playerId, false);
                    if (inventoryOpen && (protocolData = ProtocolHandler.this.dataCollector.getPlayerProtocolData(playerId)) != null) {
                        protocolData.recordConcurrentAction("INVENTORY_OPEN_WHILE_DIGGING");
                        this.plugin.getLogger().warning("Player " + player.getName() + " detected with inventory open while digging!");
                    }
                }
                if (actionType != null) {
                    ProtocolHandler.this.checkConcurrentActions(playerId, actionType);
                }
            }
        });
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, new PacketType[]{PacketType.Play.Client.CHAT}){

            public void onPacketReceiving(PacketEvent event) {
                Player player = event.getPlayer();
                UUID playerId = player.getUniqueId();
                if (!ProtocolHandler.this.dataCollector.isCollectingData(playerId)) {
                    return;
                }
                String message = (String)event.getPacket().getStrings().read(0);
                if (!message.startsWith("/")) {
                    ProtocolHandler.this.checkConcurrentActions(playerId, "CHATTING");
                }
            }
        });
    }

    private void checkConcurrentActions(UUID playerId, String newAction) {
        PlayerActionTracker tracker = this.playerActionTrackers.computeIfAbsent(playerId, k -> new PlayerActionTracker());
        PlayerProtocolData protocolData = this.dataCollector.getPlayerProtocolData(playerId);
        if (protocolData == null) {
            return;
        }
        Player player = this.plugin.getServer().getPlayer(playerId);
        String playerName = player != null ? player.getName() : playerId.toString();
        boolean wasDigging = tracker.isActionActive("DIGGING");
        boolean wasChatting = tracker.isActionActive("CHATTING");
        long timestamp = System.currentTimeMillis();
        boolean isDuplicate = tracker.addAction(newAction, timestamp);
        if (isDuplicate) {
            this.plugin.getLogger().fine("Skipping duplicate " + newAction + " packet from " + playerName);
            return;
        }
        boolean inventoryOpen = this.inventoryOpenMap.getOrDefault(playerId, false);
        if (inventoryOpen && newAction.equals("DIGGING")) {
            protocolData.recordConcurrentAction("INVENTORY_OPEN_WHILE_DIGGING");
        }
        if (newAction.equals("DIGGING") && wasChatting || newAction.equals("CHATTING") && wasDigging) {
            protocolData.recordConcurrentAction("CHATTING_WHILE_DIGGING");
        }
    }

    public boolean isInventoryOpen(UUID playerId) {
        return this.inventoryOpenMap.getOrDefault(playerId, false);
    }

    public void cleanupPlayer(UUID playerId) {
        this.inventoryOpenMap.remove(playerId);
        this.playerActionTrackers.remove(playerId);
    }

    public void shutdown() {
        this.inventoryOpenMap.clear();
        this.playerActionTrackers.clear();
    }

    public boolean isPlayerDigging(UUID playerId) {
        PlayerActionTracker tracker = this.playerActionTrackers.get(playerId);
        return tracker != null && tracker.isActionActive("DIGGING");
    }

    private static class PlayerActionTracker {
        private final Map<String, Long> lastActionTimes = new HashMap<String, Long>();
        private final Map<String, Long> lastProcessedTimes = new HashMap<String, Long>();
        private static final long ACTION_EXPIRY_TIME = 350L;
        private static final long DUPLICATE_THRESHOLD = 100L;

        private PlayerActionTracker() {
        }

        boolean addAction(String action, long timestamp) {
            Long lastProcessed = this.lastProcessedTimes.get(action);
            if (lastProcessed != null && timestamp - lastProcessed < 100L) {
                return true;
            }
            this.lastActionTimes.put(action, timestamp);
            this.lastProcessedTimes.put(action, timestamp);
            return false;
        }

        boolean isActionActive(String action) {
            Long lastTime = this.lastActionTimes.get(action);
            if (lastTime == null) {
                return false;
            }
            return System.currentTimeMillis() - lastTime < 350L;
        }
    }
}

