/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments;

import org.bukkit.Material;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.PunishmentManager;
import org.myplugin.deepGuardXray.punishments.PunishmentHandler;

public abstract class AbstractPunishmentHandler
implements PunishmentHandler {
    protected final deepGuardXray plugin;
    protected final ConfigManager configManager;
    protected final PunishmentManager punishmentManager;

    public AbstractPunishmentHandler(deepGuardXray plugin, ConfigManager configManager, PunishmentManager punishmentManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.punishmentManager = punishmentManager;
    }

    protected boolean isValuableOre(Material material) {
        switch (material) {
            case DIAMOND_ORE: 
            case DEEPSLATE_DIAMOND_ORE: 
            case EMERALD_ORE: 
            case DEEPSLATE_EMERALD_ORE: 
            case ANCIENT_DEBRIS: {
                return true;
            }
        }
        return false;
    }

    protected boolean isOre(Material material) {
        switch (material) {
            case DIAMOND_ORE: 
            case DEEPSLATE_DIAMOND_ORE: 
            case EMERALD_ORE: 
            case DEEPSLATE_EMERALD_ORE: 
            case ANCIENT_DEBRIS: 
            case COAL_ORE: 
            case DEEPSLATE_COAL_ORE: 
            case COPPER_ORE: 
            case DEEPSLATE_COPPER_ORE: 
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: 
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: 
            case REDSTONE_ORE: 
            case DEEPSLATE_REDSTONE_ORE: 
            case LAPIS_ORE: 
            case DEEPSLATE_LAPIS_ORE: 
            case NETHER_GOLD_ORE: 
            case NETHER_QUARTZ_ORE: {
                return true;
            }
        }
        return false;
    }

    protected String formatItemName(Material material) {
        String name = material.name();
        name = name.replace('_', ' ');
        name = name.toLowerCase();
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == ' ') {
                capitalizeNext = true;
                result.append(c);
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

