/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments.handlers;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.PunishmentManager;
import org.myplugin.deepGuardXray.punishments.AbstractPunishmentHandler;

public class CursedPickaxeHandler
extends AbstractPunishmentHandler {
    public CursedPickaxeHandler(deepGuardXray plugin, ConfigManager configManager, PunishmentManager punishmentManager) {
        super(plugin, configManager, punishmentManager);
    }

    @Override
    public boolean processBlockBreak(Player player, Block block) {
        Material ore = block.getType();
        if (!this.isOre(ore)) {
            return false;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (tool != null && tool.getType().name().contains("PICKAXE")) {
            if (this.isValuableOre(ore)) {
                player.getInventory().setItemInMainHand(null);
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 0.7f);
                player.playSound(player.getLocation(), Sound.ENTITY_BLAZE_HURT, 0.8f, 0.5f);
                player.getWorld().spawnParticle(Particle.LAVA, block.getLocation().add(0.5, 0.5, 0.5), 15, 0.4, 0.4, 0.4, 0.1);
                player.getWorld().spawnParticle(Particle.ITEM, block.getLocation().add(0.5, 0.5, 0.5), 25, 0.5, 0.5, 0.5, 0.1, (Object)new ItemStack(tool.getType()));
                player.sendMessage((Component)Component.text((String)"Your pickaxe SHATTERS into pieces as punishment for your suspicious mining!", (TextColor)NamedTextColor.DARK_RED));
                this.damageRandomInventoryItems(player, 2);
                if (ThreadLocalRandom.current().nextInt(100) < 5) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, 6000, 2));
                    player.sendMessage((Component)Component.text((String)"Your arms ache terribly from the cursed tool breaking...", (TextColor)NamedTextColor.RED));
                }
                if (this.configManager.isDebugEnabled()) {
                    this.plugin.getLogger().info("Cursed pickaxe triggered for " + player.getName() + " mining " + ore.name() + " - Tool destroyed with additional penalties");
                }
            } else if (ThreadLocalRandom.current().nextInt(100) < 50) {
                player.getInventory().setItemInMainHand(null);
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                player.sendMessage((Component)Component.text((String)"Your cursed pickaxe breaks while mining ore!", (TextColor)NamedTextColor.RED));
                player.getWorld().spawnParticle(Particle.ITEM, block.getLocation().add(0.5, 0.5, 0.5), 15, 0.3, 0.3, 0.3, 0.05, (Object)new ItemStack(tool.getType()));
            } else if (tool.getItemMeta() instanceof Damageable) {
                int remainingDurability;
                Damageable damageable = (Damageable)tool.getItemMeta();
                short maxDurability = tool.getType().getMaxDurability();
                int currentDamage = damageable.getDamage();
                int newDamage = currentDamage + (int)((double)(remainingDurability = maxDurability - currentDamage) * 0.9);
                if (newDamage >= maxDurability) {
                    player.getInventory().setItemInMainHand(null);
                    player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                    player.sendMessage((Component)Component.text((String)"Your cursed pickaxe finally gives out!", (TextColor)NamedTextColor.RED));
                } else {
                    damageable.setDamage(newDamage);
                    tool.setItemMeta((ItemMeta)damageable);
                    player.sendMessage((Component)Component.text((String)"Your cursed pickaxe is barely holding together!", (TextColor)NamedTextColor.RED));
                    player.playSound(player.getLocation(), Sound.BLOCK_GLASS_BREAK, 0.5f, 1.5f);
                }
            }
        }
        return false;
    }

    @Override
    public boolean isActive(Player player) {
        return this.punishmentManager.hasCursedPickaxe(player.getUniqueId());
    }

    private void damageRandomInventoryItems(Player player, int itemCount) {
        Random random = new Random();
        PlayerInventory inventory = player.getInventory();
        ArrayList<Integer> toolSlots = new ArrayList<Integer>();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || !this.isTool(item.getType())) continue;
            toolSlots.add(i);
        }
        if (toolSlots.isEmpty()) {
            return;
        }
        int damaged = 0;
        while (!toolSlots.isEmpty() && damaged < itemCount) {
            int remainingDurability;
            int randomIndex = random.nextInt(toolSlots.size());
            int slot = (Integer)toolSlots.remove(randomIndex);
            ItemStack item = inventory.getItem(slot);
            if (item == null || !(item.getItemMeta() instanceof Damageable)) continue;
            Damageable damageable = (Damageable)item.getItemMeta();
            short maxDurability = item.getType().getMaxDurability();
            int currentDamage = damageable.getDamage();
            int newDamage = currentDamage + (int)((double)(remainingDurability = maxDurability - currentDamage) * 0.75);
            if (newDamage >= maxDurability) {
                inventory.setItem(slot, null);
                player.sendMessage((Component)Component.text((String)("Your " + this.formatItemName(item.getType()) + " has been destroyed by the curse!"), (TextColor)NamedTextColor.RED));
            } else {
                damageable.setDamage(newDamage);
                item.setItemMeta((ItemMeta)damageable);
            }
            ++damaged;
        }
        if (damaged > 0) {
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 0.7f, 0.9f);
            player.sendMessage((Component)Component.text((String)"The curse spreads to other tools in your inventory!", (TextColor)NamedTextColor.RED));
        }
    }

    private boolean isTool(Material material) {
        String name = material.name();
        return name.contains("PICKAXE") || name.contains("AXE") || name.contains("SHOVEL") || name.contains("HOE") || name.contains("SWORD") || name.contains("SHEARS");
    }
}

