/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments.handlers;

import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.PunishmentManager;
import org.myplugin.deepGuardXray.punishments.AbstractPunishmentHandler;
import org.myplugin.deepGuardXray.utils.LocationUtils;

public class FoolsGoldHandler
extends AbstractPunishmentHandler {
    public FoolsGoldHandler(deepGuardXray plugin, ConfigManager configManager, PunishmentManager punishmentManager) {
        super(plugin, configManager, punishmentManager);
    }

    @Override
    public boolean processBlockBreak(Player player, Block block) {
        Material ore = block.getType();
        if (ore != Material.DIAMOND_ORE && ore != Material.DEEPSLATE_DIAMOND_ORE) {
            return false;
        }
        Collection originalDrops = block.getDrops(player.getInventory().getItemInMainHand());
        for (ItemStack drop : originalDrops) {
            if (drop.getType() == Material.DIAMOND) {
                Material fakeMaterial = ThreadLocalRandom.current().nextBoolean() ? Material.RAW_COPPER : Material.RAW_GOLD;
                ItemStack fakeDrop = new ItemStack(fakeMaterial, drop.getAmount());
                block.getWorld().dropItemNaturally(block.getLocation(), fakeDrop);
                player.getWorld().spawnParticle(Particle.WITCH, block.getLocation().add(0.5, 0.5, 0.5), 15, 0.4, 0.4, 0.4, 0.01);
                continue;
            }
            block.getWorld().dropItemNaturally(block.getLocation(), drop);
        }
        if (ThreadLocalRandom.current().nextInt(2) == 0) {
            player.sendMessage((Component)Component.text((String)"The diamond's luster seems... different somehow.", (TextColor)NamedTextColor.GOLD));
        }
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Fool's Gold punishment triggered for " + player.getName() + " at " + LocationUtils.formatLocation(block.getLocation()) + " - Diamonds replaced with copper/gold.");
        }
        block.setType(Material.AIR);
        return true;
    }

    @Override
    public boolean isActive(Player player) {
        return this.punishmentManager.hasFoolsGold(player.getUniqueId());
    }
}

