/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.alerts;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.utils.LocationUtils;

public class StaffAlertManager {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final Set<UUID> oreAlertToggledOff = new HashSet<UUID>();
    private final Map<UUID, Map<Material, OreCounter>> staffOreTracker = new HashMap<UUID, Map<Material, OreCounter>>();

    public StaffAlertManager(JavaPlugin plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public Component getFormattedOreName(Material ore) {
        String oreName = ore.name();
        String formattedName = oreName.replace("_", " ");
        String[] words = formattedName.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            result.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        formattedName = result.toString().trim();
        return switch (ore) {
            case Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.AQUA);
            case Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.GREEN);
            case Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.NETHER_GOLD_ORE -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.GOLD);
            case Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.GRAY);
            case Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.DARK_GRAY);
            case Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.GOLD);
            case Material.REDSTONE_ORE, Material.DEEPSLATE_REDSTONE_ORE -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.RED);
            case Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.BLUE);
            case Material.NETHER_QUARTZ_ORE -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.WHITE);
            case Material.ANCIENT_DEBRIS -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.DARK_PURPLE);
            default -> (TextComponent)Component.text((String)formattedName).color((TextColor)NamedTextColor.YELLOW);
        };
    }

    public String getFormattedOreNameLegacy(Material ore) {
        String oreName = ore.name();
        String formattedName = oreName.replace("_", " ");
        String[] words = formattedName.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            result.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }

    public boolean toggleOreAlert(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.oreAlertToggledOff.contains(uuid)) {
            this.oreAlertToggledOff.remove(uuid);
            return false;
        }
        this.oreAlertToggledOff.add(uuid);
        return true;
    }

    public boolean areAlertsToggledOff(UUID uuid) {
        return this.oreAlertToggledOff.contains(uuid);
    }

    public void updateStaffOreCounter(Player player, Material ore, Location loc) {
        deepGuardXray dgxPlugin;
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        long resetTimeMillis = this.configManager.getStaffOreResetTime() * 50L;
        long detectionTimeWindow = 120000L;
        long alertCooldown = 300000L;
        Map oreMap = this.staffOreTracker.computeIfAbsent(uuid, k -> new HashMap());
        OreCounter counter = (OreCounter)oreMap.get(ore);
        if (counter == null) {
            counter = new OreCounter();
        } else if (currentTime - counter.lastUpdate > resetTimeMillis) {
            counter = new OreCounter();
        }
        counter.miningTimestamps.add(currentTime);
        ++counter.count;
        counter.lastUpdate = currentTime;
        oreMap.put(ore, counter);
        int recentOreCount = counter.getCountInTimeWindow(detectionTimeWindow);
        boolean isSuspiciousMining = false;
        double suspicionScore = 0.0;
        String pattern = "";
        if ((ore == Material.DIAMOND_ORE || ore == Material.DEEPSLATE_DIAMOND_ORE) && recentOreCount >= 8) {
            isSuspiciousMining = true;
            suspicionScore = Math.min((double)(recentOreCount * 3), 100.0);
            pattern = "High Diamond Frequency (2min)";
        } else if (ore == Material.ANCIENT_DEBRIS && recentOreCount >= 4) {
            isSuspiciousMining = true;
            suspicionScore = Math.min((double)recentOreCount * 15.0, 100.0);
            pattern = "High Ancient Debris Frequency (2min)";
        } else if ((ore == Material.EMERALD_ORE || ore == Material.DEEPSLATE_EMERALD_ORE) && recentOreCount >= 12) {
            isSuspiciousMining = true;
            suspicionScore = Math.min((double)recentOreCount * 6.0, 100.0);
            pattern = "High Emerald Frequency (2min)";
        }
        if (loc.getY() < 0.0 && (ore == Material.DIAMOND_ORE || ore == Material.DEEPSLATE_DIAMOND_ORE || ore == Material.ANCIENT_DEBRIS)) {
            suspicionScore += 2.0;
        }
        if (isSuspiciousMining && currentTime - counter.lastAlertSent > alertCooldown && this.plugin instanceof deepGuardXray && (dgxPlugin = (deepGuardXray)this.plugin).getConfigManager().isWebhookAlertEnabled("suspicious_mining")) {
            dgxPlugin.getWebhookManager().sendSuspiciousMiningAlert(player, pattern, suspicionScore);
            counter.lastAlertSent = currentTime;
        }
        if (isSuspiciousMining || this.configManager.isStaffOreAlerts()) {
            String friendlyWorld = LocationUtils.getFriendlyWorldName(player.getWorld());
            String formattedLoc = LocationUtils.formatLocation(loc);
            Component formattedOreName = this.getFormattedOreName(ore);
            String logMessage = isSuspiciousMining ? "SUSPICIOUS: Player " + player.getName() + " mined " + recentOreCount + " " + this.getFormattedOreNameLegacy(ore) + " in 2 minutes at " + friendlyWorld : "Player " + player.getName() + " mined " + counter.count + " " + this.getFormattedOreNameLegacy(ore) + " at " + friendlyWorld;
            Component baseMessage = isSuspiciousMining ? ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[SUSPICIOUS] ").color((TextColor)NamedTextColor.RED)).append(Component.text((String)("Player " + player.getName() + " mined " + recentOreCount + " ")).color((TextColor)NamedTextColor.YELLOW))).append(formattedOreName)).append(Component.text((String)(" in 2 minutes at " + friendlyWorld)).color((TextColor)NamedTextColor.YELLOW)) : ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[OreAlert] ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)("Player " + player.getName() + " mined " + counter.count + " ")).color((TextColor)NamedTextColor.RED))).append(formattedOreName)).append(Component.text((String)(" at " + friendlyWorld)).color((TextColor)NamedTextColor.RED));
            Component teleportComponent = ((TextComponent)((TextComponent)Component.text((String)" [Click to teleport]").color((TextColor)NamedTextColor.GOLD)).clickEvent(ClickEvent.runCommand((String)("/dgx teleport " + player.getName())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Teleport to " + player.getName()))));
            Component fullMessage = baseMessage.append(teleportComponent);
            for (Player online : this.plugin.getServer().getOnlinePlayers()) {
                if (!online.hasPermission("deepguardx.staff") || !isSuspiciousMining && this.areAlertsToggledOff(online.getUniqueId())) continue;
                online.sendMessage(fullMessage);
            }
            this.logDecoyEvent(logMessage);
        }
    }

    public void logDecoyEvent(String message) {
        File logFile = new File(this.plugin.getDataFolder(), "decoy-warnings.log");
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(logFile, true));){
            String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            bw.write("[" + timeStamp + "] " + message);
            bw.newLine();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not write to decoy-warnings.log: " + e.getMessage());
        }
    }

    public void alertStaffWithTeleport(Player player, Location loc, String rawMessage) {
        String friendlyWorld = LocationUtils.getFriendlyWorldName(loc.getWorld());
        String formattedLoc = LocationUtils.formatLocation(loc);
        String logMessage = rawMessage.replace(loc.toString(), friendlyWorld + " " + formattedLoc);
        Component baseMsg = ((TextComponent)Component.text((String)"[DeepGuardX] ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)logMessage).color((TextColor)NamedTextColor.RED));
        Component tpComponent = ((TextComponent)((TextComponent)Component.text((String)" [Click to teleport]").color((TextColor)NamedTextColor.AQUA)).clickEvent(ClickEvent.runCommand((String)("/dgx teleport " + player.getName())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Teleport to " + player.getName()))));
        Component fullMessage = baseMsg.append(tpComponent);
        for (Player online : this.plugin.getServer().getOnlinePlayers()) {
            if (!online.hasPermission("deepguardx.staff")) continue;
            online.sendMessage(fullMessage);
        }
        this.logDecoyEvent(logMessage);
    }

    private static class OreCounter {
        int count = 0;
        long lastUpdate = 0L;
        long lastAlertSent = 0L;
        List<Long> miningTimestamps = new ArrayList<Long>();

        private OreCounter() {
        }

        public int getCountInTimeWindow(long timeWindowMillis) {
            long currentTime = System.currentTimeMillis();
            long cutoffTime = currentTime - timeWindowMillis;
            this.miningTimestamps.removeIf(timestamp -> timestamp < cutoffTime);
            return this.miningTimestamps.size();
        }
    }
}

