/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.myplugin.deepGuardXray.commands.AntiXrayCommand;
import org.myplugin.deepGuardXray.deepGuardXray;

public class CommandHider
implements Listener,
CommandExecutor,
TabCompleter {
    private final deepGuardXray plugin;
    private final List<String> hiddenCommands;
    private final AntiXrayCommand realCommandExecutor;

    public CommandHider(deepGuardXray plugin) {
        this.plugin = plugin;
        this.hiddenCommands = Arrays.asList("deepguard", "dgx", "deepguardx", "deepguard-xray:deepguard", "deepguard-xray:dgx");
        this.realCommandExecutor = new AntiXrayCommand(plugin, plugin.getUpdateChecker());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && !sender.hasPermission("deepguardx.use")) {
            String errorLine1 = this.plugin.getConfigManager().getCommandHidingErrorLine1();
            String errorLine2 = this.plugin.getConfigManager().getCommandHidingErrorLine2().replace("{command}", label);
            sender.sendMessage(errorLine1);
            sender.sendMessage(errorLine2);
            return true;
        }
        return this.realCommandExecutor.onCommand(sender, command, label, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (sender instanceof Player && !sender.hasPermission("deepguardx.use")) {
            return new ArrayList<String>();
        }
        if (this.realCommandExecutor instanceof TabCompleter) {
            return this.realCommandExecutor.onTabComplete(sender, command, alias, args);
        }
        return null;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("deepguardx.use")) {
            event.getCommands().removeAll(this.hiddenCommands);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onTabComplete(TabCompleteEvent event) {
        if (!(event.getSender() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getSender();
        if (!player.hasPermission("deepguardx.use")) {
            String buffer = event.getBuffer().toLowerCase();
            for (String cmd : this.hiddenCommands) {
                if (buffer.startsWith("/" + cmd)) {
                    event.setCancelled(true);
                    event.setCompletions(new ArrayList());
                    return;
                }
                String cmdWithSlash = "/" + cmd;
                if (!cmdWithSlash.startsWith(buffer)) continue;
                event.setCancelled(true);
                event.setCompletions(new ArrayList());
                return;
            }
        }
    }
}

