/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands.subcommands;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.AppealManager;

public class AppealCommand
implements CommandExecutor,
Listener {
    private final deepGuardXray plugin;
    private final AppealManager appealManager;
    private final Map<UUID, Integer> awaitingReason = new HashMap<UUID, Integer>();

    public AppealCommand(deepGuardXray plugin, AppealManager appealManager) {
        this.plugin = plugin;
        this.appealManager = appealManager;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        UUID playerId = player.getUniqueId();
        int punishmentLevel = this.plugin.getPunishmentManager().getPlayerPunishmentLevel(playerId);
        if (punishmentLevel <= 0) {
            player.sendMessage(Component.text((String)"You don't have any active punishments to appeal.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        AppealManager.Appeal existingAppeal = this.appealManager.getActiveAppealForPlayer(playerId);
        if (existingAppeal != null && existingAppeal.getPunishmentLevel() == punishmentLevel && (existingAppeal.getStatus() == AppealManager.AppealStatus.PENDING || existingAppeal.getStatus() == AppealManager.AppealStatus.UNDER_REVIEW)) {
            this.showAppealStatus(player, existingAppeal);
            return true;
        }
        List<AppealManager.Appeal> allAppeals = this.appealManager.getAppealsForPlayer(playerId);
        if (!allAppeals.isEmpty()) {
            allAppeals.sort(Comparator.comparing(AppealManager.Appeal::getTimestamp).reversed());
            AppealManager.Appeal mostRecentAppeal = allAppeals.get(0);
            if (mostRecentAppeal.getPunishmentLevel() != punishmentLevel) {
                this.startAppealProcess(player, punishmentLevel);
                return true;
            }
            if (mostRecentAppeal.getStatus() == AppealManager.AppealStatus.DENIED || mostRecentAppeal.getStatus() == AppealManager.AppealStatus.APPROVED) {
                this.startAppealProcess(player, punishmentLevel);
                return true;
            }
            this.showAppealStatus(player, mostRecentAppeal);
            return true;
        }
        this.startAppealProcess(player, punishmentLevel);
        return true;
    }

    private void startAppealProcess(Player player, int punishmentLevel) {
        UUID playerId = player.getUniqueId();
        this.awaitingReason.put(playerId, punishmentLevel);
        player.sendMessage(Component.text((String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557").color((TextColor)NamedTextColor.GOLD));
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)"Please type your appeal reason ").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)"\u2551").color((TextColor)NamedTextColor.GOLD)));
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)"Explain why you believe the ").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)"\u2551").color((TextColor)NamedTextColor.GOLD)));
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)"detection was incorrect. ").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)"\u2551").color((TextColor)NamedTextColor.GOLD)));
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)"Your next message will be your ").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)"\u2551").color((TextColor)NamedTextColor.GOLD)));
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)"appeal reason (not visible to ").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)"\u2551").color((TextColor)NamedTextColor.GOLD)));
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)"other players). ").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)"\u2551").color((TextColor)NamedTextColor.GOLD)));
        player.sendMessage(Component.text((String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d").color((TextColor)NamedTextColor.GOLD));
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.2f);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.awaitingReason.containsKey(playerId)) {
            event.setCancelled(true);
            int punishmentLevel = this.awaitingReason.get(playerId);
            this.awaitingReason.remove(playerId);
            String appealReason = event.getMessage();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                AppealManager.Appeal appeal = this.appealManager.createAppeal(player, punishmentLevel, appealReason);
                player.sendMessage(Component.text((String)"Your appeal has been submitted successfully!").color((TextColor)NamedTextColor.GREEN));
                player.sendMessage(Component.text((String)"Staff will review your case as soon as possible.").color((TextColor)NamedTextColor.YELLOW));
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"Use ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)"/dgx appeal").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)" to check your appeal status.").color((TextColor)NamedTextColor.GRAY)));
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.5f, 1.2f);
            });
        }
    }

    private void showAppealStatus(Player player, AppealManager.Appeal appeal) {
        UUID playerId = player.getUniqueId();
        int currentPunishmentLevel = this.plugin.getPunishmentManager().getPlayerPunishmentLevel(playerId);
        Component statusComponent = ((TextComponent)Component.text((String)"Status: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)appeal.getStatus().getDisplayName()).color(appeal.getStatus().getColor()));
        player.sendMessage(Component.text((String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 APPEAL STATUS \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557").color((TextColor)NamedTextColor.AQUA));
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)("Appeal #" + appeal.getId())).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(statusComponent)).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
        if (appeal.getStatus() != AppealManager.AppealStatus.PENDING && !appeal.getStaffResponse().isEmpty()) {
            player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"Staff Response:").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
            player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)appeal.getStaffResponse()).color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
        }
        if (appeal.getStatus() == AppealManager.AppealStatus.PENDING || appeal.getStatus() == AppealManager.AppealStatus.UNDER_REVIEW) {
            player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"Your appeal is being reviewed.").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
        } else if (appeal.getStatus() == AppealManager.AppealStatus.APPROVED) {
            if (currentPunishmentLevel > 0 && appeal.getPunishmentLevel() != currentPunishmentLevel) {
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"You have a new punishment.").color((TextColor)NamedTextColor.RED))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"Type /dgx appeal to appeal it.").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
            } else {
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"Your punishment has been removed!").color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
            }
        } else if (appeal.getStatus() == AppealManager.AppealStatus.DENIED) {
            player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"Your appeal was denied.").color((TextColor)NamedTextColor.RED))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
            if (currentPunishmentLevel > 0) {
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"You can submit a new appeal.").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"Type /dgx appeal to try again.").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
            }
        }
        player.sendMessage(Component.text((String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d").color((TextColor)NamedTextColor.AQUA));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        AppealManager.Appeal appeal = this.appealManager.getActiveAppealForPlayer(playerId);
        if (appeal != null) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.showAppealStatus(player, appeal), 40L);
        }
    }
}

