/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands.subcommands;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;

public class CommandHidingCommand {
    private final deepGuardXray plugin;
    private final ConfigManager configManager;

    public CommandHidingCommand(deepGuardXray plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        boolean isConsole;
        boolean bl = isConsole = !(sender instanceof Player);
        if (!isConsole && !(player = (Player)sender).isOp()) {
            player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"Only server operators can manage command hiding.", (TextColor)NamedTextColor.RED)));
            return true;
        }
        if (args.length == 0) {
            boolean isEnabled = this.configManager.isCommandHidingEnabled();
            if (isConsole) {
                sender.sendMessage("Command Hiding is currently " + (isEnabled ? "ENABLED" : "DISABLED"));
                sender.sendMessage("Use /deepguardx commandhiding <enable/disable> to change this setting.");
                sender.sendMessage("Note: Changes require a server restart to take full effect!");
                if (isEnabled) {
                    sender.sendMessage("IMPORTANT: With command hiding enabled, players require the 'deepguardx.use' permission");
                    sender.sendMessage("to use any DeepGuardX commands, otherwise they'll see 'Unknown command' errors.");
                    sender.sendMessage("");
                    sender.sendMessage("LIMITATION: This only hides commands from direct use. Commands will still");
                    sender.sendMessage("be visible in tab completion, '/help', '/pl', '/plugins', etc.");
                }
            } else {
                Player player2 = (Player)sender;
                player2.sendMessage(Component.text((String)"Command Hiding is currently ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)(isEnabled ? "ENABLED" : "DISABLED"), (TextColor)(isEnabled ? NamedTextColor.GREEN : NamedTextColor.RED), (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
                player2.sendMessage(((TextComponent)Component.text((String)"Use ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"/deepguardx commandhiding <enable/disable>", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" to change this setting.", (TextColor)NamedTextColor.GRAY)));
                player2.sendMessage(Component.text((String)"Note: ", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)"Changes require a server restart to take full effect!", (TextColor)NamedTextColor.RED)));
                if (isEnabled) {
                    player2.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u26a0 IMPORTANT: ", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)"With command hiding enabled, players require the ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"deepguardx.use", (TextColor)NamedTextColor.AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}))).append((Component)Component.text((String)" permission to use any DeepGuardX commands, otherwise they'll see 'Unknown command' errors.", (TextColor)NamedTextColor.WHITE)));
                    player2.sendMessage(Component.text((String)"\u26a0 LIMITATION: ", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)"This only hides commands from direct use. Commands will still be visible in tab completion, '/help', '/pl', '/plugins', etc.", (TextColor)NamedTextColor.WHITE)));
                }
            }
            return true;
        }
        String action = args[0].toLowerCase();
        if (action.equals("enable")) {
            if (this.configManager.isCommandHidingEnabled()) {
                if (isConsole) {
                    sender.sendMessage("Command Hiding is already enabled.");
                } else {
                    Player player3 = (Player)sender;
                    player3.sendMessage((Component)Component.text((String)"Command Hiding is already enabled.", (TextColor)NamedTextColor.YELLOW));
                }
                return true;
            }
            this.setCommandHidingEnabled(true);
            if (isConsole) {
                sender.sendMessage("Command Hiding has been ENABLED");
                sender.sendMessage("Note: A server restart is required for this change to take full effect!");
                sender.sendMessage("---------------------------------------------------");
                sender.sendMessage("IMPORTANT PERMISSION NOTICE:");
                sender.sendMessage("You MUST grant players the 'deepguardx.use' permission");
                sender.sendMessage("to allow them to use any DeepGuardX commands.");
                sender.sendMessage("Without this permission, players will see the");
                sender.sendMessage("'Unknown command' error when trying to use commands.");
                sender.sendMessage("---------------------------------------------------");
                sender.sendMessage("LIMITATION: This only hides commands from direct use.");
                sender.sendMessage("Commands will still be visible in tab completion and '/help'.");
                sender.sendMessage("To hide from those too, you need a separate permissions");
                sender.sendMessage("or command hiding plugin (like CommandFilter or TabTPS).");
                sender.sendMessage("---------------------------------------------------");
            } else {
                Player player4 = (Player)sender;
                player4.sendMessage(Component.text((String)"Command Hiding has been ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"ENABLED", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
                player4.sendMessage(Component.text((String)"Note: ", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)"A server restart is required for this change to take full effect!", (TextColor)NamedTextColor.RED)));
                player4.sendMessage((Component)Component.text((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (TextColor)NamedTextColor.GOLD));
                player4.sendMessage((Component)Component.text((String)"\u26a0 IMPORTANT PERMISSION NOTICE:", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
                player4.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"You ", (TextColor)NamedTextColor.WHITE).append((Component)Component.text((String)"MUST", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" grant players the ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"deepguardx.use", (TextColor)NamedTextColor.AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}))).append((Component)Component.text((String)" permission", (TextColor)NamedTextColor.WHITE)));
                player4.sendMessage((Component)Component.text((String)"to allow them to use any DeepGuardX commands.", (TextColor)NamedTextColor.WHITE));
                player4.sendMessage((Component)Component.text((String)"Without this permission, players will see the", (TextColor)NamedTextColor.WHITE));
                player4.sendMessage((Component)Component.text((String)"'Unknown command' error when trying to use commands.", (TextColor)NamedTextColor.WHITE));
                player4.sendMessage((Component)Component.text((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (TextColor)NamedTextColor.GOLD));
                player4.sendMessage((Component)Component.text((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (TextColor)NamedTextColor.YELLOW));
                player4.sendMessage((Component)Component.text((String)"\u26a0 LIMITATION:", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
                player4.sendMessage((Component)Component.text((String)"This only hides commands from direct use.", (TextColor)NamedTextColor.WHITE));
                player4.sendMessage((Component)Component.text((String)"Commands will still be visible in tab completion, '/help',", (TextColor)NamedTextColor.WHITE));
                player4.sendMessage((Component)Component.text((String)"'/bukkit:help', '/pl', '/plugins', etc.", (TextColor)NamedTextColor.WHITE));
                player4.sendMessage((Component)Component.text((String)"To hide from those sources, you need a separate permissions", (TextColor)NamedTextColor.WHITE));
                player4.sendMessage((Component)Component.text((String)"or command hiding plugin (like LuckPerms).", (TextColor)NamedTextColor.WHITE));
                player4.sendMessage((Component)Component.text((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (TextColor)NamedTextColor.YELLOW));
            }
            return true;
        }
        if (action.equals("disable")) {
            if (!this.configManager.isCommandHidingEnabled()) {
                if (isConsole) {
                    sender.sendMessage("Command Hiding is already disabled.");
                } else {
                    Player player5 = (Player)sender;
                    player5.sendMessage((Component)Component.text((String)"Command Hiding is already disabled.", (TextColor)NamedTextColor.YELLOW));
                }
                return true;
            }
            this.setCommandHidingEnabled(false);
            if (isConsole) {
                sender.sendMessage("Command Hiding has been DISABLED");
                sender.sendMessage("Note: A server restart is required for this change to take full effect!");
            } else {
                Player player6 = (Player)sender;
                player6.sendMessage(Component.text((String)"Command Hiding has been ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"DISABLED", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
                player6.sendMessage(Component.text((String)"Note: ", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)"A server restart is required for this change to take full effect!", (TextColor)NamedTextColor.RED)));
            }
            return true;
        }
        if (isConsole) {
            sender.sendMessage("Invalid argument: " + action + ". Use 'enable' or 'disable'.");
        } else {
            Player player7 = (Player)sender;
            player7.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Invalid argument: ", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)action, (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)". Use ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"enable", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" or ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"disable", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)".", (TextColor)NamedTextColor.RED)));
        }
        return true;
    }

    private void setCommandHidingEnabled(boolean enabled) {
        this.configManager.setCommandHidingEnabled(enabled);
    }

    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String partial = args[0].toLowerCase();
            if ("enable".startsWith(partial)) {
                completions.add("enable");
            }
            if ("disable".startsWith(partial)) {
                completions.add("disable");
            }
        }
        return completions;
    }
}

