/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands.subcommands;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.DecoyManager;

public class HighlightDecoyCommand
implements CommandExecutor {
    private final deepGuardXray plugin;
    private final Map<UUID, BukkitTask> highlightTasks = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, Integer> highlightRadius = new HashMap<UUID, Integer>();
    private final Map<UUID, GameMode> originalGameModes = new HashMap<UUID, GameMode>();
    private final Map<UUID, Location> originalLocations = new HashMap<UUID, Location>();
    private final Map<UUID, Boolean> shouldReturnToOriginalLocation = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> inNearestMode = new HashMap<UUID, Boolean>();

    public HighlightDecoyCommand(deepGuardXray plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"This command can only be used by players.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        UUID playerId = player.getUniqueId();
        if (this.inNearestMode.getOrDefault(playerId, false).booleanValue()) {
            player.sendMessage(Component.text((String)"You are already using a highlight command. Please wait for it to complete.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0) {
            this.toggleHighlighting(player, false);
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("off") || args[0].equalsIgnoreCase("disable")) {
                this.disableHighlighting(player);
                return true;
            }
            if (args[0].equalsIgnoreCase("nearest")) {
                if (this.highlightTasks.containsKey(playerId)) {
                    this.disableHighlighting(player);
                }
                this.highlightNearestDecoy(player);
                return true;
            }
            if (args[0].equalsIgnoreCase("return")) {
                boolean shouldReturn = this.shouldReturnToOriginalLocation.getOrDefault(playerId, false) == false;
                this.shouldReturnToOriginalLocation.put(playerId, shouldReturn);
                player.sendMessage(Component.text((String)("Return to original location on disable: " + (shouldReturn ? "ENABLED" : "DISABLED"))).color((TextColor)NamedTextColor.GREEN));
                return true;
            }
            try {
                int radius = Integer.parseInt(args[0]);
                if (radius < 5) {
                    radius = 5;
                }
                if (radius > 50) {
                    radius = 50;
                }
                this.highlightRadius.put(playerId, radius);
                player.sendMessage(Component.text((String)("Highlight radius set to " + radius + " blocks.")).color((TextColor)NamedTextColor.GREEN));
                if (this.highlightTasks.containsKey(playerId)) {
                    this.toggleHighlighting(player, false);
                    this.toggleHighlighting(player, false);
                }
                return true;
            }
            catch (NumberFormatException e) {
                player.sendMessage(Component.text((String)"Invalid radius. Please enter a number between 5 and 50.").color((TextColor)NamedTextColor.RED));
                return true;
            }
        }
        player.sendMessage(Component.text((String)"Usage:").color((TextColor)NamedTextColor.YELLOW));
        player.sendMessage(((TextComponent)Component.text((String)("/" + label + " highlight")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" - Toggle highlighting of decoy veins").color((TextColor)NamedTextColor.YELLOW)));
        player.sendMessage(((TextComponent)Component.text((String)("/" + label + " highlight <radius>")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" - Set highlight radius (5-50 blocks)").color((TextColor)NamedTextColor.YELLOW)));
        player.sendMessage(((TextComponent)Component.text((String)("/" + label + " highlight off")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" - Disable highlighting").color((TextColor)NamedTextColor.YELLOW)));
        player.sendMessage(((TextComponent)Component.text((String)("/" + label + " highlight nearest")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" - Highlight only nearest decoy vein").color((TextColor)NamedTextColor.YELLOW)));
        player.sendMessage(((TextComponent)Component.text((String)("/" + label + " highlight return")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" - Toggle returning to original location").color((TextColor)NamedTextColor.YELLOW)));
        return true;
    }

    private void toggleHighlighting(Player player, boolean isNearestMode) {
        UUID playerId = player.getUniqueId();
        if (this.highlightTasks.containsKey(playerId)) {
            this.disableHighlighting(player);
        } else {
            this.enableHighlighting(player, isNearestMode);
        }
    }

    private void enableHighlighting(final Player player, boolean isNearestMode) {
        final UUID playerId = player.getUniqueId();
        this.disableHighlighting(player);
        GameMode originalMode = player.getGameMode();
        Location originalLoc = player.getLocation().clone();
        this.originalGameModes.put(playerId, originalMode);
        this.originalLocations.put(playerId, originalLoc);
        this.inNearestMode.put(playerId, isNearestMode);
        player.setGameMode(GameMode.SPECTATOR);
        player.sendMessage(Component.text((String)"Switched to spectator mode. You can now see through blocks.").color((TextColor)NamedTextColor.YELLOW));
        final int radius = this.highlightRadius.getOrDefault(playerId, 30);
        BukkitTask task = new BukkitRunnable(this){
            final /* synthetic */ HighlightDecoyCommand this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    this.this$0.cleanupPlayer(playerId);
                    return;
                }
                DecoyManager decoyManager = this.this$0.plugin.getDecoyManager();
                Map<Location, Set<Location>> decoyVeins = decoyManager.getAllDecoyVeins();
                if (decoyVeins.isEmpty()) {
                    if (this.getTaskId() % 40 == 0) {
                        player.sendMessage(Component.text((String)"No decoy veins found in range.").color((TextColor)NamedTextColor.YELLOW));
                    }
                    return;
                }
                int highlightedVeins = 0;
                int totalBlocks = 0;
                Location playerLoc = player.getLocation();
                for (Map.Entry<Location, Set<Location>> entry : decoyVeins.entrySet()) {
                    Location primaryLoc = entry.getKey();
                    Set<Location> veinBlocks = entry.getValue();
                    if (primaryLoc.getWorld() != playerLoc.getWorld() || primaryLoc.distance(playerLoc) > (double)radius) continue;
                    boolean validVein = false;
                    for (Location blockLoc : veinBlocks) {
                        if (!decoyManager.isDecoy(blockLoc)) continue;
                        this.this$0.highlightBlock(player, blockLoc);
                        ++totalBlocks;
                        validVein = true;
                    }
                    if (!validVein) continue;
                    ++highlightedVeins;
                }
                if (highlightedVeins > 0) {
                    if (this.getTaskId() % 40 == 0) {
                        player.sendMessage(Component.text((String)("Highlighting " + totalBlocks + " decoy blocks in " + highlightedVeins + " veins within " + radius + " blocks.")).color((TextColor)NamedTextColor.GREEN));
                    }
                } else if (this.getTaskId() % 40 == 0) {
                    player.sendMessage(Component.text((String)("No decoy veins found within " + radius + " blocks. Move around to find some.")).color((TextColor)NamedTextColor.YELLOW));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 15L);
        this.highlightTasks.put(playerId, task);
        player.sendMessage(Component.text((String)("Decoy vein highlighting enabled with radius " + String.valueOf(this.highlightRadius.getOrDefault(playerId, 30)) + " blocks.")).color((TextColor)NamedTextColor.GREEN));
        Bukkit.getPluginManager().registerEvents(new Listener(){
            final /* synthetic */ HighlightDecoyCommand this$0;
            {
                this.this$0 = this$0;
            }

            @EventHandler
            public void onPlayerQuit(PlayerQuitEvent event) {
                if (event.getPlayer().getUniqueId().equals(playerId)) {
                    this.this$0.cleanupPlayer(playerId);
                }
            }
        }, (Plugin)this.plugin);
    }

    private void disableHighlighting(Player player) {
        Location originalLoc;
        boolean shouldReturn;
        GameMode originalMode;
        UUID playerId = player.getUniqueId();
        BukkitTask task = this.highlightTasks.remove(playerId);
        if (task != null) {
            task.cancel();
        }
        if ((originalMode = this.originalGameModes.remove(playerId)) != null && player.isOnline()) {
            player.setGameMode(originalMode);
            player.sendMessage(Component.text((String)("Restored your original game mode (" + this.formatGameMode(originalMode) + ").")).color((TextColor)NamedTextColor.YELLOW));
        }
        boolean bl = shouldReturn = this.shouldReturnToOriginalLocation.getOrDefault(playerId, false) != false || this.inNearestMode.getOrDefault(playerId, false) != false;
        if (shouldReturn && player.isOnline() && (originalLoc = this.originalLocations.get(playerId)) != null) {
            player.teleport(originalLoc);
            player.sendMessage(Component.text((String)"Returned you to your original location.").color((TextColor)NamedTextColor.YELLOW));
        }
        this.inNearestMode.remove(playerId);
        this.originalLocations.remove(playerId);
        if (player.isOnline()) {
            player.sendMessage(Component.text((String)"Decoy vein highlighting disabled.").color((TextColor)NamedTextColor.YELLOW));
        }
    }

    private void cleanupPlayer(UUID playerId) {
        BukkitTask quitTask = this.highlightTasks.remove(playerId);
        if (quitTask != null) {
            quitTask.cancel();
        }
        this.originalGameModes.remove(playerId);
        this.originalLocations.remove(playerId);
        this.inNearestMode.remove(playerId);
        this.highlightRadius.remove(playerId);
    }

    private String formatGameMode(GameMode mode) {
        switch (mode) {
            case CREATIVE: {
                return "Creative";
            }
            case SURVIVAL: {
                return "Survival";
            }
            case ADVENTURE: {
                return "Adventure";
            }
            case SPECTATOR: {
                return "Spectator";
            }
        }
        return mode.toString();
    }

    private void highlightNearestDecoy(final Player player) {
        final UUID playerId = player.getUniqueId();
        this.inNearestMode.put(playerId, true);
        GameMode originalMode = player.getGameMode();
        Location originalLocation = player.getLocation().clone();
        this.originalGameModes.put(playerId, originalMode);
        this.originalLocations.put(playerId, originalLocation);
        player.setGameMode(GameMode.SPECTATOR);
        player.sendMessage(Component.text((String)"Switched to spectator mode temporarily.").color((TextColor)NamedTextColor.YELLOW));
        DecoyManager decoyManager = this.plugin.getDecoyManager();
        Location playerLoc = player.getLocation();
        Map<Location, Set<Location>> decoyVeins = decoyManager.getAllDecoyVeins();
        if (decoyVeins.isEmpty()) {
            player.sendMessage(Component.text((String)"No decoy veins found.").color((TextColor)NamedTextColor.YELLOW));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.cleanupAndRestore(player), 40L);
            return;
        }
        Location nearestVeinLoc = null;
        double nearestDistance = Double.MAX_VALUE;
        Set<Location> nearestVeinBlocks = null;
        for (Map.Entry<Location, Set<Location>> entry : decoyVeins.entrySet()) {
            double distance;
            Location veinLoc = entry.getKey();
            Set<Location> veinBlocks = entry.getValue();
            if (veinLoc.getWorld() != playerLoc.getWorld()) continue;
            boolean validVein = false;
            for (Location blockLoc : veinBlocks) {
                if (!decoyManager.isDecoy(blockLoc)) continue;
                validVein = true;
                break;
            }
            if (!validVein || !((distance = veinLoc.distance(playerLoc)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestVeinLoc = veinLoc;
            nearestVeinBlocks = veinBlocks;
        }
        if (nearestVeinLoc == null || nearestVeinBlocks == null) {
            player.sendMessage(Component.text((String)"No valid decoy veins found in your world.").color((TextColor)NamedTextColor.YELLOW));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.cleanupAndRestore(player), 40L);
            return;
        }
        player.teleport(nearestVeinLoc);
        Location veinLocation = nearestVeinLoc;
        final Set<Location> finalNearestVeinBlocks = nearestVeinBlocks;
        final DecoyManager finalDecoyManager = decoyManager;
        BukkitTask highlightTask = new BukkitRunnable(this){
            private int count = 0;
            final /* synthetic */ HighlightDecoyCommand this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.count >= 10 || !player.isOnline()) {
                    if (player.isOnline()) {
                        this.this$0.cleanupAndRestore(player);
                    } else {
                        this.this$0.cleanupPlayer(playerId);
                    }
                    this.cancel();
                    return;
                }
                if (this.count == 5) {
                    player.sendMessage(Component.text((String)"You will be returned to your original location in 5 seconds...").color((TextColor)NamedTextColor.YELLOW));
                }
                int validBlocks = 0;
                for (Location blockLoc : finalNearestVeinBlocks) {
                    if (!finalDecoyManager.isDecoy(blockLoc)) continue;
                    this.this$0.highlightBlock(player, blockLoc);
                    ++validBlocks;
                }
                if (validBlocks == 0 && this.count > 0) {
                    player.sendMessage(Component.text((String)"No decoy blocks remain in this vein. Returning you now.").color((TextColor)NamedTextColor.YELLOW));
                    this.this$0.cleanupAndRestore(player);
                    this.cancel();
                    return;
                }
                ++this.count;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.highlightTasks.put(playerId, highlightTask);
        player.sendMessage(Component.text((String)("Teleported to and highlighting nearest decoy vein at " + this.formatLocation(nearestVeinLoc) + " (" + String.format("%.1f", nearestDistance) + " blocks away)")).color((TextColor)NamedTextColor.GREEN));
        player.sendMessage(Component.text((String)"You will be returned to your original location and game mode in 10 seconds.").color((TextColor)NamedTextColor.YELLOW));
    }

    private void cleanupAndRestore(Player player) {
        UUID playerId = player.getUniqueId();
        GameMode originalMode = this.originalGameModes.getOrDefault(playerId, GameMode.SURVIVAL);
        Location originalLoc = this.originalLocations.getOrDefault(playerId, player.getLocation());
        BukkitTask task = this.highlightTasks.remove(playerId);
        if (task != null) {
            task.cancel();
        }
        this.originalGameModes.remove(playerId);
        this.originalLocations.remove(playerId);
        this.inNearestMode.remove(playerId);
        player.setGameMode(originalMode);
        player.teleport(originalLoc);
        player.sendMessage(Component.text((String)"Returned you to your original game mode and location.").color((TextColor)NamedTextColor.YELLOW));
    }

    private void highlightBlock(Player player, Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.spawnParticle(Particle.FLAME, location.clone().add(0.5, 0.5, 0.5), 5, 0.4, 0.4, 0.4, 0.01);
        world.spawnParticle(Particle.ASH, location.clone().add(0.5, 0.5, 0.5), 1, 0.0, 0.0, 0.0, 1.0);
    }

    private String formatLocation(Location loc) {
        return loc.getWorld().getName() + " [" + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ() + "]";
    }
}

