/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.commands.subcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.ml.MLManager;

public class MLCommand
implements CommandExecutor {
    private final deepGuardXray plugin;
    private final MLManager mlManager;

    public MLCommand(deepGuardXray plugin, MLManager mlManager) {
        this.plugin = plugin;
        this.mlManager = mlManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(player);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand) {
            case "train": {
                return this.handleTrainCommand(player, subArgs);
            }
            case "analyze": {
                return this.handleAnalyzeCommand(player, subArgs);
            }
            case "report": {
                return this.handleReportCommand(player, subArgs);
            }
            case "enable": {
                return this.handleEnableCommand(player, true);
            }
            case "disable": {
                return this.handleEnableCommand(player, false);
            }
            case "status": {
                return this.handleStatusCommand(player);
            }
        }
        this.sendHelp(player);
        return true;
    }

    private void sendHelp(Player player) {
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u25b6 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"DeepGuard-XRay ML ", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"Commands", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" \u25c0", (TextColor)NamedTextColor.GOLD)));
        if (player.hasPermission("deepguardx.ml.train")) {
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"/deepguardx ml train ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"train", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" <player> <cheater|normal>", (TextColor)NamedTextColor.YELLOW))).clickEvent(ClickEvent.suggestCommand((String)"/deepguardx ml train "))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to suggest command"))));
        }
        if (player.hasPermission("deepguardx.ml.analyze")) {
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"/deepguardx ml ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"analyze", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" <player>", (TextColor)NamedTextColor.YELLOW))).clickEvent(ClickEvent.suggestCommand((String)"/deepguardx ml analyze "))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to suggest command"))));
        }
        if (player.hasPermission("deepguardx.ml.report")) {
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"/deepguardx ml ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"report", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" <player>", (TextColor)NamedTextColor.YELLOW))).clickEvent(ClickEvent.suggestCommand((String)"/deepguardx ml report "))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"View detailed analysis report for a player"))));
        }
        if (player.hasPermission("deepguardx.ml.toggle")) {
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"/deepguardx ml ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"enable", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).clickEvent(ClickEvent.runCommand((String)"/deepguardx ml enable"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to enable ML system"))));
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"/deepguardx ml ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"disable", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).clickEvent(ClickEvent.runCommand((String)"/deepguardx ml disable"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to disable ML system"))));
        }
        if (player.hasPermission("deepguardx.ml.status")) {
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"/deepguardx ml ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"status", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).clickEvent(ClickEvent.runCommand((String)"/deepguardx ml status"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to check ML system status"))));
        }
    }

    private boolean handleTrainCommand(Player sender, String[] args) {
        if (!sender.hasPermission("deepguardx.ml.train")) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to train the ML system.", (TextColor)NamedTextColor.RED)));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Usage: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"/deepguardx ml train <player> <cheater|normal>", (TextColor)NamedTextColor.YELLOW)));
            return true;
        }
        String playerName = args[0];
        String label = args[1].toLowerCase();
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Player not found: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" is not online.", (TextColor)NamedTextColor.RED)));
            return true;
        }
        if (!label.equals("cheater") && !label.equals("normal")) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Invalid label. ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"Use 'cheater' or 'normal'", (TextColor)NamedTextColor.YELLOW)));
            return true;
        }
        boolean isCheater = label.equals("cheater");
        this.mlManager.startTraining(targetPlayer, isCheater);
        sender.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2713 ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)"Started collecting training data from ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" as ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)label, (TextColor)(isCheater ? NamedTextColor.RED : NamedTextColor.GREEN), (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
        return true;
    }

    private boolean handleAnalyzeCommand(Player sender, String[] args) {
        if (!sender.hasPermission("deepguardx.ml.analyze")) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to analyze players.", (TextColor)NamedTextColor.RED)));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Usage: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"/deepguardx ml analyze <player>", (TextColor)NamedTextColor.YELLOW)));
            return true;
        }
        String playerName = args[0];
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Player not found: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" is not online.", (TextColor)NamedTextColor.RED)));
            return true;
        }
        this.mlManager.startAnalysis(targetPlayer);
        sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\ud83d\udd0d ", (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)"Started analyzing ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" for X-ray behavior. Results will be shown in a few minutes.", (TextColor)NamedTextColor.AQUA)));
        return true;
    }

    private boolean handleReportCommand(Player sender, String[] args) {
        if (!sender.hasPermission("deepguardx.ml.report")) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to view analysis reports.", (TextColor)NamedTextColor.RED)));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Usage: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"/deepguardx ml report <player>", (TextColor)NamedTextColor.YELLOW)));
            return true;
        }
        String playerName = args[0];
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        UUID targetId = null;
        if (targetPlayer == null) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Player not found or no analysis data available: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW)));
            return true;
        }
        targetId = targetPlayer.getUniqueId();
        List<String> reportLines = this.mlManager.getSimplifiedReport(targetId);
        sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u25b6 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"X-Ray Detection Report: ", (TextColor)NamedTextColor.AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" \u25c0", (TextColor)NamedTextColor.GOLD)));
        for (String line : reportLines) {
            sender.sendMessage(line);
        }
        return true;
    }

    private boolean handleEnableCommand(Player sender, boolean enable) {
        if (!sender.hasPermission("deepguardx.ml.toggle")) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to toggle the ML system.", (TextColor)NamedTextColor.RED)));
            return true;
        }
        this.mlManager.setEnabled(enable);
        if (enable) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u2713 ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)"ML detection system ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"ENABLED", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
        } else {
            sender.sendMessage(((TextComponent)Component.text((String)"\u2713 ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)"ML detection system ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"DISABLED", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
        }
        return true;
    }

    private boolean handleStatusCommand(Player sender) {
        if (!sender.hasPermission("deepguardx.ml.status")) {
            sender.sendMessage(((TextComponent)Component.text((String)"\u26a0 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Permission Denied: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"You don't have permission to check ML system status.", (TextColor)NamedTextColor.RED)));
            return true;
        }
        boolean enabled = this.mlManager.isEnabled();
        sender.sendMessage(((TextComponent)Component.text((String)"\u25b6 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"DeepGuard-XRay ML Status", (TextColor)NamedTextColor.AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" \u25c0", (TextColor)NamedTextColor.GOLD)));
        sender.sendMessage(Component.text((String)"  System: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(enabled ? "ENABLED" : "DISABLED"), (TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED), (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
        if (this.mlManager.isTrained()) {
            sender.sendMessage(Component.text((String)"  Model: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"TRAINED", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
        } else {
            sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)"  Model: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"NOT TRAINED", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" - Use ", (TextColor)NamedTextColor.YELLOW))).append(((TextComponent)Component.text((String)"/deepguardx ml train", (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.suggestCommand((String)"/deepguardx ml train "))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to suggest command")))));
        }
        return true;
    }

    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return completions;
        }
        if (args.length == 1) {
            if (sender.hasPermission("deepguardx.ml.train") && "train".startsWith(args[0].toLowerCase())) {
                completions.add("train");
            }
            if (sender.hasPermission("deepguardx.ml.analyze") && "analyze".startsWith(args[0].toLowerCase())) {
                completions.add("analyze");
            }
            if (sender.hasPermission("deepguardx.ml.report") && "report".startsWith(args[0].toLowerCase())) {
                completions.add("report");
            }
            if (sender.hasPermission("deepguardx.ml.toggle")) {
                if ("enable".startsWith(args[0].toLowerCase())) {
                    completions.add("enable");
                }
                if ("disable".startsWith(args[0].toLowerCase())) {
                    completions.add("disable");
                }
            }
            if (sender.hasPermission("deepguardx.ml.status") && "status".startsWith(args[0].toLowerCase())) {
                completions.add("status");
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("train") && sender.hasPermission("deepguardx.ml.train") || args[0].equalsIgnoreCase("analyze") && sender.hasPermission("deepguardx.ml.analyze") || args[0].equalsIgnoreCase("report") && sender.hasPermission("deepguardx.ml.report")) {
                String partial = args[1].toLowerCase();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(partial)) continue;
                    completions.add(player.getName());
                }
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("train") && sender.hasPermission("deepguardx.ml.train")) {
            String partial = args[2].toLowerCase();
            if ("cheater".startsWith(partial)) {
                completions.add("cheater");
            }
            if ("normal".startsWith(partial)) {
                completions.add("normal");
            }
        }
        return completions;
    }
}

