/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray;

import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.myplugin.deepGuardXray.alerts.StaffAlertManager;
import org.myplugin.deepGuardXray.commands.AntiXrayCommand;
import org.myplugin.deepGuardXray.commands.CommandHider;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.gui.GuiListener;
import org.myplugin.deepGuardXray.gui.PlayerStatsGuiListener;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.libs.bstats.bukkit.Metrics;
import org.myplugin.deepGuardXray.listeners.BlockListener;
import org.myplugin.deepGuardXray.listeners.ChatListener;
import org.myplugin.deepGuardXray.listeners.UpdateListener;
import org.myplugin.deepGuardXray.managers.AppealManager;
import org.myplugin.deepGuardXray.managers.DecoyManager;
import org.myplugin.deepGuardXray.managers.PunishmentManager;
import org.myplugin.deepGuardXray.managers.StatsManager;
import org.myplugin.deepGuardXray.managers.SuspiciousManager;
import org.myplugin.deepGuardXray.managers.WebhookManager;
import org.myplugin.deepGuardXray.ml.MLConfig;
import org.myplugin.deepGuardXray.ml.MLDataManager;
import org.myplugin.deepGuardXray.ml.MLManager;
import org.myplugin.deepGuardXray.protocol.ProtocolHandler;
import org.myplugin.deepGuardXray.punishments.handlers.Paranoia.ParanoiaHandler;
import org.myplugin.deepGuardXray.utils.ChatInputHandler;
import org.myplugin.deepGuardXray.utils.UpdateApplier;
import org.myplugin.deepGuardXray.utils.UpdateChecker;

public class deepGuardXray
extends JavaPlugin {
    private static deepGuardXray instance;
    private ConfigManager configManager;
    private StaffAlertManager staffAlertManager;
    private DecoyManager decoyManager;
    private PunishmentManager punishmentManager;
    private AppealManager appealManager;
    private UpdateChecker updateChecker;
    private UpdateApplier updateApplier;
    private ParanoiaHandler paranoiaHandler;
    private ChatInputHandler chatInputHandler;
    private MLManager mlManager;
    private ProtocolHandler protocolHandler;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.updateApplier = new UpdateApplier(this);
        this.updateApplier.performPendingCleanup();
        boolean updatePending = this.updateApplier.checkForPendingUpdate();
        int resourceId = 122967;
        this.updateChecker = new UpdateChecker(this, resourceId);
        this.appealManager = new AppealManager(this);
        int pluginId = 25174;
        Metrics metrics = new Metrics(this, pluginId);
        this.getLogger().info("bStats metrics enabled!");
        if (this.getConfig().getBoolean("check-for-updates", true)) {
            this.getServer().getPluginManager().registerEvents((Listener)new UpdateListener(this, this.updateChecker), (Plugin)this);
        }
        this.configManager = new ConfigManager(this);
        this.configManager.setupDefaultPunishmentOptions();
        this.configManager.setupDefaultAutoSaveConfigs();
        this.getConfigManager().initializeWebhookSettings();
        this.chatInputHandler = new ChatInputHandler(this);
        WebhookManager.initialize(this, this.getConfigManager());
        SuspiciousManager.initialize(this);
        StatsManager.initialize(this, this.configManager);
        this.staffAlertManager = new StaffAlertManager(this, this.configManager);
        this.decoyManager = new DecoyManager(this, this.configManager);
        this.punishmentManager = new PunishmentManager(this.configManager, this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this.punishmentManager, this), (Plugin)this);
        StaffMenuGUI.setPlugin(this);
        StaffMenuGUI mainMenuGUI = new StaffMenuGUI();
        this.paranoiaHandler = new ParanoiaHandler(this, this.punishmentManager, this.configManager);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this.configManager, this.staffAlertManager, this.decoyManager, this.punishmentManager, this.paranoiaHandler), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerStatsGuiListener(), (Plugin)this);
        this.initializeMLSystem();
        if (this.configManager.isCommandHidingEnabled()) {
            CommandHider commandHider = new CommandHider(this);
            this.getServer().getPluginManager().registerEvents((Listener)commandHider, (Plugin)this);
            this.getCommand("deepguard").setExecutor((CommandExecutor)commandHider);
            this.getCommand("deepguard").setTabCompleter((TabCompleter)commandHider);
            if (this.getCommand("dgx") != null) {
                this.getCommand("dgx").setExecutor((CommandExecutor)commandHider);
                this.getCommand("dgx").setTabCompleter((TabCompleter)commandHider);
            }
            if (this.getCommand("deepguardx") != null) {
                this.getCommand("deepguardx").setExecutor((CommandExecutor)commandHider);
                this.getCommand("deepguardx").setTabCompleter((TabCompleter)commandHider);
            }
            this.getLogger().info("Command hiding feature enabled - commands will be hidden from players without permission");
        } else {
            this.getCommand("deepguard").setExecutor((CommandExecutor)new AntiXrayCommand(this, this.updateChecker));
        }
        StatsManager.updateAutoSaveSettings();
        SuspiciousManager.updateAutoSaveSettings();
        this.punishmentManager.updateAutoSaveSettings();
        this.ensureCompleteConfig();
        this.getLogger().info("DeepGuard-XRay Plugin enabled with config settings!");
        if (updatePending) {
            this.getLogger().info("=================================================");
            this.getLogger().info(" DeepGuard-XRay will be automatically updated when the server shuts down!");
            this.getLogger().info("=================================================");
        }
    }

    private void initializeMLSystem() {
        MLDataManager.initialize(this);
        MLConfig mlConfig = new MLConfig(this);
        this.mlManager = new MLManager(this, this.configManager);
        if (mlConfig.isEnabled()) {
            this.getLogger().info("ML detection system enabled!");
            if (this.mlManager.isTrained()) {
                this.getLogger().info("ML model successfully loaded with pre-trained data!");
            } else {
                this.getLogger().warning("ML model is not trained. Use '/deepguardx ml train <player> <cheater|normal>' to collect training data.");
            }
            if (this.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
                try {
                    this.protocolHandler = new ProtocolHandler(this, this.mlManager.getDataCollector(), this.configManager);
                    this.getLogger().info("ProtocolLib detected, advanced detection features enabled!");
                }
                catch (Exception e) {
                    this.getLogger().severe("Failed to initialize ProtocolLib integration: " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                this.getLogger().warning("ProtocolLib not found! Advanced protocol-based detection features will be disabled.");
            }
        } else {
            this.getLogger().info("ML detection system is disabled. Use '/deepguardx ml enable' to enable it.");
        }
    }

    public void saveConfig() {
        super.saveConfig();
        try {
            File configFile = new File(this.getDataFolder(), "config.yml");
            if (this.getConfigManager().isDebugEnabled()) {
                this.getLogger().info("Forcefully saving config to " + configFile.getAbsolutePath());
            }
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                this.saveResource("config.yml", false);
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Error ensuring config file exists: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void onDisable() {
        StatsManager.saveAllData();
        SuspiciousManager.saveAllData();
        if (this.protocolHandler != null) {
            this.protocolHandler.shutdown();
        }
        if (this.punishmentManager != null) {
            this.punishmentManager.onDisable();
        }
        if (this.updateApplier != null && this.updateApplier.isUpdatePending()) {
            this.getLogger().info("Applying DeepGuard-XRay update during shutdown...");
            this.updateApplier.applyUpdateOnShutdown();
        }
        if (this.paranoiaHandler != null) {
            this.paranoiaHandler.cleanup();
        }
    }

    private void ensureCompleteConfig() {
        boolean configUpdated = false;
        configUpdated |= this.ensureConfigPath("command-hiding.enabled", false);
        configUpdated |= this.ensureConfigPath("command-hiding.messages.error-line1", "\u00a7cUnknown or incomplete command, see below for error");
        if (configUpdated |= this.ensureConfigPath("command-hiding.messages.error-line2", "\u00a7c\u00a7n{command}\u00a7r\u00a7c\u00a7o<--[HERE]")) {
            this.saveConfig();
            this.getLogger().info("Added missing configuration options to config.yml");
        }
    }

    private boolean ensureConfigPath(String path, Object defaultValue) {
        if (!this.getConfig().isSet(path)) {
            this.getConfig().set(path, defaultValue);
            return true;
        }
        return false;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public MLManager getMLManager() {
        return this.mlManager;
    }

    public ChatInputHandler getChatInputHandler() {
        return this.chatInputHandler;
    }

    public WebhookManager getWebhookManager() {
        return WebhookManager.getInstance();
    }

    public AppealManager getAppealManager() {
        return this.appealManager;
    }

    public static deepGuardXray getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public StaffAlertManager getStaffAlertManager() {
        return this.staffAlertManager;
    }

    public void setStaffAlertManager(StaffAlertManager staffAlertManager) {
        this.staffAlertManager = staffAlertManager;
    }

    public DecoyManager getDecoyManager() {
        return this.decoyManager;
    }

    public void setDecoyManager(DecoyManager decoyManager) {
        this.decoyManager = decoyManager;
    }

    public PunishmentManager getPunishmentManager() {
        return this.punishmentManager;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public UpdateApplier getUpdateApplier() {
        return this.updateApplier;
    }

    public boolean isAutoUpdateEnabled() {
        return this.getConfig().getBoolean("auto-updates.enabled", true);
    }
}

