/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.myplugin.deepGuardXray.deepGuardXray;

public class StaffMenuGUI {
    private final Inventory inv = Bukkit.createInventory(null, (int)54, (Component)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2727 ").color((TextColor)NamedTextColor.AQUA)).append(((TextComponent)Component.text((String)"DeepGuard").color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.BOLD))).append(Component.text((String)"-").color((TextColor)NamedTextColor.DARK_GRAY))).append(((TextComponent)Component.text((String)"XRay").color((TextColor)NamedTextColor.RED)).decorate(TextDecoration.BOLD))).append(Component.text((String)" Control Panel").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)" \u2727").color((TextColor)NamedTextColor.AQUA)));
    private static deepGuardXray plugin;

    public StaffMenuGUI() {
        this.initializeItems();
    }

    public static void setPlugin(deepGuardXray deepGuardXray2) {
        plugin = deepGuardXray2;
    }

    private void initializeItems() {
        this.createBorder();
        this.addSectionTitles();
        this.addMainButtons();
        this.addAppealsButton();
        this.addDecorativeElements();
        this.addPluginInfo();
    }

    private void createBorder() {
        int i;
        ItemStack topBorder = this.createGuiItem(Material.BLUE_STAINED_GLASS_PANE, Component.text((String)" ").color((TextColor)NamedTextColor.DARK_GRAY), false, new Component[0]);
        ItemStack bottomBorder = this.createGuiItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, Component.text((String)" ").color((TextColor)NamedTextColor.DARK_GRAY), false, new Component[0]);
        ItemStack sideBorder = this.createGuiItem(Material.CYAN_STAINED_GLASS_PANE, Component.text((String)" ").color((TextColor)NamedTextColor.DARK_GRAY), false, new Component[0]);
        ItemStack cornerBorder = this.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, Component.text((String)"DeepGuard-XRay").color((TextColor)NamedTextColor.LIGHT_PURPLE), true, new Component[0]);
        for (i = 0; i < 9; ++i) {
            this.inv.setItem(i, topBorder);
        }
        for (i = 45; i < 54; ++i) {
            this.inv.setItem(i, bottomBorder);
        }
        for (i = 1; i <= 4; ++i) {
            this.inv.setItem(i * 9, sideBorder);
            this.inv.setItem(i * 9 + 8, sideBorder);
        }
        this.inv.setItem(0, cornerBorder);
        this.inv.setItem(8, cornerBorder);
        this.inv.setItem(45, cornerBorder);
        this.inv.setItem(53, cornerBorder);
    }

    private void addSectionTitles() {
        this.inv.setItem(2, this.createGuiItem(Material.OBSERVER, ((TextComponent)Component.text((String)"\u2726 Analysis & Monitoring \u2726").color((TextColor)NamedTextColor.AQUA)).decorate(TextDecoration.BOLD), true, new Component[0]));
        this.inv.setItem(6, this.createGuiItem(Material.LODESTONE, ((TextComponent)Component.text((String)"\u2726 Management & Configuration \u2726").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD), true, new Component[0]));
    }

    private void addMainButtons() {
        this.inv.setItem(10, this.createEnhancedItem(Material.PLAYER_HEAD, ((TextComponent)Component.text((String)"\ud83d\udcca Player Analytics").color((TextColor)NamedTextColor.GREEN)).decorate(TextDecoration.BOLD), true, Arrays.asList(Component.text((String)"Detailed mining statistics and player data").color((TextColor)NamedTextColor.GRAY), Component.text((String)"\u2022 View ore mining trends").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Track player mining history").color((TextColor)NamedTextColor.WHITE), Component.empty(), Component.text((String)"\u00bb Click to access analytics dashboard").color((TextColor)NamedTextColor.GREEN)), "MHF_Question"));
        this.inv.setItem(19, this.createGuiItem(Material.SPYGLASS, ((TextComponent)Component.text((String)"\ud83d\udd0d Suspicious Activity").color((TextColor)NamedTextColor.RED)).decorate(TextDecoration.BOLD), true, new Component[]{Component.text((String)"Monitor potentially suspicious players").color((TextColor)NamedTextColor.GRAY), Component.text((String)"\u2022 Recent flagged behaviors").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Abnormal mining patterns").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 X-Ray probability assessment").color((TextColor)NamedTextColor.WHITE), Component.empty(), Component.text((String)"\u00bb Click to investigate").color((TextColor)NamedTextColor.RED)}));
        this.inv.setItem(28, this.createGuiItem(Material.DRAGON_HEAD, ((TextComponent)Component.text((String)"\ud83e\udd16 ML Analysis").color((TextColor)NamedTextColor.DARK_PURPLE)).decorate(TextDecoration.BOLD), true, new Component[]{Component.text((String)"Advanced reasoning-based detection").color((TextColor)NamedTextColor.GRAY), Component.text((String)"\u2022 Mining style recognition").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Gets smarter over time [With More training data]").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Ore discovery pattern detection").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Step-by-step reasoning engine").color((TextColor)NamedTextColor.WHITE), Component.empty(), Component.text((String)"\u00bb Click to access ML tools").color((TextColor)NamedTextColor.DARK_PURPLE)}));
        this.inv.setItem(14, this.createGuiItem(Material.WRITABLE_BOOK, ((TextComponent)Component.text((String)"\u2696 Punishment System").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD), true, new Component[]{Component.text((String)"Configure automated enforcement").color((TextColor)NamedTextColor.GRAY), Component.text((String)"\u2022 Manage punishment tiers").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Configure response actions").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Set escalation thresholds").color((TextColor)NamedTextColor.WHITE), Component.empty(), Component.text((String)"\u00bb Click to manage").color((TextColor)NamedTextColor.GOLD)}));
        this.inv.setItem(23, this.createGuiItem(Material.END_CRYSTAL, ((TextComponent)Component.text((String)"\ud83d\udd14 Discord Webhook").color((TextColor)NamedTextColor.LIGHT_PURPLE)).decorate(TextDecoration.BOLD), true, new Component[]{Component.text((String)"Real-time Discord notifications").color((TextColor)NamedTextColor.GRAY), Component.text((String)"\u2022 Customize alert channels").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Configure notification types").color((TextColor)NamedTextColor.WHITE), Component.empty(), Component.text((String)"\u00bb Click to configure").color((TextColor)NamedTextColor.LIGHT_PURPLE)}));
        this.inv.setItem(32, this.createGuiItem(Material.DIAMOND_PICKAXE, ((TextComponent)Component.text((String)"\u26cf Ore Management").color((TextColor)NamedTextColor.AQUA)).decorate(TextDecoration.BOLD), true, new Component[]{Component.text((String)"Configure ore tracking system").color((TextColor)NamedTextColor.GRAY), Component.text((String)"\u2022 Set tracked ore types").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Configure detection thresholds").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Manage decoy ore placement").color((TextColor)NamedTextColor.WHITE), Component.empty(), Component.text((String)"\u00bb Click to configure").color((TextColor)NamedTextColor.AQUA)}));
        this.inv.setItem(25, this.createGuiItem(Material.COMMAND_BLOCK, ((TextComponent)Component.text((String)"\u2699 Plugin Configuration").color((TextColor)NamedTextColor.LIGHT_PURPLE)).decorate(TextDecoration.BOLD), true, new Component[]{Component.text((String)"Advanced plugin settings").color((TextColor)NamedTextColor.GRAY), Component.text((String)"\u2022 Core functionality options").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2022 Staff permission controls").color((TextColor)NamedTextColor.WHITE), Component.empty(), Component.text((String)"\u00bb Click to configure").color((TextColor)NamedTextColor.LIGHT_PURPLE)}));
    }

    private void addAppealsButton() {
        int pendingCount = 0;
        if (plugin != null && plugin.getAppealManager() != null) {
            pendingCount = plugin.getAppealManager().getPendingAppeals().size();
        }
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.text((String)"Manage player punishment appeals").color((TextColor)NamedTextColor.GRAY));
        lore.add(Component.empty());
        if (pendingCount > 0) {
            lore.add(((TextComponent)((TextComponent)Component.text((String)"\u2022 ").color((TextColor)NamedTextColor.WHITE)).append(Component.text((String)(pendingCount + " pending ")).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)(pendingCount == 1 ? "appeal" : "appeals")).color((TextColor)NamedTextColor.WHITE)));
        } else {
            lore.add(Component.text((String)"\u2022 No pending appeals").color((TextColor)NamedTextColor.WHITE));
        }
        lore.add(Component.text((String)"\u2022 Review player submissions").color((TextColor)NamedTextColor.WHITE));
        lore.add(Component.text((String)"\u2022 Approve or deny appeals").color((TextColor)NamedTextColor.WHITE));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to manage appeals").color((TextColor)NamedTextColor.GOLD));
        Material material = pendingCount > 0 ? Material.FILLED_MAP : Material.MAP;
        ItemStack appealsItem = this.createGuiItem(material, ((TextComponent)Component.text((String)"\ud83d\udccb Player Appeals").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD), pendingCount > 0, lore.toArray(new Component[0]));
        this.inv.setItem(34, appealsItem);
    }

    private void addDecorativeElements() {
        ItemStack centerIcon = this.createGuiItem(Material.NETHER_STAR, ((TextComponent)Component.text((String)"DeepGuard-XRay").color((TextColor)NamedTextColor.AQUA)).decorate(TextDecoration.BOLD), true, Component.text((String)"Advanced X-Ray Protection").color((TextColor)NamedTextColor.YELLOW), Component.text((String)"Powerful anti-cheat system").color((TextColor)NamedTextColor.YELLOW));
        this.inv.setItem(4, centerIcon);
        ItemStack redstone = this.createGuiItem(Material.REDSTONE, Component.text((String)"Active Protection").color((TextColor)NamedTextColor.RED), false, new Component[0]);
        ItemStack compass = this.createGuiItem(Material.COMPASS, Component.text((String)"Player Monitoring").color((TextColor)NamedTextColor.BLUE), false, new Component[0]);
        ItemStack barrier = this.createGuiItem(Material.BARRIER, Component.text((String)"Cheat Prevention").color((TextColor)NamedTextColor.DARK_RED), false, new Component[0]);
        this.inv.setItem(37, redstone);
        this.inv.setItem(43, compass);
        this.inv.setItem(40, barrier);
    }

    private void addPluginInfo() {
        String version = "v" + (plugin != null ? plugin.getDescription().getVersion() : "1.0.0");
        ItemStack versionItem = this.createGuiItem(Material.BOOK, ((TextComponent)Component.text((String)"Plugin Information").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD), false, new Component[]{Component.text((String)("DeepGuard-XRay " + version)).color((TextColor)NamedTextColor.YELLOW), Component.text((String)"Developed by Jasemi").color((TextColor)NamedTextColor.AQUA), Component.empty(), Component.text((String)"Active protection systems:").color((TextColor)NamedTextColor.GREEN), Component.text((String)"\u2713 Mining pattern analysis").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2713 ML-based detection").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2713 Decoy ore system").color((TextColor)NamedTextColor.WHITE), Component.text((String)"\u2713 Player appeals system").color((TextColor)NamedTextColor.WHITE)});
        this.inv.setItem(49, versionItem);
    }

    private ItemStack createGuiItem(Material material, Component name, boolean enchanted, Component ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(name);
        if (lore.length > 0) {
            ArrayList<Component> loreList = new ArrayList<Component>();
            for (Component line : lore) {
                loreList.add(line);
            }
            meta.lore(loreList);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createEnhancedItem(Material material, Component name, boolean enchanted, List<Component> lore, String skullOwner) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (material == Material.PLAYER_HEAD && skullOwner != null && meta instanceof SkullMeta) {
            ((SkullMeta)meta).setOwningPlayer(Bukkit.getOfflinePlayer((String)skullOwner));
        }
        meta.displayName(name);
        if (lore != null && !lore.isEmpty()) {
            meta.lore(lore);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
        player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 0.7f, 1.2f);
    }
}

