/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.gui.subgui.AppealDetailsGUI;
import org.myplugin.deepGuardXray.managers.AppealManager;

public class AppealGUI {
    private final Inventory inv;
    private final deepGuardXray plugin;
    private final AppealManager appealManager;
    private final Map<Integer, AppealManager.Appeal> appealSlots = new HashMap<Integer, AppealManager.Appeal>();
    private final int page;
    private final int maxPage;
    private static final int PAGE_SIZE = 36;
    private static final int ITEMS_PER_ROW = 9;

    public AppealGUI(deepGuardXray plugin, AppealManager appealManager, int page) {
        this.plugin = plugin;
        this.appealManager = appealManager;
        this.page = Math.max(0, page);
        List<AppealManager.Appeal> pendingAppeals = appealManager.getPendingAppeals();
        this.maxPage = (int)Math.ceil((double)pendingAppeals.size() / 36.0);
        this.inv = Bukkit.createInventory(null, (int)54, (Component)((TextComponent)Component.text((String)"\ud83d\udccb DeepGuardX Appeal System").color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.BOLD, true));
        this.initializeItems(pendingAppeals);
    }

    private void initializeItems(List<AppealManager.Appeal> appeals) {
        appeals.sort(Comparator.comparing(AppealManager.Appeal::getTimestamp).reversed());
        int startIndex = this.page * 36;
        int endIndex = Math.min(startIndex + 36, appeals.size());
        for (int i = startIndex; i < endIndex; ++i) {
            AppealManager.Appeal appeal = appeals.get(i);
            int slot = (i - startIndex) % 36;
            ItemStack item = this.createAppealItem(appeal);
            this.inv.setItem(slot, item);
            this.appealSlots.put(slot, appeal);
        }
        if (this.maxPage > 1) {
            if (this.page > 0) {
                ItemStack prevItem = this.createGuiItem(Material.ARROW, Component.text((String)"\u25c0 Previous Page").color((TextColor)NamedTextColor.YELLOW), false, Component.text((String)("Go to page " + this.page)).color((TextColor)NamedTextColor.GRAY));
                this.inv.setItem(45, prevItem);
            }
            if (this.page < this.maxPage - 1) {
                ItemStack nextItem = this.createGuiItem(Material.ARROW, Component.text((String)"Next Page \u25b6").color((TextColor)NamedTextColor.YELLOW), false, Component.text((String)("Go to page " + (this.page + 2))).color((TextColor)NamedTextColor.GRAY));
                this.inv.setItem(53, nextItem);
            }
            ItemStack pageItem = this.createGuiItem(Material.PAPER, Component.text((String)("Page " + (this.page + 1) + "/" + this.maxPage)).color((TextColor)NamedTextColor.GOLD), false, new Component[0]);
            this.inv.setItem(49, pageItem);
        }
        ItemStack backItem = this.createGuiItem(Material.BARRIER, Component.text((String)"\u21a9 Back to Staff Menu").color((TextColor)NamedTextColor.RED), false, new Component[0]);
        this.inv.setItem(this.maxPage > 1 ? 48 : 49, backItem);
        ItemStack countItem = this.createGuiItem(Material.BOOK, Component.text((String)(appeals.size() + " Pending Appeals")).color((TextColor)NamedTextColor.AQUA), false, new Component[0]);
        this.inv.setItem(this.maxPage > 1 ? 50 : 51, countItem);
    }

    private ItemStack createAppealItem(AppealManager.Appeal appeal) {
        switch (appeal.getPunishmentLevel()) {
            case 1: {
                Material material = Material.YELLOW_WOOL;
                break;
            }
            case 2: {
                Material material = Material.ORANGE_WOOL;
                break;
            }
            case 3: {
                Material material = Material.RED_WOOL;
                break;
            }
            case 4: {
                Material material = Material.PURPLE_WOOL;
                break;
            }
            case 5: {
                Material material = Material.MAGENTA_WOOL;
                break;
            }
            case 6: {
                Material material = Material.BLACK_WOOL;
                break;
            }
            default: {
                Material material = Material.WHITE_WOOL;
            }
        }
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        Player player = Bukkit.getPlayer((UUID)appeal.getPlayerId());
        if (player != null) {
            meta.setOwningPlayer((OfflinePlayer)player);
        } else {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)appeal.getPlayerId()));
        }
        meta.displayName(((TextComponent)Component.text((String)("Appeal #" + appeal.getId() + ": ")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)appeal.getPlayerName()).color((TextColor)NamedTextColor.YELLOW)));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.text((String)("Level " + appeal.getPunishmentLevel() + " Punishment")).color((TextColor)NamedTextColor.RED));
        lore.add(Component.text((String)("Submitted: " + appeal.getFormattedTimestamp())).color((TextColor)NamedTextColor.GRAY));
        lore.add(Component.empty());
        String reasonPreview = appeal.getReason().length() > 30 ? appeal.getReason().substring(0, 27) + "..." : appeal.getReason();
        lore.add(((TextComponent)Component.text((String)"Reason: ").color((TextColor)NamedTextColor.WHITE)).append(Component.text((String)reasonPreview).color((TextColor)NamedTextColor.YELLOW)));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to view details").color((TextColor)NamedTextColor.GREEN));
        meta.lore(lore);
        meta.addEnchant(Enchantment.DENSITY, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    private ItemStack createGuiItem(Material material, Component name, boolean enchanted, Component ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(name);
        if (lore.length > 0) {
            ArrayList loreList = new ArrayList();
            Collections.addAll(loreList, lore);
            meta.lore(loreList);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.DENSITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
        player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 0.5f, 1.2f);
    }

    public static boolean handleClick(Player player, int slot, Inventory inventory, deepGuardXray plugin, AppealManager appealManager) {
        AppealGUI gui = AppealGUI.getGuiFromInventory(inventory, plugin, appealManager);
        if (gui == null) {
            return false;
        }
        if (slot == 48 || slot == 49) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
            player.closeInventory();
            StaffMenuGUI staffMenu = new StaffMenuGUI();
            staffMenu.openInventory(player);
            return true;
        }
        if (slot == 45 && gui.page > 0) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
            new AppealGUI(plugin, appealManager, gui.page - 1).openInventory(player);
            return true;
        }
        if (slot == 53 && gui.page < gui.maxPage - 1) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
            new AppealGUI(plugin, appealManager, gui.page + 1).openInventory(player);
            return true;
        }
        if (gui.appealSlots.containsKey(slot)) {
            AppealManager.Appeal appeal = gui.appealSlots.get(slot);
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
            new AppealDetailsGUI(plugin, appealManager, appeal).openInventory(player);
            return true;
        }
        return false;
    }

    private static AppealGUI getGuiFromInventory(Inventory inventory, deepGuardXray plugin, AppealManager appealManager) {
        if (inventory.getViewers().isEmpty()) {
            return null;
        }
        Component title = ((HumanEntity)inventory.getViewers().get(0)).getOpenInventory().title();
        if (title == null) {
            return null;
        }
        String titleStr = title.toString();
        if (titleStr.contains("Appeal System")) {
            return new AppealGUI(plugin, appealManager, 0);
        }
        return null;
    }
}

