/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.subgui.MLAnalysisGUI;
import org.myplugin.deepGuardXray.ml.MLConfig;

public class AutoAnalysisGUI {
    public static final String PERMISSION = "deepguardx.gui_ml";
    private static final int INVENTORY_SIZE = 27;
    private static final int STATUS_SLOT = 4;
    private static final int TOGGLE_SLOT = 10;
    private static final int THRESHOLD_SLOT = 12;
    private static final int INCREASE_THRESHOLD_SLOT = 13;
    private static final int DECREASE_THRESHOLD_SLOT = 11;
    private static final int WAITING_LIST_SLOT = 16;
    private static final int BACK_SLOT = 22;
    private final deepGuardXray plugin;
    private final MLConfig mlConfig;

    public AutoAnalysisGUI(deepGuardXray plugin) {
        this.plugin = plugin;
        this.mlConfig = plugin.getMLManager().getMLConfig();
    }

    public void openInventory(Player player) {
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(Component.text((String)"You don't have permission to access the Auto Analysis GUI.").color((TextColor)NamedTextColor.RED));
            return;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)27, (Component)Component.text((String)"\u2699 Auto ML Analysis Settings").color((TextColor)NamedTextColor.DARK_AQUA));
        ItemStack filler = AutoAnalysisGUI.createItem(Material.BLACK_STAINED_GLASS_PANE, " ");
        for (int i = 0; i < 27; ++i) {
            inventory.setItem(i, filler);
        }
        boolean isEnabled = this.mlConfig.isAutoAnalysisEnabled();
        inventory.setItem(4, this.createStatusItem(isEnabled));
        inventory.setItem(10, this.createToggleItem(isEnabled));
        inventory.setItem(12, this.createThresholdItem(this.mlConfig.getSuspiciousThreshold()));
        inventory.setItem(13, AutoAnalysisGUI.createItem(Material.LIME_DYE, "\u00a7a\u25b2 Increase Threshold", List.of("\u00a77Click to increase the suspicious", "\u00a77count threshold by 1")));
        inventory.setItem(11, AutoAnalysisGUI.createItem(Material.RED_DYE, "\u00a7c\u25bc Decrease Threshold", List.of("\u00a77Click to decrease the suspicious", "\u00a77count threshold by 1")));
        inventory.setItem(16, this.createWaitingListItem());
        inventory.setItem(22, AutoAnalysisGUI.createItem(Material.ARROW, "\u00a7fBack to ML Analysis", List.of("\u00a77Return to the ML analysis menu")));
        player.openInventory(inventory);
    }

    private ItemStack createStatusItem(boolean isEnabled) {
        String name;
        Material material;
        ArrayList<String> lore = new ArrayList<String>();
        if (isEnabled) {
            material = Material.LIME_CONCRETE;
            name = "\u2705 Auto Analysis: ENABLED";
            lore.add("\u00a7aThe system will automatically analyze");
            lore.add("\u00a7aplayers when they reach the suspicious");
            lore.add("\u00a7acount threshold");
        } else {
            material = Material.RED_CONCRETE;
            name = "\u274c Auto Analysis: DISABLED";
            lore.add("\u00a7cAutomatic player analysis is currently");
            lore.add("\u00a7cdisabled. Enable it to automatically");
            lore.add("\u00a7canalyze suspicious players");
        }
        return AutoAnalysisGUI.createItem(material, name, lore);
    }

    private ItemStack createToggleItem(boolean isEnabled) {
        Material material = isEnabled ? Material.REDSTONE_BLOCK : Material.EMERALD_BLOCK;
        String name = isEnabled ? "\u00a7cDisable Auto Analysis" : "\u00a7aEnable Auto Analysis";
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(isEnabled ? "\u00a7eClick to disable automatic analysis" : "\u00a7eClick to enable automatic analysis");
        lore.add("\u00a77When enabled, players with suspicious");
        lore.add("\u00a77counts higher than the threshold will");
        lore.add("\u00a77be automatically analyzed");
        return AutoAnalysisGUI.createItem(material, name, lore);
    }

    private ItemStack createThresholdItem(int threshold) {
        return AutoAnalysisGUI.createItem(Material.HOPPER, "\u00a7bSuspicious Count Threshold: \u00a7f" + threshold, List.of("\u00a77Players need this many suspicious", "\u00a77counts to trigger automatic analysis", "\u00a77Current setting: \u00a7f" + threshold));
    }

    private ItemStack createWaitingListItem() {
        int queueSize = this.plugin.getMLManager().getAutoAnalysisQueueSize();
        int currentlyAnalyzing = this.plugin.getMLManager().getPlayersUnderAnalysis().size();
        int maxPlayers = this.mlConfig.getMaxAutoAnalysisPlayers();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Maximum players analyzed at once: \u00a7f" + maxPlayers);
        lore.add("\u00a77Currently analyzing: \u00a7f" + currentlyAnalyzing + "/" + maxPlayers);
        lore.add("\u00a77Players in waiting queue: \u00a7f" + queueSize);
        lore.add("");
        lore.add("\u00a77Players are analyzed in real-time when");
        lore.add("\u00a77their suspicious count exceeds the");
        lore.add("\u00a77threshold during mining activity");
        lore.add("");
        lore.add("\u00a77Players with higher suspicious counts");
        lore.add("\u00a77are prioritized in the queue");
        lore.add("");
        lore.add("\u00a77Players are only analyzed once");
        lore.add("\u00a77to avoid redundant processing");
        return AutoAnalysisGUI.createItem(Material.PAPER, "\u00a7eWaiting List Information", lore);
    }

    public static void handleClick(Player player, int slot, Inventory inventory, deepGuardXray plugin) {
        MLConfig mlConfig = plugin.getMLManager().getMLConfig();
        if (slot == 10) {
            boolean currentStatus = mlConfig.isAutoAnalysisEnabled();
            plugin.getMLManager().setAutoAnalysisEnabled(!currentStatus);
            player.playSound(player.getLocation(), currentStatus ? Sound.BLOCK_STONE_BUTTON_CLICK_OFF : Sound.BLOCK_STONE_BUTTON_CLICK_ON, 0.5f, 1.0f);
            player.sendMessage(Component.text((String)("Auto Analysis " + (!currentStatus ? "enabled" : "disabled"))).color((TextColor)(!currentStatus ? NamedTextColor.GREEN : NamedTextColor.RED)));
            new AutoAnalysisGUI(plugin).openInventory(player);
            return;
        }
        if (slot == 22) {
            new MLAnalysisGUI(plugin).openInventory(player);
            return;
        }
        if (slot == 13) {
            int currentThreshold = mlConfig.getSuspiciousThreshold();
            mlConfig.setSuspiciousThreshold(currentThreshold + 1);
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 1.5f);
            player.sendMessage(Component.text((String)("Suspicious count threshold increased to " + (currentThreshold + 1))).color((TextColor)NamedTextColor.GREEN));
            new AutoAnalysisGUI(plugin).openInventory(player);
            return;
        }
        if (slot == 11) {
            int currentThreshold = mlConfig.getSuspiciousThreshold();
            if (currentThreshold > 1) {
                mlConfig.setSuspiciousThreshold(currentThreshold - 1);
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 0.8f);
                player.sendMessage(Component.text((String)("Suspicious count threshold decreased to " + (currentThreshold - 1))).color((TextColor)NamedTextColor.YELLOW));
            } else {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
                player.sendMessage(Component.text((String)"Threshold cannot be lower than 1").color((TextColor)NamedTextColor.RED));
            }
            new AutoAnalysisGUI(plugin).openInventory(player);
            return;
        }
    }

    private static ItemStack createItem(Material material, String name) {
        return AutoAnalysisGUI.createItem(material, name, Collections.emptyList());
    }

    private static ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.text((String)name));
        if (!lore.isEmpty()) {
            List loreComponents = lore.stream().map(line -> {
                if (line.startsWith("\u00a7")) {
                    return Component.text((String)line);
                }
                return (TextComponent)Component.text((String)line).color((TextColor)NamedTextColor.GRAY);
            }).collect(Collectors.toList());
            meta.lore(loreComponents);
        }
        item.setItemMeta(meta);
        return item;
    }
}

