/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.subgui.ConfigSettingsGUI;
import org.myplugin.deepGuardXray.managers.StatsManager;
import org.myplugin.deepGuardXray.managers.SuspiciousManager;
import org.myplugin.deepGuardXray.utils.DirectConfigSaver;

public class AutoSaveSettingsGUI {
    private final Inventory inv;
    private final ConfigManager configManager;
    private final deepGuardXray plugin;
    private static final String TITLE = "\u2699 Auto-Save Settings";

    public AutoSaveSettingsGUI(ConfigManager configManager, deepGuardXray plugin) {
        this.configManager = configManager;
        this.plugin = plugin;
        this.inv = Bukkit.createInventory(null, (int)45, (Component)Component.text((String)TITLE).color((TextColor)NamedTextColor.AQUA));
        this.initializeItems();
    }

    private void initializeItems() {
        int row;
        ItemStack border = this.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, " ", false);
        ItemStack separator = this.createGuiItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, " ", false);
        for (int i = 0; i < 9; ++i) {
            this.inv.setItem(i, border);
            this.inv.setItem(36 + i, border);
        }
        for (row = 1; row < 4; ++row) {
            this.inv.setItem(row * 9, border);
            this.inv.setItem(row * 9 + 8, border);
        }
        for (row = 1; row < 4; ++row) {
            this.inv.setItem(row * 9 + 3, separator);
        }
        for (row = 1; row < 4; ++row) {
            this.inv.setItem(row * 9 + 6, separator);
        }
        this.inv.setItem(4, this.createGuiItem(Material.CLOCK, "Auto-Save Settings", true, TextDecoration.BOLD, NamedTextColor.YELLOW, Component.text((String)"Configure automatic data saving").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(11, this.createGuiItem(Material.EXPERIENCE_BOTTLE, "Stats Manager", true, TextDecoration.BOLD, NamedTextColor.GREEN, Component.text((String)"Mining statistics auto-save settings").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(14, this.createGuiItem(Material.ENDER_EYE, "Suspicious Manager", true, TextDecoration.BOLD, NamedTextColor.LIGHT_PURPLE, Component.text((String)"Suspicious player data auto-save settings").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(17, this.createGuiItem(Material.IRON_AXE, "Punishment Manager", true, TextDecoration.BOLD, NamedTextColor.RED, Component.text((String)"Punishment data auto-save settings").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(40, this.createGuiItem(Material.BARRIER, "Back to Plugin Configuration", false, null, NamedTextColor.RED, new Component[0]));
        this.addAutoSaveSettings();
    }

    private void addAutoSaveSettings() {
        this.inv.setItem(10, this.createToggleItem("Stats Auto-Save Enabled", this.configManager.isStatsAutoSaveEnabled(), "Enable/disable automatic saving of mining statistics", "stats.autoSave.enabled"));
        this.inv.setItem(19, this.createNumberItem("Stats Save Interval", this.configManager.getStatsAutoSaveInterval(), "Minutes between auto-saves for mining stats", "stats.autoSave.intervalMinutes"));
        this.inv.setItem(28, this.createToggleItem("Stats Save Logging", this.configManager.isStatsAutoSaveLoggingEnabled(), "Enable/disable logging of auto-save operations for stats", "stats.autoSave.logging"));
        this.inv.setItem(13, this.createToggleItem("Suspicious Auto-Save", this.configManager.isSuspiciousAutoSaveEnabled(), "Enable/disable automatic saving of suspicious player data", "suspicious.autoSave.enabled"));
        this.inv.setItem(22, this.createNumberItem("Suspicious Save Interval", this.configManager.getSuspiciousAutoSaveInterval(), "Minutes between auto-saves for suspicious data", "suspicious.autoSave.intervalMinutes"));
        this.inv.setItem(31, this.createToggleItem("Suspicious Save Logging", this.configManager.isSuspiciousAutoSaveLoggingEnabled(), "Enable/disable logging of auto-save operations for suspicious data", "suspicious.autoSave.logging"));
        this.inv.setItem(16, this.createToggleItem("Punishment Auto-Save", this.configManager.isPunishmentAutoSaveEnabled(), "Enable/disable automatic saving of punishment data", "punishment.autoSave.enabled"));
        this.inv.setItem(25, this.createNumberItem("Punishment Save Interval", this.configManager.getPunishmentAutoSaveInterval(), "Minutes between auto-saves for punishment data", "punishment.autoSave.intervalMinutes"));
        this.inv.setItem(34, this.createToggleItem("Punishment Save Logging", this.configManager.isPunishmentAutoSaveLoggingEnabled(), "Enable/disable logging of auto-save operations for punishment data", "punishment.autoSave.logging"));
    }

    private ItemStack createToggleItem(String name, boolean value, String description, String configPath) {
        Material material = value ? Material.LIME_CONCRETE : Material.RED_CONCRETE;
        Component status = value ? Component.text((String)"ENABLED").color((TextColor)NamedTextColor.GREEN) : Component.text((String)"DISABLED").color((TextColor)NamedTextColor.RED);
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)description).color((TextColor)NamedTextColor.GRAY));
        lore.add(status);
        lore.add(Component.text((String)"Click to toggle").color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)("Config path: " + configPath)).color((TextColor)NamedTextColor.DARK_GRAY));
        return this.createGuiItemWithLore(material, Component.text((String)name).color((TextColor)NamedTextColor.GOLD), value, lore);
    }

    private ItemStack createNumberItem(String name, Number value, String description, String configPath) {
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)description).color((TextColor)NamedTextColor.GRAY));
        lore.add(((TextComponent)Component.text((String)"Current value: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)value.toString()).color((TextColor)NamedTextColor.WHITE)));
        lore.add(Component.text((String)"Left-click to increase").color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)"Right-click to decrease").color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)("Config path: " + configPath)).color((TextColor)NamedTextColor.DARK_GRAY));
        return this.createGuiItemWithLore(Material.PAPER, Component.text((String)name).color((TextColor)NamedTextColor.GOLD), false, lore);
    }

    private ItemStack createGuiItem(Material material, String name, boolean enchanted, TextDecoration decoration, NamedTextColor color, Component ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        TextComponent displayName = Component.text((String)name);
        if (color != null) {
            displayName = displayName.color((TextColor)color);
        }
        if (decoration != null) {
            displayName = displayName.decorate(decoration);
        }
        meta.displayName((Component)displayName);
        if (lore.length > 0) {
            ArrayList<Component> itemLore = new ArrayList<Component>();
            for (Component loreLine : lore) {
                itemLore.add(loreLine);
            }
            meta.lore(itemLore);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.DENSITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createGuiItem(Material material, String name, boolean enchanted) {
        return this.createGuiItem(material, name, enchanted, null, null, new Component[0]);
    }

    private ItemStack createGuiItemWithLore(Material material, Component displayName, boolean enchanted, List<Component> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(displayName);
        if (lore != null && !lore.isEmpty()) {
            meta.lore(lore);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.DENSITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        if (!player.hasPermission("deepguardx.gui_config")) {
            player.sendMessage(Component.text((String)"You don't have permission to access the config settings.").color((TextColor)NamedTextColor.RED));
            return;
        }
        player.openInventory(this.inv);
    }

    public static void handleClick(Player player, int slot, Inventory inventory, ClickType clickType, ConfigManager configManager, deepGuardXray plugin) {
        boolean isHeader;
        if (!player.hasPermission("deepguardx.gui_config")) {
            player.sendMessage(Component.text((String)"You don't have permission to modify the config settings.").color((TextColor)NamedTextColor.RED));
            player.closeInventory();
            return;
        }
        if (slot == 40) {
            new ConfigSettingsGUI(configManager, plugin).openInventory(player);
            return;
        }
        boolean isBorder = slot < 9 || slot >= 36 || slot % 9 == 0 || slot % 9 == 8 || slot % 9 == 3 || slot % 9 == 6;
        boolean bl = isHeader = slot == 4 || slot == 11 || slot == 14 || slot == 17;
        if (isBorder || isHeader) {
            return;
        }
        ItemStack clicked = inventory.getItem(slot);
        if (clicked == null || !clicked.hasItemMeta() || !clicked.getItemMeta().hasLore()) {
            return;
        }
        List lore = clicked.getItemMeta().lore();
        if (lore == null || lore.isEmpty()) {
            return;
        }
        Component configPathComponent = (Component)lore.get(lore.size() - 1);
        String configPathLine = PlainTextComponentSerializer.plainText().serialize(configPathComponent);
        if (!configPathLine.contains("Config path:")) {
            return;
        }
        String configPath = configPathLine.substring(configPathLine.lastIndexOf("Config path:") + 12).trim();
        plugin.getLogger().info("Processing click for config path: " + configPath);
        if (clicked.getType() == Material.LIME_CONCRETE || clicked.getType() == Material.RED_CONCRETE) {
            boolean currentValue = clicked.getType() == Material.LIME_CONCRETE;
            boolean newValue = !currentValue;
            boolean success = DirectConfigSaver.saveBoolean(plugin, configPath, newValue);
            if (success) {
                plugin.reloadConfig();
                configManager.reloadConfig();
                if (configPath.startsWith("stats.autoSave.")) {
                    StatsManager.updateAutoSaveSettings();
                } else if (configPath.startsWith("suspicious.autoSave.")) {
                    SuspiciousManager.updateAutoSaveSettings();
                } else if (configPath.startsWith("punishment.autoSave.")) {
                    plugin.getPunishmentManager().updateAutoSaveSettings();
                }
                player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Setting ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)configPath).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" changed to ").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)(newValue ? "ENABLED" : "DISABLED")).color((TextColor)(newValue ? NamedTextColor.GREEN : NamedTextColor.RED))));
                if (plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                    plugin.getWebhookManager().sendStaffActionLog(player.getName(), "Changed Configuration", configPath + " \u2192 " + (newValue ? "ENABLED" : "DISABLED"));
                }
                new AutoSaveSettingsGUI(configManager, plugin).openInventory(player);
            } else {
                player.sendMessage(Component.text((String)"Failed to save config change. Check console for details.").color((TextColor)NamedTextColor.RED));
            }
            return;
        }
        if (clicked.getType() == Material.PAPER) {
            boolean isRightClick;
            Component valueLine = (Component)lore.get(1);
            String valueStr = PlainTextComponentSerializer.plainText().serialize(valueLine);
            String extractedValue = valueStr.substring(valueStr.lastIndexOf(": ") + 2).trim();
            boolean isInteger = !extractedValue.contains(".");
            boolean isLeftClick = clickType == ClickType.LEFT || clickType == ClickType.SHIFT_LEFT;
            boolean bl2 = isRightClick = clickType == ClickType.RIGHT || clickType == ClickType.SHIFT_RIGHT;
            if (!isLeftClick && !isRightClick) {
                player.sendMessage(Component.text((String)"Please use left-click to increase or right-click to decrease the value.").color((TextColor)NamedTextColor.RED));
                return;
            }
            if (isInteger) {
                try {
                    int currentValue = Integer.parseInt(extractedValue);
                    int newValue = isLeftClick ? currentValue + 5 : Math.max(1, currentValue - 5);
                    boolean success = DirectConfigSaver.saveInteger(plugin, configPath, newValue);
                    if (success) {
                        plugin.reloadConfig();
                        configManager.reloadConfig();
                        if (configPath.startsWith("stats.autoSave.")) {
                            StatsManager.updateAutoSaveSettings();
                        } else if (configPath.startsWith("suspicious.autoSave.")) {
                            SuspiciousManager.updateAutoSaveSettings();
                        } else if (configPath.startsWith("punishment.autoSave.")) {
                            plugin.getPunishmentManager().updateAutoSaveSettings();
                        }
                        new AutoSaveSettingsGUI(configManager, plugin).openInventory(player);
                        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Setting ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)configPath).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" updated to ").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)String.valueOf(newValue)).color((TextColor)NamedTextColor.AQUA)));
                        if (plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                            plugin.getWebhookManager().sendStaffActionLog(player.getName(), "Changed Configuration", configPath + " \u2192 " + newValue);
                        }
                    } else {
                        player.sendMessage(Component.text((String)"Failed to save config change. Check console for details.").color((TextColor)NamedTextColor.RED));
                    }
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().severe("Error parsing integer value: " + extractedValue);
                    player.sendMessage(Component.text((String)"Error parsing number. Please report this to a developer.").color((TextColor)NamedTextColor.RED));
                }
            }
        }
    }
}

