/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.gui.subgui.AutoSaveSettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.DecoySettingsGUI;
import org.myplugin.deepGuardXray.gui.subgui.StaffSettingsGUI;

public class ConfigSettingsGUI {
    private final Inventory inv;
    private final ConfigManager configManager;
    private final deepGuardXray plugin;
    private static final String TITLE = "\u2699 Plugin Configuration";
    public static final String PERMISSION = "deepguardx.gui_config";

    public ConfigSettingsGUI(ConfigManager configManager, deepGuardXray plugin) {
        this.configManager = configManager;
        this.plugin = plugin;
        this.inv = Bukkit.createInventory(null, (int)27, (Component)Component.text((String)TITLE).color((TextColor)NamedTextColor.AQUA));
        this.initializeItems();
    }

    private void initializeItems() {
        ItemStack border = this.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, " ", false);
        for (int i = 0; i < 9; ++i) {
            this.inv.setItem(i, border);
            this.inv.setItem(18 + i, border);
        }
        this.inv.setItem(9, border);
        this.inv.setItem(17, border);
        this.inv.setItem(4, this.createGuiItem(Material.REDSTONE, "Plugin Configuration", true, TextDecoration.BOLD, NamedTextColor.RED, Component.text((String)"Select a category to configure").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(11, this.createGuiItem(Material.DIAMOND_PICKAXE, "Decoy Settings", true, TextDecoration.BOLD, NamedTextColor.AQUA, Component.text((String)"Configure decoy ore generation").color((TextColor)NamedTextColor.GRAY), Component.text((String)"Settings for detecting X-ray").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(13, this.createGuiItem(Material.CLOCK, "Auto-Save Settings", true, TextDecoration.BOLD, NamedTextColor.YELLOW, Component.text((String)"Configure automatic data saving").color((TextColor)NamedTextColor.GRAY), Component.text((String)"Manage data persistence").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(15, this.createGuiItem(Material.SHIELD, "Staff Settings", true, TextDecoration.BOLD, NamedTextColor.GREEN, Component.text((String)"Configure staff alerts and tools").color((TextColor)NamedTextColor.GRAY), Component.text((String)"Manage staff notifications").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(22, this.createGuiItem(Material.BARRIER, "Back to \u26cf Staff Control Panel", false, null, NamedTextColor.RED, new Component[0]));
    }

    private ItemStack createGuiItem(Material material, String name, boolean enchanted, TextDecoration decoration, NamedTextColor color, Component ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        TextComponent displayName = Component.text((String)name);
        if (color != null) {
            displayName = displayName.color((TextColor)color);
        }
        if (decoration != null) {
            displayName = displayName.decorate(decoration);
        }
        meta.displayName((Component)displayName);
        if (lore.length > 0) {
            ArrayList<Component> itemLore = new ArrayList<Component>();
            for (Component loreLine : lore) {
                itemLore.add(loreLine);
            }
            meta.lore(itemLore);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.DENSITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createGuiItem(Material material, String name, boolean enchanted) {
        return this.createGuiItem(material, name, enchanted, null, null, new Component[0]);
    }

    public void openInventory(Player player) {
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(Component.text((String)"You don't have permission to access the config settings.").color((TextColor)NamedTextColor.RED));
            return;
        }
        player.openInventory(this.inv);
    }

    public static void handleClick(Player player, int slot, Inventory inventory, ConfigManager configManager, deepGuardXray plugin) {
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(Component.text((String)"You don't have permission to modify the config settings.").color((TextColor)NamedTextColor.RED));
            player.closeInventory();
            return;
        }
        switch (slot) {
            case 11: {
                new DecoySettingsGUI(configManager, plugin).openInventory(player);
                break;
            }
            case 13: {
                new AutoSaveSettingsGUI(configManager, plugin).openInventory(player);
                break;
            }
            case 15: {
                new StaffSettingsGUI(configManager, plugin).openInventory(player);
                break;
            }
            case 22: {
                new StaffMenuGUI().openInventory(player);
            }
        }
    }
}

