/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.gui.subgui.AutoAnalysisGUI;
import org.myplugin.deepGuardXray.gui.subgui.MLReportsGUI;
import org.myplugin.deepGuardXray.gui.subgui.PlayerSelectorGUI;
import org.myplugin.deepGuardXray.ml.MLDataManager;
import org.myplugin.deepGuardXray.ml.MLManager;

public class MLAnalysisGUI {
    public static final String PERMISSION = "deepguardx.gui_ml";
    private static final int INVENTORY_SIZE = 54;
    public static final int MAX_PLAYERS = 5;
    private static final int STATUS_SLOT = 4;
    private static final int TOGGLE_SLOT = 13;
    private static final int ANALYZE_PLAYER_SLOT = 26;
    private static final int TRAINING_STATS_SLOT = 17;
    private static final int AUTO_ANALYSIS_SLOT = 8;
    private static final int NORMAL_TRAINING_ROW = 3;
    private static final int CHEATER_TRAINING_ROW = 4;
    private static final int ADD_NORMAL_PLAYER_SLOT = MLAnalysisGUI.getSlot(3, 8);
    private static final int ADD_CHEATER_PLAYER_SLOT = MLAnalysisGUI.getSlot(4, 8);
    private static final int MONITORING_ROW = 2;
    private static final int BACK_SLOT = 49;
    private static final int REPORTS_SLOT = 53;
    private final deepGuardXray plugin;
    private final MLManager mlManager;

    public MLAnalysisGUI(deepGuardXray plugin) {
        this.plugin = plugin;
        this.mlManager = plugin.getMLManager();
    }

    public void openInventory(Player player) {
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(Component.text((String)"You don't have permission to access the ML Analysis GUI.").color((TextColor)NamedTextColor.RED));
            return;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)"\ud83e\udd16 ML Analysis").color((TextColor)NamedTextColor.DARK_AQUA));
        ItemStack filler = MLAnalysisGUI.createItem(Material.BLACK_STAINED_GLASS_PANE, " ");
        for (int i = 0; i < 54; ++i) {
            inventory.setItem(i, filler);
        }
        boolean isEnabled = this.mlManager.isEnabled();
        boolean isTrained = this.mlManager.isTrained();
        inventory.setItem(4, this.createStatusItem(isEnabled, isTrained));
        inventory.setItem(13, this.createToggleItem(isEnabled));
        inventory.setItem(17, this.createTrainingStatsItem());
        inventory.setItem(53, this.createReportsItem());
        this.addActiveMonitoringItems(inventory);
        this.addTrainingItems(inventory);
        inventory.setItem(8, this.createAutoAnalysisItem(this.mlManager.getMLConfig().isAutoAnalysisEnabled()));
        inventory.setItem(26, this.createAnalyzePlayerItem());
        inventory.setItem(ADD_NORMAL_PLAYER_SLOT, this.createAddNormalPlayerItem());
        inventory.setItem(ADD_CHEATER_PLAYER_SLOT, this.createAddCheaterPlayerItem());
        inventory.setItem(49, MLAnalysisGUI.createItem(Material.ARROW, "Back to Main Menu", List.of("Return to the main staff menu")));
        player.openInventory(inventory);
    }

    private ItemStack createReportsItem() {
        return MLAnalysisGUI.createItem(Material.PAPER, "\u00a7b\ud83d\udccb ML Analysis Reports", List.of("\u00a7eView detailed reports of ML analysis", "\u00a7eand detection results"));
    }

    private ItemStack createAutoAnalysisItem(boolean isEnabled) {
        Material material = Material.REPEATER;
        String name = "\u00a7b\u2699 Auto Analysis Settings";
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a7eManage automatic ML analysis based");
        lore.add("\u00a7eon player suspicious counts");
        lore.add("");
        lore.add(isEnabled ? "\u00a7aCurrently: \u00a7aENABLED" : "\u00a7cCurrently: \u00a7cDISABLED");
        lore.add("\u00a77Click to configure settings");
        return MLAnalysisGUI.createItem(material, name, lore);
    }

    private ItemStack createStatusItem(boolean isEnabled, boolean isTrained) {
        String name;
        Material material;
        ArrayList<String> lore = new ArrayList<String>();
        if (isEnabled) {
            material = Material.LIME_CONCRETE;
            name = "\u2705 ML System: ENABLED";
        } else {
            material = Material.RED_CONCRETE;
            name = "\u274c ML System: DISABLED";
        }
        lore.add(isTrained ? "\u00a7aModel: TRAINED" : "\u00a7cModel: NOT TRAINED");
        if (!isTrained) {
            lore.add("");
            lore.add("\u00a7eYou need to collect training data");
            lore.add("\u00a7efrom normal players and cheaters.");
        }
        return MLAnalysisGUI.createItem(material, name, lore);
    }

    private ItemStack createToggleItem(boolean isEnabled) {
        Material material = isEnabled ? Material.REDSTONE_BLOCK : Material.EMERALD_BLOCK;
        String name = isEnabled ? "\u00a7cDisable ML System" : "\u00a7aEnable ML System";
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(isEnabled ? "\u00a7eClick to disable the ML system" : "\u00a7eClick to enable the ML system");
        return MLAnalysisGUI.createItem(material, name, lore);
    }

    private ItemStack createAnalyzePlayerItem() {
        return MLAnalysisGUI.createItem(Material.SPYGLASS, "\u00a7b\ud83d\udcca Select Player to Analyze", List.of("\u00a7eClick to select a player to analyze", "\u00a7efor potential X-ray usage"));
    }

    private ItemStack createAddNormalPlayerItem() {
        return MLAnalysisGUI.createItem(Material.EMERALD, "\u00a7a\ud83d\udcc8 Select Normal Player for Training", List.of("\u00a7eClick to select a player to use", "\u00a7efor training as a NORMAL player", "", "\u00a7c\u26a0 WARNING:", "\u00a7fOnly select players you are CERTAIN", "\u00a7fare legitimate. Bad training data", "\u00a7fwill reduce detection accuracy.", "", "\u00a7fRecommended: Use yourself or other", "\u00a7ftrusted staff members for training."));
    }

    private ItemStack createAddCheaterPlayerItem() {
        return MLAnalysisGUI.createItem(Material.REDSTONE, "\u00a7c\ud83d\udd0d Select Cheater for Training", List.of("\u00a7eClick to select a player to use", "\u00a7efor training as a CHEATER", "", "\u00a7c\u26a0 WARNING:", "\u00a7fOnly select players you have CONFIRMED", "\u00a7fare using X-ray. Never guess or assume.", "\u00a7fFalse data will harm the ML system.", "", "\u00a7fRecommended: Ask trusted staff members", "\u00a7for use X-ray yourself and mine diamonds", "\u00a7fto generate accurate training data."));
    }

    private ItemStack createTrainingStatsItem() {
        MLDataManager.MLTrainingData trainingData = MLDataManager.loadTrainingData();
        int normalCount = trainingData.getNormalFeatures().size();
        int cheaterCount = trainingData.getCheaterFeatures().size();
        int totalCount = normalCount + cheaterCount;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a7eCurrent Training Data:");
        lore.add("\u00a7f\u2022 \u00a7aTotal Samples: \u00a7f" + totalCount);
        lore.add("\u00a7f\u2022 \u00a7aNormal Players: \u00a7f" + normalCount);
        lore.add("\u00a7f\u2022 \u00a7cCheaters: \u00a7f" + cheaterCount);
        lore.add("");
        if (!trainingData.hasEnoughData()) {
            lore.add("\u00a7cNot enough training data!");
            lore.add("\u00a7cNeed at least 3 samples of each type.");
        } else {
            lore.add("\u00a7aSufficient training data available.");
            lore.add("\u00a7a(always keep the samples balance)");
        }
        return MLAnalysisGUI.createItem(Material.BOOK, "\u00a7dTraining Data Statistics", lore);
    }

    private void addActiveMonitoringItems(Inventory inventory) {
        inventory.setItem(MLAnalysisGUI.getSlot(2, 0), MLAnalysisGUI.createItem(Material.OBSERVER, "\u00a7bCurrently Monitoring", List.of("\u00a7ePlayers currently under analysis", "\u00a7eMax: 5 players")));
        ArrayList<UUID> monitoredPlayers = new ArrayList<UUID>(this.mlManager.getPlayersUnderAnalysis());
        for (int i = 0; i < 7; ++i) {
            int slot = MLAnalysisGUI.getSlot(2, i + 1);
            if (i < monitoredPlayers.size()) {
                UUID playerId = (UUID)monitoredPlayers.get(i);
                Player player = Bukkit.getPlayer((UUID)playerId);
                if (player != null) {
                    double score;
                    ItemStack head = new ItemStack(Material.PLAYER_HEAD);
                    SkullMeta meta = (SkullMeta)head.getItemMeta();
                    meta.setOwningPlayer((OfflinePlayer)player);
                    meta.displayName(Component.text((String)player.getName()).color((TextColor)NamedTextColor.AQUA));
                    ArrayList<Component> lore = new ArrayList<Component>();
                    lore.add(Component.text((String)"Currently analyzing...").color((TextColor)NamedTextColor.YELLOW));
                    long remainingTime = this.getRemainingAnalysisTime(playerId);
                    if (remainingTime > 0L) {
                        lore.add(((TextComponent)Component.text((String)"Time remaining: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.formatTime(remainingTime)).color((TextColor)NamedTextColor.WHITE)));
                    }
                    if ((score = this.mlManager.getDetectionScore(playerId)) >= 0.0) {
                        NamedTextColor scoreColor = score > 0.7 ? NamedTextColor.RED : (score > 0.4 ? NamedTextColor.GOLD : NamedTextColor.GREEN);
                        lore.add(((TextComponent)Component.text((String)"Suspicion Score: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)String.format("%.1f%%", score * 100.0)).color((TextColor)scoreColor)));
                    }
                    meta.lore(lore);
                    head.setItemMeta((ItemMeta)meta);
                    inventory.setItem(slot, head);
                    continue;
                }
                inventory.setItem(slot, MLAnalysisGUI.createItem(Material.BARRIER, "\u00a7cOffline Player", List.of("\u00a77This player is no longer online")));
                continue;
            }
            if (i < 5) {
                inventory.setItem(slot, MLAnalysisGUI.createItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "\u00a77Empty Slot", List.of("\u00a77No player being monitored in this slot")));
                continue;
            }
            inventory.setItem(slot, MLAnalysisGUI.createItem(Material.RED_STAINED_GLASS_PANE, "\u00a7cLocked Slot", List.of("\u00a77Maximum number of players reached")));
        }
    }

    private void addTrainingItems(Inventory inventory) {
        long remainingTime;
        ArrayList<Component> lore;
        SkullMeta meta;
        ItemStack head;
        Player player;
        UUID playerId;
        int slot;
        int i;
        inventory.setItem(MLAnalysisGUI.getSlot(3, 0), MLAnalysisGUI.createItem(Material.IRON_PICKAXE, "\u00a7aNormal Player Training", List.of("\u00a7ePlayers providing normal data", "\u00a7eMax: 5 players")));
        inventory.setItem(MLAnalysisGUI.getSlot(4, 0), MLAnalysisGUI.createItem(Material.DIAMOND_PICKAXE, "\u00a7cCheater Training", List.of("\u00a7ePlayers providing cheater data", "\u00a7eMax: 5 players")));
        Map<UUID, Boolean> trainingPlayers = this.mlManager.getPlayersInTraining();
        List normalPlayers = trainingPlayers.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
        List cheaterPlayers = trainingPlayers.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        for (i = 0; i < 7; ++i) {
            slot = MLAnalysisGUI.getSlot(3, i + 1);
            if (i < normalPlayers.size()) {
                playerId = (UUID)normalPlayers.get(i);
                player = Bukkit.getPlayer((UUID)playerId);
                if (player == null) continue;
                head = new ItemStack(Material.PLAYER_HEAD);
                meta = (SkullMeta)head.getItemMeta();
                meta.setOwningPlayer((OfflinePlayer)player);
                meta.displayName(Component.text((String)player.getName()).color((TextColor)NamedTextColor.GREEN));
                lore = new ArrayList<Component>();
                lore.add(Component.text((String)"Training as normal player").color((TextColor)NamedTextColor.GREEN));
                remainingTime = this.getRemainingTrainingTime(playerId);
                if (remainingTime > 0L) {
                    lore.add(((TextComponent)Component.text((String)"Time remaining: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.formatTime(remainingTime)).color((TextColor)NamedTextColor.WHITE)));
                }
                lore.add(Component.text((String)"Click to cancel training").color((TextColor)NamedTextColor.GRAY));
                meta.lore(lore);
                head.setItemMeta((ItemMeta)meta);
                inventory.setItem(slot, head);
                continue;
            }
            if (i < 5) {
                inventory.setItem(slot, MLAnalysisGUI.createItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "\u00a77Empty Slot", List.of("\u00a77No normal player in training")));
                continue;
            }
            inventory.setItem(slot, MLAnalysisGUI.createItem(Material.RED_STAINED_GLASS_PANE, "\u00a7cLocked Slot", List.of("\u00a77Maximum number of players reached")));
        }
        for (i = 0; i < 7; ++i) {
            slot = MLAnalysisGUI.getSlot(4, i + 1);
            if (i < cheaterPlayers.size()) {
                playerId = (UUID)cheaterPlayers.get(i);
                player = Bukkit.getPlayer((UUID)playerId);
                if (player == null) continue;
                head = new ItemStack(Material.PLAYER_HEAD);
                meta = (SkullMeta)head.getItemMeta();
                meta.setOwningPlayer((OfflinePlayer)player);
                meta.displayName(Component.text((String)player.getName()).color((TextColor)NamedTextColor.RED));
                lore = new ArrayList();
                lore.add(Component.text((String)"Training as cheater").color((TextColor)NamedTextColor.RED));
                remainingTime = this.getRemainingTrainingTime(playerId);
                if (remainingTime > 0L) {
                    lore.add(((TextComponent)Component.text((String)"Time remaining: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.formatTime(remainingTime)).color((TextColor)NamedTextColor.WHITE)));
                }
                lore.add(Component.text((String)"Click to cancel training").color((TextColor)NamedTextColor.GRAY));
                meta.lore(lore);
                head.setItemMeta((ItemMeta)meta);
                inventory.setItem(slot, head);
                continue;
            }
            if (i < 5) {
                inventory.setItem(slot, MLAnalysisGUI.createItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "\u00a77Empty Slot", List.of("\u00a77No cheater in training")));
                continue;
            }
            inventory.setItem(slot, MLAnalysisGUI.createItem(Material.RED_STAINED_GLASS_PANE, "\u00a7cLocked Slot", List.of("\u00a77Maximum number of players reached")));
        }
    }

    public static void handleClick(Player player, int slot, Inventory inventory, deepGuardXray plugin) {
        Player target;
        SkullMeta meta;
        ItemStack clicked;
        MLManager mlManager = plugin.getMLManager();
        if (slot == 13) {
            boolean currentStatus = mlManager.isEnabled();
            mlManager.setEnabled(!currentStatus);
            player.playSound(player.getLocation(), currentStatus ? Sound.BLOCK_STONE_BUTTON_CLICK_OFF : Sound.BLOCK_STONE_BUTTON_CLICK_ON, 0.5f, 1.0f);
            player.sendMessage(Component.text((String)("ML System " + (!currentStatus ? "enabled" : "disabled"))).color((TextColor)(!currentStatus ? NamedTextColor.GREEN : NamedTextColor.RED)));
            new MLAnalysisGUI(plugin).openInventory(player);
            return;
        }
        if (slot == 49) {
            new StaffMenuGUI().openInventory(player);
            return;
        }
        if (slot == 8) {
            new AutoAnalysisGUI(plugin).openInventory(player);
            return;
        }
        if (slot == 26) {
            if (mlManager.getPlayersUnderAnalysis().size() >= 5) {
                player.sendMessage(Component.text((String)"Maximum number of players already being analyzed!").color((TextColor)NamedTextColor.RED));
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
                return;
            }
            new PlayerSelectorGUI(plugin, PlayerSelectorGUI.SelectionType.ANALYZE).openInventory(player);
            return;
        }
        if (slot == ADD_NORMAL_PLAYER_SLOT) {
            long currentCount = mlManager.getPlayersInTraining().entrySet().stream().filter(e -> (Boolean)e.getValue() == false).count();
            if (currentCount >= 5L) {
                player.sendMessage(Component.text((String)"Maximum number of normal players already in training!").color((TextColor)NamedTextColor.RED));
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
                return;
            }
            new PlayerSelectorGUI(plugin, PlayerSelectorGUI.SelectionType.TRAIN_NORMAL).openInventory(player);
            return;
        }
        if (slot == ADD_CHEATER_PLAYER_SLOT) {
            long currentCount = mlManager.getPlayersInTraining().entrySet().stream().filter(Map.Entry::getValue).count();
            if (currentCount >= 5L) {
                player.sendMessage(Component.text((String)"Maximum number of cheaters already in training!").color((TextColor)NamedTextColor.RED));
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
                return;
            }
            new PlayerSelectorGUI(plugin, PlayerSelectorGUI.SelectionType.TRAIN_CHEATER).openInventory(player);
            return;
        }
        if (slot == 53) {
            new MLReportsGUI(plugin, 0).openInventory(player);
            return;
        }
        if ((MLAnalysisGUI.isInRow(slot, 3) || MLAnalysisGUI.isInRow(slot, 4)) && slot % 9 != 0 && (clicked = inventory.getItem(slot)) != null && clicked.getType() == Material.PLAYER_HEAD && (meta = (SkullMeta)clicked.getItemMeta()).getOwningPlayer() != null && (target = Bukkit.getPlayer((UUID)meta.getOwningPlayer().getUniqueId())) != null) {
            mlManager.cancelTraining(target);
            player.sendMessage(Component.text((String)("Cancelled training for " + target.getName())).color((TextColor)NamedTextColor.YELLOW));
            new MLAnalysisGUI(plugin).openInventory(player);
        }
    }

    private static int getSlot(int row, int col) {
        return row * 9 + col;
    }

    private static boolean isInRow(int slot, int row) {
        return slot >= row * 9 && slot < (row + 1) * 9;
    }

    private static ItemStack createItem(Material material, String name) {
        return MLAnalysisGUI.createItem(material, name, Collections.emptyList());
    }

    private static ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.text((String)name));
        if (!lore.isEmpty()) {
            List loreComponents = lore.stream().map(line -> {
                if (line.startsWith("\u00a7")) {
                    return Component.text((String)line);
                }
                return (TextComponent)Component.text((String)line).color((TextColor)NamedTextColor.GRAY);
            }).collect(Collectors.toList());
            meta.lore(loreComponents);
        }
        item.setItemMeta(meta);
        return item;
    }

    private String formatTime(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        long minutes = seconds / 60L;
        long remainingSeconds = seconds % 60L;
        if (remainingSeconds == 0L) {
            return minutes + "m";
        }
        return minutes + "m " + remainingSeconds + "s";
    }

    private long getRemainingAnalysisTime(UUID playerId) {
        return this.mlManager.getRemainingAnalysisTime(playerId);
    }

    private long getRemainingTrainingTime(UUID playerId) {
        return this.mlManager.getRemainingTrainingTime(playerId);
    }
}

