/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.subgui.MLAnalysisGUI;
import org.myplugin.deepGuardXray.ml.MLDataManager;

public class MLReportsGUI {
    public static final String PERMISSION = "deepguardx.gui_ml";
    private static final int INVENTORY_SIZE = 54;
    private static final int REPORTS_PER_PAGE = 28;
    private static final int PREV_PAGE_SLOT = 45;
    private static final int NEXT_PAGE_SLOT = 53;
    private static final int BACK_SLOT = 49;
    private static final int PAGE_INDICATOR_SLOT = 47;
    private static final Map<Integer, String> REPORT_PATHS = new HashMap<Integer, String>();
    private final deepGuardXray plugin;
    private final int currentPage;
    private final String playerFilter;
    private static final SimpleDateFormat DISPLAY_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public MLReportsGUI(deepGuardXray plugin, int page) {
        this(plugin, page, null);
    }

    public MLReportsGUI(deepGuardXray plugin, int page, String playerFilter) {
        this.plugin = plugin;
        this.currentPage = Math.max(0, page);
        this.playerFilter = playerFilter;
    }

    public void openInventory(Player player) {
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(Component.text((String)"You don't have permission to access the ML Reports GUI.").color((TextColor)NamedTextColor.RED));
            return;
        }
        Object title = "\ud83d\udccb ML Analysis Reports";
        if (this.playerFilter != null) {
            title = "\ud83d\udccb ML Analysis Reports: " + this.playerFilter;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)title).color((TextColor)NamedTextColor.DARK_AQUA));
        this.addReportsFromManager(inventory);
        this.addNavigationBar(inventory);
        player.openInventory(inventory);
    }

    private void addNavigationBar(Inventory inventory) {
        List<String> reportPaths = MLDataManager.getPlayerReports(this.playerFilter);
        int totalReports = reportPaths.size();
        int totalPages = Math.max(1, (totalReports + 28 - 1) / 28);
        StringBuilder pagesIndicator = new StringBuilder();
        for (int i = 0; i < totalPages; ++i) {
            if (i == this.currentPage) {
                pagesIndicator.append("\u00a7a").append(i + 1);
            } else {
                pagesIndicator.append("\u00a77").append(i + 1);
            }
            if (i >= totalPages - 1) continue;
            pagesIndicator.append("\u00a77/");
        }
        inventory.setItem(47, MLReportsGUI.createItem(Material.PAPER, "\u00a7ePage " + (this.currentPage + 1) + " of " + totalPages, List.of("\u00a77Total Reports: " + totalReports, "\u00a77Pages: " + pagesIndicator.toString())));
        if (this.currentPage > 0) {
            inventory.setItem(45, MLReportsGUI.createItem(Material.ARROW, "\u00a7aPrevious Page", List.of("\u00a77Go to page " + this.currentPage)));
        } else {
            inventory.setItem(45, MLReportsGUI.createItem(Material.GRAY_DYE, "\u00a78Previous Page", List.of("\u00a77You are on the first page")));
        }
        if (this.currentPage < totalPages - 1) {
            inventory.setItem(53, MLReportsGUI.createItem(Material.ARROW, "\u00a7aNext Page", List.of("\u00a77Go to page " + (this.currentPage + 2))));
        } else {
            inventory.setItem(53, MLReportsGUI.createItem(Material.GRAY_DYE, "\u00a78Next Page", List.of("\u00a77You are on the last page")));
        }
        inventory.setItem(49, MLReportsGUI.createItem(Material.BARRIER, "\u00a7cBack to ML Analysis", List.of("\u00a77Return to the main ML Analysis menu")));
    }

    private void addReportsFromManager(Inventory inventory) {
        List<String> reportPaths = MLDataManager.getPlayerReports(this.playerFilter);
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, reportPaths.size());
        if (startIndex >= reportPaths.size()) {
            ItemStack noReports = MLReportsGUI.createItem(Material.BARRIER, "\u00a7cNo reports found", List.of("\u00a77There are no ML analysis reports to display."));
            inventory.setItem(22, noReports);
            return;
        }
        List<String> pageReports = reportPaths.subList(startIndex, endIndex);
        int slot = 0;
        for (String reportPath : pageReports) {
            try {
                ItemStack reportItem;
                Matcher matcher;
                Pattern pattern;
                File reportFile = new File(reportPath);
                String fileName = reportFile.getName();
                String reportContent = new String(Files.readAllBytes(Paths.get(reportPath, new String[0])));
                String playerName = "Unknown";
                Pattern nameJsonPattern = Pattern.compile("\"playerName\":\\s*\"([^\"]*)\"");
                Matcher nameJsonMatcher = nameJsonPattern.matcher(reportContent);
                if (nameJsonMatcher.find()) {
                    playerName = nameJsonMatcher.group(1);
                } else {
                    pattern = Pattern.compile("([^_]+)_([^_]+)_(\\d{4}-\\d{2}-\\d{2}_\\d{2}-\\d{2}-\\d{2})\\.json");
                    matcher = pattern.matcher(fileName);
                    if (matcher.find()) {
                        playerName = matcher.group(1);
                    }
                }
                pattern = Pattern.compile("([^_]+)_([^_]+)_(\\d{4}-\\d{2}-\\d{2}_\\d{2}-\\d{2}-\\d{2})\\.json");
                matcher = pattern.matcher(fileName);
                String suspicionLevel = "unknown";
                Date timestamp = new Date();
                if (matcher.find()) {
                    suspicionLevel = matcher.group(2);
                    SimpleDateFormat fileFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
                    try {
                        timestamp = fileFormat.parse(matcher.group(3));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                double suspicionScore = this.extractSuspicionScore(reportContent);
                String conclusion = this.extractConclusion(reportContent);
                Object shortConclusion = conclusion;
                if (conclusion.length() > 100) {
                    shortConclusion = conclusion.substring(0, 97) + "...";
                }
                Material material = suspicionScore >= 0.8 ? Material.RED_CONCRETE : (suspicionScore >= 0.6 ? Material.ORANGE_CONCRETE : (suspicionScore >= 0.4 ? Material.YELLOW_CONCRETE : Material.LIME_CONCRETE));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add("\u00a77Date: \u00a7f" + DISPLAY_DATE_FORMAT.format(timestamp));
                lore.add("\u00a77Suspicion Score: \u00a7" + this.getSuspicionColor(suspicionScore) + String.format("%.1f%%", suspicionScore * 100.0));
                lore.add("\u00a77Level: \u00a7" + this.getSuspicionColor(suspicionScore) + this.formatSuspicionLevel(suspicionLevel));
                lore.add("");
                lore.add("\u00a77Conclusion:");
                List<String> wrappedConclusion = this.wrapText((String)shortConclusion, 35);
                for (String line : wrappedConclusion) {
                    lore.add("\u00a78" + line);
                }
                lore.add("");
                lore.add("\u00a7eClick to view detailed report");
                int row = slot / 7;
                int col = slot % 7;
                int inventorySlot = row * 9 + col;
                try {
                    reportItem = this.createPlayerHead(playerName, "\u00a7" + this.getSuspicionColor(suspicionScore) + playerName, lore);
                }
                catch (Exception e) {
                    reportItem = MLReportsGUI.createItem(material, "\u00a7" + this.getSuspicionColor(suspicionScore) + playerName, lore);
                }
                REPORT_PATHS.put(inventorySlot, reportPath);
                inventory.setItem(inventorySlot, reportItem);
                ++slot;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error loading report from " + reportPath + ": " + e.getMessage());
            }
        }
    }

    private ItemStack createPlayerHead(String playerName, String displayName, List<String> lore) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.displayName((Component)Component.text((String)displayName));
        if (!lore.isEmpty()) {
            List loreComponents = lore.stream().map(line -> {
                if (line.startsWith("\u00a7")) {
                    return Component.text((String)line);
                }
                return (TextComponent)Component.text((String)line).color((TextColor)NamedTextColor.GRAY);
            }).collect(Collectors.toList());
            meta.lore(loreComponents);
        }
        meta.setOwner(playerName);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private double extractSuspicionScore(String reportContent) {
        try {
            Pattern pattern = Pattern.compile("\"suspicionScore\":\\s*([0-9.]+)");
            Matcher matcher = pattern.matcher(reportContent);
            if (matcher.find()) {
                return Double.parseDouble(matcher.group(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    private String extractConclusion(String reportContent) {
        try {
            Pattern pattern = Pattern.compile("\"conclusion\":\\s*\"([^\"]*)\"");
            Matcher matcher = pattern.matcher(reportContent);
            if (matcher.find()) {
                return matcher.group(1).replace("\\\"", "\"").replace("\\\\", "\\");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "No conclusion available";
    }

    private String formatSuspicionLevel(String level) {
        return switch (level) {
            case "high_risk" -> "High Risk";
            case "suspicious" -> "Suspicious";
            case "medium_risk" -> "Medium Risk";
            case "low_risk" -> "Low Risk";
            case "normal" -> "Normal";
            default -> level.replace("_", " ");
        };
    }

    private char getSuspicionColor(double score) {
        if (score >= 0.8) {
            return 'c';
        }
        if (score >= 0.6) {
            return '6';
        }
        if (score >= 0.4) {
            return 'e';
        }
        if (score >= 0.2) {
            return 'a';
        }
        return '7';
    }

    private List<String> wrapText(String text, int width) {
        String[] words;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words = text.split(" ")) {
            if (currentLine.length() + word.length() + 1 <= width) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            lines.add(currentLine.toString());
            currentLine = new StringBuilder(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public static void handleClick(Player player, int slot, Inventory inventory, deepGuardXray plugin) {
        if (slot == 49) {
            new MLAnalysisGUI(plugin).openInventory(player);
            return;
        }
        if (slot == 45) {
            ItemStack pageIndicator = inventory.getItem(47);
            if (pageIndicator != null && pageIndicator.hasItemMeta()) {
                String name = pageIndicator.getItemMeta().displayName().toString();
                try {
                    int currentPage = Integer.parseInt(name.split(" ")[1]) - 1;
                    String title = inventory.getType().getDefaultTitle();
                    String playerFilter = null;
                    if (title.contains(": ")) {
                        playerFilter = title.substring(title.indexOf(": ") + 2);
                    }
                    new MLReportsGUI(plugin, currentPage - 1, playerFilter).openInventory(player);
                }
                catch (Exception e) {
                    new MLReportsGUI(plugin, 0).openInventory(player);
                }
            }
            return;
        }
        if (slot == 53) {
            ItemStack pageIndicator = inventory.getItem(47);
            if (pageIndicator != null && pageIndicator.hasItemMeta()) {
                String name = pageIndicator.getItemMeta().displayName().toString();
                try {
                    int currentPage = Integer.parseInt(name.split(" ")[1]) - 1;
                    String title = inventory.getType().getDefaultTitle();
                    String playerFilter = null;
                    if (title.contains(": ")) {
                        playerFilter = title.split(": ")[1];
                    }
                    new MLReportsGUI(plugin, currentPage + 1, playerFilter).openInventory(player);
                }
                catch (Exception e) {
                    new MLReportsGUI(plugin, 0).openInventory(player);
                }
            }
            return;
        }
        if (slot == 46) {
            String title = inventory.getType().getDefaultTitle();
            if (title.contains(": ")) {
                new MLReportsGUI(plugin, 0).openInventory(player);
            } else {
                player.closeInventory();
                player.sendMessage(Component.text((String)"Please type the name of the player to filter reports for.").color((TextColor)NamedTextColor.YELLOW));
                player.sendMessage(Component.text((String)"Use: /dgx ml reports player <name>").color((TextColor)NamedTextColor.YELLOW));
            }
            return;
        }
        String reportPath = REPORT_PATHS.get(slot);
        if (reportPath != null) {
            MLReportsGUI.openDetailedReport(player, reportPath, plugin);
        }
    }

    private static void openDetailedReport(Player player, String reportPath, deepGuardXray plugin) {
        try {
            String reportContent = new String(Files.readAllBytes(Paths.get(reportPath, new String[0])));
            Pattern playerPattern = Pattern.compile("\"playerName\":\\s*\"([^\"]*)\"");
            Matcher playerMatcher = playerPattern.matcher(reportContent);
            String playerName = playerMatcher.find() ? playerMatcher.group(1) : "Unknown";
            double suspicionScore = MLReportsGUI.extractSuspicionScoreStatic(reportContent);
            player.sendMessage(Component.text((String)("---- ML Analysis Report for " + playerName + " ----")).color((TextColor)NamedTextColor.GOLD));
            player.sendMessage(Component.text((String)("Suspicion Score: " + String.format("%.1f%%", suspicionScore * 100.0))).color((TextColor)MLReportsGUI.getSuspicionColorComponent(suspicionScore)));
            String conclusion = MLReportsGUI.extractConclusionStatic(reportContent);
            player.sendMessage(((TextComponent)Component.text((String)"Conclusion: ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)conclusion).color((TextColor)NamedTextColor.WHITE)));
            List<String> reasoningSteps = MLReportsGUI.extractReasoningSteps(reportContent);
            player.sendMessage(Component.text((String)"Analysis Process:").color((TextColor)NamedTextColor.GOLD));
            int stepNumber = 1;
            for (String step : reasoningSteps) {
                player.sendMessage(((TextComponent)Component.text((String)(stepNumber + ". ")).color((TextColor)NamedTextColor.YELLOW)).append(Component.text((String)step).color((TextColor)NamedTextColor.GRAY)));
                ++stepNumber;
            }
            Map<String, Double> metrics = MLReportsGUI.extractKeyMetrics(reportContent);
            if (!metrics.isEmpty()) {
                player.sendMessage(Component.text((String)"Key Player Metrics:").color((TextColor)NamedTextColor.GOLD));
                for (Map.Entry<String, Double> entry : metrics.entrySet()) {
                    String key = entry.getKey();
                    Double value = entry.getValue();
                    String displayKey = key.replace("_", " ").replace("ore count", "ore blocks").replace("ore rate", "ore blocks/min");
                    String[] words = displayKey.split(" ");
                    StringBuilder formattedKey = new StringBuilder();
                    for (String word : words) {
                        if (word.length() <= 0) continue;
                        formattedKey.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
                    }
                    String formattedValue = key.contains("rate") || key.contains("per_") ? String.format("%.2f", value) : (value % 1.0 == 0.0 ? String.format("%.0f", value) : String.format("%.2f", value));
                    player.sendMessage(((TextComponent)Component.text((String)("  " + formattedKey.toString().trim() + ": ")).color((TextColor)NamedTextColor.YELLOW)).append(Component.text((String)formattedValue).color((TextColor)NamedTextColor.WHITE)));
                }
            }
            player.sendMessage(Component.text((String)"----------------------------------------").color((TextColor)NamedTextColor.GOLD));
        }
        catch (Exception e) {
            player.sendMessage(Component.text((String)("Error loading report: " + e.getMessage())).color((TextColor)NamedTextColor.RED));
            plugin.getLogger().warning("Error loading report from " + reportPath + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static double extractSuspicionScoreStatic(String reportContent) {
        try {
            Pattern pattern = Pattern.compile("\"suspicionScore\":\\s*([0-9.]+)");
            Matcher matcher = pattern.matcher(reportContent);
            if (matcher.find()) {
                return Double.parseDouble(matcher.group(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    private static String extractConclusionStatic(String reportContent) {
        try {
            Pattern pattern = Pattern.compile("\"conclusion\":\\s*\"([^\"]*)\"");
            Matcher matcher = pattern.matcher(reportContent);
            if (matcher.find()) {
                return matcher.group(1).replace("\\\"", "\"").replace("\\\\", "\\");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "No conclusion available";
    }

    private static List<String> extractReasoningSteps(String reportContent) {
        ArrayList<String> steps = new ArrayList<String>();
        try {
            String[] rawSteps;
            int stepsStart = reportContent.indexOf("\"reasoningSteps\"");
            if (stepsStart == -1) {
                return steps;
            }
            int arrayStart = reportContent.indexOf("[", stepsStart);
            int arrayEnd = reportContent.indexOf("]", arrayStart);
            if (arrayStart == -1 || arrayEnd == -1) {
                return steps;
            }
            String stepsArray = reportContent.substring(arrayStart + 1, arrayEnd);
            for (String step : rawSteps = stepsArray.split(",\\s*\"")) {
                if ((step = step.trim()).startsWith("\"")) {
                    step = step.substring(1);
                }
                if (step.endsWith("\"")) {
                    step = step.substring(0, step.length() - 1);
                }
                if ((step = step.replace("\\\"", "\"").replace("\\\\", "\\").replace("\\n", "\n")).isEmpty()) continue;
                steps.add(step);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return steps;
    }

    private static Map<String, Double> extractKeyMetrics(String reportContent) {
        LinkedHashMap<String, Double> metrics = new LinkedHashMap<String, Double>();
        try {
            String[] keyMetricPatterns;
            if (!reportContent.contains("\"playerData\"")) {
                return metrics;
            }
            for (String metricName : keyMetricPatterns = new String[]{"sessionDuration", "total_blocks_mined", "total_ores_mined", "ores_per_minute", "diamonds_per_hour", "ore_count_diamond", "ore_count_iron", "ore_count_gold", "ore_count_redstone", "ore_count_lapis", "ore_count_emerald", "ore_count_coal", "ore_rate_diamond", "ore_rate_iron", "ore_rate_gold", "head_direction_changes", "head_direction_change_rate"}) {
                Pattern pattern = Pattern.compile("\"" + metricName + "\":\\s*([0-9.]+)");
                Matcher matcher = pattern.matcher(reportContent);
                if (!matcher.find()) continue;
                metrics.put(metricName, Double.parseDouble(matcher.group(1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return metrics;
    }

    private static NamedTextColor getSuspicionColorComponent(double score) {
        if (score >= 0.8) {
            return NamedTextColor.RED;
        }
        if (score >= 0.6) {
            return NamedTextColor.GOLD;
        }
        if (score >= 0.4) {
            return NamedTextColor.YELLOW;
        }
        if (score >= 0.2) {
            return NamedTextColor.GREEN;
        }
        return NamedTextColor.GRAY;
    }

    private static ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.text((String)name));
        if (!lore.isEmpty()) {
            List loreComponents = lore.stream().map(line -> {
                if (line.startsWith("\u00a7")) {
                    return Component.text((String)line);
                }
                return (TextComponent)Component.text((String)line).color((TextColor)NamedTextColor.GRAY);
            }).collect(Collectors.toList());
            meta.lore(loreComponents);
        }
        item.setItemMeta(meta);
        return item;
    }
}

