/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.myplugin.deepGuardXray.config.ConfigManager;

public class OreConfigGUI {
    private final Inventory inv;
    private final ConfigManager configManager;
    private final Material[] availableOres = new Material[]{Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE, Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.REDSTONE_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE, Material.ANCIENT_DEBRIS};
    public static final String PERMISSION = "deepguardx.gui_oreconfig";

    public OreConfigGUI(ConfigManager configManager) {
        this.configManager = configManager;
        this.inv = Bukkit.createInventory(null, (int)27, (Component)Component.text((String)"\u26cf Ore Management").color((TextColor)NamedTextColor.AQUA));
        this.initializeItems();
    }

    private void initializeItems() {
        this.inv.clear();
        Set<Material> naturalOres = this.configManager.getNaturalOres();
        int slot = 0;
        for (Material ore : this.availableOres) {
            ItemStack item = new ItemStack(ore);
            ItemMeta meta = item.getItemMeta();
            meta.displayName(Component.text((String)ore.name()).color((TextColor)NamedTextColor.GOLD));
            ArrayList<Component> lore = new ArrayList<Component>();
            if (naturalOres.contains(ore)) {
                lore.add(Component.text((String)"Selected").color((TextColor)NamedTextColor.GREEN));
                meta.addEnchant(Enchantment.DENSITY, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            } else {
                lore.add(Component.text((String)"Not Selected").color((TextColor)NamedTextColor.RED));
            }
            meta.lore(lore);
            item.setItemMeta(meta);
            this.inv.setItem(slot, item);
            ++slot;
        }
        this.inv.setItem(26, this.createGuiItem(Material.BARRIER, "Back to \u26cf Staff Control Panel", new Component[0]));
    }

    private ItemStack createGuiItem(Material material, String name, Component ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)name).color((TextColor)NamedTextColor.GOLD));
        if (lore.length > 0) {
            meta.lore(Arrays.asList(lore));
        }
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(Component.text((String)"You do not have permission to configure ores.").color((TextColor)NamedTextColor.RED));
            return;
        }
        player.openInventory(this.inv);
    }

    public void refresh() {
        this.initializeItems();
    }
}

