/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.subgui.ConfigSettingsGUI;
import org.myplugin.deepGuardXray.utils.DirectConfigSaver;

public class StaffSettingsGUI {
    private final Inventory inv;
    private final ConfigManager configManager;
    private final deepGuardXray plugin;
    private static final String TITLE = "\u2699 Staff Settings";

    public StaffSettingsGUI(ConfigManager configManager, deepGuardXray plugin) {
        this.configManager = configManager;
        this.plugin = plugin;
        this.inv = Bukkit.createInventory(null, (int)27, (Component)Component.text((String)TITLE).color((TextColor)NamedTextColor.AQUA));
        this.initializeItems();
    }

    private void initializeItems() {
        ItemStack border = this.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, " ", false);
        for (int i = 0; i < 9; ++i) {
            this.inv.setItem(i, border);
            this.inv.setItem(18 + i, border);
        }
        this.inv.setItem(4, this.createGuiItem(Material.SHIELD, "Staff Settings", true, TextDecoration.BOLD, NamedTextColor.GREEN, Component.text((String)"Configure staff alerts and notifications").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(22, this.createGuiItem(Material.BARRIER, "Back to Plugin Configuration", false, null, NamedTextColor.RED, new Component[0]));
        this.addStaffSettings();
    }

    private void addStaffSettings() {
        this.inv.setItem(10, this.createToggleItem("Staff Ore Alerts", this.configManager.isStaffOreAlerts(), "Alert staff for each ore mined", "staff.oreAlerts"));
        this.inv.setItem(12, this.createNumberItem("Ore Reset Time (ticks)", this.configManager.getStaffOreResetTime(), "Time before ore counter resets (36000 = 30 minutes)", "staff.oreResetTime"));
        this.inv.setItem(14, this.createToggleItem("Staff Alert Enabled", this.configManager.isStaffAlertEnabled(), "Alert staff when decoy ore is broken", "staff.alertEnabled"));
        this.inv.setItem(16, this.createToggleItem("Debug Enabled", this.configManager.isDebugEnabled(), "Enable debug logging", "debug.enabled"));
    }

    private ItemStack createToggleItem(String name, boolean value, String description, String configPath) {
        Material material = value ? Material.LIME_CONCRETE : Material.RED_CONCRETE;
        Component status = value ? Component.text((String)"ENABLED").color((TextColor)NamedTextColor.GREEN) : Component.text((String)"DISABLED").color((TextColor)NamedTextColor.RED);
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)description).color((TextColor)NamedTextColor.GRAY));
        lore.add(status);
        lore.add(Component.text((String)"Click to toggle").color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)("Config path: " + configPath)).color((TextColor)NamedTextColor.DARK_GRAY));
        return this.createGuiItemWithLore(material, Component.text((String)name).color((TextColor)NamedTextColor.GOLD), value, lore);
    }

    private ItemStack createNumberItem(String name, Number value, String description, String configPath) {
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)description).color((TextColor)NamedTextColor.GRAY));
        lore.add(((TextComponent)Component.text((String)"Current value: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)value.toString()).color((TextColor)NamedTextColor.WHITE)));
        lore.add(Component.text((String)"Left-click to increase").color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)"Right-click to decrease").color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)("Config path: " + configPath)).color((TextColor)NamedTextColor.DARK_GRAY));
        return this.createGuiItemWithLore(Material.PAPER, Component.text((String)name).color((TextColor)NamedTextColor.GOLD), false, lore);
    }

    private ItemStack createGuiItem(Material material, String name, boolean enchanted, TextDecoration decoration, NamedTextColor color, Component ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        TextComponent displayName = Component.text((String)name);
        if (color != null) {
            displayName = displayName.color((TextColor)color);
        }
        if (decoration != null) {
            displayName = displayName.decorate(decoration);
        }
        meta.displayName((Component)displayName);
        if (lore.length > 0) {
            ArrayList<Component> itemLore = new ArrayList<Component>();
            for (Component loreLine : lore) {
                itemLore.add(loreLine);
            }
            meta.lore(itemLore);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.DENSITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createGuiItem(Material material, String name, boolean enchanted) {
        return this.createGuiItem(material, name, enchanted, null, null, new Component[0]);
    }

    private ItemStack createGuiItemWithLore(Material material, Component displayName, boolean enchanted, List<Component> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(displayName);
        if (lore != null && !lore.isEmpty()) {
            meta.lore(lore);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.DENSITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        if (!player.hasPermission("deepguardx.gui_config")) {
            player.sendMessage(Component.text((String)"You don't have permission to access the config settings.").color((TextColor)NamedTextColor.RED));
            return;
        }
        player.openInventory(this.inv);
    }

    public static void handleClick(Player player, int slot, Inventory inventory, ClickType clickType, ConfigManager configManager, deepGuardXray plugin) {
        boolean isHeader;
        if (!player.hasPermission("deepguardx.gui_config")) {
            player.sendMessage(Component.text((String)"You don't have permission to modify the config settings.").color((TextColor)NamedTextColor.RED));
            player.closeInventory();
            return;
        }
        if (slot == 22) {
            new ConfigSettingsGUI(configManager, plugin).openInventory(player);
            return;
        }
        boolean isBorder = slot < 9 || slot >= 18;
        boolean bl = isHeader = slot == 4;
        if (isBorder || isHeader) {
            return;
        }
        ItemStack clicked = inventory.getItem(slot);
        if (clicked == null || !clicked.hasItemMeta() || !clicked.getItemMeta().hasLore()) {
            return;
        }
        List lore = clicked.getItemMeta().lore();
        if (lore == null || lore.isEmpty()) {
            return;
        }
        Component configPathComponent = (Component)lore.get(lore.size() - 1);
        String configPathLine = PlainTextComponentSerializer.plainText().serialize(configPathComponent);
        if (!configPathLine.contains("Config path:")) {
            return;
        }
        String configPath = configPathLine.substring(configPathLine.lastIndexOf("Config path:") + 12).trim();
        plugin.getLogger().info("Processing click for config path: " + configPath);
        if (clicked.getType() == Material.LIME_CONCRETE || clicked.getType() == Material.RED_CONCRETE) {
            boolean currentValue = clicked.getType() == Material.LIME_CONCRETE;
            boolean newValue = !currentValue;
            boolean success = DirectConfigSaver.saveBoolean(plugin, configPath, newValue);
            if (success) {
                plugin.reloadConfig();
                configManager.reloadConfig();
                player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Setting ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)configPath).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" changed to ").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)(newValue ? "ENABLED" : "DISABLED")).color((TextColor)(newValue ? NamedTextColor.GREEN : NamedTextColor.RED))));
                if (plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                    plugin.getWebhookManager().sendStaffActionLog(player.getName(), "Changed Configuration", configPath + " \u2192 " + (newValue ? "ENABLED" : "DISABLED"));
                }
                new StaffSettingsGUI(configManager, plugin).openInventory(player);
            } else {
                player.sendMessage(Component.text((String)"Failed to save config change. Check console for details.").color((TextColor)NamedTextColor.RED));
            }
            return;
        }
        if (clicked.getType() == Material.PAPER) {
            boolean isRightClick;
            Component valueLine = (Component)lore.get(1);
            String valueStr = PlainTextComponentSerializer.plainText().serialize(valueLine);
            String extractedValue = valueStr.substring(valueStr.lastIndexOf(": ") + 2).trim();
            boolean isInteger = !extractedValue.contains(".");
            boolean isLeftClick = clickType == ClickType.LEFT || clickType == ClickType.SHIFT_LEFT;
            boolean bl2 = isRightClick = clickType == ClickType.RIGHT || clickType == ClickType.SHIFT_RIGHT;
            if (!isLeftClick && !isRightClick) {
                player.sendMessage(Component.text((String)"Please use left-click to increase or right-click to decrease the value.").color((TextColor)NamedTextColor.RED));
                return;
            }
            if (isInteger) {
                try {
                    int currentValue = Integer.parseInt(extractedValue);
                    int newValue = isLeftClick ? currentValue + 6000 : Math.max(6000, currentValue - 6000);
                    boolean success = DirectConfigSaver.saveInteger(plugin, configPath, newValue);
                    if (success) {
                        plugin.reloadConfig();
                        configManager.reloadConfig();
                        new StaffSettingsGUI(configManager, plugin).openInventory(player);
                        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Setting ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)configPath).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" updated to ").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)String.valueOf(newValue)).color((TextColor)NamedTextColor.AQUA)));
                        if (plugin.getConfigManager().isWebhookAlertEnabled("staff_actions")) {
                            plugin.getWebhookManager().sendStaffActionLog(player.getName(), "Changed Configuration", configPath + " \u2192 " + newValue);
                        }
                    } else {
                        player.sendMessage(Component.text((String)"Failed to save config change. Check console for details.").color((TextColor)NamedTextColor.RED));
                    }
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().severe("Error parsing integer value: " + extractedValue);
                    player.sendMessage(Component.text((String)"Error parsing number. Please report this to a developer.").color((TextColor)NamedTextColor.RED));
                }
            }
        }
    }
}

