/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.gui.subgui;

import java.util.ArrayList;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.gui.StaffMenuGUI;
import org.myplugin.deepGuardXray.managers.WebhookManager;

public class WebhookSettingsGUI {
    private final Inventory inv;
    private final ConfigManager configManager;
    private final deepGuardXray plugin;
    public static final String PERMISSION = "deepguardx.gui_webhook";

    public WebhookSettingsGUI(ConfigManager configManager, deepGuardXray plugin) {
        this.configManager = configManager;
        this.plugin = plugin;
        this.inv = Bukkit.createInventory(null, (int)36, (Component)((TextComponent)Component.text((String)"\ud83d\udd14 Discord Webhook Settings").color((TextColor)NamedTextColor.DARK_PURPLE)).decorate(TextDecoration.BOLD));
        this.initializeItems();
    }

    private void initializeItems() {
        int i;
        ItemStack border = this.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, Component.text((String)"\u25fc").color((TextColor)NamedTextColor.DARK_GRAY), false, new Component[0]);
        for (i = 0; i < 9; ++i) {
            this.inv.setItem(i, border);
        }
        for (i = 27; i < 36; ++i) {
            this.inv.setItem(i, border);
        }
        this.inv.setItem(9, border);
        this.inv.setItem(18, border);
        this.inv.setItem(17, border);
        this.inv.setItem(26, border);
        String webhookUrl = this.configManager.getWebhookUrl();
        boolean webhookConfigured = webhookUrl != null && !webhookUrl.isEmpty() && (webhookUrl.startsWith("https://discord.com/api/webhooks/") || webhookUrl.startsWith("https://discordapp.com/api/webhooks/"));
        this.inv.setItem(10, this.createGuiItem(webhookConfigured ? Material.LIME_WOOL : Material.RED_WOOL, Component.text((String)"Discord Webhook URL").color((TextColor)(webhookConfigured ? NamedTextColor.GREEN : NamedTextColor.RED)), false, Component.text((String)(webhookConfigured ? "\u2713 Configured" : "\u2717 Not Configured")).color((TextColor)(webhookConfigured ? NamedTextColor.GREEN : NamedTextColor.RED)), Component.text((String)("Click to " + (webhookConfigured ? "edit" : "set") + " the webhook URL")).color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(11, this.createAlertToggle("xray_detection", "X-Ray Detection Alerts", Material.DIAMOND_ORE, Component.text((String)"Alerts for decoy ore mining").color((TextColor)NamedTextColor.GRAY), Component.text((String)"Basic detection method").color((TextColor)NamedTextColor.YELLOW), Component.text((String)"Not 100% reliable on its own").color((TextColor)NamedTextColor.RED)));
        this.inv.setItem(12, this.createAlertToggle("suspicious_mining", "Suspicious Mining Alerts", Material.NETHERITE_PICKAXE, Component.text((String)"Alerts for rapid ore mining patterns").color((TextColor)NamedTextColor.GRAY), Component.text((String)"May flag legitimate players").color((TextColor)NamedTextColor.YELLOW), Component.text((String)"Use with other detection methods").color((TextColor)NamedTextColor.GOLD)));
        this.inv.setItem(13, this.createAlertToggle("ml_analysis", "ML Analysis Results", Material.BEACON, Component.text((String)"Machine learning-based detection").color((TextColor)NamedTextColor.AQUA), Component.text((String)"Most reliable cheater detection").color((TextColor)NamedTextColor.GREEN), Component.text((String)"Recommended for enforcement").color((TextColor)NamedTextColor.GREEN), Component.text((String)"\u2b50 Primary detection method").color((TextColor)NamedTextColor.GOLD)));
        this.inv.setItem(14, this.createAlertToggle("punishment_applied", "Punishment Alerts", Material.BARRIER, new Component[0]));
        this.inv.setItem(15, this.createAlertToggle("staff_actions", "Staff Action Logs", Material.SHIELD, new Component[0]));
        this.inv.setItem(16, this.createAlertToggle("appeal_updates", "Appeal System Alerts", Material.PAPER, new Component[0]));
        this.inv.setItem(21, this.createGuiItem(Material.REDSTONE, Component.text((String)"Test Webhook").color((TextColor)NamedTextColor.GOLD), true, Component.text((String)"Sends a test message to Discord").color((TextColor)NamedTextColor.GRAY), Component.text((String)"to verify your webhook is working").color((TextColor)NamedTextColor.GRAY)));
        this.inv.setItem(31, this.createGuiItem(Material.ARROW, Component.text((String)"Back to \u26cf Staff Control Panel").color((TextColor)NamedTextColor.AQUA), false, new Component[0]));
    }

    private ItemStack createAlertToggle(String alertType, String displayName, Material material, Component ... additionalLore) {
        boolean enabled = this.configManager.isWebhookAlertEnabled(alertType);
        ArrayList<Component> loreList = new ArrayList<Component>();
        loreList.add(Component.text((String)(enabled ? "\u2713 Enabled" : "\u2717 Disabled")).color((TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED)));
        if (additionalLore.length > 0) {
            loreList.addAll(Arrays.asList(additionalLore));
        }
        loreList.add(Component.text((String)"Click to toggle").color((TextColor)NamedTextColor.GRAY));
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)displayName).color((TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED)));
        meta.lore(loreList);
        if (enabled) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createGuiItem(Material material, Component name, boolean enchanted, Component ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(name);
        if (lore.length > 0) {
            ArrayList<Component> loreList = new ArrayList<Component>();
            for (Component line : lore) {
                loreList.add(line);
            }
            meta.lore(loreList);
        }
        if (enchanted) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
    }

    public static void handleClick(Player player, int slot, Inventory inventory, ConfigManager configManager, deepGuardXray plugin) {
        if (slot == 10) {
            player.closeInventory();
            player.sendMessage(Component.text((String)"Please enter your Discord webhook URL in chat:").color((TextColor)NamedTextColor.GOLD));
            player.sendMessage(((TextComponent)Component.text((String)"(Your webhook URL will not be visible to other players)").color((TextColor)NamedTextColor.GRAY)).decorate(TextDecoration.ITALIC));
            plugin.getChatInputHandler().registerChatInputHandler(player.getUniqueId(), input -> {
                if (input.startsWith("https://discord.com/api/webhooks/") || input.startsWith("https://discordapp.com/api/webhooks/")) {
                    configManager.setWebhookUrl((String)input);
                    plugin.getConfig().set("webhook.url", input);
                    plugin.saveConfig();
                    player.sendMessage(Component.text((String)"Webhook URL set successfully!").color((TextColor)NamedTextColor.GREEN));
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> new WebhookSettingsGUI(configManager, plugin).openInventory(player));
                } else {
                    player.sendMessage(Component.text((String)"Invalid webhook URL. It must start with https://discord.com/api/webhooks/").color((TextColor)NamedTextColor.RED));
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> new WebhookSettingsGUI(configManager, plugin).openInventory(player));
                }
                return true;
            });
            return;
        }
        if (slot == 11) {
            WebhookSettingsGUI.toggleWebhookAlert(player, "xray_detection", configManager, plugin);
        } else if (slot == 12) {
            WebhookSettingsGUI.toggleWebhookAlert(player, "suspicious_mining", configManager, plugin);
        } else if (slot == 13) {
            WebhookSettingsGUI.toggleWebhookAlert(player, "ml_analysis", configManager, plugin);
        } else if (slot == 14) {
            WebhookSettingsGUI.toggleWebhookAlert(player, "punishment_applied", configManager, plugin);
        } else if (slot == 15) {
            WebhookSettingsGUI.toggleWebhookAlert(player, "staff_actions", configManager, plugin);
        } else if (slot == 16) {
            WebhookSettingsGUI.toggleWebhookAlert(player, "appeal_updates", configManager, plugin);
        } else if (slot == 21) {
            String webhookUrl = configManager.getWebhookUrl();
            if (webhookUrl != null && !webhookUrl.isEmpty() && (webhookUrl.startsWith("https://discord.com/api/webhooks/") || webhookUrl.startsWith("https://discordapp.com/api/webhooks/"))) {
                player.sendMessage(Component.text((String)"Sending test message to Discord...").color((TextColor)NamedTextColor.YELLOW));
                WebhookManager.sendTestMessage(webhookUrl, player.getName());
                player.sendMessage(Component.text((String)"Test message sent! Check your Discord channel.").color((TextColor)NamedTextColor.GREEN));
            } else {
                player.sendMessage(Component.text((String)"Please set up a valid webhook URL first!").color((TextColor)NamedTextColor.RED));
                if (webhookUrl != null && !webhookUrl.isEmpty()) {
                    player.sendMessage(Component.text((String)"Debug: Current URL doesn't start with expected prefix").color((TextColor)NamedTextColor.GRAY));
                    String safePrefix = webhookUrl.length() > 10 ? webhookUrl.substring(0, 10) + "..." : webhookUrl;
                    player.sendMessage(Component.text((String)("Debug: URL starts with: " + safePrefix)).color((TextColor)NamedTextColor.GRAY));
                }
            }
        } else if (slot == 31) {
            StaffMenuGUI staffMenu = new StaffMenuGUI();
            staffMenu.openInventory(player);
        }
    }

    private static void toggleWebhookAlert(Player player, String alertType, ConfigManager configManager, deepGuardXray plugin) {
        boolean currentState = configManager.isWebhookAlertEnabled(alertType);
        configManager.setWebhookAlertEnabled(alertType, !currentState);
        plugin.getConfig().set("webhook.alerts." + alertType, (Object)(!currentState ? 1 : 0));
        plugin.saveConfig();
        player.sendMessage(((TextComponent)Component.text((String)(WebhookSettingsGUI.formatAlertTypeName(alertType) + " alerts are now ")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)(!currentState ? "enabled" : "disabled")).color((TextColor)(!currentState ? NamedTextColor.GREEN : NamedTextColor.RED))));
        new WebhookSettingsGUI(configManager, plugin).openInventory(player);
    }

    private static String formatAlertTypeName(String alertType) {
        if (alertType.equals("ml_analysis")) {
            return "ML Analysis";
        }
        String[] words = alertType.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formatted.toString().trim();
    }
}

