/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.listeners;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.PunishmentManager;

public class ChatListener
implements Listener {
    private final PunishmentManager punishmentManager;
    private final deepGuardXray plugin;

    public ChatListener(PunishmentManager punishmentManager, deepGuardXray plugin) {
        this.punishmentManager = punishmentManager;
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.punishmentManager.isUntrustedMiner(playerId)) {
            Component originalMessage = event.message();
            Component taggedMessage = Component.text((String)"[Untrusted Miner] ", (TextColor)NamedTextColor.RED).append(originalMessage);
            event.message(taggedMessage);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Modified chat format for untrusted miner: " + player.getName());
            }
        }
    }
}

