/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.managers;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.myplugin.deepGuardXray.deepGuardXray;

public class AppealManager
implements Listener {
    private final deepGuardXray plugin;
    private final File appealFile;
    private final Map<Integer, Appeal> appealById = new HashMap<Integer, Appeal>();
    private final Map<UUID, List<Appeal>> appealsByPlayer = new HashMap<UUID, List<Appeal>>();
    private int nextAppealId = 1;

    public AppealManager(deepGuardXray plugin) {
        this.plugin = plugin;
        this.appealFile = new File(plugin.getDataFolder(), "appeals.yml");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.loadAppeals();
    }

    public Appeal createAppeal(Player player, int punishmentLevel, String reason) {
        UUID playerId = player.getUniqueId();
        for (Appeal existingAppeal : this.getAppealsForPlayer(playerId)) {
            if (existingAppeal.getStatus() != AppealStatus.PENDING && existingAppeal.getStatus() != AppealStatus.UNDER_REVIEW || existingAppeal.getPunishmentLevel() != punishmentLevel) continue;
            return existingAppeal;
        }
        int appealId = this.getNextAppealId();
        Appeal appeal = new Appeal(appealId, playerId, player.getName(), punishmentLevel, reason);
        this.appealById.put(appealId, appeal);
        this.appealsByPlayer.computeIfAbsent(playerId, k -> new ArrayList()).add(appeal);
        this.saveAppeals();
        if (this.plugin.getConfigManager().isWebhookAlertEnabled("appeal_updates")) {
            this.plugin.getWebhookManager().sendNewAppealAlert(appealId, player.getName(), punishmentLevel, reason);
        }
        this.notifyStaffAboutNewAppeal(appeal);
        return appeal;
    }

    private synchronized int getNextAppealId() {
        int id = this.nextAppealId++;
        return id;
    }

    public Appeal getAppeal(int appealId) {
        return this.appealById.get(appealId);
    }

    public List<Appeal> getAppealsForPlayer(UUID playerId) {
        return this.appealsByPlayer.getOrDefault(playerId, new ArrayList());
    }

    public Appeal getActiveAppealForPlayer(UUID playerId) {
        List<Appeal> appeals = this.getAppealsForPlayer(playerId);
        int currentPunishmentLevel = this.plugin.getPunishmentManager().getPlayerPunishmentLevel(playerId);
        for (Appeal appeal : appeals) {
            if (appeal.getStatus() != AppealStatus.PENDING && appeal.getStatus() != AppealStatus.UNDER_REVIEW || appeal.getPunishmentLevel() != currentPunishmentLevel) continue;
            return appeal;
        }
        return null;
    }

    public List<Appeal> getPendingAppeals() {
        return this.appealById.values().stream().filter(appeal -> appeal.getStatus() == AppealStatus.PENDING || appeal.getStatus() == AppealStatus.UNDER_REVIEW).collect(Collectors.toList());
    }

    public void updateAppealStatus(int appealId, AppealStatus newStatus, String staffName, String response) {
        Appeal appeal = this.appealById.get(appealId);
        if (appeal != null) {
            Player player;
            appeal.setStatus(newStatus);
            appeal.setStaffName(staffName);
            appeal.setStaffResponse(response);
            this.saveAppeals();
            if (this.plugin.getConfigManager().isWebhookAlertEnabled("appeal_updates")) {
                this.plugin.getWebhookManager().sendAppealStatusAlert(appealId, appeal.getPlayerName(), appeal.getPunishmentLevel(), newStatus, staffName, response);
            }
            if (newStatus == AppealStatus.APPROVED) {
                Player player2 = Bukkit.getPlayer((UUID)appeal.getPlayerId());
                if (player2 != null && player2.isOnline()) {
                    this.plugin.getPunishmentManager().removePunishment(player2);
                    player2.sendMessage(Component.text((String)"Your appeal has been approved! Your punishment has been removed.").color((TextColor)NamedTextColor.GREEN));
                    player2.playSound(player2.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                }
            } else if (newStatus == AppealStatus.DENIED) {
                Player player3 = Bukkit.getPlayer((UUID)appeal.getPlayerId());
                if (player3 != null && player3.isOnline()) {
                    player3.sendMessage(Component.text((String)"Your appeal has been denied.").color((TextColor)NamedTextColor.RED));
                    if (!response.isEmpty()) {
                        player3.sendMessage(Component.text((String)("Reason: " + response)).color((TextColor)NamedTextColor.YELLOW));
                    }
                    player3.playSound(player3.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.8f);
                }
            } else if (newStatus == AppealStatus.UNDER_REVIEW && (player = Bukkit.getPlayer((UUID)appeal.getPlayerId())) != null && player.isOnline()) {
                player.sendMessage(Component.text((String)"Your appeal is now under review by staff.").color((TextColor)NamedTextColor.AQUA));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.2f);
            }
        }
    }

    private void notifyStaffAboutNewAppeal(Appeal appeal) {
        Component message = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[").color((TextColor)NamedTextColor.DARK_GRAY)).append(Component.text((String)"DeepGuardX").color((TextColor)NamedTextColor.RED))).append(Component.text((String)"] ").color((TextColor)NamedTextColor.DARK_GRAY))).append(Component.text((String)("New appeal #" + appeal.getId() + " from ")).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)appeal.getPlayerName()).color((TextColor)NamedTextColor.AQUA))).append(Component.text((String)(" (Level " + appeal.getPunishmentLevel() + ")")).color((TextColor)NamedTextColor.YELLOW));
        for (Player staff : Bukkit.getOnlinePlayers()) {
            if (!staff.hasPermission("deepguardx.staff")) continue;
            staff.sendMessage(message);
            staff.playSound(staff.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 0.7f, 1.2f);
        }
    }

    @EventHandler
    public void onStaffJoin(PlayerJoinEvent event) {
        List<Appeal> pendingAppeals;
        Player player = event.getPlayer();
        if (player.hasPermission("deepguardx.staff") && !(pendingAppeals = this.getPendingAppeals()).isEmpty()) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                player.sendMessage(Component.text((String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557").color((TextColor)NamedTextColor.AQUA));
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(((TextComponent)Component.text((String)"DeepGuardX Appeal System").color((TextColor)NamedTextColor.YELLOW)).decorate(TextDecoration.BOLD))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
                player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"There ").color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)(pendingAppeals.size() == 1 ? "is " : "are ")).color((TextColor)NamedTextColor.WHITE))).append(Component.text((int)pendingAppeals.size()).color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)" pending ").color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)(pendingAppeals.size() == 1 ? "appeal" : "appeals")).color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\u2551 ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"Check the Staff GUI to review them").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" \u2551").color((TextColor)NamedTextColor.AQUA)));
                player.sendMessage(Component.text((String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d").color((TextColor)NamedTextColor.AQUA));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 0.7f, 1.2f);
            }, 60L);
        }
    }

    private void loadAppeals() {
        if (!this.appealFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.appealFile);
        ConfigurationSection appealsSection = config.getConfigurationSection("appeals");
        if (appealsSection == null) {
            return;
        }
        this.appealById.clear();
        this.appealsByPlayer.clear();
        int highestId = 0;
        for (String key : appealsSection.getKeys(false)) {
            ConfigurationSection appealSection = appealsSection.getConfigurationSection(key);
            if (appealSection == null) continue;
            int id = Integer.parseInt(key);
            highestId = Math.max(highestId, id);
            UUID playerId = UUID.fromString(appealSection.getString("playerId"));
            String playerName = appealSection.getString("playerName");
            int punishmentLevel = appealSection.getInt("punishmentLevel");
            String reason = appealSection.getString("reason");
            long timestamp = appealSection.getLong("timestamp");
            AppealStatus status = AppealStatus.fromString(appealSection.getString("status"));
            String staffResponse = appealSection.getString("staffResponse", "");
            String staffName = appealSection.getString("staffName", "");
            Appeal appeal = new Appeal(id, playerId, playerName, punishmentLevel, reason, timestamp, status, staffResponse, staffName);
            this.appealById.put(id, appeal);
            this.appealsByPlayer.computeIfAbsent(playerId, k -> new ArrayList()).add(appeal);
        }
        this.nextAppealId = highestId + 1;
    }

    private void saveAppeals() {
        YamlConfiguration config = new YamlConfiguration();
        ConfigurationSection appealsSection = config.createSection("appeals");
        for (Appeal appeal : this.appealById.values()) {
            ConfigurationSection appealSection = appealsSection.createSection(String.valueOf(appeal.getId()));
            appealSection.set("playerId", (Object)appeal.getPlayerId().toString());
            appealSection.set("playerName", (Object)appeal.getPlayerName());
            appealSection.set("punishmentLevel", (Object)appeal.getPunishmentLevel());
            appealSection.set("reason", (Object)appeal.getReason());
            appealSection.set("timestamp", (Object)appeal.getTimestamp());
            appealSection.set("status", (Object)appeal.getStatus().name());
            appealSection.set("staffResponse", (Object)appeal.getStaffResponse());
            appealSection.set("staffName", (Object)appeal.getStaffName());
        }
        try {
            config.save(this.appealFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save appeals data: " + e.getMessage());
        }
    }

    public static class Appeal {
        private final int id;
        private final UUID playerId;
        private final String playerName;
        private final int punishmentLevel;
        private final String reason;
        private final long timestamp;
        private AppealStatus status;
        private String staffResponse;
        private String staffName;

        public Appeal(int id, UUID playerId, String playerName, int punishmentLevel, String reason) {
            this.id = id;
            this.playerId = playerId;
            this.playerName = playerName;
            this.punishmentLevel = punishmentLevel;
            this.reason = reason;
            this.timestamp = System.currentTimeMillis();
            this.status = AppealStatus.PENDING;
            this.staffResponse = "";
            this.staffName = "";
        }

        public Appeal(int id, UUID playerId, String playerName, int punishmentLevel, String reason, long timestamp, AppealStatus status, String staffResponse, String staffName) {
            this.id = id;
            this.playerId = playerId;
            this.playerName = playerName;
            this.punishmentLevel = punishmentLevel;
            this.reason = reason;
            this.timestamp = timestamp;
            this.status = status;
            this.staffResponse = staffResponse;
            this.staffName = staffName;
        }

        public int getId() {
            return this.id;
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public int getPunishmentLevel() {
            return this.punishmentLevel;
        }

        public String getReason() {
            return this.reason;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public AppealStatus getStatus() {
            return this.status;
        }

        public String getStaffResponse() {
            return this.staffResponse;
        }

        public String getStaffName() {
            return this.staffName;
        }

        public void setStatus(AppealStatus status) {
            this.status = status;
        }

        public void setStaffResponse(String staffResponse) {
            this.staffResponse = staffResponse;
        }

        public void setStaffName(String staffName) {
            this.staffName = staffName;
        }

        public String getFormattedTimestamp() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(new Date(this.timestamp));
        }
    }

    public static enum AppealStatus {
        PENDING("Pending", TextColor.color((int)255, (int)215, (int)0)),
        APPROVED("Approved", TextColor.color((int)50, (int)205, (int)50)),
        DENIED("Denied", TextColor.color((int)255, (int)0, (int)0)),
        UNDER_REVIEW("Under Review", TextColor.color((int)30, (int)144, (int)255));

        private final String displayName;
        private final TextColor color;

        private AppealStatus(String displayName, TextColor color) {
            this.displayName = displayName;
            this.color = color;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public TextColor getColor() {
            return this.color;
        }

        public static AppealStatus fromString(String statusStr) {
            try {
                return AppealStatus.valueOf(statusStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return PENDING;
            }
        }
    }
}

