/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.managers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.utils.LocationUtils;

public class DecoyManager {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final Map<Location, Material> decoyMap = new HashMap<Location, Material>();
    private final Map<UUID, OreTracker> trackerMap = new HashMap<UUID, OreTracker>();
    private final Set<LocationWrapper> playerPlacedOre = new HashSet<LocationWrapper>();
    private final Map<Location, Set<Location>> veinMap = new HashMap<Location, Set<Location>>();
    private final Map<Location, Map<Location, Material>> originalBlockTypes = new HashMap<Location, Map<Location, Material>>();
    private final Map<Location, UUID> decoyOwners = new HashMap<Location, UUID>();
    private final BlockFace[] ADJACENT_FACES = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    private final Set<Material> replaceableBlocks = new HashSet<Material>(Arrays.asList(Material.STONE, Material.DEEPSLATE, Material.COBBLESTONE, Material.DIRT, Material.GRAVEL, Material.GRANITE, Material.DIORITE, Material.ANDESITE, Material.TUFF, Material.CALCITE, Material.DRIPSTONE_BLOCK));

    public Map<Location, Set<Location>> getAllDecoyVeins() {
        return new HashMap<Location, Set<Location>>(this.veinMap);
    }

    public DecoyManager(JavaPlugin plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.scheduleOreTrackerCleanup();
    }

    private void scheduleOreTrackerCleanup() {
        long cleanupInterval = Math.max(1200L, this.configManager.getTimeWindowTicks() / 2L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<UUID, OreTracker>> it = this.trackerMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, OreTracker> entry = it.next();
                OreTracker tracker = entry.getValue();
                if (!tracker.isExpired(currentTime, this.configManager.getTimeWindowTicks())) continue;
                it.remove();
            }
        }, cleanupInterval, cleanupInterval);
    }

    public void addPlayerPlacedOre(Location loc) {
        this.playerPlacedOre.add(new LocationWrapper(loc));
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Added player-placed ore at " + LocationUtils.formatLocation(loc));
        }
    }

    public boolean isPlayerPlacedOre(Location loc) {
        boolean result = this.playerPlacedOre.contains(new LocationWrapper(loc));
        if (this.configManager.isDebugEnabled() && result) {
            this.plugin.getLogger().info("Found player-placed ore at " + LocationUtils.formatLocation(loc));
        }
        return result;
    }

    public void removePlayerPlacedOre(Location loc) {
        boolean removed = this.playerPlacedOre.remove(new LocationWrapper(loc));
        if (this.configManager.isDebugEnabled() && removed) {
            this.plugin.getLogger().info("Removed player-placed ore at " + LocationUtils.formatLocation(loc));
        }
    }

    public boolean isDecoy(Location loc) {
        if (!this.decoyMap.containsKey(loc)) {
            return false;
        }
        Material expectedType = this.decoyMap.get(loc);
        Block block = loc.getBlock();
        if (block.getType() != expectedType) {
            this.removeDecoy(loc);
            return false;
        }
        return true;
    }

    public void removeDecoy(Location loc) {
        Material expectedMaterial = this.decoyMap.remove(loc);
        this.decoyOwners.remove(loc);
        for (Map.Entry<Location, Set<Location>> entry : new HashMap<Location, Set<Location>>(this.veinMap).entrySet()) {
            if (!entry.getValue().contains(loc)) continue;
            entry.getValue().remove(loc);
            if (!entry.getValue().isEmpty()) break;
            this.veinMap.remove(entry.getKey());
            this.originalBlockTypes.remove(entry.getKey());
            break;
        }
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Removed decoy ore at " + LocationUtils.formatLocation(loc));
        }
    }

    public void trackOreBreak(Player player, Block block, Material ore) {
        if (!this.configManager.getNaturalOres().contains(ore)) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        OreTracker tracker = this.trackerMap.computeIfAbsent(playerUUID, k -> new OreTracker());
        tracker.increment(System.currentTimeMillis());
        if (tracker.getCount() > this.configManager.getOreThreshold() && this.configManager.isDecoyEnabled()) {
            this.placeDecoy(player, block, ore);
            tracker.reset();
        }
    }

    private void placeDecoy(Player player, Block originalBlock, Material oreType) {
        Location initialCandidateLoc = this.calculateDecoyLocation(player, originalBlock.getLocation());
        int maxAttempts = 5;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            if (initialCandidateLoc == null || !this.isBuried(initialCandidateLoc) || !this.placeDecoyVeinAt(player, initialCandidateLoc, oreType)) continue;
            return;
        }
        Location originalLoc = originalBlock.getLocation();
        int radius = this.configManager.getDecoySearchRadius();
        for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
            for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
                for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                    Location candidateLoc;
                    if (xOffset == 0 && yOffset == 0 && zOffset == 0 || (candidateLoc = originalLoc.clone().add((double)xOffset, (double)yOffset, (double)zOffset)) == null || candidateLoc.getWorld() == null || !candidateLoc.getWorld().equals((Object)originalLoc.getWorld()) || !this.isBuried(candidateLoc) || !this.placeDecoyVeinAt(player, candidateLoc, oreType)) continue;
                    return;
                }
            }
        }
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Failed to place decoy ore vein for " + player.getName() + " near " + LocationUtils.formatLocation(originalLoc));
        }
    }

    private boolean placeDecoyVeinAt(Player player, Location startLoc, Material oreType) {
        int veinSize = this.getVeinSizeForOre(oreType);
        Set<Location> veinBlocks = this.generateVein(startLoc, oreType, veinSize);
        if (veinBlocks.isEmpty() || veinBlocks.size() < Math.max(2, veinSize / 2)) {
            return false;
        }
        HashMap<Location, Material> originalTypes = new HashMap<Location, Material>();
        UUID playerUUID = player.getUniqueId();
        int actualBlocksPlaced = 0;
        for (Location loc : veinBlocks) {
            Block block = loc.getBlock();
            if (!this.replaceableBlocks.contains(block.getType()) || this.playerPlacedOre.contains(new LocationWrapper(loc)) || this.decoyMap.containsKey(loc)) continue;
            originalTypes.put(loc, block.getType());
            block.setType(oreType);
            this.decoyMap.put(loc, oreType);
            this.decoyOwners.put(loc, playerUUID);
            ++actualBlocksPlaced;
        }
        if (actualBlocksPlaced == 0) {
            return false;
        }
        HashSet<Location> placedBlocks = new HashSet<Location>();
        for (Location loc : veinBlocks) {
            if (!this.decoyMap.containsKey(loc)) continue;
            placedBlocks.add(loc);
        }
        this.veinMap.put(startLoc, placedBlocks);
        this.originalBlockTypes.put(startLoc, originalTypes);
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Decoy ore vein placed for " + player.getName() + " at " + LocationUtils.formatLocation(startLoc) + " with " + actualBlocksPlaced + " blocks (originally planned " + veinBlocks.size() + ")");
        }
        this.scheduleDecoyVeinRevert(player, startLoc);
        return true;
    }

    private int getVeinSizeForOre(Material oreType) {
        Random random = new Random();
        if (oreType == Material.DIAMOND_ORE || oreType == Material.DEEPSLATE_DIAMOND_ORE) {
            return 3 + random.nextInt(3);
        }
        if (oreType == Material.EMERALD_ORE || oreType == Material.DEEPSLATE_EMERALD_ORE) {
            return 1 + random.nextInt(2);
        }
        if (oreType == Material.IRON_ORE || oreType == Material.DEEPSLATE_IRON_ORE || oreType == Material.GOLD_ORE || oreType == Material.DEEPSLATE_GOLD_ORE) {
            return 4 + random.nextInt(4);
        }
        if (oreType == Material.COAL_ORE || oreType == Material.DEEPSLATE_COAL_ORE) {
            return 5 + random.nextInt(11);
        }
        if (oreType == Material.REDSTONE_ORE || oreType == Material.DEEPSLATE_REDSTONE_ORE || oreType == Material.LAPIS_ORE || oreType == Material.DEEPSLATE_LAPIS_ORE) {
            return 4 + random.nextInt(5);
        }
        return 3 + random.nextInt(3);
    }

    private Set<Location> generateVein(Location startLoc, Material oreType, int size) {
        HashSet<Location> veinBlocks = new HashSet<Location>();
        HashSet<Location> candidates = new HashSet<Location>();
        Block startBlock = startLoc.getBlock();
        if (!this.replaceableBlocks.contains(startBlock.getType()) || this.playerPlacedOre.contains(new LocationWrapper(startLoc)) || !this.isBuried(startLoc)) {
            return veinBlocks;
        }
        veinBlocks.add(startLoc);
        for (BlockFace face : this.ADJACENT_FACES) {
            candidates.add(startBlock.getRelative(face).getLocation());
        }
        Random random = new Random();
        int attempts = 0;
        int maxAttempts = size * 5;
        while (veinBlocks.size() < size && !candidates.isEmpty() && attempts < maxAttempts) {
            ++attempts;
            ArrayList candidateList = new ArrayList(candidates);
            Location nextLoc = (Location)candidateList.get(random.nextInt(candidateList.size()));
            candidates.remove(nextLoc);
            Block block = nextLoc.getBlock();
            if (!this.replaceableBlocks.contains(block.getType()) || this.playerPlacedOre.contains(new LocationWrapper(nextLoc)) || this.decoyMap.containsKey(nextLoc) || !this.isBuried(nextLoc)) continue;
            veinBlocks.add(nextLoc);
            for (BlockFace face : this.ADJACENT_FACES) {
                Location adjLoc = block.getRelative(face).getLocation();
                if (veinBlocks.contains(adjLoc) || candidates.contains(adjLoc)) continue;
                candidates.add(adjLoc);
            }
        }
        if (veinBlocks.size() < Math.max(2, size / 2)) {
            return new HashSet<Location>();
        }
        return veinBlocks;
    }

    private void scheduleDecoyVeinRevert(Player player, Location primaryLoc) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            boolean shouldRevert;
            Set<Location> veinBlocks = this.veinMap.get(primaryLoc);
            Map<Location, Material> originalTypes = this.originalBlockTypes.get(primaryLoc);
            if (veinBlocks == null || originalTypes == null) {
                return;
            }
            boolean bl = shouldRevert = !player.isOnline() || player.getLocation().distance(primaryLoc) > this.configManager.getMaxDecayDistance();
            if (shouldRevert) {
                for (Location loc : veinBlocks) {
                    Block block = loc.getBlock();
                    Material originalType = originalTypes.get(loc);
                    if (originalType == null || !this.decoyMap.containsKey(loc) || block.getType() != this.decoyMap.get(loc)) continue;
                    block.setType(originalType);
                    this.decoyMap.remove(loc);
                    this.decoyOwners.remove(loc);
                }
                this.veinMap.remove(primaryLoc);
                this.originalBlockTypes.remove(primaryLoc);
                if (this.configManager.isDebugEnabled()) {
                    this.plugin.getLogger().info("Reverted decoy ore vein at " + LocationUtils.formatLocation(primaryLoc) + (player.isOnline() ? " due to player being too far away" : " because player went offline"));
                }
            }
        }, this.configManager.getDecoyRevertDelay());
    }

    private Location calculateDecoyLocation(Player player, Location original) {
        Location eyeLoc = player.getEyeLocation();
        Vector viewDir = eyeLoc.getDirection().normalize();
        Vector decoyDir = viewDir.clone().multiply(-1);
        Vector perpendicular = decoyDir.clone().crossProduct(new Vector(0, 1, 0)).normalize();
        decoyDir.add(perpendicular.multiply(this.configManager.getDecoyFieldOffset()));
        return original.clone().add(decoyDir.multiply(this.configManager.getDecoyDistance()));
    }

    private boolean isBuried(Location loc) {
        Material adj;
        Block adjacentBlock;
        BlockFace[] criticalFaces;
        Block block = loc.getBlock();
        int buriedCount = 0;
        int exposedCount = 0;
        for (BlockFace face : criticalFaces = new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            adjacentBlock = block.getRelative(face);
            adj = adjacentBlock.getType();
            if (adj != Material.AIR && adj != Material.WATER && adj != Material.LAVA && adj != Material.CAVE_AIR && !this.isTransparent(adj) || ++exposedCount < 2) continue;
            return false;
        }
        for (BlockFace face : BlockFace.values()) {
            if (face == BlockFace.SELF || (adj = (adjacentBlock = block.getRelative(face)).getType()) == Material.AIR || adj == Material.WATER || adj == Material.LAVA || adj == Material.CAVE_AIR || this.isTransparent(adj)) continue;
            ++buriedCount;
        }
        int buriedThreshold = this.configManager.getBuriedThreshold();
        return buriedCount >= buriedThreshold;
    }

    private boolean isTransparent(Material material) {
        return material.isTransparent() || material == Material.GLASS || material == Material.TINTED_GLASS || material.name().contains("GLASS_PANE") || material.name().contains("LEAVES") || material == Material.ICE || material == Material.SLIME_BLOCK;
    }

    public void validateDecoys() {
        int removedCount = 0;
        HashSet<Location> veinsToRemove = new HashSet<Location>();
        Iterator<Map.Entry<Location, Material>> it = this.decoyMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Location, Material> entry = it.next();
            Location loc = entry.getKey();
            Material expectedType = entry.getValue();
            Block block = loc.getBlock();
            if (block.getType() == expectedType) continue;
            it.remove();
            this.decoyOwners.remove(loc);
            ++removedCount;
        }
        if (removedCount > 0) {
            for (Map.Entry<Location, Set<Location>> entry : this.veinMap.entrySet()) {
                boolean validVein = false;
                for (Location blockLoc : entry.getValue()) {
                    if (!this.decoyMap.containsKey(blockLoc)) continue;
                    validVein = true;
                    break;
                }
                if (validVein) continue;
                veinsToRemove.add(entry.getKey());
            }
            for (Location location : veinsToRemove) {
                this.veinMap.remove(location);
                this.originalBlockTypes.remove(location);
                if (!this.configManager.isDebugEnabled()) continue;
                this.plugin.getLogger().info("Removed invalid vein at " + LocationUtils.formatLocation(location));
            }
        }
        if (this.configManager.isDebugEnabled() && removedCount > 0) {
            this.plugin.getLogger().info("Validated decoys: removed " + removedCount + " invalid entries and " + veinsToRemove.size() + " veins");
        }
    }

    private void scheduleDecoyValidation() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::validateDecoys, 12000L, 12000L);
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Scheduled decoy validation every 10 minutes");
        }
    }

    private static class LocationWrapper {
        private final String world;
        private final int x;
        private final int y;
        private final int z;

        public LocationWrapper(Location loc) {
            this.world = loc.getWorld().getName();
            this.x = loc.getBlockX();
            this.y = loc.getBlockY();
            this.z = loc.getBlockZ();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LocationWrapper)) {
                return false;
            }
            LocationWrapper other = (LocationWrapper)obj;
            return this.world.equals(other.world) && this.x == other.x && this.y == other.y && this.z == other.z;
        }

        public int hashCode() {
            return this.world.hashCode() ^ this.x ^ this.y << 8 ^ this.z << 16;
        }
    }

    private static class OreTracker {
        private int count = 0;
        private long lastBreakTime = 0L;

        private OreTracker() {
        }

        public void increment(long currentTime) {
            ++this.count;
            this.lastBreakTime = currentTime;
        }

        public int getCount() {
            return this.count;
        }

        public void reset() {
            this.count = 0;
        }

        public boolean isExpired(long currentTime, long timeWindowTicks) {
            long timeWindowMs = timeWindowTicks * 50L;
            return currentTime - this.lastBreakTime > timeWindowMs;
        }
    }
}

