/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.managers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.ml.MLConfig;

public class SuspiciousManager {
    private static final Map<UUID, Integer> suspiciousCounts = new HashMap<UUID, Integer>();
    private static File suspiciousFile;
    private static FileConfiguration suspiciousConfig;
    private static deepGuardXray plugin;
    private static int autoSaveTaskId;

    public static void initialize(deepGuardXray pluginInstance) {
        plugin = pluginInstance;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdir();
        }
        if (!(suspiciousFile = new File(plugin.getDataFolder(), "suspicious_counts.yml")).exists()) {
            try {
                suspiciousFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.SEVERE, "Could not create suspicious_counts.yml", e);
            }
        }
        suspiciousConfig = YamlConfiguration.loadConfiguration((File)suspiciousFile);
        SuspiciousManager.loadSuspiciousCounts();
    }

    private static void loadSuspiciousCounts() {
        suspiciousCounts.clear();
        if (suspiciousConfig.contains("players")) {
            for (String uuidString : suspiciousConfig.getConfigurationSection("players").getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    int count = suspiciousConfig.getInt("players." + uuidString);
                    suspiciousCounts.put(uuid, count);
                }
                catch (IllegalArgumentException e) {
                    plugin.getLogger().warning("Invalid UUID in suspicious_counts.yml: " + uuidString);
                }
            }
        }
        plugin.getLogger().info("Loaded suspicious counts for " + suspiciousCounts.size() + " players");
    }

    private static void saveSuspiciousCounts() {
        suspiciousConfig.set("players", null);
        for (Map.Entry<UUID, Integer> entry : suspiciousCounts.entrySet()) {
            suspiciousConfig.set("players." + entry.getKey().toString(), (Object)entry.getValue());
        }
        try {
            suspiciousConfig.save(suspiciousFile);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "Could not save suspicious_counts.yml", e);
        }
    }

    public static void addSuspicious(UUID playerId) {
        Player player;
        MLConfig mlConfig;
        int previousCount = suspiciousCounts.getOrDefault(playerId, 0);
        suspiciousCounts.merge(playerId, 1, Integer::sum);
        int newCount = suspiciousCounts.get(playerId);
        if (plugin != null && plugin.getMLManager() != null && (mlConfig = plugin.getMLManager().getMLConfig()) != null && mlConfig.isAutoAnalysisEnabled() && (player = Bukkit.getPlayer((UUID)playerId)) != null && player.isOnline()) {
            int threshold = mlConfig.getSuspiciousThreshold();
            if (previousCount < threshold && newCount >= threshold) {
                if (!plugin.getMLManager().hasExistingReport(playerId, player.getName())) {
                    plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> {
                        plugin.getMLManager().queuePlayerForAnalysis(playerId);
                        plugin.getLogger().info("Player " + player.getName() + " crossed the suspicious threshold (" + threshold + ") and was queued for auto-analysis");
                    });
                } else {
                    plugin.getLogger().info("Player " + player.getName() + " crossed the suspicious threshold but already has a report");
                }
            } else if (!(newCount <= previousCount || previousCount < threshold || plugin.getMLManager().hasExistingReport(playerId, player.getName()) || plugin.getMLManager().getPlayersUnderAnalysis().contains(playerId) || plugin.getMLManager().isPlayerInAnalysisQueue(playerId))) {
                plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> {
                    plugin.getMLManager().queuePlayerForAnalysis(playerId);
                    plugin.getLogger().info("Player " + player.getName() + " suspicious count increased from " + previousCount + " to " + newCount + " (above threshold) and was queued for auto-analysis");
                });
            }
        }
    }

    public static Map<UUID, Integer> getSuspiciousCounts() {
        return suspiciousCounts;
    }

    public static void setSuspiciousCount(UUID playerId, int count) {
        suspiciousCounts.put(playerId, count);
    }

    public static void removeSuspicious(UUID playerId) {
        suspiciousCounts.remove(playerId);
    }

    public static void forceSave() {
        SuspiciousManager.saveSuspiciousCounts();
        plugin.getLogger().info("Force-saved suspicious counts for " + suspiciousCounts.size() + " players");
    }

    public static void saveAllData() {
        SuspiciousManager.saveSuspiciousCounts();
        plugin.getLogger().info("Saved suspicious counts for " + suspiciousCounts.size() + " players");
        if (autoSaveTaskId != -1) {
            plugin.getServer().getScheduler().cancelTask(autoSaveTaskId);
            autoSaveTaskId = -1;
        }
    }

    private static void startAutoSaveTask() {
        if (autoSaveTaskId != -1) {
            plugin.getServer().getScheduler().cancelTask(autoSaveTaskId);
        }
        long autoSaveInterval = (long)plugin.getConfigManager().getSuspiciousAutoSaveInterval() * 1200L;
        autoSaveTaskId = plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, () -> {
            if (plugin.getConfigManager().isSuspiciousAutoSaveLoggingEnabled()) {
                plugin.getLogger().info("Auto-saving suspicious player data...");
            }
            SuspiciousManager.saveSuspiciousCounts();
            if (plugin.getConfigManager().isSuspiciousAutoSaveLoggingEnabled()) {
                plugin.getLogger().info("Auto-save complete for " + suspiciousCounts.size() + " players");
            }
        }, autoSaveInterval, autoSaveInterval);
        if (plugin.getConfigManager().isSuspiciousAutoSaveLoggingEnabled()) {
            plugin.getLogger().info("Started auto-save task for suspicious player data (every " + plugin.getConfigManager().getSuspiciousAutoSaveInterval() + " minutes)");
        }
    }

    public static void updateAutoSaveSettings() {
        if (plugin.getConfigManager() == null) {
            return;
        }
        if (plugin.getConfigManager().isSuspiciousAutoSaveEnabled() && autoSaveTaskId == -1) {
            SuspiciousManager.startAutoSaveTask();
        } else if (!plugin.getConfigManager().isSuspiciousAutoSaveEnabled() && autoSaveTaskId != -1) {
            plugin.getServer().getScheduler().cancelTask(autoSaveTaskId);
            autoSaveTaskId = -1;
            if (plugin.getConfigManager().isSuspiciousAutoSaveLoggingEnabled()) {
                plugin.getLogger().info("Auto-save for suspicious player data has been disabled");
            }
        } else if (plugin.getConfigManager().isSuspiciousAutoSaveEnabled()) {
            SuspiciousManager.startAutoSaveTask();
        }
    }

    static {
        autoSaveTaskId = -1;
    }
}

