/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.ml;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.util.Vector;
import org.myplugin.deepGuardXray.ml.MLConfig;
import org.myplugin.deepGuardXray.ml.MLDataManager;
import org.myplugin.deepGuardXray.ml.PlayerMiningData;
import org.myplugin.deepGuardXray.protocol.PlayerProtocolData;

public class PlayerDataCollector {
    private final Map<UUID, PlayerMiningData> playerDataMap = new ConcurrentHashMap<UUID, PlayerMiningData>();
    private final MLConfig mlConfig;
    private final Set<Material> rareMaterials = new HashSet<Material>();
    private final Map<UUID, Long> lastMovementRecordTime = new ConcurrentHashMap<UUID, Long>();
    private static final long MOVEMENT_RECORD_INTERVAL = 500L;

    public PlayerDataCollector(MLConfig mlConfig) {
        this.mlConfig = mlConfig;
        this.initRareMaterials();
    }

    private void initRareMaterials() {
        this.rareMaterials.add(Material.DIAMOND_ORE);
        this.rareMaterials.add(Material.DEEPSLATE_DIAMOND_ORE);
        this.rareMaterials.add(Material.ANCIENT_DEBRIS);
        this.rareMaterials.add(Material.EMERALD_ORE);
        this.rareMaterials.add(Material.DEEPSLATE_EMERALD_ORE);
    }

    public void startCollecting(Player player, boolean isLabeledCheater) {
        UUID playerId = player.getUniqueId();
        this.playerDataMap.put(playerId, new PlayerProtocolData(player.getName(), isLabeledCheater));
    }

    public PlayerMiningData stopCollecting(Player player) {
        return this.playerDataMap.remove(player.getUniqueId());
    }

    public void processBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!this.playerDataMap.containsKey(playerId)) {
            return;
        }
        PlayerMiningData data = this.playerDataMap.get(playerId);
        Block block = event.getBlock();
        Material blockType = block.getType();
        Vector lookDirection = player.getLocation().getDirection();
        data.recordBlockBreak(block, lookDirection);
    }

    public PlayerMiningData getPlayerData(UUID playerId) {
        return this.playerDataMap.get(playerId);
    }

    public PlayerProtocolData getPlayerProtocolData(UUID playerId) {
        PlayerMiningData data = this.playerDataMap.get(playerId);
        if (data instanceof PlayerProtocolData) {
            return (PlayerProtocolData)data;
        }
        return null;
    }

    public boolean isCollectingData(UUID playerId) {
        return this.playerDataMap.containsKey(playerId);
    }

    public void saveAllData() {
        for (PlayerMiningData data : this.playerDataMap.values()) {
            data.calculateDerivedFeatures();
            MLDataManager.savePlayerData(data);
        }
    }

    public void processPlayerMove(Player player) {
        long lastRecordTime;
        UUID playerId = player.getUniqueId();
        if (!this.playerDataMap.containsKey(playerId)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastRecordTime = this.lastMovementRecordTime.getOrDefault(playerId, 0L).longValue()) < 500L) {
            return;
        }
        this.lastMovementRecordTime.put(playerId, currentTime);
        PlayerMiningData data = this.playerDataMap.get(playerId);
        Vector position = player.getLocation().toVector();
        data.recordPlayerPosition(position);
    }
}

