/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.ml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class PlayerMiningData {
    private final String playerName;
    private final long sessionStartTime;
    private final boolean labeledAsCheater;
    private final List<BlockBreakRecord> blockBreaks = new ArrayList<BlockBreakRecord>();
    private final List<BlockBreakRecord> oreBreaks = new ArrayList<BlockBreakRecord>();
    private final Set<Material> valuableOreMaterials = new HashSet<Material>();
    private final Set<Material> diamondOreMaterials = new HashSet<Material>();
    private final Set<Material> netheriteOreMaterials = new HashSet<Material>();
    private final List<BlockBreakRecord> diamondOreBreaks = new ArrayList<BlockBreakRecord>();
    private final List<BlockBreakRecord> netheriteOreBreaks = new ArrayList<BlockBreakRecord>();
    private final List<OreVein> diamondVeins = new ArrayList<OreVein>();
    private final List<OreVein> netheriteVeins = new ArrayList<OreVein>();
    private OreVein currentDiamondVein = null;
    private OreVein currentNetheriteVein = null;
    private final int VEIN_PROXIMITY_THRESHOLD = 3;
    private Vector lastDiamondPosition = null;
    private Vector lastNetheritePosition = null;
    private final List<Double> diamondDistances = new ArrayList<Double>();
    private final List<Double> netheriteDistances = new ArrayList<Double>();
    private Long lastBlockBreakTime = null;
    private final List<Long> idleTimes = new ArrayList<Long>();
    private int totalBlocksBroken = 0;
    private int totalOresMined = 0;
    private Map<Material, Integer> oreCounts = new HashMap<Material, Integer>();
    private Map<Material, List<OreTimeWindow>> oreTimeWindows = new HashMap<Material, List<OreTimeWindow>>();
    private final Map<String, Double> features = new HashMap<String, Double>();
    private final List<YLevelRecord> yLevelRecords = new ArrayList<YLevelRecord>();
    private Double lastYLevel = null;
    private long lastYLevelChangeTime = 0L;
    private final List<Double> yLevelChanges = new ArrayList<Double>();
    private final List<Long> timeAtSameYLevel = new ArrayList<Long>();
    private int totalYLevelChanges = 0;
    private double totalYLevelChangeAmount = 0.0;
    private final double Y_LEVEL_CHANGE_THRESHOLD = 1.0;

    public PlayerMiningData(String playerName, boolean labeledAsCheater) {
        this.playerName = playerName;
        this.sessionStartTime = System.currentTimeMillis();
        this.labeledAsCheater = labeledAsCheater;
        this.initializeValuableOreMaterials();
        this.initializeDiamondAndNetheriteOreMaterials();
        for (Material oreMaterial : this.valuableOreMaterials) {
            this.oreTimeWindows.put(oreMaterial, new ArrayList());
        }
    }

    private void initializeValuableOreMaterials() {
        this.valuableOreMaterials.add(Material.DIAMOND_ORE);
        this.valuableOreMaterials.add(Material.DEEPSLATE_DIAMOND_ORE);
        this.valuableOreMaterials.add(Material.ANCIENT_DEBRIS);
        this.valuableOreMaterials.add(Material.EMERALD_ORE);
        this.valuableOreMaterials.add(Material.DEEPSLATE_EMERALD_ORE);
        this.valuableOreMaterials.add(Material.GOLD_ORE);
        this.valuableOreMaterials.add(Material.DEEPSLATE_GOLD_ORE);
        this.valuableOreMaterials.add(Material.IRON_ORE);
        this.valuableOreMaterials.add(Material.DEEPSLATE_IRON_ORE);
        this.valuableOreMaterials.add(Material.LAPIS_ORE);
        this.valuableOreMaterials.add(Material.DEEPSLATE_LAPIS_ORE);
        this.valuableOreMaterials.add(Material.REDSTONE_ORE);
        this.valuableOreMaterials.add(Material.DEEPSLATE_REDSTONE_ORE);
        this.valuableOreMaterials.add(Material.COPPER_ORE);
        this.valuableOreMaterials.add(Material.DEEPSLATE_COPPER_ORE);
        this.valuableOreMaterials.add(Material.NETHER_GOLD_ORE);
        this.valuableOreMaterials.add(Material.NETHER_QUARTZ_ORE);
    }

    private void initializeDiamondAndNetheriteOreMaterials() {
        this.diamondOreMaterials.add(Material.DIAMOND_ORE);
        this.diamondOreMaterials.add(Material.DEEPSLATE_DIAMOND_ORE);
        this.netheriteOreMaterials.add(Material.ANCIENT_DEBRIS);
    }

    public void recordBlockBreak(Block block, Vector lookDirection) {
        long idleTime;
        long timestamp = System.currentTimeMillis();
        Vector blockPosition = block.getLocation().toVector();
        Material blockType = block.getType();
        if (this.lastBlockBreakTime != null && (idleTime = timestamp - this.lastBlockBreakTime) > 0L && idleTime < 3600000L) {
            this.idleTimes.add(idleTime);
        }
        this.lastBlockBreakTime = timestamp;
        BlockBreakRecord record = new BlockBreakRecord(timestamp, blockType, blockPosition);
        this.blockBreaks.add(record);
        ++this.totalBlocksBroken;
        if (this.valuableOreMaterials.contains(blockType)) {
            this.recordOreFound(block);
        }
        if (this.diamondOreMaterials.contains(blockType)) {
            this.recordDiamondOreFound(record);
        }
        if (this.netheriteOreMaterials.contains(blockType)) {
            this.recordNetheriteOreFound(record);
        }
    }

    public void recordPlayerPosition(Vector position) {
        long timestamp = System.currentTimeMillis();
        double currentYLevel = position.getY();
        YLevelRecord record = new YLevelRecord(timestamp, currentYLevel, position);
        this.yLevelRecords.add(record);
        if (this.lastYLevel != null) {
            double yChange = Math.abs(currentYLevel - this.lastYLevel);
            if (yChange >= 1.0) {
                this.yLevelChanges.add(yChange);
                ++this.totalYLevelChanges;
                this.totalYLevelChangeAmount += yChange;
                long timeAtLevel = timestamp - this.lastYLevelChangeTime;
                if (timeAtLevel > 0L && timeAtLevel < 3600000L) {
                    this.timeAtSameYLevel.add(timeAtLevel);
                }
                this.lastYLevelChangeTime = timestamp;
            }
        } else {
            this.lastYLevelChangeTime = timestamp;
        }
        this.lastYLevel = currentYLevel;
    }

    public void recordOreFound(Block block) {
        long timestamp = System.currentTimeMillis();
        Material blockType = block.getType();
        BlockBreakRecord record = new BlockBreakRecord(timestamp, blockType, block.getLocation().toVector());
        this.oreBreaks.add(record);
        ++this.totalOresMined;
        this.oreCounts.put(blockType, this.oreCounts.getOrDefault(blockType, 0) + 1);
        this.updateTimeWindows(blockType, timestamp);
    }

    private void recordDiamondOreFound(BlockBreakRecord record) {
        this.diamondOreBreaks.add(record);
        if (this.lastDiamondPosition != null) {
            double distance = this.lastDiamondPosition.distance(record.position);
            this.diamondDistances.add(distance);
        }
        this.lastDiamondPosition = record.position;
        if (this.currentDiamondVein == null) {
            this.currentDiamondVein = new OreVein();
            this.currentDiamondVein.addOre(record);
            this.diamondVeins.add(this.currentDiamondVein);
        } else {
            boolean belongsToCurrentVein = false;
            for (BlockBreakRecord veinOre : this.currentDiamondVein.ores) {
                double distance = veinOre.position.distance(record.position);
                if (!(distance <= 3.0)) continue;
                belongsToCurrentVein = true;
                break;
            }
            if (belongsToCurrentVein) {
                this.currentDiamondVein.addOre(record);
            } else {
                this.currentDiamondVein = new OreVein();
                this.currentDiamondVein.addOre(record);
                this.diamondVeins.add(this.currentDiamondVein);
            }
        }
    }

    private void recordNetheriteOreFound(BlockBreakRecord record) {
        this.netheriteOreBreaks.add(record);
        if (this.lastNetheritePosition != null) {
            double distance = this.lastNetheritePosition.distance(record.position);
            this.netheriteDistances.add(distance);
        }
        this.lastNetheritePosition = record.position;
        if (this.currentNetheriteVein == null) {
            this.currentNetheriteVein = new OreVein();
            this.currentNetheriteVein.addOre(record);
            this.netheriteVeins.add(this.currentNetheriteVein);
        } else {
            boolean belongsToCurrentVein = false;
            for (BlockBreakRecord veinOre : this.currentNetheriteVein.ores) {
                double distance = veinOre.position.distance(record.position);
                if (!(distance <= 3.0)) continue;
                belongsToCurrentVein = true;
                break;
            }
            if (belongsToCurrentVein) {
                this.currentNetheriteVein.addOre(record);
            } else {
                this.currentNetheriteVein = new OreVein();
                this.currentNetheriteVein.addOre(record);
                this.netheriteVeins.add(this.currentNetheriteVein);
            }
        }
    }

    private void updateTimeWindows(Material oreType, long timestamp) {
        List<OreTimeWindow> windows = this.oreTimeWindows.get(oreType);
        if (windows.isEmpty()) {
            windows.add(new OreTimeWindow(60000L));
            windows.add(new OreTimeWindow(180000L));
            windows.add(new OreTimeWindow(300000L));
            windows.add(new OreTimeWindow(600000L));
        }
        for (OreTimeWindow window : windows) {
            window.addOre(timestamp);
        }
    }

    private boolean isVeinInLinePattern(OreVein vein) {
        if (vein.ores.size() < 3) {
            return false;
        }
        ArrayList<Vector> positions = new ArrayList<Vector>();
        for (BlockBreakRecord ore : vein.ores) {
            positions.add(ore.position);
        }
        if (positions.size() == 3) {
            double d12 = ((Vector)positions.get(0)).distance((Vector)positions.get(1));
            double d23 = ((Vector)positions.get(1)).distance((Vector)positions.get(2));
            double d13 = ((Vector)positions.get(0)).distance((Vector)positions.get(2));
            return Math.abs(d13 - (d12 + d23)) < 0.5;
        }
        if (positions.size() > 3) {
            Vector prev = null;
            Vector current = null;
            Vector direction = null;
            double totalAngleDeviation = 0.0;
            int angleCount = 0;
            for (Vector pos : positions) {
                if (prev == null) {
                    prev = pos;
                    continue;
                }
                if (current == null) {
                    current = pos;
                    direction = current.clone().subtract(prev);
                    direction.normalize();
                    continue;
                }
                Vector newDirection = pos.clone().subtract(current);
                newDirection.normalize();
                double dot = direction.dot(newDirection);
                dot = Math.max(-1.0, Math.min(1.0, dot));
                double angle = Math.acos(dot);
                double deviation = Math.abs(angle - Math.PI);
                totalAngleDeviation += deviation;
                ++angleCount;
                prev = current;
                current = pos;
                direction = newDirection;
            }
            if (angleCount > 0) {
                double avgDeviation = totalAngleDeviation / (double)angleCount;
                return avgDeviation < 0.3;
            }
        }
        return false;
    }

    public void calculateDerivedFeatures() {
        long totalMiningTimeMs = System.currentTimeMillis() - this.sessionStartTime;
        this.features.put("total_mining_time_seconds", (double)totalMiningTimeMs / 1000.0);
        this.features.put("total_blocks_broken", Double.valueOf(this.totalBlocksBroken));
        this.features.put("total_ores_mined", Double.valueOf(this.totalOresMined));
        for (Material oreMaterial : this.valuableOreMaterials) {
            String oreName = oreMaterial.toString().toLowerCase();
            this.features.put("ore_count_" + oreName, (double)this.oreCounts.getOrDefault(oreMaterial, 0));
        }
        for (Material oreMaterial : this.valuableOreMaterials) {
            if (!this.oreTimeWindows.containsKey(oreMaterial)) continue;
            List<OreTimeWindow> windows = this.oreTimeWindows.get(oreMaterial);
            String oreName = oreMaterial.toString().toLowerCase();
            for (OreTimeWindow window : windows) {
                String windowName;
                if (window.windowSizeMs == 60000L) {
                    windowName = "1min";
                } else if (window.windowSizeMs == 180000L) {
                    windowName = "3min";
                } else if (window.windowSizeMs == 300000L) {
                    windowName = "5min";
                } else {
                    if (window.windowSizeMs != 600000L) continue;
                    windowName = "10min";
                }
                this.features.put("ore_rate_" + (String)oreName + "_" + windowName, window.getMaxRate());
            }
        }
        int totalDiamondVeins = this.diamondVeins.size();
        int totalDiamondOresInVeins = 0;
        int diamondVeinsInLinePattern = 0;
        for (OreVein vein : this.diamondVeins) {
            totalDiamondOresInVeins += vein.ores.size();
            if (!this.isVeinInLinePattern(vein)) continue;
            ++diamondVeinsInLinePattern;
        }
        double avgDiamondVeinSize = totalDiamondVeins > 0 ? (double)totalDiamondOresInVeins / (double)totalDiamondVeins : 0.0;
        this.features.put("avg_diamond_vein_size", avgDiamondVeinSize);
        int totalNetheriteVeins = this.netheriteVeins.size();
        int totalNetheriteOresInVeins = 0;
        for (OreVein vein : this.netheriteVeins) {
            totalNetheriteOresInVeins += vein.ores.size();
        }
        double avgAncientDebrisVeinSize = totalNetheriteVeins > 0 ? (double)totalNetheriteOresInVeins / (double)totalNetheriteVeins : 0.0;
        this.features.put("avg_ancient_debris_vein_size", avgAncientDebrisVeinSize);
        double avgDiamondDistance = 0.0;
        if (!this.diamondDistances.isEmpty()) {
            double totalDiamondDistance = 0.0;
            for (double distance : this.diamondDistances) {
                totalDiamondDistance += distance;
            }
            avgDiamondDistance = totalDiamondDistance / (double)this.diamondDistances.size();
        }
        this.features.put("avg_distance_between_diamonds", avgDiamondDistance);
        double avgNetheriteDistance = 0.0;
        if (!this.netheriteDistances.isEmpty()) {
            double totalNetheriteDistance = 0.0;
            for (double distance : this.netheriteDistances) {
                totalNetheriteDistance += distance;
            }
            avgNetheriteDistance = totalNetheriteDistance / (double)this.netheriteDistances.size();
        }
        this.features.put("avg_distance_between_netherite", avgNetheriteDistance);
        double avgIdleTime = 0.0;
        if (!this.idleTimes.isEmpty()) {
            long totalIdleTime = 0L;
            for (long idleTime : this.idleTimes) {
                totalIdleTime += idleTime;
            }
            avgIdleTime = (double)totalIdleTime / (double)this.idleTimes.size() / 1000.0;
        }
        this.features.put("avg_idle_time_seconds", avgIdleTime);
        double avgYLevelChange = 0.0;
        if (!this.yLevelChanges.isEmpty()) {
            double totalChanges = 0.0;
            for (double change : this.yLevelChanges) {
                totalChanges += change;
            }
            avgYLevelChange = totalChanges / (double)this.yLevelChanges.size();
        }
        this.features.put("avg_y_level_change", avgYLevelChange);
        double avgTimeAtSameYLevel = 0.0;
        if (!this.timeAtSameYLevel.isEmpty()) {
            long totalTime = 0L;
            for (long time : this.timeAtSameYLevel) {
                totalTime += time;
            }
            avgTimeAtSameYLevel = (double)totalTime / (double)this.timeAtSameYLevel.size() / 1000.0;
        }
        this.features.put("avg_time_at_same_y_level", avgTimeAtSameYLevel);
        double miningTimeMinutes = (double)totalMiningTimeMs / 60000.0;
        double yLevelChangesPerMinute = (double)this.totalYLevelChanges / miningTimeMinutes;
        this.features.put("y_level_changes_per_minute", yLevelChangesPerMinute);
        HashMap<Integer, Long> yLevelFrequency = new HashMap<Integer, Long>();
        long totalRecordedTime = 0L;
        for (int i = 1; i < this.yLevelRecords.size(); ++i) {
            YLevelRecord current = this.yLevelRecords.get(i);
            YLevelRecord previous = this.yLevelRecords.get(i - 1);
            int yInt = (int)previous.yLevel;
            long timeSpent = current.timestamp - previous.timestamp;
            if (timeSpent <= 0L || timeSpent >= 3600000L) continue;
            yLevelFrequency.put(yInt, yLevelFrequency.getOrDefault(yInt, 0L) + timeSpent);
            totalRecordedTime += timeSpent;
        }
        long maxTimeAtYLevel = 0L;
        int mostCommonYLevel = 0;
        for (Map.Entry entry : yLevelFrequency.entrySet()) {
            if ((Long)entry.getValue() <= maxTimeAtYLevel) continue;
            maxTimeAtYLevel = (Long)entry.getValue();
            mostCommonYLevel = (Integer)entry.getKey();
        }
        double percentTimeAtMostCommonYLevel = 0.0;
        if (totalRecordedTime > 0L) {
            percentTimeAtMostCommonYLevel = (double)maxTimeAtYLevel * 100.0 / (double)totalRecordedTime;
        }
        this.features.put("percent_time_at_most_common_y", percentTimeAtMostCommonYLevel);
        this.features.put("most_common_y_level", Double.valueOf(mostCommonYLevel));
        ArrayList<Double> yChangesBeforeValuableOre = new ArrayList<Double>();
        ArrayList<Double> yChangesAfterValuableOre = new ArrayList<Double>();
        long TIME_WINDOW = 10000L;
        for (BlockBreakRecord oreBreak : this.oreBreaks) {
            if (!this.valuableOreMaterials.contains(oreBreak.material)) continue;
            ArrayList<YLevelRecord> beforeRecords = new ArrayList<YLevelRecord>();
            ArrayList<YLevelRecord> afterRecords = new ArrayList<YLevelRecord>();
            for (YLevelRecord yRecord : this.yLevelRecords) {
                long timeDiff = yRecord.timestamp - oreBreak.timestamp;
                if (timeDiff < 0L && Math.abs(timeDiff) <= 10000L) {
                    beforeRecords.add(yRecord);
                    continue;
                }
                if (timeDiff <= 0L || timeDiff > 10000L) continue;
                afterRecords.add(yRecord);
            }
            if (beforeRecords.size() >= 2) {
                double totalYChange = Math.abs(((YLevelRecord)beforeRecords.get((int)0)).yLevel - ((YLevelRecord)beforeRecords.get((int)(beforeRecords.size() - 1))).yLevel);
                yChangesBeforeValuableOre.add(totalYChange);
            }
            if (afterRecords.size() < 2) continue;
            double totalYChange = Math.abs(((YLevelRecord)afterRecords.get((int)0)).yLevel - ((YLevelRecord)afterRecords.get((int)(afterRecords.size() - 1))).yLevel);
            yChangesAfterValuableOre.add(totalYChange);
        }
        double avgYChangeBeforeOre = 0.0;
        if (!yChangesBeforeValuableOre.isEmpty()) {
            double sum = 0.0;
            for (Double change : yChangesBeforeValuableOre) {
                sum += change.doubleValue();
            }
            avgYChangeBeforeOre = sum / (double)yChangesBeforeValuableOre.size();
        }
        this.features.put("avg_y_change_before_ore", avgYChangeBeforeOre);
        double avgYChangeAfterOre = 0.0;
        if (!yChangesAfterValuableOre.isEmpty()) {
            double sum = 0.0;
            for (Double change : yChangesAfterValuableOre) {
                sum += change.doubleValue();
            }
            avgYChangeAfterOre = sum / (double)yChangesAfterValuableOre.size();
        }
        this.features.put("avg_y_change_after_ore", avgYChangeAfterOre);
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (YLevelRecord record : this.yLevelRecords) {
            minY = Math.min(minY, record.yLevel);
            maxY = Math.max(maxY, record.yLevel);
        }
        double yRange = minY != Double.MAX_VALUE && maxY != Double.MIN_VALUE ? maxY - minY : 0.0;
        this.features.put("y_level_range", yRange);
        double yLevelVariance = 0.0;
        if (this.yLevelRecords.size() > 1) {
            double sumY = 0.0;
            for (YLevelRecord record : this.yLevelRecords) {
                sumY += record.yLevel;
            }
            double meanY = sumY / (double)this.yLevelRecords.size();
            double sumSquaredDiff = 0.0;
            for (YLevelRecord record : this.yLevelRecords) {
                double diff = record.yLevel - meanY;
                sumSquaredDiff += diff * diff;
            }
            yLevelVariance = sumSquaredDiff / (double)this.yLevelRecords.size();
        }
        this.features.put("y_level_variance", yLevelVariance);
        this.features.put("y_level_std_dev", Math.sqrt(yLevelVariance));
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean isLabeledAsCheater() {
        return this.labeledAsCheater;
    }

    public Map<String, Double> getFeatures() {
        return this.features;
    }

    public List<BlockBreakRecord> getBlockBreaks() {
        return this.blockBreaks;
    }

    public List<BlockBreakRecord> getOreBreaks() {
        return this.oreBreaks;
    }

    public long getTotalMiningTimeMs() {
        return System.currentTimeMillis() - this.sessionStartTime;
    }

    static class OreVein {
        final List<BlockBreakRecord> ores = new ArrayList<BlockBreakRecord>();

        OreVein() {
        }

        void addOre(BlockBreakRecord ore) {
            this.ores.add(ore);
        }

        int getSize() {
            return this.ores.size();
        }
    }

    static class BlockBreakRecord {
        final long timestamp;
        final Material material;
        final Vector position;

        BlockBreakRecord(long timestamp, Material material, Vector position) {
            this.timestamp = timestamp;
            this.material = material;
            this.position = position;
        }
    }

    static class YLevelRecord {
        final long timestamp;
        final double yLevel;
        final Vector position;

        YLevelRecord(long timestamp, double yLevel, Vector position) {
            this.timestamp = timestamp;
            this.yLevel = yLevel;
            this.position = position;
        }
    }

    static class OreTimeWindow {
        final long windowSizeMs;
        final List<Long> oreTimestamps = new ArrayList<Long>();

        OreTimeWindow(long windowSizeMs) {
            this.windowSizeMs = windowSizeMs;
        }

        void addOre(long timestamp) {
            this.oreTimestamps.add(timestamp);
            long cutoffTime = timestamp - this.windowSizeMs;
            this.oreTimestamps.removeIf(t -> t < cutoffTime);
        }

        double getMaxRate() {
            if (this.oreTimestamps.isEmpty()) {
                return 0.0;
            }
            int count = this.oreTimestamps.size();
            return (double)count * 60000.0 / (double)this.windowSizeMs;
        }
    }
}

